/*
 * Decompiled with CFR 0.152.
 */
package com.cloudrail.si.services;

import com.cloudrail.si.CloudRail;
import com.cloudrail.si.exceptions.AuthenticationException;
import com.cloudrail.si.exceptions.HttpException;
import com.cloudrail.si.exceptions.NotFoundException;
import com.cloudrail.si.exceptions.ParseException;
import com.cloudrail.si.exceptions.ServiceUnavailableException;
import com.cloudrail.si.interfaces.PointsOfInterest;
import com.cloudrail.si.servicecode.Interpreter;
import com.cloudrail.si.servicecode.Sandbox;
import com.cloudrail.si.servicecode.commands.awaitCodeRedirect.RedirectReceiver;
import com.cloudrail.si.statistics.InitSelfTestTask;
import com.cloudrail.si.statistics.ReportCallTask;
import com.cloudrail.si.statistics.ReportErrorTask;
import com.cloudrail.si.types.Error;
import com.cloudrail.si.types.ErrorType;
import com.cloudrail.si.types.POI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Yelp
implements PointsOfInterest {
    private static final Map<String, Object[]> SERVICE_CODE = Collections.unmodifiableMap(new HashMap<String, Object[]>(){
        {
            this.put("init", new Object[]{new Object[]{"create", "$P0.crToYelp", "Object"}, new Object[]{"create", "$P0.yelpToCr", "Object"}, new Object[]{"callFunc", "addCategory", "$P0", "airport", "airports"}, new Object[]{"callFunc", "addCategory", "$P0", "amusement_park", "amusementparks"}, new Object[]{"callFunc", "addCategory", "$P0", "aquarium", "aquariums"}, new Object[]{"callFunc", "addCategory", "$P0", "art_gallery", "galleries"}, new Object[]{"callFunc", "addCategory", "$P0", "bakery", "bakeries"}, new Object[]{"callFunc", "addCategory", "$P0", "bank", "banks"}, new Object[]{"callFunc", "addCategory", "$P0", "bar", "bars"}, new Object[]{"callFunc", "addCategory", "$P0", "beauty_salon", "beautysvc"}, new Object[]{"callFunc", "addCategory", "$P0", "bicycle_store", "bicycles"}, new Object[]{"callFunc", "addCategory", "$P0", "book_store", "bookstores"}, new Object[]{"callFunc", "addCategory", "$P0", "bowling_alley", "bowling"}, new Object[]{"callFunc", "addCategory", "$P0", "bus_station", "buses"}, new Object[]{"callFunc", "addCategory", "$P0", "cafe", "cafes"}, new Object[]{"callFunc", "addCategory", "$P0", "car_dealer", "car_dealers"}, new Object[]{"callFunc", "addCategory", "$P0", "car_rental", "carrental"}, new Object[]{"callFunc", "addCategory", "$P0", "car_wash", "carwash"}, new Object[]{"callFunc", "addCategory", "$P0", "casino", "casinos"}, new Object[]{"callFunc", "addCategory", "$P0", "cemetery", "funeralservices"}, new Object[]{"callFunc", "addCategory", "$P0", "church", "churches"}, new Object[]{"callFunc", "addCategory", "$P0", "clothing_store", "fashion"}, new Object[]{"callFunc", "addCategory", "$P0", "convenience_store", "convenience"}, new Object[]{"callFunc", "addCategory", "$P0", "courthouse", "courthouses"}, new Object[]{"callFunc", "addCategory", "$P0", "dentist", "dentists"}, new Object[]{"callFunc", "addCategory", "$P0", "department_store", "deptstores"}, new Object[]{"callFunc", "addCategory", "$P0", "doctor", "physicians"}, new Object[]{"callFunc", "addCategory", "$P0", "electronics_store", "electronics"}, new Object[]{"callFunc", "addCategory", "$P0", "embassy", "embassy"}, new Object[]{"callFunc", "addCategory", "$P0", "finance", "financialservices"}, new Object[]{"callFunc", "addCategory", "$P0", "fire_station", "firedepartments"}, new Object[]{"callFunc", "addCategory", "$P0", "florist", "florists"}, new Object[]{"callFunc", "addCategory", "$P0", "food", "food"}, new Object[]{"callFunc", "addCategory", "$P0", "funeral_home", "funeralservices"}, new Object[]{"callFunc", "addCategory", "$P0", "furniture_store", "furniture"}, new Object[]{"callFunc", "addCategory", "$P0", "gas_station", "servicestations"}, new Object[]{"callFunc", "addCategory", "$P0", "grocery_or_supermarket", "grocery"}, new Object[]{"callFunc", "addCategory", "$P0", "gym", "gyms"}, new Object[]{"callFunc", "addCategory", "$P0", "hardware_store", "hardware"}, new Object[]{"callFunc", "addCategory", "$P0", "health", "health"}, new Object[]{"callFunc", "addCategory", "$P0", "hindu_temple", "hindu_temples"}, new Object[]{"callFunc", "addCategory", "$P0", "hospital", "hospitals"}, new Object[]{"callFunc", "addCategory", "$P0", "jewelry_store", "jewelry"}, new Object[]{"callFunc", "addCategory", "$P0", "laundry", "drycleaninglaundry"}, new Object[]{"callFunc", "addCategory", "$P0", "lawyer", "lawyers"}, new Object[]{"callFunc", "addCategory", "$P0", "library", "libraries"}, new Object[]{"callFunc", "addCategory", "$P0", "locksmith", "locksmiths"}, new Object[]{"callFunc", "addCategory", "$P0", "mosque", "mosques"}, new Object[]{"callFunc", "addCategory", "$P0", "movie_theater", "movietheaters"}, new Object[]{"callFunc", "addCategory", "$P0", "museum", "museums"}, new Object[]{"callFunc", "addCategory", "$P0", "night_club", "danceclubs"}, new Object[]{"callFunc", "addCategory", "$P0", "parks", "parks"}, new Object[]{"callFunc", "addCategory", "$P0", "parking", "parking"}, new Object[]{"callFunc", "addCategory", "$P0", "pet_store", "petstore"}, new Object[]{"callFunc", "addCategory", "$P0", "pharmacy", "pharmacy"}, new Object[]{"callFunc", "addCategory", "$P0", "physiotherapist", "physicaltherapy"}, new Object[]{"callFunc", "addCategory", "$P0", "police", "policedepartments"}, new Object[]{"callFunc", "addCategory", "$P0", "post_office", "postoffices"}, new Object[]{"callFunc", "addCategory", "$P0", "real_estate_agency", "realestateagents"}, new Object[]{"callFunc", "addCategory", "$P0", "restaurant", "restaurants"}, new Object[]{"callFunc", "addCategory", "$P0", "rv_park", "rvparks"}, new Object[]{"callFunc", "addCategory", "$P0", "school", "education"}, new Object[]{"callFunc", "addCategory", "$P0", "shoe_store", "shoes"}, new Object[]{"callFunc", "addCategory", "$P0", "shopping_mall", "shoppingcenters"}, new Object[]{"callFunc", "addCategory", "$P0", "spa", "spas"}, new Object[]{"callFunc", "addCategory", "$P0", "stadium", "stadiumsarenas"}, new Object[]{"callFunc", "addCategory", "$P0", "synagogue", "synagogues"}, new Object[]{"callFunc", "addCategory", "$P0", "taxi_stand", "taxis"}, new Object[]{"callFunc", "addCategory", "$P0", "train_station", "trainstations"}, new Object[]{"callFunc", "addCategory", "$P0", "travel_agency", "travelagents"}, new Object[]{"callFunc", "addCategory", "$P0", "university", "collegeuniv"}, new Object[]{"callFunc", "addCategory", "$P0", "veterinary_care", "vet"}, new Object[]{"callFunc", "addCategory", "$P0", "zoo", "zoos"}});
            this.put("getNearbyPOIs", new Object[]{new Object[]{"callFunc", "checkNull", "$P0", "$P2", "Latitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P3", "Longitude"}, new Object[]{"callFunc", "checkNull", "$P0", "$P4", "Radius"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P2", -90, "Latitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P3", -180, "Longitude"}, new Object[]{"callFunc", "checkLessThan", "$P0", "$P4", 0, "Radius"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P2", 90, "Latitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P3", 180, "Longitude"}, new Object[]{"callFunc", "checkGreaterThan", "$P0", "$P4", 40000, "Radius"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"callFunc", "checkIsEmpty", "$P0", "$P6", "Categories"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.method", "GET"}, new Object[]{"set", "$L0.url", "https://api.yelp.com/v2/search"}, new Object[]{"create", "$L1", "String", "?"}, new Object[]{"string.concat", "$L1", "$L1", "ll=", "$P2", "%2C", "$P3"}, new Object[]{"string.concat", "$L1", "$L1", "&radius_filter=", "$P4"}, new Object[]{"if!=than", "$P5", null, 2}, new Object[]{"string.urlEncode", "$L2", "$P5"}, new Object[]{"string.concat", "$L1", "$L1", "&term=", "$L2"}, new Object[]{"if!=than", "$P6", null, 3}, new Object[]{"callFunc", "getCategoriesString", "$P0", "$L2", "$P6"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "&category_filter=", "$L2"}, new Object[]{"create", "$L2", "Array"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"push", "$L2", "category_filter"}, new Object[]{"push", "$L2", "ll"}, new Object[]{"push", "$L2", "oauth_consumer_key"}, new Object[]{"push", "$L2", "oauth_nonce"}, new Object[]{"push", "$L2", "oauth_signature_method"}, new Object[]{"push", "$L2", "oauth_timestamp"}, new Object[]{"push", "$L2", "oauth_token"}, new Object[]{"push", "$L2", "oauth_version"}, new Object[]{"push", "$L2", "radius_filter"}, new Object[]{"if!=than", "$P5", null, 1}, new Object[]{"push", "$L2", "term"}, new Object[]{"create", "$L3", "Object"}, new Object[]{"string.concat", "$L3.ll", "$P2", ",", "$P3"}, new Object[]{"string.concat", "$L3.radius_filter", "$P4", ""}, new Object[]{"if!=than", "$P5", null, 1}, new Object[]{"set", "$L3.term", "$P5"}, new Object[]{"if!=than", "$P6", null, 1}, new Object[]{"callFunc", "getCategoriesString", "$P0", "$L3.category_filter", "$P6"}, new Object[]{"callFunc", "oAuth1:signRequest", "$P0", "$L0", "$L2", "$L3"}, new Object[]{"string.concat", "$L0.url", "$L0.url", "$L1"}, new Object[]{"http.requestCall", "$L2", "$L0"}, new Object[]{"callFunc", "checkHttpResponse", "$P0", "$L2"}, new Object[]{"json.parse", "$L3", "$L2.responseBody"}, new Object[]{"create", "$P1", "Array"}, new Object[]{"create", "$L4", "Number", 0}, new Object[]{"size", "$L5", "$L3.businesses"}, new Object[]{"if<than", "$L4", "$L5", 5}, new Object[]{"get", "$L6", "$L3.businesses", "$L4"}, new Object[]{"callFunc", "extractBusiness", "$P0", "$L7", "$L6"}, new Object[]{"push", "$P1", "$L7"}, new Object[]{"math.add", "$L4", "$L4", 1}, new Object[]{"jumpRel", -6}});
            this.put("checkNull", new Object[]{new Object[]{"if==than", "$P1", null, 3}, new Object[]{"string.concat", "$L0", "$P2", " is not allowed to be null."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkLessThan", new Object[]{new Object[]{"if<than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be less than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkGreaterThan", new Object[]{new Object[]{"if>than", "$P1", "$P2", 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be greater than ", "$P2", "."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("checkIsEmpty", new Object[]{new Object[]{"size", "$L0", "$P2"}, new Object[]{"if==than", "$L0", 0, 3}, new Object[]{"string.concat", "$L0", "$P3", " is not allowed to be empty."}, new Object[]{"create", "$L1", "Error", "$L0", "IllegalArgument"}, new Object[]{"throwError", "$L1"}});
            this.put("oAuth1:signRequest", new Object[]{new Object[]{"if==than", "$P1.requestHeaders", null, 1}, new Object[]{"create", "$P1.requestHeaders", "Object"}, new Object[]{"create", "$L0", "Object"}, new Object[]{"set", "$L0.oauth_consumer_key", "$P0.consumerKey"}, new Object[]{"callFunc", "oAuth1:generateNonce", "$L0.oauth_nonce"}, new Object[]{"set", "$L0.oauth_signature_method", "HMAC-SHA1"}, new Object[]{"create", "$L1", "Date"}, new Object[]{"math.multiply", "$L1", "$L1.Time", 0.001}, new Object[]{"math.floor", "$L1", "$L1"}, new Object[]{"string.format", "$L0.oauth_timestamp", "%d", "$L1"}, new Object[]{"set", "$L0.oauth_token", "$P0.token"}, new Object[]{"set", "$L0.oauth_version", "1.0"}, new Object[]{"string.urlEncode", "$L2", "$P1.url"}, new Object[]{"string.concat", "$L1", "$P1.method", "&", "$L2", "&"}, new Object[]{"set", "$L2", ""}, new Object[]{"set", "$L3", 0}, new Object[]{"size", "$L4", "$P2"}, new Object[]{"if<than", "$L3", "$L4", 12}, new Object[]{"get", "$L5", "$P2", "$L3"}, new Object[]{"if==than", "$L5", "oauth_callback", 1}, new Object[]{"set", "$L0.oauth_callback", "$P0.redirectUri"}, new Object[]{"get", "$L6", "$L0", "$L5"}, new Object[]{"if>than", "$L3", 0, 1}, new Object[]{"string.concat", "$L2", "$L2", "&"}, new Object[]{"if==than", "$L6", null, 1}, new Object[]{"get", "$L6", "$P3", "$L5"}, new Object[]{"string.urlEncode", "$L6", "$L6"}, new Object[]{"string.concat", "$L2", "$L2", "$L5", "=", "$L6"}, new Object[]{"math.add", "$L3", "$L3", 1}, new Object[]{"jumpRel", -13}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"string.concat", "$L1", "$L1", "$L2"}, new Object[]{"set", "$L2", "$P0.tokenSecret"}, new Object[]{"string.concat", "$L2", "$P0.consumerSecret", "&", "$L2"}, new Object[]{"crypt.hmac.sha1", "$L2", "$L2", "$L1"}, new Object[]{"array.uint8ToBase64", "$L2", "$L2"}, new Object[]{"string.urlEncode", "$L2", "$L2"}, new Object[]{"set", "$L0.oauth_signature", "$L2"}, new Object[]{"set", "$L2", "OAuth "}, new Object[]{"if!=than", "$L0.oauth_callback", null, 2}, new Object[]{"string.urlEncode", "$L3", "$L0.oauth_callback"}, new Object[]{"string.concat", "$L2", "$L2", "oauth_callback", "=\"", "$L3", "\"", ", "}, new Object[]{"string.concat", "$L2", "$L2", "oauth_consumer_key", "=\"", "$L0.oauth_consumer_key", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_nonce", "=\"", "$L0.oauth_nonce", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature", "=\"", "$L0.oauth_signature", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_signature_method", "=\"", "$L0.oauth_signature_method", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_timestamp", "=\"", "$L0.oauth_timestamp", "\""}, new Object[]{"if!=than", "$L0.oauth_token", null, 1}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_token", "=\"", "$L0.oauth_token", "\""}, new Object[]{"string.concat", "$L2", "$L2", ", ", "oauth_version", "=\"", "$L0.oauth_version", "\""}, new Object[]{"set", "$P1.requestHeaders.Authorization", "$L2"}});
            this.put("oAuth1:generateNonce", new Object[]{new Object[]{"create", "$L0", "Date"}, new Object[]{"string.format", "$L0", "%d", "$L0.Time"}, new Object[]{"hash.md5", "$L0", "$L0"}, new Object[]{"size", "$L1", "$L0"}, new Object[]{"set", "$L2", 0}, new Object[]{"set", "$P0", ""}, new Object[]{"get", "$L3", "$L0", "$L2"}, new Object[]{"string.format", "$L4", "%02x", "$L3"}, new Object[]{"string.concat", "$P0", "$P0", "$L4"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"if>=than", "$L2", "$L1", -5}});
            this.put("checkHttpResponse", new Object[]{new Object[]{"if>=than", "$P1.code", 400, 9}, new Object[]{"if==than", "$P2.code", 401, 2}, new Object[]{"create", "$L3", "Error", "Invalid credentials or access rights. Make sure that your application has read and write permission.", "Authentication"}, new Object[]{"throwError", "$L3"}, new Object[]{"if==than", "$P2.code", 503, 2}, new Object[]{"create", "$L3", "Error", "Service unavailable. Try again later.", "ServiceUnavailable"}, new Object[]{"throwError", "$L3"}, new Object[]{"json.parse", "$L0", "$P1.responseBody"}, new Object[]{"create", "$L1", "Error", "$L0.error.description", "Http"}, new Object[]{"throwError", "$L1"}});
            this.put("getCategoriesString", new Object[]{new Object[]{"create", "$P1", "String"}, new Object[]{"create", "$L0", "Number", 0}, new Object[]{"size", "$L1", "$P2"}, new Object[]{"if<than", "$L0", "$L1", 10}, new Object[]{"get", "$L2", "$P2", "$L0"}, new Object[]{"get", "$L2", "$P0.crToYelp", "$L2"}, new Object[]{"if==than", "$L2", null, 2}, new Object[]{"create", "$L3", "Error", "Unknown category.", "IllegalArgument"}, new Object[]{"throwError", "$L3"}, new Object[]{"if!=than", "$L0", 0, 1}, new Object[]{"string.concat", "$P1", "$P1", ","}, new Object[]{"string.concat", "$P1", "$P1", "$L2"}, new Object[]{"math.add", "$L0", "$L0", 1}, new Object[]{"jumpRel", -11}});
            this.put("extractBusiness", new Object[]{new Object[]{"create", "$L0", "Location"}, new Object[]{"set", "$L0.latitude", "$P2.location.coordinate.latitude"}, new Object[]{"set", "$L0.longitude", "$P2.location.coordinate.longitude"}, new Object[]{"create", "$L1", "Array"}, new Object[]{"create", "$L2", "Number", 0}, new Object[]{"size", "$L3", "$P2.categories"}, new Object[]{"if<than", "$L2", "$L3", 7}, new Object[]{"get", "$L4", "$P2.categories", "$L2"}, new Object[]{"get", "$L5", "$L4", 1}, new Object[]{"get", "$L6", "$P0.yelpToCr", "$L5"}, new Object[]{"if!=than", "$L6", null, 1}, new Object[]{"push", "$L1", "$L6"}, new Object[]{"math.add", "$L2", "$L2", 1}, new Object[]{"jumpRel", -8}, new Object[]{"create", "$P1", "POI", "$L1", "$P2.image_url", "$L0", "$P2.name", "$P2.phone"}});
            this.put("addCategory", new Object[]{new Object[]{"set", "$P0.crToYelp", "$P2", "$P1"}, new Object[]{"set", "$P0.yelpToCr", "$P1", "$P2"}});
        }
    });
    private Map<String, Object> interpreterStorage = new TreeMap<String, Object>();
    private Map<String, Object> instanceDependencyStorage;
    private List<Object> persistentStorage = new ArrayList<Object>();

    public Yelp(RedirectReceiver redirectReceiver, String consumerKey, String consumerSecret, String token, String tokenSecret) {
        this.persistentStorage.add(new HashMap());
        this.instanceDependencyStorage = new TreeMap<String, Object>();
        this.instanceDependencyStorage.put("redirectReceiver", redirectReceiver);
        new InitSelfTestTask("Yelp").start();
        this.interpreterStorage.put("consumerKey", consumerKey);
        this.interpreterStorage.put("consumerSecret", consumerSecret);
        this.interpreterStorage.put("token", token);
        this.interpreterStorage.put("tokenSecret", tokenSecret);
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        if (SERVICE_CODE.containsKey("init")) {
            ip.callFunction("init", this.interpreterStorage);
        }
    }

    @Override
    public List<POI> getNearbyPOIs(Double latitude, Double longitude, Long radius, String searchTerm, List<String> categories) {
        CloudRail.validateKey();
        new ReportCallTask("Yelp", "getNearbyPOIs").start();
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        ip.callFunction("getNearbyPOIs", this.interpreterStorage, null, latitude, longitude, radius, searchTerm, categories);
        Error error = (Error)ip.getError();
        if (error != null) {
            new ReportErrorTask("Yelp", "getNearbyPOIs").start();
            if (ErrorType.ILLEGAL_ARGUMENT.equals((Object)error.getErrorType())) {
                throw new IllegalArgumentException(error.toString());
            }
            if (ErrorType.AUTHENTICATION.equals((Object)error.getErrorType())) {
                throw new AuthenticationException(error.toString());
            }
            if (ErrorType.NOT_FOUND.equals((Object)error.getErrorType())) {
                throw new NotFoundException(error.toString());
            }
            if (ErrorType.HTTP.equals((Object)error.getErrorType())) {
                throw new HttpException(error.toString());
            }
            if (ErrorType.SERVICE_UNAVAILABLE.equals((Object)error.getErrorType())) {
                throw new ServiceUnavailableException(error.toString());
            }
            throw new RuntimeException(ip.getError().toString());
        }
        return (List)ip.getParameter(1);
    }

    public String saveAsString() {
        Interpreter ip = new Interpreter(new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage));
        return ip.saveAsString();
    }

    public void loadAsString(String savedState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        Interpreter ip = new Interpreter(sandbox);
        ip.loadAsString(savedState);
        this.persistentStorage = sandbox.getPersistentStorage();
    }

    public void resumeLogin(String executionState) throws ParseException {
        Sandbox sandbox = new Sandbox(SERVICE_CODE, this.persistentStorage, this.instanceDependencyStorage);
        sandbox.loadStateFromString(executionState);
        Interpreter ip = new Interpreter(sandbox);
        ip.resumeFunction("Authenticating:login", this.interpreterStorage);
    }
}

