/*
 * Decompiled with CFR 0.152.
 */
package codacy.api.services;

import codacy.api.CodacyClient;
import codacy.api.error.CodacyGenericException;
import codacy.api.error.CommitNotFoundException;
import codacy.api.model.CommitDelta;
import codacy.api.model.CommitOverview;
import codacy.api.request.Endpoints;

public class CommitService {
    private CodacyClient client = null;

    public CommitService(CodacyClient codacyClient) {
        this.client = codacyClient;
    }

    public CommitOverview getCommit(String string, String string2, String string3) throws CodacyGenericException, CommitNotFoundException {
        try {
            return this.client.getRequest(Endpoints.commit(string, string2, string3), CommitOverview.class);
        }
        catch (CodacyGenericException codacyGenericException) {
            if (codacyGenericException.getMessage().contains("could not retrieve commit data")) {
                throw new CommitNotFoundException(codacyGenericException);
            }
            throw codacyGenericException;
        }
    }

    public CommitDelta getCommitDelta(String string, String string2, String string3) throws CodacyGenericException, CommitNotFoundException {
        try {
            return this.client.getRequest(Endpoints.commitDelta(string, string2, string3), CommitDelta.class);
        }
        catch (CodacyGenericException codacyGenericException) {
            if (codacyGenericException.getMessage().contains("could not retrieve commit data")) {
                throw new CommitNotFoundException(codacyGenericException);
            }
            throw codacyGenericException;
        }
    }
}

