/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.Autogenerated;
import com.codename1.rad.annotations.RAD;
import com.codename1.rad.annotations.processors.BaseProcessor;
import com.codename1.rad.annotations.processors.ProcessingEnvironmentWrapper;
import com.codename1.rad.annotations.processors.ViewProcessor;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.codename1.rad.annotations.RAD", "com.codename1.rad.annotations.Stub", "com.codename1.rad.annotations.GenerateHelper"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class EntityProcessor
extends BaseProcessor {
    private RoundEnvironment roundEnv;
    private Set<Element> deferred = new HashSet<Element>();
    private boolean entitiesAddedThisRound;
    private int roundNum = 1;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(new ProcessingEnvironmentWrapper(processingEnv));
    }

    @Override
    void installTypes(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.env().nextRound();
        long startTime = System.currentTimeMillis();
        this.entitiesAddedThisRound = false;
        this.roundEnv = roundEnv;
        this.installTypes(annotations, roundEnv);
        boolean out = this.processSchemas(annotations, roundEnv);
        boolean bl = out = this.processEntities(annotations, roundEnv) || out;
        if (this.entitiesAddedThisRound) {
            this.deferred.addAll(new ViewProcessor(this.processingEnv).defer(annotations, roundEnv));
        } else {
            ViewProcessor vp = new ViewProcessor(this.processingEnv);
            vp.installTypes(annotations, new RoundEnvironmentWrapper(roundEnv, this.deferred));
            out = vp.process(annotations, new RoundEnvironmentWrapper(roundEnv, this.deferred)) || out;
            this.deferred.clear();
        }
        startTime = System.currentTimeMillis() - startTime;
        if (startTime > 10L) {
            System.out.println("CodeRAD Annotation Processor round " + this.roundNum + " took " + startTime + " milliseconds");
        }
        ++this.roundNum;
        return out;
    }

    public boolean processEntities(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ExecutionPlan plan = new ExecutionPlan(annotations, roundEnv);
        return true;
    }

    private void createEntityClass(EntityPlan entityPlan, RoundEnvironment roundEnv) {
        CodeBlock.Builder entityTypeInitializer = CodeBlock.builder();
        CodeBlock.Builder initializer = CodeBlock.builder();
        ArrayList methods = new ArrayList();
        ArrayList fields = new ArrayList();
        initializer.add("setEntityType(TYPE);\n", new Object[0]);
        entityPlan.properties.values().forEach(entityProperty -> {
            CodeBlock.Builder propertyStatement = CodeBlock.builder();
            propertyStatement.add("RAD_PROPERTY_" + entityProperty.name + "=" + entityProperty.getTypeString(roundEnv), new Object[0]);
            entityTypeInitializer.add(propertyStatement.build());
            MethodSpec.Builder methodSpecB = MethodSpec.methodBuilder((String)((EntityProperty)entityProperty).getGetterName()).returns(ClassName.get((TypeMirror)entityProperty.type)).addModifiers(new Modifier[]{Modifier.PUBLIC});
            if (entityProperty.type.getKind() == TypeKind.BOOLEAN) {
                methodSpecB.addCode("Boolean out = getBoolean(RAD_PROPERTY_" + entityProperty.name + "); \nreturn out == null ? false : out;", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.INT) {
                methodSpecB.addCode("Integer out = getInt(RAD_PROPERTY_" + entityProperty.name + ");\nreturn out == null ? 0 : out;", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.FLOAT) {
                methodSpecB.addCode("Float out = getFloat(RAD_PROPERTY_" + entityProperty.name + ");\nreturn out == null ? 0f : out;", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.DOUBLE) {
                methodSpecB.addCode("Double out = getDouble(RAD_PROPERTY_" + entityProperty.name + ");\nreturn out == null ? 0 : out;", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.LONG) {
                methodSpecB.addCode("Long out = getLong(RAD_PROPERTY_" + entityProperty.name + ");\nreturn out == null ? 0L : out;", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.DECLARED && entityProperty.type.toString().equals("java.util.Date")) {
                methodSpecB.addCode("return getDate(RAD_PROPERTY_" + entityProperty.name + ");", new Object[0]);
            } else if (entityProperty.type.getKind() == TypeKind.DECLARED && entityProperty.type.toString().equals("java.lang.String")) {
                methodSpecB.addCode("return getText(RAD_PROPERTY_" + entityProperty.name + ");", new Object[0]);
            } else {
                methodSpecB.addCode("return ($T)get(RAD_PROPERTY_" + entityProperty.name + ");", new Object[]{entityProperty.type});
            }
            MethodSpec methodSpec = methodSpecB.build();
            methods.add(methodSpec);
            methodSpec = MethodSpec.methodBuilder((String)((EntityProperty)entityProperty).getSetterName()).addParameter(ClassName.get((TypeMirror)entityProperty.type), "_value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("set(RAD_PROPERTY_" + entityProperty.name + ", _value);", new Object[0]).build();
            methods.add(methodSpec);
            ClassName propertyClass = ClassName.get((String)"com.codename1.rad.models", (String)"Property", (String[])new String[0]);
            FieldSpec.Builder fieldSpec = FieldSpec.builder((TypeName)propertyClass, (String)("RAD_PROPERTY_" + entityProperty.name), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            if (entityProperty.initialValue != null) {
                if ("new".equals(entityProperty.initialValue)) {
                    TypeElement typeEl;
                    TypeKind propKind = entityProperty.type.getKind();
                    String value = null;
                    if (propKind == TypeKind.INT || propKind == TypeKind.FLOAT || propKind == TypeKind.DOUBLE || propKind == TypeKind.LONG || propKind == TypeKind.BYTE || propKind == TypeKind.SHORT) {
                        value = "0";
                    } else if (propKind == TypeKind.DECLARED && (typeEl = (TypeElement)((DeclaredType)entityProperty.type).asElement()) != null) {
                        if (typeEl.getKind() == ElementKind.INTERFACE) {
                            if (this.isA(typeEl, "com.codename1.rad.models.Entity")) {
                                String implName = typeEl.getQualifiedName() + "Impl";
                                value = "new " + implName + "()";
                            } else if (typeEl.getQualifiedName().contentEquals("java.util.List") || typeEl.getQualifiedName().contentEquals("java.util.Collection")) {
                                value = "new java.util.ArrayList()";
                            } else if (typeEl.getQualifiedName().contentEquals("java.util.Set")) {
                                value = "new java.util.HashSet()";
                            } else {
                                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot find class to create new inital value for property " + entityProperty.name, entityProperty.methodElement);
                            }
                        } else {
                            value = "new " + typeEl.getQualifiedName() + "()";
                        }
                    }
                    if (value == null) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to find appropriate constructor for initialValue of property " + entityProperty.name + " of entity " + entityPlan.entityName, entityProperty.methodElement);
                    } else {
                        initializer.add(((EntityProperty)entityProperty).getSetterName() + "(" + value + ");\n", new Object[0]);
                    }
                } else {
                    initializer.add(((EntityProperty)entityProperty).getSetterName() + "(" + entityProperty.initialValue + ");\n", new Object[0]);
                }
            }
            fields.add(fieldSpec.build());
        });
        entityTypeInitializer.addStatement("register(" + entityPlan.entityName + "Impl.class, this);", new Object[0]);
        entityTypeInitializer.addStatement("register(" + entityPlan.entityName + ".class, this, type -> {return new " + entityPlan.entityName + "Impl();});", new Object[0]);
        TypeSpec entityType = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"EntityType", (String[])new String[0])).addInitializerBlock(entityTypeInitializer.build()).build();
        TypeSpec.Builder entitySpec = TypeSpec.classBuilder((String)(entityPlan.entityName + "Impl")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Autogenerated.class).addField(FieldSpec.builder((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"EntityType", (String[])new String[0]), (String)"TYPE", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{entityType}).build()).addInitializerBlock(initializer.build());
        if (entityPlan.entityAbstractClass != null) {
            entitySpec.superclass(entityPlan.entityAbstractClass.asType());
        } else {
            entitySpec.superclass((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"BaseEntity", (String[])new String[0]));
        }
        if (entityPlan.entityInterface != null) {
            entitySpec.addSuperinterface(entityPlan.entityInterface.asType());
        }
        for (MethodSpec methodSpec : methods) {
            entitySpec.addMethod(methodSpec);
        }
        for (FieldSpec fieldSpec : fields) {
            entitySpec.addField(fieldSpec);
        }
        JavaFile javaFile = JavaFile.builder((String)entityPlan.packageName, (TypeSpec)entitySpec.build()).build();
        try {
            JavaFileObject entityFile = this.processingEnv.getFiler().createSourceFile(entityPlan.packageName + "." + entityPlan.entityName + "Impl", entityPlan.entityAbstractClass, entityPlan.entityInterface);
            try (PrintWriter writer = new PrintWriter(entityFile.openWriter());){
                this.entitiesAddedThisRound = true;
                javaFile.writeTo((Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createEntityWrapper(EntityPlan entityPlan, RoundEnvironment roundEnv) {
        ArrayList methods = new ArrayList();
        ArrayList fields = new ArrayList();
        entityPlan.properties.values().forEach(entityProperty -> {
            MethodSpec methodSpec = MethodSpec.methodBuilder((String)((EntityProperty)entityProperty).getGetterName()).returns(ClassName.get((TypeMirror)entityProperty.type)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("return ($T)getEntity()." + entityProperty.getWrapperAccessorCall(roundEnv) + ";", new Object[]{entityProperty.type}).build();
            methods.add(methodSpec);
            methodSpec = MethodSpec.methodBuilder((String)((EntityProperty)entityProperty).getSetterName()).addParameter(ClassName.get((TypeMirror)entityProperty.type), "_value", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("getEntity()." + entityProperty.getWrapperSetterCall(roundEnv, "_value") + ";", new Object[0]).build();
            methods.add(methodSpec);
        });
        MethodSpec.Builder cnst = MethodSpec.constructorBuilder().addParameter((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"Entity", (String[])new String[0]), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("super(entity);", new Object[0]);
        MethodSpec.Builder wrap = MethodSpec.methodBuilder((String)"wrap").addParameter((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"Entity", (String[])new String[0]), "entity", new Modifier[0]).returns((TypeName)ClassName.get((TypeElement)entityPlan.entityInterface)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addCode("if (entity == null) return null;", new Object[0]).addCode("if (entity instanceof $T) return ($T)entity;", new Object[]{entityPlan.entityInterface, entityPlan.entityInterface}).addCode("$T wrapper = entity.getEntity().getWrapper($T.class);", new Object[]{entityPlan.entityInterface, entityPlan.entityInterface}).addCode("if (wrapper != null) return wrapper;", new Object[0]).addCode("wrapper = new " + entityPlan.entityName + "Wrapper(entity); entity.getEntity().addWrapper(wrapper);return wrapper;", new Object[0]);
        TypeSpec.Builder entitySpec = TypeSpec.classBuilder((String)(entityPlan.entityName + "Wrapper")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"SimpleEntityWrapper", (String[])new String[0])).addMethod(cnst.build()).addMethod(wrap.build()).addAnnotation(Autogenerated.class);
        if (entityPlan.entityInterface != null) {
            entitySpec.addSuperinterface(entityPlan.entityInterface.asType());
        }
        for (MethodSpec methodSpec : methods) {
            entitySpec.addMethod(methodSpec);
        }
        for (FieldSpec fieldSpec : fields) {
            entitySpec.addField(fieldSpec);
        }
        JavaFile javaFile = JavaFile.builder((String)entityPlan.packageName, (TypeSpec)entitySpec.build()).build();
        try {
            JavaFileObject entityFile = this.processingEnv.getFiler().createSourceFile(entityPlan.packageName + "." + entityPlan.entityName + "Wrapper", entityPlan.entityAbstractClass, entityPlan.entityInterface);
            try (PrintWriter writer = new PrintWriter(entityFile.openWriter());){
                this.entitiesAddedThisRound = true;
                javaFile.writeTo((Appendable)writer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class EntityPlan {
        private boolean executed;
        private String packageName;
        private String entityName;
        private List<TypeElement> toProcess = new ArrayList<TypeElement>();
        private TypeElement entityInterface;
        private TypeElement entityAbstractClass;
        private TypeElement entityImplementationClass;
        private TypeElement entityWrapperClass;
        private Map<String, EntityProperty> properties = new HashMap<String, EntityProperty>();

        EntityPlan(String packageName, String name) {
            this.entityName = name;
            this.packageName = packageName;
        }

        void init(RoundEnvironment env) {
            Elements elements = EntityProcessor.this.processingEnv.getElementUtils();
            this.entityInterface = elements.getTypeElement(this.packageName + ".I" + this.entityName);
            if (this.entityInterface == null || this.entityInterface.getKind() != ElementKind.INTERFACE) {
                this.entityInterface = elements.getTypeElement(this.packageName + "." + this.entityName);
                if (this.entityInterface == null || this.entityInterface.getKind() != ElementKind.INTERFACE) {
                    this.entityInterface = null;
                }
            }
            this.entityAbstractClass = elements.getTypeElement(this.packageName + ".Abstract" + this.entityName);
            this.entityImplementationClass = elements.getTypeElement(this.packageName + "." + this.entityName + "Impl");
            this.entityWrapperClass = elements.getTypeElement(this.packageName + "." + this.entityName + "Wrapper");
            this.initProperties();
        }

        void initProperties() {
            for (TypeElement el : new TypeElement[]{this.entityInterface, this.entityAbstractClass}) {
                if (el == null) continue;
                EntityProcessor.this.getAllTaggedAndAbstractMethods(null, el).forEach(methodEl -> {
                    String initialValue;
                    RAD radAnno;
                    String propName = BaseProcessor.getPropName(methodEl.getSimpleName().toString());
                    if (propName == null) {
                        return;
                    }
                    if (methodEl.getSimpleName().toString().startsWith("is") && !"boolean".equalsIgnoreCase(methodEl.getReturnType().toString()) && !"java.lang.Boolean".equalsIgnoreCase(methodEl.getReturnType().toString())) {
                        return;
                    }
                    ExecutableElement eeMethod = methodEl;
                    String methodName = eeMethod.getSimpleName().toString();
                    TypeMirror returnTypeMirror = eeMethod.getReturnType();
                    TypeElement returnType = (TypeElement)EntityProcessor.this.processingEnv.getTypeUtils().asElement(returnTypeMirror);
                    TypeMirror paramTypeMirror = null;
                    if (eeMethod.getParameters().size() == 1) {
                        paramTypeMirror = eeMethod.getParameters().get(0).asType();
                    }
                    TypeMirror propTypeMirror = paramTypeMirror == null ? returnTypeMirror : paramTypeMirror;
                    TypeElement propType = (TypeElement)EntityProcessor.this.processingEnv.getTypeUtils().asElement(propTypeMirror);
                    EntityProperty prop = this.getProperty(propName, propTypeMirror, eeMethod);
                    if (prop.type != propTypeMirror) {
                        EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Mismatch property type.  Getter and setter should have same type", eeMethod);
                    }
                    prop.addTags(EntityProcessor.this.extractTags((Element)methodEl));
                    if (!this.validatePropertyTags(prop, (Element)methodEl)) {
                        EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Two properties found with the same tags.", el);
                    }
                    if ((radAnno = methodEl.getAnnotation(RAD.class)) != null && (initialValue = radAnno.initialValue()) != null && !initialValue.isEmpty()) {
                        prop.setInitialValue(initialValue);
                    }
                });
            }
        }

        EntityProperty getProperty(String name, TypeMirror type, ExecutableElement methodElement) {
            if (!this.properties.containsKey(name)) {
                EntityProperty prop = new EntityProperty(name, type, methodElement);
                this.properties.put(name, prop);
            }
            return this.properties.get(name);
        }

        boolean validatePropertyTags(EntityProperty prop, Element methodEl) {
            HashSet<String> sandbox = new HashSet<String>();
            sandbox.addAll(prop.tags);
            int numTags = sandbox.size();
            for (EntityProperty otherProp : this.properties.values()) {
                if (otherProp == prop) continue;
                sandbox.removeAll(otherProp.tags);
                if (sandbox.size() == numTags) continue;
                EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Two properties with the same tags.", methodEl);
                return false;
            }
            return true;
        }

        void executePlan(RoundEnvironment roundEnv) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            if (this.entityInterface != null && this.toProcess.contains(this.entityInterface)) {
                if (this.entityAbstractClass == null || EntityProcessor.this.isAutogenerated(this.entityAbstractClass)) {
                    this.generateImplementationClass(roundEnv);
                }
                if (this.entityWrapperClass == null || EntityProcessor.this.isAutogenerated(this.entityWrapperClass)) {
                    this.generateWrapperClass(roundEnv);
                }
            }
            if (this.entityAbstractClass != null && this.toProcess.contains(this.entityAbstractClass) && (this.entityImplementationClass == null || EntityProcessor.this.isAutogenerated(this.entityImplementationClass))) {
                this.generateImplementationClass(roundEnv);
            }
        }

        void generateAbstractClass() {
            TypeSpec.Builder entitySpec = TypeSpec.classBuilder((String)("Abstract" + this.entityName)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(RAD.class).addAnnotation(Autogenerated.class).addSuperinterface(this.entityInterface.asType()).superclass((TypeName)ClassName.get((String)"com.codename1.rad.models", (String)"Entity", (String[])new String[0]));
            JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)entitySpec.build()).build();
            try {
                JavaFileObject entityFile = EntityProcessor.this.processingEnv.getFiler().createSourceFile(this.packageName + ".Abstract" + this.entityName, this.entityInterface);
                try (PrintWriter writer = new PrintWriter(entityFile.openWriter());){
                    EntityProcessor.this.entitiesAddedThisRound = true;
                    javaFile.writeTo((Appendable)writer);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void generateWrapperClass(RoundEnvironment roundEnv) {
            EntityProcessor.this.createEntityWrapper(this, roundEnv);
        }

        void generateImplementationClass(RoundEnvironment roundEnv) {
            EntityProcessor.this.createEntityClass(this, roundEnv);
        }

        void generateInterface() {
        }
    }

    private class EntityProperty {
        String name;
        TypeMirror type;
        Element methodElement;
        Set<String> tags = new LinkedHashSet<String>();
        String initialValue = null;

        EntityProperty(String name, TypeMirror type, Element methodElement) {
            this.name = name;
            this.type = type;
            this.methodElement = methodElement;
            if (type == null) {
                EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Property " + name + " has a null type", methodElement);
                throw new IllegalArgumentException("Property " + name + " has a null type");
            }
        }

        void setInitialValue(String value) {
            this.initialValue = value;
        }

        void addTags(String ... tags) {
            this.tags.addAll(Arrays.asList(tags));
        }

        String getWrapperAccessorCall(RoundEnvironment roundEnv) {
            TypeElement propType = (TypeElement)EntityProcessor.this.processingEnv.getTypeUtils().asElement(this.type);
            TypeMirror propTypeMirror = this.type;
            String typeStr = null;
            switch (propTypeMirror.getKind()) {
                case DOUBLE: {
                    typeStr = "Double";
                    break;
                }
                case INT: {
                    typeStr = "Int";
                    break;
                }
                case FLOAT: {
                    typeStr = "Float";
                    break;
                }
                case BOOLEAN: {
                    typeStr = "Boolean";
                    break;
                }
                case LONG: {
                    typeStr = "Long";
                }
            }
            String argsPrefix = "";
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.BaseEntity")) {
                typeStr = "Entity";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                typeStr = "EntityList";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.util.Date")) {
                typeStr = "Date";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.String")) {
                typeStr = "Text";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Double")) {
                typeStr = "Double";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Integer")) {
                typeStr = "Integer";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Float")) {
                typeStr = "Float";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Boolean")) {
                typeStr = "Boolean";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Long")) {
                typeStr = "Long";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.EntityList")) {
                typeStr = "EntityList";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.Entity")) {
                typeStr = "Entity";
            }
            StringBuilder tagsStrBuilder = new StringBuilder();
            for (String tag : this.tags) {
                if (tagsStrBuilder.length() > 0) {
                    tagsStrBuilder.append(", ");
                }
                tagsStrBuilder.append(tag);
            }
            String tagsStr = tagsStrBuilder.toString();
            if (typeStr == null) {
                typeStr = "";
            }
            return "get" + typeStr + "(" + argsPrefix + tagsStr + ")";
        }

        String getWrapperSetterCall(RoundEnvironment roundEnv, String valueVarName) {
            TypeElement propType = (TypeElement)EntityProcessor.this.processingEnv.getTypeUtils().asElement(this.type);
            TypeMirror propTypeMirror = this.type;
            String typeStr = null;
            switch (propTypeMirror.getKind()) {
                case DOUBLE: {
                    typeStr = "Double";
                    break;
                }
                case INT: {
                    typeStr = "Int";
                    break;
                }
                case FLOAT: {
                    typeStr = "Float";
                    break;
                }
                case BOOLEAN: {
                    typeStr = "Boolean";
                    break;
                }
                case LONG: {
                    typeStr = "Long";
                }
            }
            String argsPrefix = "";
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity")) {
                typeStr = "";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                typeStr = "";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.util.Date")) {
                typeStr = "Date";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.String")) {
                typeStr = "Text";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Double")) {
                typeStr = "Double";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Integer")) {
                typeStr = "Integer";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Float")) {
                typeStr = "Float";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Boolean")) {
                typeStr = "Boolean";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Long")) {
                typeStr = "Long";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.EntityList")) {
                typeStr = "";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.Entity")) {
                typeStr = "";
            }
            StringBuilder tagsStrBuilder = new StringBuilder();
            for (String tag : this.tags) {
                if (tagsStrBuilder.length() > 0) {
                    tagsStrBuilder.append(", ");
                }
                tagsStrBuilder.append(tag);
            }
            String tagsStr = tagsStrBuilder.toString();
            if (typeStr == null) {
                typeStr = "";
            }
            return "set" + typeStr + "(" + argsPrefix + tagsStr + ", " + valueVarName + ")";
        }

        String getTypeString(RoundEnvironment roundEnv) {
            TypeElement propType = (TypeElement)EntityProcessor.this.processingEnv.getTypeUtils().asElement(this.type);
            if (this.type == null) {
                EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Property " + this.name + " has no type");
                throw new IllegalStateException("Property " + this.name + " has no type");
            }
            TypeMirror propTypeMirror = this.type;
            String typeStr = null;
            switch (propTypeMirror.getKind()) {
                case DOUBLE: {
                    typeStr = "Double";
                    break;
                }
                case INT: {
                    typeStr = "Integer";
                    break;
                }
                case FLOAT: {
                    typeStr = "Float";
                    break;
                }
                case BOOLEAN: {
                    typeStr = "Boolean";
                    break;
                }
                case LONG: {
                    typeStr = "Long";
                }
            }
            String argsPrefix = "";
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity")) {
                typeStr = "entity";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                typeStr = "entityList";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.util.Date")) {
                typeStr = "date";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.String")) {
                typeStr = "string";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Double")) {
                typeStr = "Double";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Integer")) {
                typeStr = "Integer";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Float")) {
                typeStr = "Float";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Boolean")) {
                typeStr = "Boolean";
            }
            if (typeStr == null && propType.getQualifiedName().contentEquals("java.lang.Long")) {
                typeStr = "Long";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.EntityList")) {
                typeStr = "list";
                argsPrefix = propType.getQualifiedName() + ".class, ";
            }
            if (typeStr == null && EntityProcessor.this.isA(propType, "com.codename1.rad.models.Entity")) {
                typeStr = "entity";
                argsPrefix = propType.getQualifiedName() + ".class, ";
            }
            if (typeStr == null) {
                typeStr = "object";
                argsPrefix = propType.getQualifiedName() + ".class, ";
            }
            StringBuilder tagsStrBuilder = new StringBuilder();
            for (String tag : this.tags) {
                if (tagsStrBuilder.length() > 0) {
                    tagsStrBuilder.append(", ");
                }
                tagsStrBuilder.append(tag);
            }
            String tagsStr = tagsStrBuilder.toString();
            return typeStr + "(" + argsPrefix + "tags(" + tagsStr + "));";
        }

        private String getGetterName() {
            String prefix = "get";
            if (this.type.getKind() == TypeKind.BOOLEAN || this.type.toString().equals("java.lang.Boolean")) {
                prefix = "is";
            }
            return prefix + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }

        private String getSetterName() {
            return "set" + this.name.substring(0, 1).toUpperCase() + this.name.substring(1);
        }
    }

    private class ExecutionPlan {
        private Map<String, EntityPlan> entityPlans = new HashMap<String, EntityPlan>();
        private RoundEnvironment roundEnv;
        private Set<? extends TypeElement> annotations;

        ExecutionPlan(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            this.annotations = annotations;
            this.roundEnv = roundEnv;
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(RAD.class);
            LinkedHashSet<EntityPlan> plans = new LinkedHashSet<EntityPlan>();
            TypeElement entityView = EntityProcessor.this.processingEnv.getElementUtils().getTypeElement("com.codename1.rad.ui.EntityView");
            TypeElement componentBuilder = EntityProcessor.this.processingEnv.getElementUtils().getTypeElement("com.codename1.rad.ui.ComponentBuilder");
            TypeElement component = EntityProcessor.this.processingEnv.getElementUtils().getTypeElement("com.codename1.ui.Component");
            for (Element element : annotatedElements) {
                TypeElement typeEl;
                if (!(element instanceof TypeElement) || EntityProcessor.this.isA(typeEl = (TypeElement)element, "com.codename1.rad.ui.EntityView") || EntityProcessor.this.isA(typeEl, "com.codename1.rad.ui.ComponentBuilder")) continue;
                if (!this.validate(typeEl)) {
                    return;
                }
                EntityPlan plan = this.getEntityPlanFor(typeEl);
                if (plan == null) {
                    throw new RuntimeException("Problem processing @RAD annotation.  Failed to get plan for element");
                }
                plan.toProcess.add(typeEl);
                plans.add(plan);
            }
            for (EntityPlan entityPlan : plans) {
                entityPlan.executePlan(roundEnv);
            }
        }

        boolean processEntityView(TypeElement el) {
            return true;
        }

        boolean validate(TypeElement el) {
            if (el.getKind() == ElementKind.CLASS) {
                if (!el.getSimpleName().toString().startsWith("Abstract")) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "When using @RAD annotation, class name must begin with 'Abstract'", el);
                    return false;
                }
                if (!el.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "When using @RAD annotation, class must be abstract", el);
                    return false;
                }
                if (!EntityProcessor.this.isA(el, "com.codename1.rad.models.Entity")) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "When using @RAD annotation, class must implement Entity.  " + el.getSimpleName() + " does not.", el);
                    return false;
                }
                if (el.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Classes annotated with @RAD cannot be inner classes. ", el);
                    return false;
                }
                if (EntityProcessor.this.getPackageElement(el) == null) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Classes annoated with @RAD must be in a package.  Cannot be in default package.", el);
                    return false;
                }
            }
            if (el.getKind() == ElementKind.INTERFACE) {
                if (!EntityProcessor.this.isA(el, "com.codename1.rad.models.Entity")) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "When Using @RAD annotation, interface must extends Entity", el);
                    return false;
                }
                if (el.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Interfaces annotated with @RAD cannot be inner classes. ", el);
                    return false;
                }
                if (EntityProcessor.this.getPackageElement(el) == null) {
                    EntityProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Interfaces annoated with @RAD must be in a package.  Cannot be in default package.", el);
                    return false;
                }
            }
            return true;
        }

        synchronized EntityPlan getEntityPlanFor(TypeElement el) {
            try {
                String entityName = EntityProcessor.this.getEntityNameFor(el);
                if (el.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
                    // empty if block
                }
                if (!this.entityPlans.containsKey(entityName)) {
                    EntityPlan plan = new EntityPlan(EntityProcessor.this.getPackageElement(el).getQualifiedName().toString(), entityName);
                    plan.init(this.roundEnv);
                    this.entityPlans.put(entityName, plan);
                }
                return this.entityPlans.get(entityName);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }

    private class RoundEnvironmentWrapper
    implements RoundEnvironment {
        final RoundEnvironment wrapped;
        final HashSet<Element> deferred;

        RoundEnvironmentWrapper(RoundEnvironment wrapped, Set<Element> deferred) {
            this.wrapped = wrapped;
            this.deferred = new HashSet();
            this.deferred.addAll(deferred);
        }

        @Override
        public boolean processingOver() {
            return this.wrapped.processingOver();
        }

        @Override
        public boolean errorRaised() {
            return this.wrapped.errorRaised();
        }

        @Override
        public Set<? extends Element> getRootElements() {
            HashSet<? extends Element> out = new HashSet<Element>();
            out.addAll(this.wrapped.getRootElements());
            return out;
        }

        @Override
        public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
            HashSet<? extends Element> out = new HashSet<Element>();
            out.addAll(this.wrapped.getElementsAnnotatedWith(a));
            return out;
        }

        @Override
        public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a) {
            HashSet<? extends Element> out = new HashSet<Element>();
            out.addAll(this.wrapped.getElementsAnnotatedWith(a));
            out.addAll(this.deferred.stream().filter(e -> e.getAnnotation(a) != null).collect(Collectors.toList()));
            return out;
        }
    }
}

