/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.Inject;
import com.codename1.rad.annotations.RAD;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProcessingEnvironmentWrapper
implements ProcessingEnvironment {
    private int roundNum = 0;
    private ProcessingEnvironment wrapped;
    private TypesWrapper types;
    private ElementsWrapper elements;
    private Map<String, CustomTypeElement> typeMap = new HashMap<String, CustomTypeElement>();
    private Map<String, PackageWrapper> packageMap = new HashMap<String, PackageWrapper>();
    private Map<String, TypeElement> lcTypeMap = new HashMap<String, TypeElement>();
    public Map<String, TypeElementHelper> typeHelperMap = new HashMap<String, TypeElementHelper>();

    public TypeElementHelper getTypeElementHelper(TypeElement typeElement) {
        if (!this.typeHelperMap.containsKey(typeElement.getQualifiedName().toString())) {
            TypeElementHelper helper = new TypeElementHelper();
            helper.publicConstructors.addAll(this.elements.getAllMembers(typeElement).stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR && e.getModifiers().contains((Object)Modifier.PUBLIC)).collect(Collectors.toList()));
            this.typeHelperMap.put(typeElement.getQualifiedName().toString(), helper);
        }
        return this.typeHelperMap.get(typeElement.getQualifiedName().toString());
    }

    public void nextRound() {
        ++this.roundNum;
    }

    public void addTypes(CustomTypeElement ... types) {
        for (CustomTypeElement e : types) {
            this.typeMap.put(e.getQualifiedName().toString(), e);
            Element enclosing = e.getEnclosingElement();
            if (enclosing == null && e.getNestingKind() == NestingKind.TOP_LEVEL) {
                enclosing = this.elements.getPackageElement(this.extractParentQualifiedName(e.getQualifiedName().toString()));
            }
            if (enclosing == null || enclosing.getKind() != ElementKind.PACKAGE) continue;
            if (e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.CLASS) {
                ((PackageWrapper)this.wrap(enclosing)).addToIndex(e);
            }
            ((PackageWrapper)this.wrap(enclosing)).enclosedElements.add(e);
        }
    }

    public ProcessingEnvironmentWrapper(ProcessingEnvironment wrapped) {
        this.wrapped = wrapped;
        this.types = new TypesWrapper(wrapped.getTypeUtils());
        this.elements = new ElementsWrapper(wrapped.getElementUtils());
    }

    @Override
    public Map<String, String> getOptions() {
        return this.wrapped.getOptions();
    }

    @Override
    public Messager getMessager() {
        return this.wrapped.getMessager();
    }

    @Override
    public Filer getFiler() {
        return this.wrapped.getFiler();
    }

    @Override
    public Elements getElementUtils() {
        return this.elements;
    }

    @Override
    public Types getTypeUtils() {
        return this.types;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return this.wrapped.getSourceVersion();
    }

    @Override
    public Locale getLocale() {
        return this.wrapped.getLocale();
    }

    private TypeMirror getTypeParameter(DeclaredType type, ExecutableElement method, TypeMirror param) {
        if (param.getKind() == TypeKind.DECLARED || param.toString().length() != 1 || !Character.isUpperCase(param.toString().charAt(0))) {
            return param;
        }
        System.out.println("getTypeParameter(" + type + ", " + method + ", " + param);
        TypeElement typeEl = (TypeElement)type.asElement();
        int index = -1;
        for (TypeParameterElement typeParameterElement : typeEl.getTypeParameters()) {
            System.out.println("Checking " + typeParameterElement);
            ++index;
            if (!typeParameterElement.asType().toString().equals(param.toString())) continue;
            System.out.println("type: " + typeParameterElement.asType());
            System.out.println("Type arguments " + type.getTypeArguments());
            if (type.getTypeArguments().size() > index) {
                return type.getTypeArguments().get(index);
            }
            return typeParameterElement.asType();
        }
        return null;
    }

    public RDeclaredType createDeclaredType(final String type, final TypeMirror ... _typeArguments) {
        if (type == null) {
            throw new IllegalArgumentException("createDeclaredType requires non-null type");
        }
        String packageName = this.extractParentQualifiedName(type);
        PackageElement pkg = this.elements.getPackageElement(packageName);
        return new RDeclaredType(){
            ArrayList<AnnotationMirror> annotationMirrors = new ArrayList();
            List<TypeMirror> typeArguments = new ArrayList<TypeMirror>(Arrays.asList(_typeArguments));

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(type);
                if (_typeArguments.length > 0) {
                    sb.append("<");
                    for (int i = 0; i < _typeArguments.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(_typeArguments[i]);
                    }
                    sb.append(">");
                }
                return sb.toString();
            }

            @Override
            public List<? extends AnnotationMirror> getAnnotationMirrors() {
                return this.annotationMirrors;
            }

            @Override
            public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                return null;
            }

            @Override
            public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                return (Annotation[])Array.newInstance(Annotation.class, 0);
            }

            @Override
            public TypeKind getKind() {
                return TypeKind.DECLARED;
            }

            @Override
            public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                return v.visit(this);
            }

            @Override
            public Element asElement() {
                return ProcessingEnvironmentWrapper.this.elements.getTypeElement(type);
            }

            @Override
            public TypeMirror getEnclosingType() {
                return this.asElement().getEnclosingElement().asType();
            }

            @Override
            public List<? extends TypeMirror> getTypeArguments() {
                return this.typeArguments;
            }
        };
    }

    public <T extends Element> T wrap(T element) {
        if (element == null) {
            return null;
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            if (element instanceof PackageWrapper) {
                return element;
            }
            return (T)this.elements.getPackageElement(((PackageElement)element).getQualifiedName());
        }
        return element;
    }

    public <T extends Element> T unwrap(T element) {
        if (element == null) {
            return null;
        }
        if (element.getKind() == ElementKind.PACKAGE && element instanceof PackageWrapper) {
            PackageElement pe = ((PackageWrapper)element).wrapped();
            if (pe == null) {
                pe = this.elements.wrapped.getPackageElement(pe.getQualifiedName());
            }
            return (T)pe;
        }
        return element;
    }

    public String toSimpleName(String fqn) {
        if (!fqn.contains(".")) {
            return fqn;
        }
        return fqn.substring(fqn.lastIndexOf(".") + 1);
    }

    public String toQualifiedName(String packageName, String name) {
        if (packageName == null || packageName.isEmpty() || name.startsWith(packageName + ".")) {
            return name;
        }
        return packageName + "." + name;
    }

    public String extractParentQualifiedName(String name) {
        if (name.contains(".")) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return "";
    }

    public boolean isNativeElement(Element el) {
        return !(el instanceof RElement);
    }

    public boolean isNativeElements(Collection<Element> elements) {
        for (Element e : elements) {
            if (this.isNativeElement(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isNativeMirror(TypeMirror tm) {
        return !(tm instanceof RTypeMirror);
    }

    public boolean isNativeMirrors(Collection<TypeMirror> mirrors) {
        for (TypeMirror tm : mirrors) {
            if (this.isNativeMirror(tm)) continue;
            return false;
        }
        return true;
    }

    public boolean isNativeMirrors(TypeMirror ... mirrors) {
        for (TypeMirror tm : mirrors) {
            if (this.isNativeMirror(tm)) continue;
            return false;
        }
        return true;
    }

    private Inject getInjectAnnotation() {
        TypeElement controller = this.elements.getTypeElement("com.codename1.rad.ui.ViewContext");
        return controller.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CONSTRUCTOR && ((ExecutableElement)e).getParameters().size() > 0).map(e -> ((ExecutableElement)e).getParameters().get(0).getAnnotation(Inject.class)).findFirst().orElse(null);
    }

    public class PackageWrapper
    implements RElement,
    PackageElement {
        private final Name qualifiedName;
        private TypeMirror type;
        private List<Element> enclosedElements = new ArrayList<Element>();
        private int indexUpdateRound = -1;
        private Map<String, List<TypeElement>> tagMap = new HashMap<String, List<TypeElement>>();
        private Set<String> indexed = new HashSet<String>();
        private Map<String, TypeElement> lcTypeMap = new HashMap<String, TypeElement>();
        private Map<String, Set<TypeElement>> subTypeInfo = new HashMap<String, Set<TypeElement>>();
        private Map<String, InnerClassIndex> lcInnerClassIndex = new HashMap<String, InnerClassIndex>();

        private PackageElement wrapped() {
            return ProcessingEnvironmentWrapper.this.elements.wrapped.getPackageElement(this.qualifiedName);
        }

        public void updateIndex() {
            if (ProcessingEnvironmentWrapper.this.roundNum <= this.indexUpdateRound) {
                return;
            }
            this.indexUpdateRound = ProcessingEnvironmentWrapper.this.roundNum;
            for (Element element : this.getEnclosedElements()) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) continue;
                this.addToIndex((TypeElement)element);
            }
        }

        private void updateInnerClassIndexFor(String simpleName) {
            this.updateIndex();
            TypeElement enclosingClass = this.getEnclosedTypeIgnoreCase(simpleName);
            if (enclosingClass == null) {
                return;
            }
            InnerClassIndex index = this.lcInnerClassIndex.get(simpleName.toString().toLowerCase());
            if (index == null) {
                boolean foundNew;
                index = new InnerClassIndex();
                for (TypeElement innerTypeEl : enclosingClass.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.CLASS).collect(Collectors.toList())) {
                    if (innerTypeEl.getSimpleName().length() == 0) continue;
                    String key = innerTypeEl.getQualifiedName().toString().substring(enclosingClass.getQualifiedName().length() + 1);
                    key = key.toLowerCase();
                    index.lcInnerClassMap.put(key, innerTypeEl);
                }
                boolean bl = foundNew = !index.lcInnerClassMap.isEmpty();
                while (foundNew) {
                    foundNew = false;
                    ArrayList toCheck = new ArrayList(index.lcInnerClassMap.values());
                    for (TypeElement innerTypeEl : toCheck) {
                        for (TypeElement innerInnerTypeEl : innerTypeEl.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.CLASS).collect(Collectors.toList())) {
                            if (innerTypeEl.getSimpleName().length() == 0) continue;
                            String key = innerInnerTypeEl.getQualifiedName().toString().substring(enclosingClass.getQualifiedName().length() + 1);
                            key = key.toLowerCase();
                            if (index.lcInnerClassMap.containsKey(key)) continue;
                            index.lcInnerClassMap.put(key, innerInnerTypeEl);
                            foundNew = true;
                        }
                    }
                }
            }
        }

        public TypeElement getEnclosedTypeIgnoreCase(CharSequence simpleName) {
            this.updateIndex();
            String nameStr = simpleName.toString();
            if (nameStr.contains(".")) {
                String enclosingClassSimpleName = nameStr.substring(0, nameStr.indexOf("."));
                if (!this.lcTypeMap.containsKey(enclosingClassSimpleName.toLowerCase())) {
                    return null;
                }
                String innerClassRelativeQualifiedName = nameStr.substring(enclosingClassSimpleName.length() + 1);
                this.updateInnerClassIndexFor(enclosingClassSimpleName);
                return (TypeElement)this.lcInnerClassIndex.get(enclosingClassSimpleName.toLowerCase()).lcInnerClassMap.get(innerClassRelativeQualifiedName.toLowerCase());
            }
            return this.lcTypeMap.get(simpleName.toString().toLowerCase());
        }

        public void addToIndex(TypeElement el) {
            if (this.indexed.contains(el.getSimpleName().toString())) {
                return;
            }
            this.indexed.add(el.getSimpleName().toString());
            this.lcTypeMap.put(el.getSimpleName().toString().toLowerCase(), el);
            RAD anno = el.getAnnotation(RAD.class);
            if (anno != null) {
                for (String string : anno.tag()) {
                    String lcTag = string.toLowerCase();
                    List<TypeElement> tagList = this.tagMap.get(lcTag);
                    if (tagList == null) {
                        tagList = new ArrayList<TypeElement>();
                        this.tagMap.put(lcTag, tagList);
                    }
                    tagList.add(el);
                }
            }
            HashSet<TypeElement> allSupertypes = new HashSet<TypeElement>();
            boolean foundNew = false;
            for (TypeMirror typeMirror : ProcessingEnvironmentWrapper.this.types.directSupertypes(el.asType())) {
                TypeElement typeEl = (TypeElement)ProcessingEnvironmentWrapper.this.types.asElement(typeMirror);
                if (typeEl == null || allSupertypes.contains(typeEl)) continue;
                foundNew = true;
                allSupertypes.add(typeEl);
            }
            while (foundNew) {
                foundNew = false;
                HashSet roundSupertypes = new HashSet(allSupertypes);
                for (TypeElement supertypeEl : roundSupertypes) {
                    for (TypeMirror typeMirror : ProcessingEnvironmentWrapper.this.types.directSupertypes(supertypeEl.asType())) {
                        TypeElement typeEl = (TypeElement)ProcessingEnvironmentWrapper.this.types.asElement(typeMirror);
                        if (typeEl == null || allSupertypes.contains(typeEl)) continue;
                        foundNew = true;
                        allSupertypes.add(typeEl);
                    }
                }
            }
            for (TypeElement typeElement : allSupertypes) {
                Set<TypeElement> subtypes = this.subTypeInfo.get(typeElement.getQualifiedName().toString());
                if (subtypes == null) {
                    subtypes = new HashSet<TypeElement>();
                    this.subTypeInfo.put(typeElement.getQualifiedName().toString(), subtypes);
                }
                if (subtypes.contains(el)) continue;
                subtypes.add(el);
            }
        }

        public List<TypeElement> getSubtypesOf(TypeElement typeElement) {
            this.updateIndex();
            Set<TypeElement> subtypes = this.subTypeInfo.get(typeElement.getQualifiedName().toString());
            if (subtypes == null) {
                return Collections.EMPTY_LIST;
            }
            return new ArrayList<TypeElement>(subtypes);
        }

        public List<TypeElement> getEnclosedTypeElementsWithTag(String tag) {
            this.updateIndex();
            String lcTag = tag.toLowerCase();
            List out = this.tagMap.get(lcTag);
            if (out == null) {
                out = Collections.EMPTY_LIST;
            }
            return out;
        }

        public PackageWrapper(Name qualifiedName) {
            this.qualifiedName = qualifiedName;
        }

        public String toString() {
            return this.qualifiedName.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public TypeMirror asType() {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.asType();
            }
            if (this.type == null) {
                this.type = new NoType(){

                    @Override
                    public List<? extends AnnotationMirror> getAnnotationMirrors() {
                        return new ArrayList();
                    }

                    @Override
                    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                        return null;
                    }

                    @Override
                    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                        return (Annotation[])Array.newInstance(annotationType, 0);
                    }

                    @Override
                    public TypeKind getKind() {
                        return TypeKind.PACKAGE;
                    }

                    @Override
                    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                        return v.visit(this, p);
                    }
                };
            }
            return this.type;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return new HashSet<Modifier>();
        }

        @Override
        public Name getSimpleName() {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.getSimpleName();
            }
            String qualifiedNameStr = this.qualifiedName.toString();
            if (qualifiedNameStr.contains(".")) {
                return ProcessingEnvironmentWrapper.this.elements.getName(qualifiedNameStr.substring(qualifiedNameStr.lastIndexOf(".") + 1));
            }
            return this.qualifiedName;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            List<Element> out = new ArrayList<Element>();
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                out.addAll(wrapped.getEnclosedElements());
            }
            out.addAll(this.enclosedElements);
            out = out.stream().map(e -> ProcessingEnvironmentWrapper.this.wrap(e)).collect(Collectors.toList());
            return out;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.getAnnotationMirrors();
            }
            return new ArrayList();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.getAnnotation(annotationType);
            }
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.getAnnotationsByType(annotationType);
            }
            return (Annotation[])Array.newInstance(annotationType, 0);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visit(this, p);
        }

        @Override
        public boolean isUnnamed() {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return wrapped.isUnnamed();
            }
            return false;
        }

        @Override
        public Element getEnclosingElement() {
            PackageElement wrapped = this.wrapped();
            if (wrapped != null) {
                return ProcessingEnvironmentWrapper.this.wrap(wrapped.getEnclosingElement());
            }
            return null;
        }
    }

    private class InnerClassIndex {
        private Map<String, TypeElement> lcInnerClassMap = new HashMap<String, TypeElement>();

        private InnerClassIndex() {
        }
    }

    public class EntityControllerMarkerBuilder
    extends CustomTypeElementBuilder {
        private String packageName;

        public EntityControllerMarkerBuilder(String qualifiedName) {
            this.packageName = ProcessingEnvironmentWrapper.this.extractParentQualifiedName(qualifiedName);
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(this.packageName);
            this.kind(ElementKind.INTERFACE);
            String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(simpleName));
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            this.modifiers(Modifier.PUBLIC);
            this.type(ProcessingEnvironmentWrapper.this.createDeclaredType(qualifiedName.toString(), new TypeMirror[0]));
            this.enclosingElement(pkg);
        }
    }

    public class EntityControllerBuilder
    extends CustomTypeElementBuilder {
        private String packageName;
        private String baseName;
        private String modelType;

        public EntityControllerBuilder(String qualifiedName, String modelType) {
            this.packageName = ProcessingEnvironmentWrapper.this.extractParentQualifiedName(qualifiedName);
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(this.packageName);
            this.kind(ElementKind.CLASS);
            String simpleName = ProcessingEnvironmentWrapper.this.toSimpleName(qualifiedName);
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(simpleName));
            this.baseName = simpleName.substring(0, simpleName.length() - "Controller".length());
            if (modelType == null) {
                modelType = this.packageName + "." + this.baseName + "Model";
            }
            this.modelType = modelType;
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            this.modifiers(Modifier.PUBLIC);
            this.type(ProcessingEnvironmentWrapper.this.createDeclaredType(qualifiedName.toString(), new TypeMirror[0]));
            this.addInterface(ProcessingEnvironmentWrapper.this.createDeclaredType(this.packageName + ".I" + simpleName, new TypeMirror[0]));
            this.superclass(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.controllers.FormController").asType());
            this.enclosingElement(pkg);
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            element.addMethod(((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().kind(ElementKind.CONSTRUCTOR)).modifiers(Modifier.PUBLIC)).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("<init>"))).receiverType(element.asType()).returnType(element.asType()).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName("parent"))).type(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.controllers.Controller").asType())).build()).build());
            element.addMethod(((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().kind(ElementKind.CONSTRUCTOR)).modifiers(Modifier.PUBLIC)).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("<init>"))).receiverType(element.asType()).returnType(element.asType()).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().injected(true).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("parent"))).type(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.controllers.Controller").asType())).build()).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().injected(true).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("entity"))).type(ProcessingEnvironmentWrapper.this.createDeclaredType(this.modelType, new TypeMirror[0]))).build()).build());
            return this;
        }
    }

    public class EntityViewBuilder
    extends CustomTypeElementBuilder {
        private String modelQualifiedName;

        public EntityViewBuilder(String qualifiedName, String modelQualifiedName) {
            this.modelQualifiedName = modelQualifiedName;
            String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(packageName);
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(simpleName));
            this.modifiers(Modifier.PUBLIC);
            this.superclass(ProcessingEnvironmentWrapper.this.elements.getTypeElement(packageName + ".Abstract" + simpleName).asType());
            this.kind(ElementKind.CLASS);
            this.addInterface(ProcessingEnvironmentWrapper.this.createDeclaredType(packageName + "." + simpleName + "Schema", new TypeMirror[0]));
            RDeclaredType type = ProcessingEnvironmentWrapper.this.createDeclaredType(qualifiedName, ProcessingEnvironmentWrapper.this.createDeclaredType(modelQualifiedName, new TypeMirror[0]));
            this.type(type);
            this.enclosingElement(pkg);
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            TypeElement viewContext = ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.ui.ViewContext");
            if (viewContext == null) {
                throw new RuntimeException("Can't find ViewContext class.  It should be there!!!");
            }
            CustomExecutableElement constructor = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().returnType(element.type).receiverType(element.type).kind(ElementKind.CONSTRUCTOR)).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("<init>"))).modifiers(Modifier.PUBLIC)).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().injected(true).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("context"))).type(ProcessingEnvironmentWrapper.this.types.getDeclaredType(viewContext, ProcessingEnvironmentWrapper.this.createDeclaredType(element.getQualifiedName() + "Model", new TypeMirror[0])))).build()).build();
            element.addMethod(constructor);
            CustomExecutableElement getEntity = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().returnType(ProcessingEnvironmentWrapper.this.createDeclaredType(this.modelQualifiedName, new TypeMirror[0])).kind(ElementKind.METHOD)).receiverType(element.type).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("getEntity"))).modifiers(Modifier.PUBLIC)).build();
            element.addMethod(getEntity);
            return this;
        }
    }

    public class EntityImplBuilder
    extends CustomTypeElementBuilder {
        List<PropertyDescriptor> properties;

        public EntityImplBuilder(String qualifiedName) {
            this.properties = new ArrayList<PropertyDescriptor>();
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1)));
            String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(packageName);
            if (qualifiedName.endsWith("ModelImpl")) {
                String modelQualifiedName = qualifiedName.substring(0, qualifiedName.length() - "ModelImpl".length()) + "Model";
                this.addInterface(ProcessingEnvironmentWrapper.this.createDeclaredType(modelQualifiedName, new TypeMirror[0]));
            } else {
                this.addInterface(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.models.Entity").asType());
            }
            this.kind(ElementKind.CLASS);
            this.nestingKind(NestingKind.TOP_LEVEL);
            this.modifiers(Modifier.PUBLIC);
            this.superclass(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.models.BaseEntity").asType());
            this.enclosingElement(pkg);
        }

        public EntityImplBuilder addProperty(String name, String type) {
            this.properties.add(new PropertyDescriptor(name, type));
            return this;
        }

        public EntityImplBuilder addProperty(String name, DeclaredType type) {
            this.properties.add(new PropertyDescriptor(name, type));
            return this;
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            CustomExecutableElement constructor = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName("<init>"))).receiverType(element.asType()).returnType(element.asType()).kind(ElementKind.CONSTRUCTOR)).modifiers(Modifier.PUBLIC)).build();
            for (PropertyDescriptor property : this.properties) {
                CustomExecutableElement setter = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().receiverType(element.type).modifiers(Modifier.PUBLIC)).returnType(property.type()).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("set" + property.name.substring(0, 1).toUpperCase() + property.name.substring(1)))).build();
                CustomExecutableType type = ((CustomExecutableTypeBuilder)((CustomExecutableTypeBuilder)new CustomExecutableTypeBuilder().receiverType(element.type).returnType(property.type()).stringValue(property.name)).stringValue("public void " + setter.simpleName + "()")).build();
                setter.type = type;
                element.addMethod(setter);
                String prefix = "get";
                if (property.type().toString().toLowerCase().contains("boolean")) {
                    prefix = "is";
                }
                CustomExecutableElement getter = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().receiverType(element.type).modifiers(Modifier.PUBLIC)).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName(property.name))).type(property.type())).build()).simpleName(ProcessingEnvironmentWrapper.this.elements.getName(prefix + property.name.substring(0, 1).toUpperCase() + property.name.substring(1)))).build();
                type = ((CustomExecutableTypeBuilder)((CustomExecutableTypeBuilder)new CustomExecutableTypeBuilder().receiverType(element.type).returnType(property.type()).stringValue(property.name)).stringValue("public void " + setter.simpleName + "()")).build();
                getter.type = type;
                element.addMethod(getter);
            }
            return this;
        }
    }

    public class EntityBuilder
    extends CustomTypeElementBuilder {
        List<PropertyDescriptor> properties;

        EntityBuilder(String qualifiedName) {
            this.properties = new ArrayList<PropertyDescriptor>();
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1)));
            String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(packageName);
            if (qualifiedName.endsWith("Model")) {
                String schemaQualifiedName = qualifiedName.substring(0, qualifiedName.length() - "Model".length()) + "Schema";
                this.addInterface(ProcessingEnvironmentWrapper.this.createDeclaredType(schemaQualifiedName, new TypeMirror[0]));
            }
            this.kind(ElementKind.INTERFACE);
            this.nestingKind(NestingKind.TOP_LEVEL);
            this.modifiers(Modifier.PUBLIC);
            this.addInterface(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.models.Entity").asType());
            this.enclosingElement(pkg);
        }

        public EntityBuilder addProperty(String name, String type) {
            this.properties.add(new PropertyDescriptor(name, type));
            return this;
        }

        public EntityBuilder addProperty(String name, DeclaredType declaredType) {
            this.properties.add(new PropertyDescriptor(name, declaredType));
            return this;
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            for (PropertyDescriptor property : this.properties) {
                CustomExecutableElement setter = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().receiverType(element.type).modifiers(Modifier.PUBLIC)).returnType(property.type()).simpleName(ProcessingEnvironmentWrapper.this.elements.getName("set" + property.name.substring(0, 1).toUpperCase() + property.name.substring(1)))).build();
                CustomExecutableType type = ((CustomExecutableTypeBuilder)((CustomExecutableTypeBuilder)new CustomExecutableTypeBuilder().receiverType(element.type).returnType(property.type()).stringValue(property.name)).stringValue("public void " + setter.simpleName + "()")).build();
                setter.type = type;
                element.addMethod(setter);
                String prefix = "get";
                if (property.type().toString().toLowerCase().contains("boolean")) {
                    prefix = "is";
                }
                CustomExecutableElement getter = ((CustomExecutableElementBuilder)((CustomExecutableElementBuilder)new CustomExecutableElementBuilder().receiverType(element.type).modifiers(Modifier.PUBLIC)).addParameter(((CustomVariableElementBuilder)((CustomVariableElementBuilder)new CustomVariableElementBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName(property.name))).type(property.type())).build()).simpleName(ProcessingEnvironmentWrapper.this.elements.getName(prefix + property.name.substring(0, 1).toUpperCase() + property.name.substring(1)))).build();
                type = ((CustomExecutableTypeBuilder)((CustomExecutableTypeBuilder)new CustomExecutableTypeBuilder().receiverType(element.type).returnType(property.type()).stringValue(property.name)).stringValue("public void " + setter.simpleName + "()")).build();
                getter.type = type;
                element.addMethod(getter);
            }
            return this;
        }
    }

    private class PropertyDescriptor {
        String name;
        private String type;
        DeclaredType declaredType;

        public PropertyDescriptor(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public PropertyDescriptor(String name, DeclaredType type) {
            this.name = name;
            this.declaredType = type;
        }

        public DeclaredType type() {
            if (this.declaredType != null) {
                return this.declaredType;
            }
            return ProcessingEnvironmentWrapper.this.createDeclaredType(this.type, new TypeMirror[0]);
        }
    }

    public class SchemaBuilder
    extends CustomTypeElementBuilder {
        private List<TagDescriptor> tags;
        private List<CategoryDescriptor> categories;

        public SchemaBuilder(String qualifiedName) {
            this.tags = new ArrayList<TagDescriptor>();
            this.categories = new ArrayList<CategoryDescriptor>();
            if (qualifiedName == null) {
                throw new IllegalArgumentException("SchemaBuilder requires non-null qualified name");
            }
            this.simpleName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1)));
            this.qualifiedName(ProcessingEnvironmentWrapper.this.elements.getName(qualifiedName));
            this.kind(ElementKind.INTERFACE);
            this.nestingKind(NestingKind.TOP_LEVEL);
            this.modifiers(Modifier.PUBLIC);
            String packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            PackageElement pkg = ProcessingEnvironmentWrapper.this.elements.getPackageElement(packageName);
            this.enclosingElement(pkg);
            this.type(((CustomDeclaredTypeBuilder)new CustomDeclaredTypeBuilder().stringValue(qualifiedName)).enclosingType(pkg.asType()).build());
        }

        public SchemaBuilder addTag(String name) {
            this.tags.add(new TagDescriptor(name));
            return this;
        }

        public SchemaBuilder addCategory(String category) {
            this.categories.add(new CategoryDescriptor(category));
            return this;
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            for (TagDescriptor tagDescriptor : this.tags) {
                element.addField(((CustomVariableElementBuilder)((CustomVariableElementBuilder)((CustomVariableElementBuilder)new FieldBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName(tagDescriptor.name))).modifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)).type(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.models.Tag").asType())).build());
            }
            for (CategoryDescriptor categoryDescriptor : this.categories) {
                element.addField(((CustomVariableElementBuilder)((CustomVariableElementBuilder)((CustomVariableElementBuilder)new FieldBuilder().simpleName(ProcessingEnvironmentWrapper.this.elements.getName(categoryDescriptor.name))).modifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL)).type(ProcessingEnvironmentWrapper.this.elements.getTypeElement("com.codename1.rad.nodes.ActionNode.Category").asType())).build());
            }
            return this;
        }
    }

    private static class CategoryDescriptor {
        String name;

        CategoryDescriptor(String name) {
            this.name = name;
        }
    }

    private static class TagDescriptor {
        String name;

        TagDescriptor(String name) {
            this.name = name;
        }
    }

    public class CustomExecutableTypeBuilder
    extends CustomTypeMirrorBuilder<CustomExecutableTypeBuilder, CustomExecutableType> {
        protected List<TypeVariable> typeVariables;
        protected TypeMirror returnType;
        protected List<TypeMirror> parameterTypes;
        protected TypeMirror receiverType;
        protected List<TypeMirror> thrownTypes;

        public CustomExecutableTypeBuilder() {
            this.typeVariables = new ArrayList<TypeVariable>();
            this.parameterTypes = new ArrayList<TypeMirror>();
            this.thrownTypes = new ArrayList<TypeMirror>();
        }

        public CustomExecutableTypeBuilder addTypeVariable(TypeVariable var) {
            this.typeVariables.add(var);
            return this;
        }

        public CustomExecutableTypeBuilder returnType(TypeMirror returnType) {
            this.returnType = returnType;
            return this;
        }

        public CustomExecutableTypeBuilder addParameterType(TypeMirror parameterType) {
            this.parameterTypes.add(parameterType);
            return this;
        }

        public CustomExecutableTypeBuilder receiverType(TypeMirror receiverType) {
            this.receiverType = receiverType;
            return this;
        }

        public CustomExecutableTypeBuilder addThrownType(TypeMirror mirror) {
            this.thrownTypes.add(mirror);
            return this;
        }

        @Override
        protected void decorate(CustomExecutableType element) {
            super.decorate(element);
            element.typeVariables = this.typeVariables;
            element.returnType = this.returnType;
            element.parameterTypes = this.parameterTypes;
            element.receiverType = this.receiverType;
            element.thrownTypes = this.thrownTypes;
        }

        @Override
        public CustomExecutableType build() {
            CustomExecutableType element = new CustomExecutableType();
            this.decorate(element);
            return element;
        }
    }

    public class CustomDeclaredTypeBuilder
    extends CustomTypeMirrorBuilder<CustomDeclaredTypeBuilder, CustomDeclaredType> {
        protected TypeMirror enclosingType;
        protected List<TypeMirror> typeArguments;
        protected TypeMirror superclass;
        protected List<TypeMirror> interfaces;

        public CustomDeclaredTypeBuilder() {
            this.typeArguments = new ArrayList<TypeMirror>();
            this.interfaces = new ArrayList<TypeMirror>();
        }

        public CustomDeclaredTypeBuilder enclosingType(TypeMirror enclosingType) {
            this.enclosingType = enclosingType;
            return this;
        }

        public CustomDeclaredTypeBuilder addTypeArgument(TypeMirror typeMirror) {
            this.typeArguments.add(typeMirror);
            return this;
        }

        public CustomDeclaredTypeBuilder superclass(TypeMirror superclass) {
            this.superclass = superclass;
            return this;
        }

        public CustomDeclaredTypeBuilder addInterface(TypeMirror mirror) {
            this.interfaces.add(mirror);
            return this;
        }

        @Override
        protected void decorate(CustomDeclaredType element) {
            super.decorate(element);
            element.enclosingType = this.enclosingType;
            element.typeArguments = this.typeArguments;
            element.superclass = this.superclass;
            element.interfaces = this.interfaces;
        }

        @Override
        public CustomDeclaredType build() {
            CustomDeclaredType out = new CustomDeclaredType();
            this.decorate(out);
            if (out.stringValue == null) {
                throw new IllegalArgumentException("Attempt to build CustomDeclaredType without stringValue.");
            }
            return out;
        }
    }

    public abstract class CustomTypeMirrorBuilder<T extends CustomTypeMirrorBuilder, E extends CustomTypeMirror> {
        private TypeKind kind;
        private List<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();
        private String stringValue;

        public T kind(TypeKind kind) {
            this.kind = kind;
            return (T)this;
        }

        public T stringValue(String stringValue) {
            if (stringValue == null) {
                throw new IllegalArgumentException("stringValue must be non-null");
            }
            this.stringValue = stringValue;
            return (T)this;
        }

        protected void decorate(E element) {
            ((CustomTypeMirror)element).kind = this.kind;
            ((CustomTypeMirror)element).annotationMirrors = this.annotationMirrors;
            if (this.stringValue == null) {
                throw new IllegalStateException("Cannot build CustomTypeMirrorBuilder without stringValue");
            }
            ((CustomTypeMirror)element).stringValue = this.stringValue;
        }

        public abstract E build();
    }

    public class CustomExecutableType
    extends CustomTypeMirror
    implements RTypeMirror,
    ExecutableType {
        protected List<TypeVariable> typeVariables;
        protected TypeMirror returnType;
        protected List<TypeMirror> parameterTypes;
        protected TypeMirror receiverType;
        protected List<TypeMirror> thrownTypes;

        public CustomExecutableType() {
            this.typeVariables = new ArrayList<TypeVariable>();
            this.parameterTypes = new ArrayList<TypeMirror>();
            this.thrownTypes = new ArrayList<TypeMirror>();
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return super.accept(v, p);
        }

        @Override
        public List<? extends TypeVariable> getTypeVariables() {
            return this.typeVariables;
        }

        @Override
        public TypeMirror getReturnType() {
            return this.returnType;
        }

        @Override
        public List<? extends TypeMirror> getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public TypeMirror getReceiverType() {
            return this.receiverType;
        }

        @Override
        public List<? extends TypeMirror> getThrownTypes() {
            return this.thrownTypes;
        }
    }

    public class CustomDeclaredType
    extends CustomTypeMirror
    implements RDeclaredType {
        protected TypeMirror enclosingType;
        protected List<TypeMirror> typeArguments;
        protected TypeMirror superclass;
        protected List<TypeMirror> interfaces;

        public CustomDeclaredType() {
            this.typeArguments = new ArrayList<TypeMirror>();
            this.interfaces = new ArrayList<TypeMirror>();
        }

        @Override
        public Element asElement() {
            return ProcessingEnvironmentWrapper.this.types.asElement(this);
        }

        @Override
        public TypeMirror getEnclosingType() {
            return this.enclosingType;
        }

        @Override
        public List<? extends TypeMirror> getTypeArguments() {
            return this.typeArguments;
        }

        public TypeMirror getSuperclass() {
            return this.superclass;
        }

        public List<? extends TypeMirror> getInterfaces() {
            return this.interfaces;
        }

        public void addTypeArgument(TypeMirror mirror) {
            this.typeArguments.add(mirror);
        }
    }

    public class CustomTypeMirror
    implements RTypeMirror {
        protected TypeKind kind;
        protected List<AnnotationMirror> annotationMirrors;
        protected String stringValue;

        @Override
        public String toString() {
            return this.stringValue;
        }

        @Override
        public TypeKind getKind() {
            return this.kind;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visit(this, p);
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return this.annotationMirrors;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            return (Annotation[])Array.newInstance(annotationType, 0);
        }
    }

    public class FieldBuilder
    extends CustomVariableElementBuilder {
        public FieldBuilder() {
            this.kind(ElementKind.FIELD);
        }
    }

    public class MethodBuilder
    extends CustomExecutableElementBuilder {
        public MethodBuilder() {
            this.kind(ElementKind.METHOD);
        }
    }

    public class CustomVariableElementBuilder
    extends CustomElementBuilder<CustomVariableElementBuilder, CustomVariableElement> {
        private Object constantValue;
        private boolean injected;

        public CustomVariableElementBuilder constantValue(Object cv) {
            this.constantValue = cv;
            return this;
        }

        public CustomVariableElementBuilder injected(boolean injected) {
            this.injected = injected;
            return this;
        }

        @Override
        protected CustomVariableElementBuilder decorate(CustomVariableElement element) {
            super.decorate(element);
            element.constantValue = this.constantValue;
            return this;
        }

        @Override
        public CustomVariableElement build() {
            CustomVariableElement out = new CustomVariableElement(){

                @Override
                public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                    if (CustomVariableElementBuilder.this.injected && annotationType.equals(Inject.class)) {
                        return (A)ProcessingEnvironmentWrapper.this.getInjectAnnotation();
                    }
                    return super.getAnnotation(annotationType);
                }
            };
            this.decorate(out);
            return out;
        }
    }

    public class CustomExecutableElementBuilder
    extends CustomElementBuilder<CustomExecutableElementBuilder, CustomExecutableElement> {
        private List<TypeParameterElement> typeParameters;
        private TypeMirror returnType;
        private List<VariableElement> parameters;
        private TypeMirror receiverType;
        private boolean varargs;
        private boolean _default;
        private List<TypeMirror> thrownTypes;
        private AnnotationValue defaultValue;

        public CustomExecutableElementBuilder() {
            this.typeParameters = new ArrayList<TypeParameterElement>();
            this.parameters = new ArrayList<VariableElement>();
            this.thrownTypes = new ArrayList<TypeMirror>();
        }

        public CustomExecutableElementBuilder addTypeParameter(TypeParameterElement el) {
            this.typeParameters.add(el);
            return this;
        }

        public CustomExecutableElementBuilder returnType(TypeMirror returnType) {
            this.returnType = returnType;
            return this;
        }

        public CustomExecutableElementBuilder addParameter(VariableElement param) {
            this.parameters.add(param);
            return this;
        }

        public CustomExecutableElementBuilder receiverType(TypeMirror receiverType) {
            this.receiverType = receiverType;
            return this;
        }

        public CustomExecutableElementBuilder varargs(boolean varargs) {
            this.varargs = varargs;
            return this;
        }

        public CustomExecutableElementBuilder setDefault(boolean def) {
            this._default = def;
            return this;
        }

        public CustomExecutableElementBuilder addThrownType(TypeMirror thrownType) {
            this.thrownTypes.add(thrownType);
            return this;
        }

        @Override
        protected CustomExecutableElementBuilder decorate(CustomExecutableElement element) {
            super.decorate(element);
            element._default = this._default;
            element.defaultValue = this.defaultValue;
            element.typeParameters = this.typeParameters;
            element.returnType = this.returnType;
            element.receiverType = this.receiverType;
            element.varargs = this.varargs;
            element.thrownTypes = this.thrownTypes;
            element.parameters = this.parameters;
            return this;
        }

        @Override
        public CustomExecutableElement build() {
            CustomExecutableElement out = new CustomExecutableElement();
            this.decorate(out);
            return out;
        }
    }

    public class CustomTypeElementBuilder
    extends CustomElementBuilder<CustomTypeElementBuilder, CustomTypeElement> {
        private NestingKind nestingKind;
        private Name qualifiedName;
        private TypeMirror superclass;
        private List<TypeMirror> interfaces;
        private List<TypeParameterElement> typeParameters;

        public CustomTypeElementBuilder() {
            this.nestingKind = NestingKind.TOP_LEVEL;
            this.superclass = ProcessingEnvironmentWrapper.this.elements.getTypeElement("java.lang.Object").asType();
            this.interfaces = new ArrayList<TypeMirror>();
            this.typeParameters = new ArrayList<TypeParameterElement>();
        }

        public CustomTypeElementBuilder qualifiedName(Name qualifiedName) {
            this.qualifiedName = qualifiedName;
            return this;
        }

        public CustomTypeElementBuilder nestingKind(NestingKind kind) {
            this.nestingKind = kind;
            return this;
        }

        public CustomTypeElementBuilder superclass(TypeMirror superclass) {
            this.superclass = superclass;
            return this;
        }

        public CustomTypeElementBuilder addInterface(TypeMirror iface) {
            this.interfaces.add(iface);
            return this;
        }

        public CustomTypeElementBuilder addTypeParameter(TypeParameterElement el) {
            this.typeParameters.add(el);
            return this;
        }

        @Override
        protected CustomTypeElementBuilder decorate(CustomTypeElement element) {
            super.decorate(element);
            element.nestingKind = this.nestingKind;
            element.qualifiedName = this.qualifiedName;
            element.superclass = this.superclass;
            element.interfaces = this.interfaces;
            element.typeParameters = this.typeParameters;
            if (element.type == null) {
                element.type = ProcessingEnvironmentWrapper.this.createDeclaredType(this.qualifiedName.toString(), new TypeMirror[0]);
            }
            return this;
        }

        @Override
        public CustomTypeElement build() {
            CustomTypeElement out = new CustomTypeElement();
            this.decorate(out);
            return out;
        }
    }

    public abstract class CustomElementBuilder<T extends CustomElementBuilder, E extends CustomElement> {
        private TypeMirror type;
        private ElementKind kind;
        private Set<Modifier> modifiers;
        private Name simpleName;
        private Element enclosingElement;
        private List<Element> enclosedElements = new ArrayList<Element>();
        private List<AnnotationMirror> annotationMirrors;

        public T type(TypeMirror type) {
            this.type = type;
            return (T)this;
        }

        public T kind(ElementKind kind) {
            this.kind = kind;
            return (T)this;
        }

        public T modifiers(Modifier ... modifiers) {
            if (this.modifiers == null) {
                this.modifiers = new HashSet<Modifier>();
            }
            this.modifiers.addAll(Arrays.asList(modifiers));
            return (T)this;
        }

        public T simpleName(Name simpleName) {
            this.simpleName = simpleName;
            return (T)this;
        }

        public T enclosingElement(Element e) {
            this.enclosingElement = e;
            return (T)this;
        }

        public T add(Element element) {
            if (this.enclosedElements == null) {
                this.enclosedElements = new ArrayList<Element>();
            }
            this.enclosedElements.add(element);
            return (T)this;
        }

        public T add(AnnotationMirror anno) {
            if (this.annotationMirrors == null) {
                this.annotationMirrors = new ArrayList<AnnotationMirror>();
            }
            this.annotationMirrors.add(anno);
            return (T)this;
        }

        public abstract E build();

        protected T decorate(E element) {
            ((CustomElement)element).kind = this.kind;
            ((CustomElement)element).type = this.type;
            ((CustomElement)element).enclosedElements = this.enclosedElements;
            ((CustomElement)element).enclosingElement = this.enclosingElement;
            ((CustomElement)element).annotationMirrors = this.annotationMirrors;
            ((CustomElement)element).modifiers = this.modifiers;
            ((CustomElement)element).simpleName = this.simpleName;
            return (T)this;
        }
    }

    public class CustomVariableElement
    extends CustomElement
    implements RElement,
    VariableElement {
        private Object constantValue;

        @Override
        public Object getConstantValue() {
            return this.constantValue;
        }
    }

    public class CustomExecutableElement
    extends CustomElement
    implements RElement,
    ExecutableElement {
        protected List<TypeParameterElement> typeParameters;
        protected TypeMirror returnType;
        protected List<VariableElement> parameters;
        protected TypeMirror receiverType;
        protected boolean varargs;
        protected boolean _default;
        protected List<TypeMirror> thrownTypes;
        protected AnnotationValue defaultValue;

        public CustomExecutableElement() {
            this.typeParameters = new ArrayList<TypeParameterElement>();
            this.parameters = new ArrayList<VariableElement>();
            this.thrownTypes = new ArrayList<TypeMirror>();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder().append(this.returnType).append(" ").append(this.simpleName).append("(");
            boolean first = true;
            for (VariableElement param : this.parameters) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(param);
            }
            sb.append(") ");
            first = true;
            if (!this.thrownTypes.isEmpty()) {
                sb.append(" throws ");
                for (TypeMirror type : this.thrownTypes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(type);
                }
            }
            return sb.toString();
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public TypeMirror getReturnType() {
            return this.returnType;
        }

        @Override
        public List<? extends VariableElement> getParameters() {
            return this.parameters;
        }

        @Override
        public TypeMirror getReceiverType() {
            return this.receiverType;
        }

        @Override
        public boolean isVarArgs() {
            return this.varargs;
        }

        @Override
        public boolean isDefault() {
            return this._default;
        }

        @Override
        public List<? extends TypeMirror> getThrownTypes() {
            return this.thrownTypes;
        }

        @Override
        public AnnotationValue getDefaultValue() {
            return this.defaultValue;
        }
    }

    public class CustomTypeElement
    extends CustomElement
    implements TypeElement {
        private NestingKind nestingKind;
        private Name qualifiedName;
        private TypeMirror superclass;
        private List<TypeMirror> interfaces;
        private List<TypeParameterElement> typeParameters;

        public CustomTypeElement() {
            this.interfaces = new ArrayList<TypeMirror>();
            this.typeParameters = new ArrayList<TypeParameterElement>();
        }

        @Override
        public String toString() {
            return this.qualifiedName.toString();
        }

        @Override
        public NestingKind getNestingKind() {
            return this.nestingKind;
        }

        @Override
        public Name getQualifiedName() {
            return this.qualifiedName;
        }

        @Override
        public TypeMirror getSuperclass() {
            return this.superclass;
        }

        @Override
        public List<? extends TypeMirror> getInterfaces() {
            return this.interfaces;
        }

        @Override
        public List<? extends TypeParameterElement> getTypeParameters() {
            return this.typeParameters;
        }

        public void addMethod(CustomExecutableElement method) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
                method.receiverType = this.type;
            }
            method.enclosingElement = this;
            this.enclosedElements.add(method);
        }

        public void addField(CustomVariableElement field) {
            field.enclosingElement = this;
            this.enclosedElements.add(field);
        }
    }

    public class CustomElement
    implements RElement {
        protected TypeMirror type;
        protected ElementKind kind;
        protected Set<Modifier> modifiers = new HashSet<Modifier>();
        protected Name simpleName;
        protected Element enclosingElement;
        protected List<Element> enclosedElements = new ArrayList<Element>();
        protected List<AnnotationMirror> annotationMirrors = new ArrayList<AnnotationMirror>();

        public String toString() {
            return "CustomElement{type=" + this.type + ", kind=" + (Object)((Object)this.kind) + ", modifiers=" + this.modifiers + ", simpleName=" + this.simpleName + ", enclosingElement=" + this.enclosingElement + ", enclosedElements=" + this.enclosedElements + ", annotationMirrors=" + this.annotationMirrors + '}';
        }

        @Override
        public TypeMirror asType() {
            return this.type;
        }

        @Override
        public ElementKind getKind() {
            return this.kind;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        @Override
        public Name getSimpleName() {
            return this.simpleName;
        }

        @Override
        public Element getEnclosingElement() {
            Element out = this.enclosingElement;
            if (out != null && out.getKind() == ElementKind.PACKAGE && !(out instanceof PackageWrapper)) {
                out = ProcessingEnvironmentWrapper.this.elements.getPackageElement(((PackageElement)out).getQualifiedName());
            }
            return out;
        }

        @Override
        public List<? extends Element> getEnclosedElements() {
            return this.enclosedElements;
        }

        @Override
        public List<? extends AnnotationMirror> getAnnotationMirrors() {
            return this.annotationMirrors;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return null;
        }

        @Override
        public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
            return (Annotation[])Array.newInstance(annotationType, 0);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visit(this, p);
        }
    }

    public class ElementsWrapper
    implements Elements {
        private Elements wrapped;

        private ElementsWrapper(Elements wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public PackageElement getPackageElement(CharSequence name) {
            String nameStr = name.toString();
            PackageElement pkg = (PackageElement)ProcessingEnvironmentWrapper.this.packageMap.get(nameStr);
            if (pkg == null) {
                pkg = new PackageWrapper(this.getName(name));
                ProcessingEnvironmentWrapper.this.packageMap.put(nameStr, (PackageWrapper)pkg);
            }
            return pkg;
        }

        @Override
        public TypeElement getTypeElement(CharSequence name) {
            TypeElement out = this.wrapped.getTypeElement(name);
            if (out == null) {
                out = (TypeElement)ProcessingEnvironmentWrapper.this.typeMap.get(name.toString());
            }
            if (out != null) {
                ProcessingEnvironmentWrapper.this.lcTypeMap.put(name.toString().toLowerCase(), out);
            }
            return out;
        }

        @Override
        public Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror a) {
            return this.wrapped.getElementValuesWithDefaults(a);
        }

        @Override
        public String getDocComment(Element e) {
            return this.wrapped.getDocComment(e);
        }

        @Override
        public boolean isDeprecated(Element e) {
            return this.wrapped.isDeprecated(e);
        }

        @Override
        public Name getBinaryName(TypeElement type) {
            return this.wrapped.getBinaryName(type);
        }

        @Override
        public PackageElement getPackageOf(Element type) {
            Object out = null;
            switch (type.getKind()) {
                case PACKAGE: {
                    return ProcessingEnvironmentWrapper.this.wrap((PackageElement)type);
                }
                case CLASS: 
                case INTERFACE: {
                    TypeElement typeEl = (TypeElement)type;
                    if (typeEl.getNestingKind() == NestingKind.TOP_LEVEL) {
                        return ProcessingEnvironmentWrapper.this.wrap((PackageElement)typeEl.getEnclosingElement());
                    }
                    return this.getPackageOf(typeEl.getEnclosingElement());
                }
            }
            Element enclosing = type.getEnclosingElement();
            return this.getPackageOf(enclosing);
        }

        @Override
        public List<? extends Element> getAllMembers(TypeElement type) {
            HashMap<Name, ArrayList<ExecutableElement>> methodMap = new HashMap<Name, ArrayList<ExecutableElement>>();
            HashMap<Name, ArrayList<VariableElement>> fieldMap = new HashMap<Name, ArrayList<VariableElement>>();
            ArrayList<? extends Element> out = new ArrayList<Element>();
            PackageElement typePackage = ProcessingEnvironmentWrapper.this.elements.getPackageOf(type);
            if (typePackage == null) {
                throw new IllegalStateException("Attempt to get members of type " + type + " which has a null package.");
            }
            out.addAll(type.getEnclosedElements());
            for (Element element : out) {
                Name name = element.getSimpleName();
                if (element.getKind() == ElementKind.METHOD) {
                    ExecutableElement method = (ExecutableElement)element;
                    ArrayList<ExecutableElement> methods = (ArrayList<ExecutableElement>)methodMap.get(name);
                    if (methods == null) {
                        methods = new ArrayList<ExecutableElement>();
                        methodMap.put(name, methods);
                    }
                    methods.add(method);
                    continue;
                }
                if (element.getKind() != ElementKind.FIELD) continue;
                VariableElement field = (VariableElement)element;
                ArrayList<VariableElement> fields = (ArrayList<VariableElement>)fieldMap.get(name);
                if (fields == null) {
                    fields = new ArrayList<VariableElement>();
                }
                fields.add(field);
            }
            List<? extends TypeMirror> supertypes = ProcessingEnvironmentWrapper.this.types.directSupertypes(type.asType());
            for (TypeMirror typeMirror : supertypes) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                TypeElement supertypeEl = (TypeElement)ProcessingEnvironmentWrapper.this.types.asElement(typeMirror);
                PackageElement supertypePackage = ProcessingEnvironmentWrapper.this.elements.getPackageOf(supertypeEl);
                if (supertypePackage == null) {
                    throw new IllegalStateException("Supertype " + supertypeEl + " has null for package, while try ing to get members of subclass " + type);
                }
                if (supertypeEl == null) continue;
                for (Element element : this.getAllMembers(supertypeEl)) {
                    boolean samePackage;
                    if (element.getModifiers().contains((Object)Modifier.PRIVATE) || !(samePackage = ProcessingEnvironmentWrapper.this.elements.getPackageOf(supertypeEl).getQualifiedName().contentEquals(ProcessingEnvironmentWrapper.this.elements.getPackageOf(type).getQualifiedName())) && !element.getModifiers().contains((Object)Modifier.PROTECTED) && !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    Name superName = element.getSimpleName();
                    if (element.getKind() == ElementKind.METHOD) {
                        ArrayList<ExecutableElement> existingMethods = (ArrayList<ExecutableElement>)methodMap.get(superName);
                        if (existingMethods != null && !existingMethods.isEmpty() && existingMethods.stream().anyMatch(m -> this.overrides((ExecutableElement)m, (ExecutableElement)superMember, type))) continue;
                        if (existingMethods == null) {
                            existingMethods = new ArrayList<ExecutableElement>();
                            methodMap.put(superName, existingMethods);
                        }
                        existingMethods.add((ExecutableElement)element);
                        out.add(element);
                        continue;
                    }
                    if (element.getKind() == ElementKind.FIELD) {
                        ArrayList<VariableElement> existingFields = (ArrayList<VariableElement>)fieldMap.get(superName);
                        if (existingFields != null && !existingFields.isEmpty() && existingFields.stream().anyMatch(m -> this.hides((Element)m, (VariableElement)superMember))) continue;
                        if (existingFields == null) {
                            existingFields = new ArrayList<VariableElement>();
                            fieldMap.put(superName, existingFields);
                        }
                        existingFields.add((VariableElement)element);
                        out.add(element);
                        continue;
                    }
                    if (element.getKind() == ElementKind.CONSTRUCTOR) continue;
                    out.add(element);
                }
            }
            return out;
        }

        @Override
        public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
            return this.wrapped.getAllAnnotationMirrors(e);
        }

        @Override
        public boolean hides(Element hider, Element hidden) {
            return this.wrapped.hides(hider, hidden);
        }

        @Override
        public boolean overrides(ExecutableElement overrider, ExecutableElement overridden, TypeElement type) {
            if (ProcessingEnvironmentWrapper.this.isNativeElement(overrider) && ProcessingEnvironmentWrapper.this.isNativeElement(overridden) && ProcessingEnvironmentWrapper.this.isNativeElement(type) && this.wrapped.overrides(overrider, overridden, type)) {
                return true;
            }
            if (!overridden.getSimpleName().contentEquals(overridden.getSimpleName())) {
                return false;
            }
            if (overridden.getParameters().size() != overrider.getParameters().size()) {
                return false;
            }
            int index = -1;
            for (VariableElement variableElement : overridden.getParameters()) {
                VariableElement overridingParam = overrider.getParameters().get(++index);
                if (ProcessingEnvironmentWrapper.this.types.isSubtype(overridingParam.asType(), variableElement.asType())) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getConstantExpression(Object value) {
            return this.wrapped.getConstantExpression(value);
        }

        @Override
        public void printElements(Writer w, Element ... elements) {
            this.wrapped.printElements(w, elements);
        }

        @Override
        public Name getName(CharSequence cs) {
            return this.wrapped.getName(cs);
        }

        @Override
        public boolean isFunctionalInterface(TypeElement type) {
            return this.wrapped.isFunctionalInterface(type);
        }
    }

    public class TypesWrapper
    implements Types {
        private Types wrapped;

        private TypesWrapper(Types wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Element asElement(TypeMirror t) {
            Element out = null;
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t)) {
                out = this.wrapped.asElement(t);
            }
            if (t instanceof DeclaredType) {
                out = t instanceof CustomDeclaredType ? ProcessingEnvironmentWrapper.this.elements.getTypeElement(((CustomDeclaredType)t).stringValue) : ((DeclaredType)t).asElement();
            }
            if (out == null) {
                out = (Element)ProcessingEnvironmentWrapper.this.typeMap.get(t.toString());
            }
            return out;
        }

        @Override
        public boolean isSameType(TypeMirror t1, TypeMirror t2) {
            if (t1 == null || t2 == null) {
                return false;
            }
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t1) && ProcessingEnvironmentWrapper.this.isNativeMirror(t2)) {
                try {
                    return this.wrapped.isSameType(t1, t2);
                }
                catch (Exception ex) {
                    System.err.println("Exception raised while checking " + t1 + " and " + t2 + " for same type");
                    ex.printStackTrace();
                }
            }
            if (t1.getKind() != t2.getKind()) {
                return false;
            }
            switch (t1.getKind()) {
                case DECLARED: {
                    DeclaredType dt1 = (DeclaredType)t1;
                    DeclaredType dt2 = (DeclaredType)t2;
                    if (dt1.getTypeArguments().size() != dt2.getTypeArguments().size()) {
                        return false;
                    }
                    TypeElement te1 = (TypeElement)dt1.asElement();
                    TypeElement te2 = (TypeElement)dt2.asElement();
                    if (te1 == null || te2 == null) {
                        return false;
                    }
                    if (!te1.getQualifiedName().contentEquals(te2.getQualifiedName())) {
                        return false;
                    }
                    int len = dt1.getTypeArguments().size();
                    for (int i = 0; i < len; ++i) {
                        if (this.isSameType(dt1.getTypeArguments().get(i), dt2.getTypeArguments().get(i))) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isSubtype(TypeMirror t1, TypeMirror t2) {
            if (t1 == null || t2 == null) {
                return false;
            }
            if (this.isSameType(t1, t2)) {
                return true;
            }
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t1) && ProcessingEnvironmentWrapper.this.isNativeMirror(t2) && this.wrapped.isSubtype(t1, t2)) {
                return true;
            }
            for (TypeMirror typeMirror : this.directSupertypes(t1)) {
                if (!this.isSubtype(typeMirror, t2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAssignable(TypeMirror t1, TypeMirror t2) {
            if (this.isSubtype(t1, t2)) {
                return true;
            }
            return ProcessingEnvironmentWrapper.this.isNativeMirror(t1) && ProcessingEnvironmentWrapper.this.isNativeMirror(t2) && this.wrapped.isAssignable(t1, t2);
        }

        @Override
        public boolean contains(TypeMirror t1, TypeMirror t2) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t1) && ProcessingEnvironmentWrapper.this.isNativeMirror(t2)) {
                return this.wrapped.contains(t1, t2);
            }
            return false;
        }

        @Override
        public boolean isSubsignature(ExecutableType m1, ExecutableType m2) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(m1) && ProcessingEnvironmentWrapper.this.isNativeMirror(m2)) {
                return this.wrapped.isSubsignature(m1, m2);
            }
            return false;
        }

        @Override
        public List<? extends TypeMirror> directSupertypes(TypeMirror t) {
            if (t instanceof CustomDeclaredType) {
                CustomDeclaredType cdt = (CustomDeclaredType)t;
                ArrayList<? extends TypeMirror> out = new ArrayList<TypeMirror>();
                if (cdt.getSuperclass() == null) {
                    out.add(ProcessingEnvironmentWrapper.this.elements.getTypeElement("java.lang.Object").asType());
                }
                out.addAll(cdt.getInterfaces());
                return out;
            }
            if (t instanceof RDeclaredType) {
                RDeclaredType dt = (RDeclaredType)t;
                TypeElement typeEl = (TypeElement)dt.asElement();
                ArrayList<TypeMirror> out = new ArrayList<TypeMirror>();
                if (typeEl == null) {
                    return out;
                }
                if (typeEl.getSuperclass() != null) {
                    out.add(typeEl.getSuperclass());
                }
                for (TypeMirror typeMirror : typeEl.getInterfaces()) {
                    out.add(typeMirror);
                }
                return out;
            }
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t)) {
                return this.wrapped.directSupertypes(t);
            }
            return new ArrayList();
        }

        @Override
        public TypeMirror erasure(TypeMirror t) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t)) {
                return this.wrapped.erasure(t);
            }
            return t;
        }

        @Override
        public TypeElement boxedClass(PrimitiveType p) {
            return this.wrapped.boxedClass(p);
        }

        @Override
        public PrimitiveType unboxedType(TypeMirror t) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t)) {
                return this.wrapped.unboxedType(t);
            }
            return null;
        }

        @Override
        public TypeMirror capture(TypeMirror t) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(t)) {
                return this.wrapped.capture(t);
            }
            return t;
        }

        @Override
        public PrimitiveType getPrimitiveType(TypeKind kind) {
            return this.wrapped.getPrimitiveType(kind);
        }

        @Override
        public NullType getNullType() {
            return this.wrapped.getNullType();
        }

        @Override
        public NoType getNoType(TypeKind kind) {
            return this.wrapped.getNoType(kind);
        }

        @Override
        public ArrayType getArrayType(TypeMirror componentType) {
            return this.wrapped.getArrayType(componentType);
        }

        @Override
        public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
            return this.wrapped.getWildcardType(extendsBound, superBound);
        }

        @Override
        public DeclaredType getDeclaredType(final TypeElement typeElem, final TypeMirror ... typeArgs) {
            if (!ProcessingEnvironmentWrapper.this.isNativeElement(typeElem) || !ProcessingEnvironmentWrapper.this.isNativeMirrors(typeArgs)) {
                if (typeArgs.length == 0) {
                    return (DeclaredType)typeElem.asType();
                }
                return new RDeclaredType(){
                    List<TypeMirror> typeArguments;
                    {
                        this.typeArguments = new ArrayList<TypeMirror>(Arrays.asList(typeArgs));
                    }

                    @Override
                    public List<? extends AnnotationMirror> getAnnotationMirrors() {
                        return typeElem.getAnnotationMirrors();
                    }

                    @Override
                    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                        return typeElem.getAnnotation(annotationType);
                    }

                    @Override
                    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                        return typeElem.getAnnotationsByType(annotationType);
                    }

                    @Override
                    public TypeKind getKind() {
                        return TypeKind.DECLARED;
                    }

                    @Override
                    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                        return v.visit(this);
                    }

                    @Override
                    public Element asElement() {
                        return typeElem;
                    }

                    @Override
                    public TypeMirror getEnclosingType() {
                        return ((DeclaredType)typeElem.asType()).getEnclosingType();
                    }

                    @Override
                    public List<? extends TypeMirror> getTypeArguments() {
                        return this.typeArguments;
                    }
                };
            }
            if (ProcessingEnvironmentWrapper.this.isNativeElement(typeElem) && ProcessingEnvironmentWrapper.this.isNativeMirrors(typeArgs)) {
                try {
                    return this.wrapped.getDeclaredType(typeElem, typeArgs);
                }
                catch (Exception ex) {
                    System.err.println("Exception while trying to get declared type for " + typeElem + " with typeArgs=" + Arrays.toString(typeArgs));
                    throw ex;
                }
            }
            throw new IllegalStateException("Should never get here");
        }

        @Override
        public DeclaredType getDeclaredType(DeclaredType containing, TypeElement typeElem, TypeMirror ... typeArgs) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(containing) && ProcessingEnvironmentWrapper.this.isNativeElement(typeElem) && ProcessingEnvironmentWrapper.this.isNativeMirrors(typeArgs)) {
                return this.wrapped.getDeclaredType(containing, typeElem, typeArgs);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeMirror asMemberOf(final DeclaredType containing, final Element element) {
            if (ProcessingEnvironmentWrapper.this.isNativeMirror(containing) && ProcessingEnvironmentWrapper.this.isNativeElement(element)) {
                return this.wrapped.asMemberOf(containing, element);
            }
            if (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) {
                final ExecutableElement ee = (ExecutableElement)element;
                return new RExecutableType(){
                    List<TypeVariable> typeVariables = new ArrayList<TypeVariable>();

                    @Override
                    public String toString() {
                        return "" + element.getSimpleName() + this.getParameterTypes();
                    }

                    @Override
                    public List<? extends TypeVariable> getTypeVariables() {
                        return this.typeVariables;
                    }

                    @Override
                    public TypeMirror getReturnType() {
                        TypeMirror out = ProcessingEnvironmentWrapper.this.getTypeParameter(containing, ee, ee.getReturnType());
                        return out;
                    }

                    @Override
                    public List<? extends TypeMirror> getParameterTypes() {
                        return ee.getParameters().stream().map(e -> ProcessingEnvironmentWrapper.this.getTypeParameter(containing, ee, e.asType())).collect(Collectors.toList());
                    }

                    @Override
                    public TypeMirror getReceiverType() {
                        return ProcessingEnvironmentWrapper.this.getTypeParameter(containing, ee, ee.getReceiverType());
                    }

                    @Override
                    public List<? extends TypeMirror> getThrownTypes() {
                        return ee.getThrownTypes().stream().map(e -> ProcessingEnvironmentWrapper.this.getTypeParameter(containing, ee, e)).collect(Collectors.toList());
                    }

                    @Override
                    public TypeKind getKind() {
                        return TypeKind.EXECUTABLE;
                    }

                    @Override
                    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                        return v.visit(this);
                    }

                    @Override
                    public List<? extends AnnotationMirror> getAnnotationMirrors() {
                        return ee.getAnnotationMirrors();
                    }

                    @Override
                    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                        return ee.getAnnotation(annotationType);
                    }

                    @Override
                    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                        return ee.getAnnotationsByType(annotationType);
                    }
                };
            }
            throw new UnsupportedOperationException("asMemberOf not implemented yet for type " + (Object)((Object)element.getKind()) + " on element " + element + " in declared type " + containing);
        }
    }

    public class TypeElementHelper {
        private List<ExecutableElement> publicConstructors = new ArrayList<ExecutableElement>();

        public List<ExecutableElement> getPublicConstructors() {
            return this.publicConstructors;
        }
    }

    public static interface RNoType
    extends RTypeMirror,
    NoType {
    }

    public static interface RExecutableType
    extends RTypeMirror,
    ExecutableType {
    }

    public static interface RDeclaredType
    extends RTypeMirror,
    DeclaredType {
    }

    public static interface RTypeMirror
    extends TypeMirror {
    }

    public static interface RTypeElement
    extends RElement,
    TypeElement {
    }

    public static interface RElement
    extends Element {
    }
}

