/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.Inject;
import com.codename1.rad.annotations.RAD;
import com.codename1.rad.annotations.TagLib;
import com.codename1.rad.annotations.processors.BaseProcessor;
import com.codename1.rad.annotations.processors.ProcessingEnvironmentWrapper;
import com.codename1.rad.annotations.processors.XMLSchemaGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewProcessor
extends BaseProcessor {
    private static final boolean ENABLE_INDEX = false;
    private RoundEnvironment roundEnv;
    private Map<Class, Object> cache = new HashMap<Class, Object>();
    private Map<TypeElement, EntityViewBuilder> roundEntityViewBuilders = new HashMap<TypeElement, EntityViewBuilder>();

    private void clearRoundCache() {
        this.cache.remove(RoundCache.class);
    }

    private RoundCache roundCache() {
        RoundCache out = (RoundCache)this.cache.get(RoundCache.class);
        if (out == null) {
            out = new RoundCache();
            this.cache.put(RoundCache.class, out);
        }
        return out;
    }

    ViewProcessor(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
    }

    @Override
    void installTypes(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends javax.lang.model.element.Element> annotatedElements = roundEnv.getElementsAnnotatedWith(RAD.class);
        for (javax.lang.model.element.Element element : annotatedElements) {
            TypeElement typeEl;
            if (!(element instanceof TypeElement) || !this.isEntityView(typeEl = (TypeElement)element)) continue;
            this.installTypes(typeEl);
        }
    }

    public boolean isEntityView(TypeElement el) {
        if (el == null) {
            return false;
        }
        Boolean isEntityView = this.roundCache().isEntityView.get(el.getQualifiedName().toString());
        if (isEntityView == null) {
            isEntityView = this.isA(el, "com.codename1.rad.ui.EntityView");
            this.roundCache().isEntityView.put(el.getQualifiedName().toString(), isEntityView);
        }
        return isEntityView;
    }

    public boolean isComponent(TypeElement el) {
        if (el == null) {
            return false;
        }
        Boolean isComponent = this.roundCache().isComponent.get(el.getQualifiedName().toString());
        if (isComponent == null) {
            isComponent = this.isA(el, "com.codename1.ui.Component");
            this.roundCache().isComponent.put(el.getQualifiedName().toString(), isComponent);
        }
        return isComponent;
    }

    public boolean isContainer(TypeElement el) {
        if (el == null) {
            return false;
        }
        Boolean isContainer = this.roundCache().isContainer.get(el.getQualifiedName().toString());
        if (isContainer == null) {
            isContainer = this.isA(el, "com.codename1.ui.Container");
            this.roundCache().isContainer.put(el.getQualifiedName().toString(), isContainer);
        }
        return isContainer;
    }

    public boolean isNode(TypeElement el) {
        if (el == null) {
            return false;
        }
        Boolean isNode = this.roundCache().isNode.get(el.getQualifiedName().toString());
        if (isNode == null) {
            isNode = this.isA(el, "com.codename1.rad.nodes.Node");
            this.roundCache().isNode.put(el.getQualifiedName().toString(), isNode);
        }
        return isNode;
    }

    public Set<? extends TypeElement> defer(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<TypeElement> out = new HashSet<TypeElement>();
        this.roundEnv = roundEnv;
        Set<? extends javax.lang.model.element.Element> annotatedElements = roundEnv.getElementsAnnotatedWith(RAD.class);
        for (javax.lang.model.element.Element element : annotatedElements) {
            TypeElement typeEl;
            if (!(element instanceof TypeElement) || !this.isEntityView(typeEl = (TypeElement)element)) continue;
            out.add(typeEl);
        }
        return out;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.roundEnv = roundEnv;
        this.clearRoundCache();
        Set<? extends javax.lang.model.element.Element> annotatedElements = roundEnv.getElementsAnnotatedWith(RAD.class);
        for (javax.lang.model.element.Element element : annotatedElements) {
            TypeElement typeEl;
            if (!(element instanceof TypeElement) || !this.isEntityView(typeEl = (TypeElement)element)) continue;
            this.processFragment(typeEl);
        }
        return true;
    }

    private EntityViewBuilder entityViewBuilderForType(TypeElement el) {
        return new EntityViewBuilder(el);
    }

    private void installTypes(TypeElement typeEl) {
        try {
            EntityViewBuilder builder = this.entityViewBuilderForType(typeEl);
            builder.installTypes((ProcessingEnvironmentWrapper)this.processingEnv);
        }
        catch (XMLParseException ex) {
            this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), typeEl);
            ex.printStackTrace();
        }
    }

    private void processFragment(TypeElement typeEl) {
        try {
            EntityViewBuilder builder = this.entityViewBuilderForType(typeEl);
            builder.createSchemaSourceFile();
            builder.createControllerMarkerInterfaceSourceFile();
            builder.createModelSourceFile();
            builder.createControllerSourceFile();
            builder.createViewSourceFile();
            builder.createXMLSchemaSourceFile();
        }
        catch (XMLParseException ex) {
            this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), typeEl);
            ex.printStackTrace();
        }
        catch (IOException io) {
            this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write view for " + typeEl + ":" + io.getMessage(), typeEl);
            io.printStackTrace();
        }
    }

    TypeElement inferRADTagType(JavaEnvironment jenv, String propertyName) {
        TypeElement returnType;
        JavaMethodProxy method;
        TypeElement viewModelClass = jenv.lookupClass(jenv.rootBuilder.viewModelType);
        JavaClassProxy classProxy = jenv.newJavaClassProxy(viewModelClass);
        ExecutableElement el = classProxy.findGetter(propertyName, new String[0]);
        if (el != null && (method = classProxy.findMethodProxy(el.getSimpleName().toString(), 0)) != null && (returnType = method.getReturnType()) != null) {
            return returnType;
        }
        return null;
    }

    public String expandRADModelVars(JavaEnvironment jenv, String selector, boolean stringMode) {
        TypeElement inferredType;
        int startPos = selector.indexOf("${");
        if (startPos < 0) {
            if (stringMode) {
                return "\"" + StringEscapeUtils.escapeJava((String)selector) + "\"";
            }
            return selector;
        }
        int endPos = selector.indexOf("}", startPos);
        if (endPos < 0) {
            if (stringMode) {
                return "\"" + StringEscapeUtils.escapeJava((String)selector) + "\"";
            }
            return selector;
        }
        if (startPos > 0) {
            if (stringMode) {
                return "\"" + StringEscapeUtils.escapeJava((String)selector.substring(0, startPos)) + "\" + " + this.expandRADModelVars(jenv, selector.substring(startPos), stringMode);
            }
            return selector.substring(0, startPos) + this.expandRADModelVars(jenv, selector.substring(startPos), stringMode);
        }
        StringBuilder out = new StringBuilder();
        out.append("new com.codename1.rad.models.PropertySelector(context.getEntity(), ");
        StringTokenizer strtok = new StringTokenizer(selector.substring(2, endPos), "/");
        boolean first = true;
        String defaultValue = null;
        int chainLength = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String nextTok = strtok.nextToken().trim();
            if (nextTok.indexOf("|") > 0) {
                defaultValue = nextTok.substring(nextTok.indexOf("|") + 1).trim();
                nextTok = nextTok.substring(0, nextTok.indexOf("|")).trim();
            }
            if (first) {
                first = false;
                out.append(nextTok).append(")");
            } else {
                out.append(".createChildSelector(").append(nextTok).append(")");
            }
            tokens.add(nextTok);
            ++chainLength;
        }
        boolean getterAppended = false;
        if (selector.length() > endPos + 1) {
            if (selector.indexOf(".text", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "\"\"";
                }
                out.append(".getText(").append(defaultValue).append(")");
                endPos += 5;
                getterAppended = true;
            } else if (selector.indexOf(".int", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "0";
                }
                out.append(".getInt(").append(defaultValue).append(")");
                endPos += 4;
                getterAppended = true;
            } else if (selector.indexOf(".float", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "0f";
                }
                out.append(".getFloat(").append(defaultValue).append(")");
                endPos += 6;
                getterAppended = true;
            } else if (selector.indexOf(".double", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "0";
                }
                out.append(".getDouble(").append(defaultValue).append(")");
                endPos += 7;
                getterAppended = true;
            } else if (selector.indexOf(".date", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "null";
                }
                out.append(".getDate(").append(defaultValue).append(")");
                endPos += 5;
                getterAppended = true;
            } else if (selector.indexOf(".bool", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "false";
                }
                out.append(".getBoolean(").append(defaultValue).append(")");
                endPos += 5;
                getterAppended = true;
            } else if (selector.indexOf(".(", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "null";
                }
                out.append(".getAs(").append(selector.substring(selector.indexOf(".(", endPos + 1) + 2, selector.indexOf(")", endPos + 3))).append(".class, ").append(defaultValue).append(")");
                endPos = selector.indexOf(")", endPos + 3);
                getterAppended = true;
            } else if (selector.indexOf(".entityList", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "null";
                }
                out.append(".getEntityList(").append(defaultValue).append(")");
                endPos += 11;
                getterAppended = true;
            } else if (selector.indexOf(".entity", endPos + 1) == endPos + 1) {
                if (defaultValue == null) {
                    defaultValue = "null";
                }
                out.append(".getEntity(").append(defaultValue).append(")");
                endPos += 7;
                getterAppended = true;
            }
        }
        if (!(getterAppended || chainLength != 1 || !stringMode || selector.length() > endPos + 1 && selector.charAt(endPos + 1) == '.' || (inferredType = this.inferRADTagType(jenv, (String)tokens.get(0))) == null || inferredType == null || inferredType.getKind() != ElementKind.INTERFACE && inferredType.getKind() != ElementKind.CLASS)) {
            out.append(".getAs(").append(inferredType.getQualifiedName()).append(".class, ").append(defaultValue).append(")");
            getterAppended = true;
        }
        if (stringMode && selector.length() >= endPos + 1) {
            out.append(" + ");
        }
        if (selector.length() >= endPos + 1) {
            out.append(this.expandRADModelVars(jenv, selector.substring(endPos + 1), stringMode));
        }
        return out.toString();
    }

    private JavaPropertySelector createPropertySelector(JavaClassProxy classProxy, String selector) {
        return this.createPropertySelector(classProxy, selector, "java.lang.String");
    }

    private JavaPropertySelector createPropertySelector(JavaClassProxy classProxy, String selector, String propType) {
        JavaPropertySelector out = null;
        StringTokenizer strtok = new StringTokenizer(selector, ".");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            JavaMethodProxy getterMethod = classProxy.findGetterProxy(tok, new String[0]);
            if (strtok.hasMoreTokens() && getterMethod == null) {
                throw new IllegalArgumentException("Cannot create property selector for " + classProxy.className + " with selector " + selector + " becuase the class has no appropriate getter method. Token was " + tok + " and classProxy was " + classProxy.typeEl.getQualifiedName());
            }
            String _propType = propType;
            if (strtok.hasMoreTokens()) {
                TypeElement returnType = getterMethod.getReturnType();
                _propType = returnType.getQualifiedName().toString();
            }
            JavaPropertySelector javaPropertySelector = out = out == null ? new JavaPropertySelector(classProxy, tok, _propType) : new JavaPropertySelector(out, tok, _propType);
            if (!strtok.hasMoreTokens()) continue;
            classProxy = classProxy.env.newJavaClassProxy(getterMethod.getReturnType());
        }
        return out;
    }

    public boolean isStringListModel(TypeElement typeEl, VariableElement typeVar) {
        TypeElement stringType;
        if (!typeEl.getQualifiedName().contentEquals("com.codename1.ui.list.ListModel") && !typeEl.getQualifiedName().contentEquals("com.codename1.ui.list.MultipleSelectionListModel")) {
            return false;
        }
        TypeMirror tmpMirror = typeVar.asType();
        if (tmpMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType mirror = (DeclaredType)tmpMirror;
        if (mirror.getTypeArguments().isEmpty()) {
            return true;
        }
        TypeMirror typeArg = mirror.getTypeArguments().get(0);
        return typeArg.getKind() == TypeKind.DECLARED && this.isA(stringType = this.elements().getTypeElement("java.lang.String"), typeArg.toString());
    }

    private boolean isFontLiteral(String value) {
        if (value == null) {
            return false;
        }
        if ("small".equalsIgnoreCase(value) || "medium".equalsIgnoreCase(value) || "large".equalsIgnoreCase(value)) {
            return true;
        }
        if (value.length() > 0) {
            if (Character.isDigit(value.charAt(0))) {
                return true;
            }
            if (value.startsWith("native:")) {
                return true;
            }
        }
        return false;
    }

    private String formatFontAsArgumentValue(String value) {
        if (value.equalsIgnoreCase("small")) {
            return "com.codename1.ui.Font.createSystemFont(com.codename1.ui.Font.FACE_SYSTEM, com.codename1.ui.Font.STYLE_PLAIN, com.codename1.ui.Font.SIZE_SMALL)";
        }
        if (value.equalsIgnoreCase("medium")) {
            return "com.codename1.ui.Font.createSystemFont(com.codename1.ui.Font.FACE_SYSTEM, com.codename1.ui.Font.STYLE_PLAIN, com.codename1.ui.Font.SIZE_MEDIUM)";
        }
        if (value.equalsIgnoreCase("large")) {
            return "com.codename1.ui.Font.createSystemFont(com.codename1.ui.Font.FACE_SYSTEM, com.codename1.ui.Font.STYLE_PLAIN, com.codename1.ui.Font.SIZE_MEDIUM)";
        }
        if (value.contains("native:")) {
            int startPos = value.indexOf("native:");
            int endPos = value.indexOf(" ", startPos);
            if (endPos < 0) {
                endPos = value.length();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("com.codename1.ui.Font.createTrueTypeFont(");
            switch (value.substring(startPos, endPos).toLowerCase()) {
                case "native:mainthin": {
                    sb.append("CN.NATIVE_MAIN_THIN");
                    break;
                }
                case "native:mainlight": {
                    sb.append("CN.NATIVE_MAIN_LIGHT");
                    break;
                }
                case "native:mainregular": {
                    sb.append("CN.NATIVE_MAIN_REGULAR");
                    break;
                }
                case "native:mainbold": {
                    sb.append("CN.NATIVE_MAIN_BOLD");
                    break;
                }
                case "native:mainblack": {
                    sb.append("CN.NATIVE_MAIN_BLACK");
                    break;
                }
                default: {
                    this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to parse font literal " + value + ".  native fonts must be one of native:MainThin, native:MainLight, native:MainRegular, native:MainBold, native:MainBlack");
                    sb.append("CN.FONT_NATIVE_MAIN_REGULAR");
                }
            }
            String sizeStr = this.extractEmbeddedScalar(value);
            if (sizeStr == null) {
                sizeStr = "1rem";
            }
            sb.append(", ").append(this.formatScalarAsArgumentValue(sizeStr)).append("/CN.convertToPixels(1f))");
            return sb.toString();
        }
        return value;
    }

    private String extractEmbeddedScalar(String value) {
        StringTokenizer strtok = new StringTokenizer(value, " ");
        while (strtok.hasMoreTokens()) {
            String tok = strtok.nextToken();
            if (!this.isScalar(tok)) continue;
            return tok;
        }
        return null;
    }

    private boolean isScalar(String value) {
        if (value == null) {
            return false;
        }
        int len = 0;
        if (value.endsWith("vmin") || value.endsWith("vmax")) {
            len = value.length() - 4;
        } else if (value.endsWith("rem")) {
            len = value.length() - 3;
        } else if (value.endsWith("mm") || value.endsWith("px") || value.endsWith("vh") || value.endsWith("vw") || value.endsWith("em")) {
            len = value.length() - 2;
        } else if (value.endsWith("%")) {
            len = value.length() - 1;
        } else {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private String formatScalarAsArgumentValue(String scalar) {
        if (!this.isScalar(scalar)) {
            return scalar;
        }
        if (scalar.endsWith("vmin")) {
            return "(int)Math.round(((float)" + scalar.substring(0, scalar.length() - 4) + ")/100f * Math.min(CN.getDisplayWidth(), CN.getDisplayHeight()))";
        }
        if (scalar.endsWith("vmax")) {
            return "(int)Math.round(((float)" + scalar.substring(0, scalar.length() - 4) + ")/100f * Math.max(CN.getDisplayWidth(), CN.getDisplayHeight()))";
        }
        if (scalar.endsWith("vw")) {
            return "(int)Math.round(((float)" + scalar.substring(0, scalar.length() - 2) + ")/100f * CN.getDisplayWidth())";
        }
        if (scalar.endsWith("vh")) {
            return "(int)Math.round(((float)" + scalar.substring(0, scalar.length() - 2) + ")/100f * CN.getDisplayHeight())";
        }
        if (scalar.endsWith("mm")) {
            return "(int)Math.round(CN.convertToPixels((float)" + scalar.substring(0, scalar.length() - 2) + "))";
        }
        if (scalar.endsWith("px")) {
            return scalar.substring(0, scalar.length() - 2);
        }
        if (scalar.endsWith("rem")) {
            return "(int)Math.round(" + scalar.substring(0, scalar.length() - 3) + " * com.codename1.ui.Font.getDefaultFont().getHeight())";
        }
        if (scalar.endsWith("em")) {
            return "(int)Math.round(" + scalar.substring(0, scalar.length() - 3) + " * ((_cmp.getStyle() != null && _cmp.getStyle().getFont() != null) ? _cmp.getStyle().getFont().getHeight() : com.codename1.ui.Font.getDefaultFont().getHeight()))";
        }
        return scalar;
    }

    private static StringBuilder indent(StringBuilder sb, int num) {
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private static void forEach(Element root, Function<Element, Void> callback) {
        callback.apply(root);
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element childEl = (Element)n;
            ViewProcessor.forEach(childEl, callback);
        }
    }

    private static void forEachChild(Element root, Function<Element, Void> callback) {
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (!(n instanceof Element)) continue;
            Element childEl = (Element)n;
            callback.apply(childEl);
        }
    }

    private static List<Element> getChildElements(Element root) {
        ArrayList<Element> out = new ArrayList<Element>();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            Element childEl = (Element)n;
            out.add(childEl);
        }
        return out;
    }

    private static String getTextContent(Element root) {
        if (ViewProcessor.getDescendantTextContent(root).isEmpty()) {
            return root.getTextContent().trim();
        }
        return "";
    }

    private static String getDescendantTextContent(Element root) {
        StringBuilder out = new StringBuilder();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            out.append(n.getTextContent()).append(" ");
        }
        return out.toString().trim();
    }

    private static List<Element> getDescendantElements(List<Element> out, Element root) {
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            Element childEl = (Element)n;
            out.add(childEl);
            ViewProcessor.getDescendantElements(out, childEl);
        }
        return out;
    }

    private static List<Element> getChildElementsByTagName(Element root, String tagName) {
        return ViewProcessor.getChildElements(root).stream().filter(e -> e.getTagName().equalsIgnoreCase(tagName)).collect(Collectors.toList());
    }

    private static List<Element> getDescendantElementsByTagName(Element root, String tagName) {
        return ViewProcessor.getDescendantElements(new ArrayList<Element>(), root).stream().filter(e -> e.getTagName().equalsIgnoreCase(tagName)).collect(Collectors.toList());
    }

    private static Element getChildElementByTagName(Element root, String tagName) {
        for (Element child : ViewProcessor.getChildElements(root)) {
            if (!child.getTagName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    private static void forEachAttribute(Element el, Function<Attr, Void> callback) {
        NamedNodeMap attributes = el.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attributes.item(i);
            callback.apply(attr);
        }
    }

    private TypeElement toTypeElement(TypeMirror mirror) {
        return this.toTypeElement(mirror, false);
    }

    private TypeElement toTypeElement(TypeMirror mirror, boolean convertTypeVar) {
        if (convertTypeVar) {
            TypeVariable typeVar;
            if (mirror.getKind() == TypeKind.TYPEVAR) {
                typeVar = (TypeVariable)mirror;
                mirror = typeVar.getUpperBound();
            } else if (mirror.getKind() == TypeKind.ARRAY) {
                ArrayType arrayType = (ArrayType)mirror;
                mirror = arrayType.getComponentType();
            }
            if (mirror.getKind() == TypeKind.TYPEVAR) {
                typeVar = (TypeVariable)mirror;
                mirror = typeVar.getUpperBound();
            }
        }
        switch (mirror.getKind()) {
            case INT: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE: 
            case CHAR: 
            case BOOLEAN: {
                return this.types().boxedClass((PrimitiveType)mirror);
            }
            case DECLARED: 
            case ERROR: {
                DeclaredType declaredType = (DeclaredType)mirror;
                TypeElement out = (TypeElement)declaredType.asElement();
                if (out != null) {
                    return out;
                }
                out = this.elements().getTypeElement(mirror.toString());
                if (out == null && mirror.toString().contains("<")) {
                    out = this.elements().getTypeElement(mirror.toString().substring(0, mirror.toString().indexOf("<")));
                }
                if (out == null) {
                    throw new IllegalArgumentException("Cannot find class " + mirror);
                }
                return out;
            }
        }
        throw new IllegalArgumentException("Cannot convert type mirror " + mirror + " to type element");
    }

    private static String reformat(String content, int indentLevel) {
        int oldLevel = ViewProcessor.getIndentLevel(content);
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(content);
        int delta = indentLevel - oldLevel;
        String lineSeparator = ViewProcessor.getLineSeparator(content);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    sb.append(' ');
                }
                sb.append(line);
                sb.append(lineSeparator);
                continue;
            }
            int lineIndent = ViewProcessor.getIndentLevel(line);
            if (lineIndent + delta >= 0) {
                sb.append(line.substring(-delta));
            } else {
                sb.append(line.substring(lineIndent));
            }
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private static int getIndentLevel(String content) {
        Scanner scanner = new Scanner(content);
        block5: while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().isEmpty()) continue;
            int count = 0;
            int len = line.length();
            block6: for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': {
                        ++count;
                        continue block6;
                    }
                    case '\t': {
                        ++count;
                        continue block6;
                    }
                    case '\n': {
                        continue block5;
                    }
                }
            }
            return count;
        }
        return 0;
    }

    private static String getLineSeparator(String content) {
        if (content.contains("\r\n")) {
            return "\r\n";
        }
        if (content.contains("\n")) {
            return "\n";
        }
        return System.lineSeparator();
    }

    private static Set<Integer> extractIndexedParameters(Element element) {
        HashSet<Integer> out = new HashSet<Integer>();
        ViewProcessor.forEachAttribute(element, attr -> {
            String name = attr.getName();
            if (name.startsWith("_") && name.endsWith("_") && name.length() > 2 && Character.isDigit(name.charAt(1))) {
                try {
                    out.add(Integer.parseInt(name.substring(1, name.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        });
        ViewProcessor.forEachChild(element, child -> {
            String name;
            if (child.hasAttribute("rad-property") && (name = child.getAttribute("rad-property")).length() > 0 && Character.isDigit(name.charAt(0))) {
                try {
                    out.add(Integer.parseInt(name));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        });
        return out;
    }

    private <T extends javax.lang.model.element.Element> T wrap(T element) {
        return this.env().wrap(element);
    }

    static boolean isElementInsideRowTemplate(Element el) {
        if (el.getTagName().equalsIgnoreCase("row-template")) {
            return true;
        }
        Node parentNode = el.getParentNode();
        if (parentNode instanceof Element) {
            Element parentEl = (Element)parentNode;
            return ViewProcessor.isElementInsideRowTemplate(parentEl);
        }
        return false;
    }

    private boolean hasAttributeIgnoreCase(Element el, String attName) {
        NamedNodeMap attributes = el.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (!attName.equalsIgnoreCase(attr.getName())) continue;
            return true;
        }
        return false;
    }

    public static class Transition {
        private Double delay;
        private Double duration;
        private String property;
        private String timingFunction;

        public static Transition parse(String transitionString) {
            Transition out = new Transition();
            StringTokenizer strtok = new StringTokenizer(transitionString, " ");
            while (strtok.hasMoreTokens()) {
                Transition transition;
                String unit;
                String nextTok = strtok.nextToken();
                if (nextTok.trim().isEmpty()) continue;
                if (out.property == null) {
                    out.property = nextTok.trim();
                    continue;
                }
                if (out.duration == null) {
                    String durationStr = nextTok.trim();
                    String string = durationStr.endsWith("ms") ? "ms" : (unit = durationStr.endsWith("s") ? "s" : null);
                    if (unit == null) {
                        throw new IllegalArgumentException("Failed to parse transition string " + transitionString + ".  Duration " + durationStr + " had invalid time unit. Expecting 's' or 'ms'");
                    }
                    durationStr = durationStr.substring(0, durationStr.length() - unit.length());
                    out.duration = Double.parseDouble(durationStr);
                    if (!"s".equals(unit)) continue;
                    transition = out;
                    Double.valueOf(transition.duration * 1000.0);
                    transition.duration = transition.duration;
                    continue;
                }
                if (out.timingFunction == null) {
                    out.timingFunction = nextTok.trim();
                    continue;
                }
                if (out.delay != null) continue;
                String delayStr = nextTok.trim();
                String string = delayStr.endsWith("ms") ? "ms" : (unit = delayStr.endsWith("s") ? "s" : null);
                if (unit == null) {
                    throw new IllegalArgumentException("Failed to parse transition string " + transitionString + ".  Delay " + delayStr + " had invalid time unit. Expecting 's' or 'ms'");
                }
                delayStr = delayStr.substring(0, delayStr.length() - unit.length());
                out.delay = Double.parseDouble(delayStr);
                if (!"s".equals(unit)) continue;
                transition = out;
                Double.valueOf(transition.delay * 1000.0);
                transition.delay = transition.delay;
            }
            return out;
        }

        public void writeTransitionCallForBinding(StringBuilder sb, String componentVariable, boolean layoutParent) {
            String getParent;
            String string = getParent = layoutParent ? "getParent()." : "";
            if (!(this.duration != null && this.duration != 0.0 || this.delay != null && this.delay != 0.0)) {
                sb.append("revalidateLater();\n");
            } else if (this.duration == null || this.duration == 0.0) {
                sb.append("CN.setTimeout(").append(this.delay.intValue()).append(", () -> revalidateLater());\n");
            } else if (this.delay == null || this.delay == 0.0) {
                sb.append(componentVariable).append(".").append(getParent).append("animateLayout(").append(this.duration.intValue()).append(");\n");
            } else {
                sb.append("CN.setTimeout(").append(this.delay.intValue()).append(", () -> ").append(componentVariable).append(".").append(getParent).append("animateLayout(").append(this.duration.intValue()).append(");\n");
            }
        }

        public int getDurationMs() {
            return this.duration == null ? 0 : this.duration.intValue();
        }

        public void buildTransitionObject(StringBuilder sb, int indent, String varName) {
            String slideType;
            boolean forward;
            if (this.timingFunction == null) {
                return;
            }
            ViewProcessor.indent(sb, indent).append("{\n");
            indent += 4;
            if (this.timingFunction.equalsIgnoreCase("flip")) {
                ViewProcessor.indent(sb, indent).append(varName).append(" = new com.codename1.ui.animations.FlipTransition();\n");
                if (this.duration > 0.0) {
                    ViewProcessor.indent(sb, indent).append("((com.codename1.ui.animations.FlipTransition)").append(varName).append(").setDuration(").append(this.duration.intValue()).append(");\n");
                }
            } else if (this.timingFunction.equalsIgnoreCase("fade")) {
                ViewProcessor.indent(sb, indent).append(varName).append(" = com.codename1.ui.animations.CommonTransitions.createFade(").append(this.duration.intValue()).append(");\n");
            } else if (this.timingFunction.equalsIgnoreCase("slide") || this.timingFunction.startsWith("slide-")) {
                forward = !this.timingFunction.contains("reverse");
                slideType = this.timingFunction.contains("-y") || this.timingFunction.contains("-vertical") || this.timingFunction.contains("-up") || this.timingFunction.contains("-down") ? "com.codename1.ui.animations.CommonTransitions.SLIDE_VERTICAL" : "com.codename1.ui.animations.CommonTransitions.SLIDE_HORIZONTAL";
                ViewProcessor.indent(sb, indent).append(varName).append(" = com.codename1.ui.animations.CommonTransitions.createSlide(").append(slideType).append(", ").append(forward).append(", ").append(this.duration.intValue()).append(");\n");
            } else if (this.timingFunction.equalsIgnoreCase("cover") || this.timingFunction.startsWith("cover-")) {
                forward = !this.timingFunction.contains("reverse");
                slideType = this.timingFunction.contains("-y") || this.timingFunction.contains("-vertical") || this.timingFunction.contains("-up") || this.timingFunction.contains("-down") ? "com.codename1.ui.animations.CommonTransitions.SLIDE_VERTICAL" : "com.codename1.ui.animations.CommonTransitions.SLIDE_HORIZONTAL";
                ViewProcessor.indent(sb, indent).append(varName).append(" = com.codename1.ui.animations.CommonTransitions.createCover(").append(slideType).append(", ").append(forward).append(", ").append(this.duration.intValue()).append(");\n");
            } else if (this.timingFunction.equalsIgnoreCase("uncover") || this.timingFunction.startsWith("uncover-")) {
                forward = !this.timingFunction.contains("reverse");
                slideType = this.timingFunction.contains("-y") || this.timingFunction.contains("-vertical") || this.timingFunction.contains("-up") || this.timingFunction.contains("-down") ? "com.codename1.ui.animations.CommonTransitions.SLIDE_VERTICAL" : "com.codename1.ui.animations.CommonTransitions.SLIDE_HORIZONTAL";
                ViewProcessor.indent(sb, indent).append(varName).append(" = com.codename1.ui.animations.CommonTransitions.createUncover(").append(slideType).append(", ").append(forward).append(", ").append(this.duration.intValue()).append(");\n");
            }
            ViewProcessor.indent(sb, indent -= 4).append("}\n");
        }
    }

    public static class Transitions {
        private Map<String, Transition> transitions = new HashMap<String, Transition>();

        public static Transitions parse(String transitionString) {
            Transitions out = new Transitions();
            StringTokenizer strtok = new StringTokenizer(transitionString, ",");
            while (strtok.hasMoreTokens()) {
                String nextTok = strtok.nextToken();
                if (nextTok.trim().isEmpty()) continue;
                Transition t = Transition.parse(nextTok);
                out.transitions.put(t.property, t);
            }
            return out;
        }

        public Transition get(String property) {
            Transition out = this.transitions.get(property);
            if (out == null) {
                out = this.transitions.get("all");
            }
            return out;
        }
    }

    private class AttributeComparator
    implements Comparator<Attr> {
        private AttributeComparator() {
        }

        @Override
        public int compare(Attr o1, Attr o2) {
            int diff = this.score(o1) - this.score(o2);
            if (diff == 0) {
                return o1.getName().compareTo(o2.getName());
            }
            return diff;
        }

        private int countChars(String str, char ch) {
            int count = 0;
            int len = str.length();
            char[] chars = str.toCharArray();
            for (int i = 0; i < len; ++i) {
                if (chars[i] != ch) continue;
                ++count;
            }
            return count;
        }

        private int score(Attr attribute) {
            String name = attribute.getName();
            int base = 0;
            if (name.contains(".")) {
                base = 250 * this.countChars(name, '.');
            }
            if (name.equalsIgnoreCase("materialIcon") || name.equalsIgnoreCase("fontIcon")) {
                return base + 500;
            }
            if (name.toLowerCase().contains("uiid")) {
                return base + 10;
            }
            if (name.toLowerCase().contains("style")) {
                return base + 20;
            }
            return base + 250;
        }
    }

    private class EntityViewBuilder {
        private JavaEnvironment jenv;
        private int nextRadId = 0;
        private int indent = 0;
        private Element rootEl;
        private ArrayList<JavaComponentBuilder> componentBuilders = new ArrayList();
        private ArrayList<JavaNodeBuilder> nodeBuilders = new ArrayList();
        private ArrayList<JavaBeanBuilder> beanBuilders = new ArrayList();
        private Map<String, JavaClassProxy> injectableTypes = new HashMap<String, JavaClassProxy>();
        private String viewImplements;
        private String viewExtends;
        private String viewModelType = "Entity";
        private final String packageName;
        private String className;
        private TypeElement parentClass;
        private boolean parsed;

        EntityViewBuilder(TypeElement parentClass) {
            this.parentClass = parentClass;
            this.packageName = ViewProcessor.this.elements().getPackageOf(parentClass).getQualifiedName().toString();
            this.viewExtends = parentClass.getSimpleName().toString();
            this.className = parentClass.getSimpleName().toString();
            if (this.className.startsWith("Abstract")) {
                this.className = this.className.substring("Abstract".length());
            }
            this.viewModelType = this.className + "Model";
            if (parentClass.getSimpleName().contentEquals(this.className)) {
                this.className = this.className + "Impl";
            }
        }

        private <T> Set<T> setOf(T ... elements) {
            HashSet<T> out = new HashSet<T>();
            for (T el : elements) {
                out.add(el);
            }
            return out;
        }

        private void installTypes(ProcessingEnvironmentWrapper env) throws XMLParseException {
            Element controllerTag;
            TypeElement supertypeEl;
            this.parse();
            ProcessingEnvironmentWrapper processingEnvironmentWrapper = env;
            Objects.requireNonNull(processingEnvironmentWrapper);
            ProcessingEnvironmentWrapper.SchemaBuilder schemaBuilder = new ProcessingEnvironmentWrapper.SchemaBuilder(processingEnvironmentWrapper, this.packageName + "." + this.className + "Schema");
            ProcessingEnvironmentWrapper processingEnvironmentWrapper2 = env;
            Objects.requireNonNull(processingEnvironmentWrapper2);
            ProcessingEnvironmentWrapper.EntityBuilder entityBuilder = new ProcessingEnvironmentWrapper.EntityBuilder(processingEnvironmentWrapper2, this.packageName + "." + this.className + "Model");
            ProcessingEnvironmentWrapper processingEnvironmentWrapper3 = env;
            Objects.requireNonNull(processingEnvironmentWrapper3);
            ProcessingEnvironmentWrapper.EntityImplBuilder entityImplBuilder = new ProcessingEnvironmentWrapper.EntityImplBuilder(processingEnvironmentWrapper3, this.packageName + "." + this.className + "ModelImpl");
            if (this.jenv.lookupClass(this.viewModelType) != null) {
                this.viewModelType = this.jenv.lookupClass(this.viewModelType).getQualifiedName().toString();
            } else if (!this.viewModelType.contains(".")) {
                this.viewModelType = this.packageName + "." + this.viewModelType;
            }
            ProcessingEnvironmentWrapper processingEnvironmentWrapper4 = env;
            Objects.requireNonNull(processingEnvironmentWrapper4);
            ProcessingEnvironmentWrapper.EntityControllerBuilder controllerBuilder = new ProcessingEnvironmentWrapper.EntityControllerBuilder(processingEnvironmentWrapper4, this.packageName + "." + this.className + "Controller", this.viewModelType);
            ProcessingEnvironmentWrapper processingEnvironmentWrapper5 = env;
            Objects.requireNonNull(processingEnvironmentWrapper5);
            ProcessingEnvironmentWrapper.EntityControllerMarkerBuilder controllerMarkerBuilder = new ProcessingEnvironmentWrapper.EntityControllerMarkerBuilder(processingEnvironmentWrapper5, this.packageName + ".I" + this.className + "Controller");
            ProcessingEnvironmentWrapper processingEnvironmentWrapper6 = env;
            Objects.requireNonNull(processingEnvironmentWrapper6);
            ProcessingEnvironmentWrapper.EntityViewBuilder entityViewBuilder = new ProcessingEnvironmentWrapper.EntityViewBuilder(processingEnvironmentWrapper6, this.packageName + "." + this.className, this.viewModelType);
            for (Element defineTag : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-tag")) {
                if (defineTag.hasAttribute("name")) {
                    schemaBuilder.addTag(defineTag.getAttribute("name"));
                }
                String type = defineTag.hasAttribute("type") ? defineTag.getAttribute("type") : "String";
                DeclaredType declaredType = this.jenv.createDeclaredType(type, new TypeMirror[0]);
                entityBuilder.addProperty(defineTag.getAttribute("name"), declaredType);
                entityImplBuilder.addProperty(defineTag.getAttribute("name"), declaredType);
            }
            for (Element defineTag : ViewProcessor.getDescendantElementsByTagName(this.rootEl, "define-slot")) {
                if (!defineTag.hasAttribute("id")) continue;
                schemaBuilder.addTag(defineTag.getAttribute("id"));
            }
            for (Object defineCategory : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-category")) {
                if (!defineCategory.hasAttribute("name")) continue;
                schemaBuilder.addCategory(defineCategory.getAttribute("name"));
            }
            Element viewModelTag = ViewProcessor.getChildElementByTagName(this.rootEl, "view-model");
            if (viewModelTag != null) {
                for (Element defineProperty : ViewProcessor.getChildElementsByTagName(viewModelTag, "define-property")) {
                    if (!defineProperty.hasAttribute("name") || !defineProperty.hasAttribute("type")) continue;
                    String type = defineProperty.getAttribute("type");
                    DeclaredType declaredType = this.jenv.createDeclaredType(type, new TypeMirror[0]);
                    entityBuilder.addProperty(defineProperty.getAttribute("name"), declaredType);
                    entityImplBuilder.addProperty(defineProperty.getAttribute("name"), declaredType);
                }
                if (viewModelTag.hasAttribute("implements")) {
                    StringTokenizer strtok = new StringTokenizer(viewModelTag.getAttribute("implements"), ",");
                    while (strtok.hasMoreTokens()) {
                        String tok = strtok.nextToken().trim();
                        if (tok.isEmpty()) continue;
                        supertypeEl = this.jenv.lookupClass(tok);
                        if (supertypeEl == null) {
                            if (!tok.contains(".")) {
                                tok = this.packageName + "." + tok;
                            }
                            entityBuilder.addInterface(env.createDeclaredType(tok, new TypeMirror[0]));
                            continue;
                        }
                        entityBuilder.addInterface(supertypeEl.asType());
                    }
                }
                if (viewModelTag.hasAttribute("extends")) {
                    String superclass = viewModelTag.getAttribute("extends");
                    TypeElement supertypeEl2 = this.jenv.lookupClass(superclass);
                    if (supertypeEl2 == null) {
                        if (!superclass.contains(".")) {
                            superclass = this.packageName + "." + superclass;
                        }
                        entityImplBuilder.superclass(env.createDeclaredType(superclass, new TypeMirror[0]));
                    } else {
                        entityImplBuilder.superclass(supertypeEl2.asType());
                    }
                }
            }
            if ((controllerTag = ViewProcessor.getChildElementByTagName(this.rootEl, "form-controller")) != null) {
                if (controllerTag.hasAttribute("extends")) {
                    String superclass = controllerTag.getAttribute("extends");
                    supertypeEl = this.jenv.lookupClass(superclass);
                    if (supertypeEl == null) {
                        if (!superclass.contains(".")) {
                            superclass = this.packageName + "." + superclass;
                        }
                        controllerBuilder.superclass(env.createDeclaredType(superclass, new TypeMirror[0]));
                    } else {
                        controllerBuilder.superclass(supertypeEl.asType());
                    }
                }
                if (controllerTag.hasAttribute("implements")) {
                    StringTokenizer strtok = new StringTokenizer(controllerTag.getAttribute("implements"), ",");
                    while (strtok.hasMoreTokens()) {
                        String tok = strtok.nextToken().trim();
                        if (tok.isEmpty()) continue;
                        TypeElement supertypeEl3 = this.jenv.lookupClass(tok);
                        if (supertypeEl3 == null) {
                            if (!tok.contains(".")) {
                                tok = this.packageName + "." + tok;
                            }
                            controllerBuilder.addInterface(env.createDeclaredType(tok, new TypeMirror[0]));
                            continue;
                        }
                        controllerBuilder.addInterface(supertypeEl3.asType());
                    }
                }
            }
            ArrayList<ProcessingEnvironmentWrapper.CustomTypeElement> types = new ArrayList<ProcessingEnvironmentWrapper.CustomTypeElement>(Arrays.asList(schemaBuilder.build(), entityBuilder.build(), entityImplBuilder.build(), controllerMarkerBuilder.build(), controllerBuilder.build(), entityViewBuilder.build()));
            env.addTypes(types.toArray(new ProcessingEnvironmentWrapper.CustomTypeElement[types.size()]));
            JavaEnvironment.ClassIndex index = (JavaEnvironment.ClassIndex)ViewProcessor.this.cache.get(JavaEnvironment.ClassIndex.class);
            if (index != null) {
                index.componentIndex.add(((ProcessingEnvironmentWrapper.CustomTypeElement)types.get(5)).getQualifiedName().toString());
            }
        }

        private void loadImports(Element root) {
            ViewProcessor.forEach(root, el -> {
                if (el.getTagName().equalsIgnoreCase("import")) {
                    this.jenv.addImports(el.getTextContent());
                } else if (el.getTagName().equalsIgnoreCase("use-taglib")) {
                    String packageName = el.getAttribute("package");
                    String className = el.getAttribute("class");
                    if (className.isEmpty() && packageName.isEmpty()) {
                        ViewProcessor.this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "use-taglib tag requires either the 'class' or 'package' attribute.");
                        return null;
                    }
                    if (!className.isEmpty()) {
                        TypeElement typeEl = ViewProcessor.this.elements().getTypeElement(className);
                        if (typeEl == null) {
                            ViewProcessor.this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "use-taglib tag failed to resolve class " + className + ".");
                            return null;
                        }
                        TagLib tagLib = typeEl.getAnnotation(TagLib.class);
                        if (tagLib == null) {
                            ViewProcessor.this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "use-taglib specified class name " + className + " is not a TagLib.");
                            return null;
                        }
                        for (String imprt : tagLib.imports()) {
                            this.jenv.addImports(imprt);
                        }
                        return null;
                    }
                    if (!packageName.isEmpty()) {
                        PackageElement pkg = ViewProcessor.this.elements().getPackageElement(packageName);
                        if (pkg == null) {
                            ViewProcessor.this.env().getMessager().printMessage(Diagnostic.Kind.ERROR, "use-taglib failed to resolve package " + packageName);
                            return null;
                        }
                        for (javax.lang.model.element.Element child : pkg.getEnclosedElements().stream().filter(e -> e.getAnnotation(TagLib.class) != null).collect(Collectors.toList())) {
                            TagLib tagLib = child.getAnnotation(TagLib.class);
                            for (String imprt : tagLib.imports()) {
                                this.jenv.addImports(imprt);
                            }
                        }
                        return null;
                    }
                }
                return null;
            });
            this.jenv.addImports("import " + this.packageName + ".*;");
            this.jenv.addImports("import static com.codename1.rad.util.NonNull.nonNull;");
            this.jenv.addImports("import static com.codename1.rad.util.NonNull.nonNullEntries;");
            if (!root.hasAttribute("strict-imports")) {
                this.jenv.addImports("import com.codename1.ui.spinner.Picker;\n");
                this.jenv.addImports("import com.codename1.rad.schemas.*;\n");
                this.jenv.addImports("import com.codename1.rad.ui.builders.*;\n");
                this.jenv.addImports("import ca.weblite.shared.components.*;\n");
                this.jenv.addImports("import com.codename1.rad.models.*;\n");
                this.jenv.addImports("import com.codename1.rad.nodes.*;\n");
                this.jenv.addImports("import com.codename1.rad.ui.entityviews.*;\n");
                this.jenv.addImports("import com.codename1.rad.ui.beans.*;\n");
                this.jenv.addImports("import com.codename1.rad.propertyviews.*;\n");
                this.jenv.addImports("import ca.weblite.shared.components.*;\n");
                this.jenv.addImports("import com.codename1.ui.*;\n");
                this.jenv.addImports("import com.codename1.ui.plaf.*;\n");
                this.jenv.addImports("import com.codename1.components.*;\n");
                this.jenv.addImports("import static com.codename1.ui.CN.*;\n");
                this.jenv.addImports("import com.codename1.ui.layouts.*;\n");
                this.jenv.addImports("import com.codename1.rad.ui.ViewContext;\n");
                this.jenv.addImports("import com.codename1.rad.ui.EntityView;\n");
            }
        }

        private void parse() throws XMLParseException {
            Document doc;
            if (this.parsed) {
                return;
            }
            this.parsed = true;
            try {
                String xmlString = null;
                for (javax.lang.model.element.Element element : ViewProcessor.this.elements().getAllMembers(this.parentClass)) {
                    if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().contentEquals("FRAGMENT_XML") || !(element instanceof VariableElement)) continue;
                    VariableElement varEl = (VariableElement)element;
                    xmlString = (String)varEl.getConstantValue();
                    break;
                }
                if (xmlString == null) {
                    throw new XMLParseException("Parent class " + this.parentClass + " did not contain a FRAGMENT_XML property.", null, null);
                }
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                doc = documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes("utf-8")), "utf-8");
            }
            catch (Exception ex) {
                throw new XMLParseException("Failed to parse XML in view XML file for " + this.parentClass, null, ex);
            }
            this.parse(doc.getDocumentElement());
        }

        private void setViewModelType(String viewModelType) {
            this.viewModelType = viewModelType;
            this.jenv.setViewModelType(viewModelType);
        }

        private void parse(Element root) throws XMLParseException {
            this.jenv = new JavaEnvironment(root);
            this.jenv.rootBuilder = this;
            this.jenv.addImports("import " + this.packageName + ".*;");
            XMLParseException[] errors = new XMLParseException[1];
            ViewProcessor.forEach(root, el -> {
                if (errors[0] != null) {
                    return null;
                }
                Runnable runnable = () -> {
                    TypeElement beanClass;
                    String tagName = el.getTagName();
                    if (this.rootEl == null) {
                        this.rootEl = el;
                        this.loadImports((Element)el);
                        this.jenv.buildIndex();
                        if (el.hasAttribute("rad-model")) {
                            this.setViewModelType(el.getAttribute("rad-model"));
                        } else {
                            this.setViewModelType(this.className + "Model");
                        }
                        this.viewImplements = this.className + "Schema";
                        if (el.hasAttribute("rad-implements")) {
                            this.viewImplements = this.viewImplements + ", " + el.getAttribute("rad-implements");
                        }
                    }
                    if (tagName.equalsIgnoreCase("import")) {
                        return;
                    }
                    if (!tagName.contains("-") && this.jenv.isComponentTag(tagName)) {
                        JavaClassProxy builderClass = this.jenv.findComponentBuilderForTag(tagName);
                        if (builderClass != null) {
                            try {
                                JavaComponentBuilder componentBuilder = new JavaComponentBuilder((Element)el, this.jenv, builderClass, null);
                                this.componentBuilders.add(componentBuilder);
                            }
                            catch (ClassNotFoundException cnfe) {
                                XMLParseException ex;
                                errors[0] = ex = new XMLParseException("Failed to find component class for builder " + builderClass.getQualifiedName() + " while processing tag " + tagName, (Element)el, cnfe);
                                return;
                            }
                        }
                        TypeElement componentTypeEl = this.jenv.findClassThatTagCreates(tagName);
                        try {
                            if (componentTypeEl == null) {
                                throw new ClassNotFoundException();
                            }
                            JavaClassProxy componentClassProxy = this.jenv.newJavaClassProxy(componentTypeEl);
                            JavaComponentBuilder componentBuilder = new JavaComponentBuilder((Element)el, this.jenv, null, componentClassProxy);
                            this.componentBuilders.add(componentBuilder);
                        }
                        catch (ClassNotFoundException cnfe) {
                            XMLParseException ex;
                            errors[0] = ex = new XMLParseException("Failed to find component class for tag " + tagName, (Element)el, cnfe);
                            return;
                        }
                        return;
                    }
                    if (!tagName.contains("-") && (beanClass = this.jenv.findClassThatTagCreates(tagName)) != null) {
                        try {
                            this.beanBuilders.add(new JavaBeanBuilder((Element)el, this.jenv, this.jenv.newJavaClassProxy(beanClass)));
                        }
                        catch (ClassNotFoundException cnfe) {
                            XMLParseException ex;
                            errors[0] = ex = new XMLParseException("Failed to find bean class for tag " + tagName, (Element)el, cnfe);
                            return;
                        }
                    }
                    if (!tagName.contains("-") && this.jenv.isNodeTag(tagName, true)) {
                        JavaClassProxy builderClass = this.jenv.findNodeBuilderForTag(tagName);
                        if (builderClass != null) {
                            try {
                                JavaNodeBuilder nodeBuilder = new JavaNodeBuilder((Element)el, this.jenv, builderClass, null);
                                this.nodeBuilders.add(nodeBuilder);
                            }
                            catch (ClassNotFoundException cnfe) {
                                XMLParseException ex;
                                errors[0] = ex = new XMLParseException("Failed to find node class for builder " + builderClass.getQualifiedName() + " while processing tag " + tagName, (Element)el, cnfe);
                                return;
                            }
                        }
                        TypeElement nodeTypeEl = this.jenv.findClassThatTagCreates(tagName, "com.codename1.rad.nodes.Node");
                        try {
                            if (nodeTypeEl == null) {
                                throw new ClassNotFoundException();
                            }
                            JavaClassProxy nodeClassProxy = this.jenv.newJavaClassProxy(nodeTypeEl);
                            JavaNodeBuilder nodeBuilder = new JavaNodeBuilder((Element)el, this.jenv, null, nodeClassProxy);
                            this.nodeBuilders.add(nodeBuilder);
                        }
                        catch (ClassNotFoundException cnfe) {
                            XMLParseException ex;
                            errors[0] = ex = new XMLParseException("Failed to find node class for tag " + tagName, (Element)el, cnfe);
                            return;
                        }
                    }
                };
                runnable.run();
                return null;
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }

        private void writeClassVariables(StringBuilder sb) throws XMLParseException {
            XMLParseException[] errors = new XMLParseException[1];
            HashMap variables = new HashMap();
            ViewProcessor.indent(sb, this.indent).append("// Placeholder for the row model when creating EntityListCellRenderer.\n");
            ViewProcessor.indent(sb, this.indent).append("// Can access inside <script> tags inside <row-template>\n");
            ViewProcessor.indent(sb, this.indent).append("private com.codename1.rad.models.Entity rowModel;\n");
            ViewProcessor.indent(sb, this.indent).append("// Placeholder for the row index when creating EntityListCellRenderer.\n");
            ViewProcessor.indent(sb, this.indent).append("// Can access inside <script> tags inside <row-template>\n");
            ViewProcessor.indent(sb, this.indent).append("private int rowIndex;\n");
            ViewProcessor.indent(sb, this.indent).append("// Placeholder for the row selected state when creating EntityListCellRenderer.\n");
            ViewProcessor.indent(sb, this.indent).append("// Can access inside <script> tags inside <row-template>\n");
            ViewProcessor.indent(sb, this.indent).append("private boolean rowSelected;\n");
            ViewProcessor.indent(sb, this.indent).append("// Placeholder for the row focused state when creating EntityListCellRenderer.\n");
            ViewProcessor.indent(sb, this.indent).append("// Can access inside <script> tags inside <row-template>\n");
            ViewProcessor.indent(sb, this.indent).append("private boolean rowFocused;\n");
            ViewProcessor.indent(sb, this.indent).append("// Placeholder for the EntityListView when creating EntityListCellRenderer.\n");
            ViewProcessor.indent(sb, this.indent).append("// Can access inside <script> tags inside <row-template>\n");
            ViewProcessor.indent(sb, this.indent).append("private com.codename1.rad.ui.entityviews.EntityListView rowList;\n");
            ViewProcessor.indent(sb, this.indent).append("private EntityView view = this;\n");
            ViewProcessor.indent(sb, this.indent).append("private EntityView rowView;\n");
            ViewProcessor.indent(sb, this.indent).append("private ViewContext subContext;\n");
            ViewProcessor.indent(sb, this.indent).append("private Container _currentContainer;\n");
            ViewProcessor.forEach(this.rootEl, el -> {
                if (errors[0] != null) {
                    return null;
                }
                if (el.getTagName().equalsIgnoreCase("var")) {
                    String name = el.getAttribute("name");
                    if (name.isEmpty()) {
                        errors[0] = new XMLParseException("var tag requires a name attribute.", (Element)el, null);
                        return null;
                    }
                    if (variables.containsKey(name)) {
                        return null;
                    }
                    Element parentEl = (Element)el.getParentNode();
                    String visibility = "";
                    if (parentEl != null) {
                        String parentTag = parentEl.getTagName();
                        visibility = parentTag.equalsIgnoreCase("public") ? "public" : (parentTag.equalsIgnoreCase("private") ? "private" : (parentTag.equalsIgnoreCase("protected") ? "protected" : ""));
                    }
                    String type = null;
                    String lookup = el.getAttribute("lookup");
                    if (!lookup.isEmpty()) {
                        type = lookup;
                    }
                    if (el.hasAttribute("type")) {
                        type = el.getAttribute("type");
                    }
                    if (type != null) {
                        TypeElement injectableType;
                        if ("true".equals(el.getAttribute("inject")) && (injectableType = this.jenv.lookupClass(type)) != null) {
                            this.injectableTypes.put(name, this.jenv.newJavaClassProxy(injectableType));
                        }
                        variables.put(name, type);
                        ViewProcessor.indent(sb, this.indent);
                        if (!visibility.isEmpty()) {
                            sb.append(visibility).append(" ");
                        }
                        sb.append(type).append(" ").append(name).append(";\n");
                        return null;
                    }
                    return null;
                }
                if (!el.getTagName().contains("-") && (el.hasAttribute("rad-var") || el.hasAttribute("id") || el.hasAttribute("name"))) {
                    String varName = el.getAttribute("rad-var");
                    if (varName == null || varName.isEmpty()) {
                        varName = el.getAttribute("id");
                    }
                    if (varName == null || varName.isEmpty()) {
                        varName = el.getAttribute("name");
                    }
                    if (varName == null || varName.isEmpty()) {
                        return null;
                    }
                    varName = varName.replace('-', '_').replace(' ', '_');
                    String modifiers = "";
                    if (varName.startsWith("-")) {
                        modifiers = "private";
                        varName = varName.substring(1);
                    } else if (varName.startsWith("#")) {
                        modifiers = "protected";
                        varName = varName.substring(1);
                    } else if (varName.startsWith("+")) {
                        modifiers = "public";
                        varName = varName.substring(1);
                    } else if (!el.hasAttribute("rad-var")) {
                        modifiers = "public";
                    }
                    TypeElement type = this.jenv.findClassThatTagCreates(el.getTagName());
                    if (type == null) {
                        return null;
                    }
                    ViewProcessor.indent(sb, this.indent);
                    if (!modifiers.isEmpty()) {
                        sb.append(modifiers).append(" ");
                    }
                    sb.append(type.getQualifiedName().toString()).append(" ").append(varName).append(";\n");
                }
                return null;
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }

        private void writeScriptMethods(StringBuilder sb) throws XMLParseException {
            XMLParseException[] errors = new XMLParseException[1];
            ViewProcessor.forEach(this.rootEl, el -> {
                if (el.getTagName().equalsIgnoreCase("script")) {
                    if (errors[0] != null) {
                        return null;
                    }
                    String id = el.getAttribute("rad-id");
                    Element parentEl = (Element)el.getParentNode();
                    TypeElement parentType = this.jenv.findClassThatTagCreates(parentEl.getTagName());
                    if (parentType == null) {
                        errors[0] = new XMLParseException("Cannot find class for tag " + parentEl.getTagName() + " while generating script element.", (Element)el, null);
                        return null;
                    }
                    ViewProcessor.indent(sb, this.indent).append("private void script").append(id).append("(").append(parentType.getQualifiedName()).append(" it) {\n");
                    this.indent += 4;
                    String scriptContent = ViewProcessor.this.expandRADModelVars(this.jenv, el.getTextContent(), false);
                    sb.append(ViewProcessor.reformat(scriptContent, this.indent));
                    sb.append("\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                }
                return null;
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }

        private void writeMarkerInterfaces(StringBuilder sb) {
            ViewProcessor.indent(sb, this.indent).append("public static interface I").append(this.className).append("Controller{}\n");
        }

        private void writeFormControllerMarkerInterface(StringBuilder sb) {
            sb.append("package ").append(this.packageName).append(";\n");
            sb.append("import com.codename1.rad.annotations.*;\n");
            sb.append("/**\n");
            sb.append(" * A marker interface that can be used to signify that a FormController is designed to work\n");
            sb.append(" * with ").append(this.className).append(".  \n");
            sb.append(" * Usage: appController.addObjectFactory(I").append(this.className).append("Controller.class, evt -> {...});\n");
            sb.append(" */\n");
            sb.append("@Autogenerated\n");
            sb.append("public interface I").append(this.className).append("Controller {}\n");
        }

        private void writeFormController(StringBuilder sb) {
            Element defineMethods;
            Element defineConstructors;
            sb.append("package ").append(this.packageName).append(";\n");
            sb.append("import com.codename1.rad.annotations.*;\n");
            sb.append("import com.codename1.rad.controllers.FormController;\n");
            sb.append("import com.codename1.rad.controllers.Controller;\n");
            this.jenv.writeImports(sb);
            NodeList formControllerTags = this.rootEl.getElementsByTagName("form-controller");
            Element formControllerTag = null;
            if (formControllerTags.getLength() > 0) {
                formControllerTag = (Element)formControllerTags.item(0);
            }
            String parentController = formControllerTag == null || !formControllerTag.hasAttribute("extends") ? "FormController" : formControllerTag.getAttribute("extends");
            String ifaces = "I" + this.className + "Controller, FormController.CloneableFormController<" + this.className + "Controller>";
            if (formControllerTag != null && formControllerTag.hasAttribute("implements")) {
                ifaces = ifaces + ", " + formControllerTag.getAttribute("implements");
            }
            ViewProcessor.indent(sb, this.indent).append("public class ").append(this.className).append("Controller extends ").append(parentController).append(" implements ").append(ifaces).append(" {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("private ").append(this.viewModelType).append(" viewModel;\n");
            Element overrideConstructors = formControllerTag != null ? ViewProcessor.getChildElementByTagName(formControllerTag, "override-constructors") : null;
            Element element = defineConstructors = formControllerTag != null ? ViewProcessor.getChildElementByTagName(formControllerTag, "define-constructors") : null;
            if (overrideConstructors != null) {
                sb.append(ViewProcessor.reformat(overrideConstructors.getTextContent(), this.indent));
                sb.append("\n");
            } else {
                List candidates;
                TypeElement viewModelTypeEl;
                ViewProcessor.indent(sb, this.indent).append("public ").append(this.className).append("Controller(@Inject Controller parent) {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("super(parent);\n");
                ViewProcessor.indent(sb, this.indent).append("this.viewModel = createViewModel();\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                ViewProcessor.indent(sb, this.indent).append("public ").append(this.className).append("Controller(@Inject Controller parent, @Inject ").append(this.viewModelType).append(" viewModel) {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("super(parent);\n");
                ViewProcessor.indent(sb, this.indent).append("this.viewModel = viewModel != null ? viewModel : createViewModel();\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                TypeElement viewModelClassEl = viewModelTypeEl = this.jenv.lookupClass(this.viewModelType);
                if (viewModelTypeEl != null && (viewModelTypeEl.getKind() == ElementKind.INTERFACE || viewModelTypeEl.getModifiers().contains((Object)Modifier.ABSTRACT)) && (viewModelClassEl = this.jenv.lookupClass(viewModelTypeEl + "Impl")) == null && !(candidates = this.jenv.findInstantiatableClassesAssignableTo(ViewProcessor.this.elements().getPackageOf(viewModelTypeEl), this.rootEl.getOwnerDocument().createElement(viewModelTypeEl.getSimpleName().toString()), new String[]{viewModelTypeEl.getQualifiedName().toString()})).isEmpty()) {
                    viewModelClassEl = ((JavaClassProxy)candidates.get(0)).typeEl;
                }
                if (viewModelClassEl == null) {
                    throw new IllegalArgumentException("Cannot find view model for " + this.viewModelType + " while generating form controller for " + this.className);
                }
                ViewProcessor.indent(sb, this.indent).append("public ").append(this.viewModelType).append(" createViewModel() {\n");
                ViewProcessor.indent(sb, this.indent).append("    return new ").append(BaseProcessor._(viewModelClassEl.getQualifiedName().toString())).append("();\n");
                ViewProcessor.indent(sb, this.indent).append("}\n");
                ViewProcessor.indent(sb, this.indent).append("@Override\n");
                ViewProcessor.indent(sb, this.indent).append("public ").append(this.className).append("Controller cloneAndReplace() {\n");
                ViewProcessor.indent(sb, this.indent).append("    ").append(this.className).append("Controller out = new ").append(this.className).append("Controller(getParent(), viewModel);\n");
                ViewProcessor.indent(sb, this.indent).append("    out.show();\n");
                ViewProcessor.indent(sb, this.indent).append("    return out;\n");
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
            if (defineConstructors != null) {
                sb.append(ViewProcessor.reformat(defineConstructors.getTextContent(), this.indent));
                sb.append("\n");
            }
            Element overrideOnStartController = formControllerTag != null ? ViewProcessor.getChildElementByTagName(formControllerTag, "override-onStartController") : null;
            ViewProcessor.indent(sb, this.indent).append("@Override\n");
            ViewProcessor.indent(sb, this.indent).append("protected void onStartController() {\n");
            this.indent += 4;
            if (overrideOnStartController != null) {
                sb.append(ViewProcessor.reformat(overrideOnStartController.getTextContent(), this.indent));
            } else {
                ViewProcessor.indent(sb, this.indent).append("super.onStartController();\n");
                ViewProcessor.indent(sb, this.indent).append("setView(new ").append(this.className).append("(new ViewContext<").append(this.viewModelType).append(">(this, viewModel)));\n");
            }
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
            Element overrideOnStopController = formControllerTag != null ? ViewProcessor.getChildElementByTagName(formControllerTag, "override-onStopController") : null;
            ViewProcessor.indent(sb, this.indent).append("@Override\n");
            ViewProcessor.indent(sb, this.indent).append("protected void onStopController() {\n");
            this.indent += 4;
            if (overrideOnStopController != null) {
                sb.append(ViewProcessor.reformat(overrideOnStopController.getTextContent(), this.indent));
            } else {
                ViewProcessor.indent(sb, this.indent).append("super.onStopController();\n");
            }
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
            Element element2 = defineMethods = formControllerTag != null ? ViewProcessor.getChildElementByTagName(formControllerTag, "define-methods") : null;
            if (defineMethods != null) {
                sb.append(ViewProcessor.reformat(defineMethods.getTextContent(), this.indent));
            }
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
        }

        private void writeSchemaInterface(StringBuilder sb) throws XMLParseException {
            String value;
            String name;
            ViewProcessor.indent(sb, this.indent).append("package ").append(this.packageName).append(";\n");
            sb.append("import com.codename1.rad.annotations.*;\n");
            this.jenv.writeImports(sb);
            sb.append("import com.codename1.rad.schemas.*;\n");
            sb.append("@Autogenerated\n");
            sb.append("public interface ").append(this.className).append("Schema {\n");
            this.indent += 4;
            HashSet<String> usedNames = new HashSet<String>();
            for (Element defineTag : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-tag")) {
                name = defineTag.getAttribute("name");
                if (usedNames.contains(name)) continue;
                value = defineTag.getAttribute("value");
                if (value.isEmpty()) {
                    value = "new Tag(\"" + StringEscapeUtils.escapeJava((String)name) + "\")";
                }
                usedNames.add(name);
                ViewProcessor.indent(sb, this.indent).append("public static final Tag ").append(name).append(" = ").append(value).append(";\n");
            }
            for (Element defineTag : ViewProcessor.getDescendantElementsByTagName(this.rootEl, "define-slot")) {
                name = defineTag.getAttribute("id");
                if (usedNames.contains(name)) continue;
                usedNames.add(name);
                value = "";
                if (value.isEmpty()) {
                    value = "new Tag(\"" + StringEscapeUtils.escapeJava((String)name) + "\")";
                }
                ViewProcessor.indent(sb, this.indent).append("public static final Tag ").append(name).append(" = ").append(value).append(";\n");
            }
            for (Element defineCategory : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-category")) {
                name = defineCategory.getAttribute("name");
                value = defineCategory.getAttribute("value");
                if (value.isEmpty()) {
                    value = "new ActionNode.Category(\"" + StringEscapeUtils.escapeJava((String)name) + "\")";
                }
                ViewProcessor.indent(sb, this.indent).append("public static final ActionNode.Category ").append(name).append(" = ").append(value).append(";\n");
            }
            for (Element defineProperty : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-property")) {
                name = defineProperty.getAttribute("name");
                String type = defineProperty.getAttribute("type");
                String value2 = null;
                if (type.equalsIgnoreCase("text") || type.equalsIgnoreCase("string")) {
                    value2 = "ViewProperty.stringProperty()";
                    type = "String";
                } else if (type.equalsIgnoreCase("boolean")) {
                    value2 = "ViewProperty.booleanProperty()";
                    type = "Boolean";
                } else if (type.equalsIgnoreCase("double")) {
                    value2 = "ViewProperty.doubleProperty()";
                    type = "Double";
                } else if (type.equalsIgnoreCase("float")) {
                    value2 = "ViewProperty.floatProperty()";
                    type = "Float";
                } else if (type.equalsIgnoreCase("int")) {
                    value2 = "ViewProperty.intProperty()";
                    type = "Integer";
                } else {
                    value2 = "new ViewProperty(ContentType.createObjectType(" + type + ".class))";
                }
                if (type.isEmpty()) {
                    throw new XMLParseException("define-property tag requires type attribute", defineProperty, null);
                }
                ViewProcessor.indent(sb, this.indent).append("public static final ViewProperty<").append(type).append("> ").append(name).append(" = ").append(value2).append(";\n");
            }
            this.indent -= 4;
            sb.append("}\n");
        }

        private void writeModelInterface(StringBuilder sb) throws XMLParseException {
            String initialValue;
            ViewProcessor.indent(sb, this.indent).append("package ").append(this.packageName).append(";\n");
            sb.append("import com.codename1.rad.annotations.*;\n");
            this.jenv.writeImports(sb);
            Element viewModelTag = ViewProcessor.getChildElementByTagName(this.rootEl, "view-model");
            String ifaces = "Entity, " + this.className + "Schema";
            if (viewModelTag != null && viewModelTag.hasAttribute("implements")) {
                ifaces = ifaces + ", " + viewModelTag.getAttribute("implements");
            }
            sb.append("@RAD\n");
            sb.append("@Autogenerated\n");
            sb.append("public interface ").append(this.className).append("Model extends ").append(ifaces).append(" {\n");
            this.indent += 4;
            HashSet<String> usedPropertyNames = new HashSet<String>();
            if (viewModelTag != null) {
                for (Element defineProp : ViewProcessor.getChildElementsByTagName(viewModelTag, "define-property")) {
                    String name = defineProp.getAttribute("name");
                    String tags = defineProp.getAttribute("tags");
                    initialValue = defineProp.getAttribute("initialValue");
                    StringBuilder tagsStr = new StringBuilder();
                    String initialValueStr = initialValue.isEmpty() ? "" : ", initialValue=\"" + StringEscapeUtils.escapeJava((String)initialValue) + "\"";
                    StringTokenizer strtok = new StringTokenizer(tags, ",");
                    while (strtok.hasMoreTokens()) {
                        String tok = strtok.nextToken().trim();
                        if (tagsStr.length() > 0) {
                            tagsStr.append(", ");
                        }
                        tagsStr.append("\"").append(StringEscapeUtils.escapeJava((String)tok)).append("\"");
                    }
                    String type = defineProp.getAttribute("type");
                    if (type.isEmpty()) {
                        type = "String";
                    }
                    if (tagsStr.length() > 0) {
                        tagsStr.insert(0, "tag=");
                    }
                    if (name.isEmpty()) {
                        throw new XMLParseException("define-property tag requires attribute name", defineProp, null);
                    }
                    if (usedPropertyNames.contains(name)) continue;
                    usedPropertyNames.add(name);
                    String ucName = name.substring(0, 1).toUpperCase() + name.substring(1);
                    ViewProcessor.indent(sb, this.indent).append("@RAD(").append((CharSequence)tagsStr).append(initialValueStr).append(")\n");
                    String getterPrefix = "get";
                    if (type.equalsIgnoreCase("java.lang.Boolean") || type.equalsIgnoreCase("boolean")) {
                        getterPrefix = "is";
                    }
                    ViewProcessor.indent(sb, this.indent).append(type).append(" ").append(getterPrefix).append(ucName).append("();\n");
                    ViewProcessor.indent(sb, this.indent).append("@RAD\n");
                    ViewProcessor.indent(sb, this.indent).append("void set").append(ucName).append("(").append(type).append(" ").append(name).append(");\n");
                }
            }
            for (Element defineTag : ViewProcessor.getChildElementsByTagName(this.rootEl, "define-tag")) {
                String tag;
                String name = tag = defineTag.getAttribute("name");
                initialValue = defineTag.getAttribute("initialValue");
                String initialValueStr = initialValue.isEmpty() ? "" : ", initialValue=\"" + StringEscapeUtils.escapeJava((String)initialValue) + "\"";
                String type = defineTag.getAttribute("type");
                if (type.isEmpty()) {
                    type = "String";
                }
                if (name.isEmpty()) {
                    throw new XMLParseException("define-tag tag requires attribute name", defineTag, null);
                }
                if (usedPropertyNames.contains(name)) continue;
                usedPropertyNames.add(name);
                String ucName = name.substring(0, 1).toUpperCase() + name.substring(1);
                ViewProcessor.indent(sb, this.indent).append("@RAD(tag=\"").append(name).append("\"").append(initialValueStr).append(")\n");
                String getterPrefix = "get";
                if (type.equalsIgnoreCase("java.lang.Boolean") || type.equalsIgnoreCase("boolean")) {
                    getterPrefix = "is";
                }
                ViewProcessor.indent(sb, this.indent).append(type).append(" ").append(getterPrefix).append(ucName).append("();\n");
                ViewProcessor.indent(sb, this.indent).append("@RAD\n");
                ViewProcessor.indent(sb, this.indent).append("void set").append(ucName).append("(").append(type).append(" ").append(name).append(");\n");
            }
            this.indent -= 4;
            sb.append("}\n");
        }

        private void writeViewClass(StringBuilder sb) throws XMLParseException {
            ViewProcessor.indent(sb, this.indent).append("package ").append(this.packageName).append(";\n");
            sb.append("import com.codename1.rad.annotations.*;\n");
            sb.append("import com.codename1.rad.controllers.*;\n");
            this.jenv.writeImports(sb);
            sb.append("@Autogenerated\n");
            sb.append("public class ").append(this.className).append(" extends ").append(this.viewExtends).append("<").append(this.viewModelType).append(">");
            if (this.viewImplements != null) {
                sb.append(" implements ").append(this.viewImplements);
            }
            sb.append(" {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("private final ViewContext<").append(this.viewModelType).append("> context;\n");
            ViewProcessor.indent(sb, this.indent).append("private final FormController formController;\n");
            ViewProcessor.indent(sb, this.indent).append("private final ApplicationController applicationController;\n");
            ViewProcessor.indent(sb, this.indent).append("private final AppSectionController sectionController;\n");
            ViewProcessor.indent(sb, this.indent).append("private final ViewController viewController;\n");
            ViewProcessor.indent(sb, this.indent).append("private final FormController parentFormController;\n");
            ViewProcessor.indent(sb, this.indent).append("private java.util.List<Runnable> __initOnceListeners;\n");
            ViewProcessor.indent(sb, this.indent).append("private java.util.List<Runnable> __deinitListeners;\n");
            this.writeClassVariables(sb);
            this.writeScriptMethods(sb);
            ViewProcessor.indent(sb, this.indent).append("private static ViewContext<").append(this.viewModelType).append("> wrapContext(ViewContext<").append(this.viewModelType).append("> context) {\n");
            this.indent += 4;
            String vcClassName = this.jenv.rootElement.hasAttribute("view-controller") ? this.jenv.rootElement.getAttribute("view-controller") : "com.codename1.rad.controllers.ViewController";
            ViewProcessor.indent(sb, this.indent).append(vcClassName).append(" _viewController = new ").append(vcClassName).append("(context.getController());\n");
            ViewProcessor.indent(sb, this.indent).append("return _viewController.createViewContext(").append(this.viewModelType).append(".class, context.getEntity());\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n\n");
            ViewProcessor.indent(sb, this.indent).append("private Component registerViewController(Component cmp) {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("this.context.getController().setView(cmp);");
            ViewProcessor.indent(sb, this.indent).append("return this.context.getController().getView();\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n\n");
            ViewProcessor.indent(sb, this.indent).append("public ").append(this.className).append("(@Inject ViewContext<").append(this.viewModelType).append("> context) {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("super(wrapContext(context));\n");
            ViewProcessor.indent(sb, this.indent).append("this.context = getContext();\n");
            ViewProcessor.indent(sb, this.indent).append("this.formController = context.getController().getFormController();\n");
            ViewProcessor.indent(sb, this.indent).append("this.viewController = context.getController();\n");
            ViewProcessor.indent(sb, this.indent).append("this.applicationController = context.getController().getApplicationController();\n");
            ViewProcessor.indent(sb, this.indent).append("this.sectionController = context.getController().getSectionController();\n");
            ViewProcessor.indent(sb, this.indent).append("this.parentFormController = (this.formController == null || this.formController.getParent() == null) ? null : this.formController.getParent().getFormController();\n");
            ViewProcessor.indent(sb, this.indent).append("getAllStyles().stripMarginAndPadding();\n");
            ViewProcessor.indent(sb, this.indent).append("setLayout(new BorderLayout());\n");
            ViewProcessor.indent(sb, this.indent).append("_currentContainer = this;\n");
            ViewProcessor.indent(sb, this.indent).append("add(BorderLayout.CENTER, ").append("registerViewController(createComponent0()));\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
            for (JavaComponentBuilder component : this.componentBuilders) {
                component.indent = this.indent;
                component.writeBuilderMethod(sb);
            }
            for (JavaNodeBuilder nodeBuilder : this.nodeBuilders) {
                nodeBuilder.indent = this.indent;
                nodeBuilder.writeBuilderMethod(sb);
            }
            for (JavaBeanBuilder beanBuilder : this.beanBuilders) {
                beanBuilder.indent = this.indent;
                beanBuilder.writeBuilderMethod(sb);
            }
            sb.append("    @Override\n");
            sb.append("    public void commit() {}\n");
            sb.append("    @Override\n");
            sb.append("    public void update() {}\n");
            sb.append("    @Override\n");
            sb.append("    public void activate() {\n");
            sb.append("        super.activate();\n");
            sb.append("    }\n");
            sb.append("    private <T extends Node> T _setParent(Class<T> cls, T node) {\n");
            sb.append("        node.setParent(getViewNode());\n");
            sb.append("        return node;\n");
            sb.append("    }\n");
            sb.append("    private <T> T _getInjectedParameter(Class<T> type, ViewContext context, Controller controller) {\n");
            sb.append("        T lookedUp = (T)controller.lookup(type);\n");
            sb.append("        if (lookedUp != null) return lookedUp;\n");
            sb.append("        if (type == ViewContext.class) return (T)context;\n");
            sb.append("        if (Entity.class.isAssignableFrom(type)) return (T)context.getEntity();\n");
            sb.append("        if (type.isAssignableFrom(this.getClass())) return (T)this;\n");
            sb.append("        if (type.isAssignableFrom(controller.getClass())) return (T)controller;\n");
            sb.append("        if (type.isAssignableFrom(FormController.class)) return (T)formController;\n");
            sb.append("        if (type.isAssignableFrom(ApplicationController.class)) return (T)applicationController;\n");
            sb.append("        if (type.isAssignableFrom(ViewController.class)) return (T)viewController;\n");
            sb.append("        return null;\n");
            sb.append("    }\n");
            sb.append("    @Override\n");
            sb.append("    protected void initComponent() {\n");
            sb.append("        super.initComponent();\n");
            sb.append("        if (__initOnceListeners != null && !__initOnceListeners.isEmpty()) {\n");
            sb.append("            java.util.List<Runnable> toRun = new java.util.ArrayList<Runnable>(__initOnceListeners);\n");
            sb.append("            __initOnceListeners = null;\n");
            sb.append("            for (Runnable r : toRun) r.run();\n");
            sb.append("        }\n");
            sb.append("    }\n");
            sb.append("    @Override\n");
            sb.append("    protected void deinitialize() {\n");
            sb.append("        if (__deinitListeners != null && !__deinitListeners.isEmpty()) {\n");
            sb.append("            java.util.List<Runnable> toRun = new java.util.ArrayList<Runnable>(__deinitListeners);\n");
            sb.append("            for (Runnable r : toRun) r.run();\n");
            sb.append("        }\n");
            sb.append("        super.deinitialize();\n");
            sb.append("    }\n");
            sb.append("    private void addInitOnceListener(Runnable r) {\n");
            sb.append("        if (__initOnceListeners == null) __initOnceListeners = new java.util.ArrayList<>();\n");
            sb.append("        __initOnceListeners.add(r);\n");
            sb.append("    }\n");
            sb.append("    private void addDeinitListener(Runnable r) {\n");
            sb.append("        if (__deinitListeners == null) __deinitListeners = new java.util.ArrayList<>();\n");
            sb.append("        __deinitListeners.add(r);\n");
            sb.append("    }\n");
            sb.append("    private void back() {\n");
            sb.append("        com.codename1.rad.controllers.ActionSupport.dispatchEvent(new com.codename1.rad.controllers.FormController.FormBackEvent(this));\n");
            sb.append("    }\n");
            sb.append("}\n");
            this.indent -= 4;
        }

        private String getQualifiedName() {
            String out = this.parentClass.getQualifiedName().toString();
            out = out.contains(".") ? out.substring(0, out.lastIndexOf(".") + 1) : "";
            return out + this.className;
        }

        private String toCamelCase(String str) {
            int lowerCaseIndex = -1;
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (!Character.isLowerCase(str.charAt(i))) continue;
                lowerCaseIndex = i;
                break;
            }
            if (lowerCaseIndex < 0) {
                return str.toLowerCase();
            }
            if (lowerCaseIndex == 0) {
                return str;
            }
            return str.substring(0, lowerCaseIndex).toLowerCase() + str.substring(lowerCaseIndex);
        }

        public void createViewSourceFile() throws XMLParseException, IOException {
            this.parse();
            String qualifiedName = this.getQualifiedName();
            StringBuilder sb = new StringBuilder();
            this.writeViewClass(sb);
            JavaFileObject sourceFile = this.createSourceFile(qualifiedName, new javax.lang.model.element.Element[]{this.parentClass});
            try (Writer w = sourceFile.openWriter();){
                String content = sb.toString();
                w.write(content);
            }
        }

        private File findPom(File startingPoint) {
            if (startingPoint == null) {
                return null;
            }
            if (startingPoint.isDirectory()) {
                File pom = new File(startingPoint, "pom.xml");
                if (pom.exists()) {
                    return pom;
                }
                return this.findPom(startingPoint.getParentFile());
            }
            return this.findPom(startingPoint.getParentFile());
        }

        public void createXMLSchemaSourceFile() throws XMLParseException, IOException {
            class ComponentBuilderPair {
                TypeElement componentClass;
                TypeElement builderClass;
                List<String> tagNames = new ArrayList<String>();

                ComponentBuilderPair() {
                }
            }
            XMLSchemaGenerator xmlSchemaGenerator;
            this.parse();
            File rootDirectory = this.findPom(new File(System.getProperty("user.dir"))).getParentFile();
            File cn1Settings = new File(rootDirectory, "codenameone_settings.properties");
            if (!cn1Settings.exists()) {
                cn1Settings = new File(rootDirectory.getParentFile(), cn1Settings.getName());
            }
            if (!cn1Settings.exists()) {
                cn1Settings = new File(rootDirectory, "common" + File.separator + cn1Settings.getName());
            }
            if (!cn1Settings.exists()) {
                cn1Settings = new File(rootDirectory.getParentFile(), "common" + File.separator + cn1Settings.getName());
            }
            if (!cn1Settings.exists()) {
                throw new IOException("Cannot find Codename One project directory in which to generate XML schemas.");
            }
            rootDirectory = cn1Settings.getParentFile();
            File targetDirectory = new File(rootDirectory, "target");
            if (!targetDirectory.exists()) {
                throw new IOException("Cannot find target directory.");
            }
            File generatedSources = new File(targetDirectory, "generated-sources");
            File xmlSchemasDirectory = new File(generatedSources, "rad" + File.separator + "xmlSchemas");
            XMLSchemaGenerator viewSchemaGenerator = new XMLSchemaGenerator(ViewProcessor.this.env(), this.jenv, xmlSchemasDirectory, ViewProcessor.this.elements().getTypeElement(this.packageName + "." + this.className), null);
            File schemaFile = viewSchemaGenerator.getSchemaFile();
            String checksum = null;
            StringBuilder imports = new StringBuilder();
            for (String importStr : this.jenv.imports) {
                imports.append(importStr).append("\n");
            }
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(imports.toString().getBytes("utf-8"));
                byte[] digest = md.digest();
                checksum = Base64.getEncoder().encodeToString(digest);
            }
            catch (Exception ex) {
                throw new IOException("Failed to create checksum for imports on " + schemaFile);
            }
            if (schemaFile.exists()) {
                String fileContents;
                try (FileInputStream fis = new FileInputStream(schemaFile);){
                    byte[] buf = new byte[(int)schemaFile.length()];
                    fis.read(buf);
                    fileContents = new String(buf, "utf-8");
                }
                if (!fileContents.contains(checksum)) {
                    schemaFile.delete();
                }
            }
            if (schemaFile.exists()) {
                return;
            }
            viewSchemaGenerator.setChecksum(checksum);
            ArrayList<? extends javax.lang.model.element.Element> elementList = new ArrayList<javax.lang.model.element.Element>();
            HashMap tagMap = new HashMap();
            HashMap nameMap = new HashMap();
            for (Object importStatement : this.jenv.imports) {
                if (((String)importStatement).startsWith("import static")) continue;
                String string = ((String)importStatement).substring(((String)importStatement).indexOf(" ") + 1);
                if (((String)importStatement).endsWith("*")) {
                    String packageName = string.substring(0, string.lastIndexOf("."));
                    PackageElement packageElement = ViewProcessor.this.elements().getPackageElement(packageName);
                    if (packageName == null) continue;
                    elementList.addAll(packageElement.getEnclosedElements());
                    continue;
                }
                TypeElement typeEl = ViewProcessor.this.elements().getTypeElement(string);
                if (typeEl == null) continue;
                elementList.add(typeEl);
            }
            elementList.forEach(element -> {
                if (element.getKind() != ElementKind.CLASS) return;
                TypeElement typeEl = (TypeElement)element;
                String tagName = typeEl.getSimpleName().toString().toLowerCase();
                if (ViewProcessor.this.isComponent(typeEl)) {
                    ComponentBuilderPair pair = (ComponentBuilderPair)tagMap.get(tagName);
                    if (pair == null) {
                        pair = (ComponentBuilderPair)nameMap.get(typeEl.getQualifiedName().toString());
                    }
                    if (pair == null) {
                        pair = new ComponentBuilderPair();
                        pair.componentClass = typeEl;
                        pair.tagNames.add(this.toCamelCase(typeEl.getSimpleName().toString()));
                        tagMap.put(tagName, pair);
                        nameMap.put(typeEl.getQualifiedName().toString(), pair);
                        return;
                    }
                    if (pair.componentClass == null) {
                        pair.componentClass = typeEl;
                        nameMap.put(typeEl.getQualifiedName().toString(), pair);
                        return;
                    }
                    if (pair.componentClass.getQualifiedName().contentEquals(typeEl.getQualifiedName())) return;
                    return;
                } else {
                    if (!ViewProcessor.this.isA(typeEl, "com.codename1.rad.ui.ComponentBuilder")) return;
                    RAD radAnnotation = typeEl.getAnnotation(RAD.class);
                    if (radAnnotation == null) {
                        return;
                    }
                    ComponentBuilderPair pair = (ComponentBuilderPair)nameMap.get(typeEl.getQualifiedName().toString());
                    ExecutableElement getComponentMethod = ViewProcessor.this.elements().getAllMembers(typeEl).stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getSimpleName().contentEquals("getComponent")).findFirst().orElse(null);
                    ExecutableType getComponentMethodType = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)typeEl.asType(), getComponentMethod);
                    TypeElement componentElement = ViewProcessor.this.elements().getTypeElement(getComponentMethodType.getReturnType().toString());
                    if (componentElement == null) {
                        ViewProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not find type element for " + getComponentMethodType.getReturnType() + " while trying to determine the component type of a ComponentBuilder " + typeEl.getQualifiedName(), (javax.lang.model.element.Element)element);
                        throw new IllegalStateException("Could not find type element for " + getComponentMethodType.getReturnType() + " while trying to determine the component type of a ComponentBuilder " + typeEl.getQualifiedName());
                    }
                    if (pair == null) {
                        pair = (ComponentBuilderPair)nameMap.get(componentElement.getQualifiedName().toString());
                    }
                    if (pair == null) {
                        pair = new ComponentBuilderPair();
                        pair.componentClass = componentElement;
                        pair.tagNames.add(this.toCamelCase(componentElement.getSimpleName().toString()));
                        nameMap.put(componentElement.getQualifiedName().toString(), pair);
                        tagMap.put(componentElement.getSimpleName().toString(), pair);
                    }
                    if (pair.builderClass != null) return;
                    pair.builderClass = typeEl;
                    for (String tag : radAnnotation.tag()) {
                        if (pair.tagNames.contains(tag)) continue;
                        pair.tagNames.add(tag);
                    }
                    ArrayList<String> tagsToRemove = new ArrayList<String>();
                    for (String tag : pair.tagNames) {
                        if (tagMap.containsKey(tag.toLowerCase()) && !((ComponentBuilderPair)tagMap.get(tag.toLowerCase())).equals(pair)) {
                            tagsToRemove.add(this.toCamelCase(tag));
                            continue;
                        }
                        tagMap.put(tag.toLowerCase(), pair);
                    }
                    if (!tagsToRemove.isEmpty()) {
                        pair.tagNames.removeAll(tagsToRemove);
                    }
                    if (!nameMap.containsKey(typeEl.getQualifiedName().toString())) {
                        nameMap.put(typeEl.getQualifiedName().toString(), pair);
                    }
                    if (nameMap.containsKey(componentElement.getQualifiedName().toString())) return;
                    nameMap.put(componentElement.getQualifiedName().toString(), pair);
                }
            });
            HashMap<String, TypeElement> tags = new HashMap<String, TypeElement>();
            for (Map.Entry entry : tagMap.entrySet()) {
                for (String string : ((ComponentBuilderPair)entry.getValue()).tagNames) {
                    if (tags.containsKey(string)) continue;
                    tags.put(string, ((ComponentBuilderPair)entry.getValue()).componentClass);
                }
            }
            viewSchemaGenerator.setAllTags(tags);
            viewSchemaGenerator.setWriteElements(true);
            HashSet<TypeElement> dependentClasses = new HashSet<TypeElement>();
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
            for (Map.Entry entry : tagMap.entrySet()) {
                if (hashSet.contains(((ComponentBuilderPair)entry.getValue()).componentClass)) continue;
                dependentClasses.addAll(this.getParentsOf(((ComponentBuilderPair)entry.getValue()).componentClass));
                hashSet.add(((ComponentBuilderPair)entry.getValue()).componentClass);
                xmlSchemaGenerator = new XMLSchemaGenerator(ViewProcessor.this.env(), this.jenv, xmlSchemasDirectory, ((ComponentBuilderPair)entry.getValue()).componentClass, ((ComponentBuilderPair)entry.getValue()).builderClass);
                xmlSchemaGenerator.writeToFile();
                viewSchemaGenerator.addInclude(xmlSchemaGenerator.getSchemaFile());
            }
            dependentClasses.removeAll(hashSet);
            for (TypeElement typeElement : dependentClasses) {
                xmlSchemaGenerator = new XMLSchemaGenerator(ViewProcessor.this.env(), this.jenv, xmlSchemasDirectory, typeElement, null);
                xmlSchemaGenerator.setPartialSchema(true);
                xmlSchemaGenerator.writeToFile();
                viewSchemaGenerator.addInclude(xmlSchemaGenerator.getSchemaFile());
            }
            viewSchemaGenerator.getSchemaFile().delete();
            viewSchemaGenerator.writeToFile();
        }

        private Set<TypeElement> getParentsOf(TypeElement typeEl) {
            TypeMirror parentType;
            HashSet<TypeElement> out = new HashSet<TypeElement>();
            while (typeEl != null && (parentType = typeEl.getSuperclass()) != null && parentType.getKind() == TypeKind.DECLARED && (typeEl = (TypeElement)((DeclaredType)parentType).asElement()) != null && !out.contains(typeEl)) {
                out.add(typeEl);
            }
            return out;
        }

        public void createModelSourceFile() throws XMLParseException, IOException {
            this.parse();
            if (this.rootEl.hasAttribute("rad-model")) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            String modelQualifiedName = this.getQualifiedName() + "Model";
            this.writeModelInterface(sb);
            JavaFileObject sourceFile = this.createSourceFile(modelQualifiedName, new javax.lang.model.element.Element[]{this.parentClass});
            try (Writer w = sourceFile.openWriter();){
                String content = sb.toString();
                w.write(content);
            }
        }

        public void createSchemaSourceFile() throws XMLParseException, IOException {
            this.parse();
            StringBuilder sb = new StringBuilder();
            String schemaQualifiedName = this.getQualifiedName() + "Schema";
            this.writeSchemaInterface(sb);
            JavaFileObject sourceFile = this.createSourceFile(schemaQualifiedName, new javax.lang.model.element.Element[]{this.parentClass});
            try (Writer w = sourceFile.openWriter();){
                String content = sb.toString();
                w.write(content);
            }
        }

        JavaFileObject createSourceFile(String qualifiedName, javax.lang.model.element.Element[] dependentElements) throws IOException {
            return ViewProcessor.this.env().getFiler().createSourceFile(qualifiedName, dependentElements);
        }

        public void createControllerSourceFile() throws XMLParseException, IOException {
            this.parse();
            StringBuilder sb = new StringBuilder();
            String controllerQualifiedName = this.getQualifiedName() + "Controller";
            this.writeFormController(sb);
            JavaFileObject sourceFile = this.createSourceFile(controllerQualifiedName, new javax.lang.model.element.Element[]{this.parentClass});
            try (Writer w = sourceFile.openWriter();){
                String content = sb.toString();
                w.write(content);
            }
        }

        public void createControllerMarkerInterfaceSourceFile() throws XMLParseException, IOException {
            this.parse();
            StringBuilder sb = new StringBuilder();
            String controllerQualifiedName = this.getQualifiedName().substring(0, this.getQualifiedName().lastIndexOf(".")) + ".I" + this.className + "Controller";
            this.writeFormControllerMarkerInterface(sb);
            JavaFileObject sourceFile = this.createSourceFile(controllerQualifiedName, new javax.lang.model.element.Element[]{this.parentClass});
            try (Writer w = sourceFile.openWriter();){
                String content = sb.toString();
                w.write(content);
            }
        }

        public boolean containsBeanBuilderFor(Name qualifiedName) {
            for (JavaBeanBuilder builder : this.beanBuilders) {
                if (!builder.beanClass.typeEl.getQualifiedName().contentEquals(qualifiedName)) continue;
                return true;
            }
            return false;
        }
    }

    private class XMLParseException
    extends Exception {
        private Element element;
        private String attributeName;
        private String attributeValue;

        XMLParseException(String message, Element element, Throwable cause) {
            super(message, cause);
            this.element = element;
        }
    }

    private class JavaComponentBuilder
    extends JavaBuilder {
        private JavaMethodProxy builderMethod;
        private JavaClassProxy builderClass;
        private JavaClassProxy componentClass;
        private List<JavaComponentBuilder> children;
        private boolean hasViewController;

        JavaComponentBuilder(Element xmlTag, JavaEnvironment jenv, JavaClassProxy builderClass, JavaClassProxy componentClass) throws ClassNotFoundException {
            this.children = new ArrayList<JavaComponentBuilder>();
            this.xmlTag = xmlTag;
            this.jenv = jenv;
            this.builderMethod = null;
            this.builderClass = builderClass;
            if (this.builderMethod != null) {
                this.componentClass = jenv.newJavaClassProxy(this.builderMethod.getReturnType());
            } else {
                TypeElement typeEl;
                JavaClassProxy javaClassProxy = this.componentClass = componentClass == null ? jenv.newJavaClassProxy(builderClass.findMethodProxy("getComponent", 0).getReturnType()) : componentClass;
                if (componentClass == null && ViewProcessor.this.isA(this.componentClass.typeEl, "com.codename1.rad.ui.entityviews.EntityListView") && (typeEl = jenv.findClassBySimpleName(xmlTag.getTagName())) != null && ViewProcessor.this.isA(typeEl, "com.codename1.rad.ui.entityviews.EntityListView")) {
                    this.componentClass = jenv.newJavaClassProxy(typeEl);
                }
            }
        }

        void writeBuilderProperties(StringBuilder sb) throws XMLParseException {
            List rowTemplates;
            ExecutableElement setText;
            if (this.builderClass == null) {
                return;
            }
            HashSet<String> propertiesInjected = new HashSet<String>();
            for (ExecutableElement setter : this.builderClass.findInjectableSetters()) {
                String setterName = setter.getSimpleName().toString();
                if (ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, setterName)) continue;
                String propName = setterName;
                if ((!setterName.startsWith("set") ? ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, "set" + propName) : ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, propName = setterName.substring(3))) || propertiesInjected.contains(propName.toLowerCase())) continue;
                propertiesInjected.add(propName.toLowerCase());
                ExecutableType et = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.builderClass.typeEl.asType(), setter);
                TypeMirror propertyType = et.getParameterTypes().get(0);
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append(propertyType).append(" _injectedValue = ");
                this.jenv.writeInjectedValue(sb, (TypeElement)((DeclaredType)propertyType).asElement(), this.xmlTag, propName, true);
                sb.append(";\n");
                ViewProcessor.indent(sb, this.indent).append("if (_injectedValue != null) ").append("_builder.").append(setter.getSimpleName()).append("((").append(propertyType.toString()).append(")_injectedValue);\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
            JavaMethodProxy addChild = this.builderClass.findMethodProxy("addChild", 1);
            String textContent = ViewProcessor.getTextContent(this.xmlTag);
            if (textContent != null && !textContent.trim().isEmpty() && (setText = this.builderClass.findSetter("text", "java.lang.String")) != null) {
                ViewProcessor.indent(sb, this.indent);
                this.builderClass.setProperty(sb, "text", textContent.trim(), "_builder");
                sb.append("\n");
            }
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (name.contains("-") || name.startsWith("_") && name.endsWith("_") || propertiesInjected.contains(name.toLowerCase())) continue;
                propertiesInjected.add(name.toLowerCase());
                ViewProcessor.indent(sb, this.indent);
                sb.append("// ").append(name).append("=").append(value).append("\n");
                ViewProcessor.indent(sb, this.indent);
                ExecutableElement setter = this.builderClass.findSetter(name, new String[0]);
                if (setter != null) {
                    this.builderClass.setProperty(sb, attr, "_builder");
                }
                sb.append("\n");
            }
            if (ViewProcessor.this.isA(this.componentClass.typeEl, "com.codename1.rad.ui.entityviews.EntityListView") && !(rowTemplates = ViewProcessor.getChildElementsByTagName(this.xmlTag, "row-template")).isEmpty()) {
                ViewProcessor.indent(sb, this.indent).append("// ").append(rowTemplates.size()).append(" row templates defined for list view\n");
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("class Renderer").append(this.xmlTag.getAttribute("rad-id")).append(" implements com.codename1.rad.ui.EntityListCellRenderer {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("public EntityView getListCellRendererComponent(EntityListView list, Entity value, int index, boolean isSelected, boolean isFocused) {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("Entity _old_rowModel = ").append(this.jenv.rootBuilder.className).append(".this.rowModel;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowModel = value;\n");
                ViewProcessor.indent(sb, this.indent).append("int _old_rowIndex = ").append(this.jenv.rootBuilder.className).append(".this.rowIndex;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowIndex = index;\n");
                ViewProcessor.indent(sb, this.indent).append("boolean _old_rowSelected = ").append(this.jenv.rootBuilder.className).append(".this.rowSelected;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowSelected = isSelected;\n");
                ViewProcessor.indent(sb, this.indent).append("boolean _old_rowFocused = ").append(this.jenv.rootBuilder.className).append(".this.rowFocused;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowFocused = isFocused;\n");
                ViewProcessor.indent(sb, this.indent).append("EntityListView _old_rowList = ").append(this.jenv.rootBuilder.className).append(".this.rowList;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowList = list;\n");
                ViewProcessor.indent(sb, this.indent).append("com.codename1.rad.nodes.ViewNode _viewNode = new com.codename1.rad.nodes.ViewNode();\n");
                ViewProcessor.indent(sb, this.indent).append("_viewNode.setParent(context.getNode());\n");
                ViewProcessor.indent(sb, this.indent).append("ViewContext _old_subContext = ").append(this.jenv.rootBuilder.className).append(".this.subContext;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.subContext = new ViewContext(viewController, rowModel, _viewNode);\n");
                ViewProcessor.indent(sb, this.indent).append("EntityView _old_rowView = ").append(this.jenv.rootBuilder.className).append(".this.rowView;\n");
                ViewProcessor.indent(sb, this.indent).append("try {\n");
                this.indent += 4;
                for (Element rowTemplate : rowTemplates) {
                    String condition = rowTemplate.getAttribute("case");
                    if (condition.isEmpty()) {
                        condition = "true";
                    }
                    ViewProcessor.indent(sb, this.indent).append("if (").append(condition).append(") {\n");
                    this.indent += 4;
                    for (Element rowView : ViewProcessor.getChildElements(rowTemplate)) {
                        if (rowView.getTagName().contains("-")) continue;
                        TypeElement rowViewTypeEl = this.jenv.findClassThatTagCreates(rowView.getTagName(), "com.codename1.rad.ui.EntityView");
                        if (rowViewTypeEl == null) {
                            TypeElement rowComponentTypeEl = this.jenv.findClassThatTagCreates(rowView.getTagName(), "com.codename1.ui.Component");
                            if (rowComponentTypeEl == null) continue;
                            ViewProcessor.indent(sb, this.indent).append("Container cnt = new Container(new BorderLayout());\n");
                            ViewProcessor.indent(sb, this.indent).append("cnt.getStyle().stripMarginAndPadding();\n");
                            ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.rowView = new com.codename1.rad.ui.entityviews.WrapperEntityView(cnt, ").append(this.jenv.rootBuilder.className).append(".this.").append("rowModel, _viewNode);\n");
                            ViewProcessor.indent(sb, this.indent).append("cnt.add(BorderLayout.CENTER, createComponent").append(rowView.getAttribute("rad-id")).append("());\n");
                            ViewProcessor.indent(sb, this.indent).append("return ").append(this.jenv.rootBuilder.className).append(".this.rowView;\n");
                            break;
                        }
                        if (!rowView.hasAttribute("view-model")) {
                            rowView.setAttribute("view-model", "rowModel");
                        }
                        ViewProcessor.indent(sb, this.indent).append("return (EntityView) createComponent").append(rowView.getAttribute("rad-id")).append("();\n");
                        break;
                    }
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                }
                ViewProcessor.indent(sb, this.indent).append("throw new RuntimeException(\"No row view matches the provided condition.\");\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("} finally {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowModel = _old_rowModel;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowIndex = _old_rowIndex;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowSelected = _old_rowSelected;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowFocused = _old_rowFocused;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowList = _old_rowList;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("subContext = _old_subContext;\n");
                ViewProcessor.indent(sb, this.indent).append(this.jenv.rootBuilder.className).append(".this.").append("rowView = _old_rowView;\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                ViewProcessor.indent(sb, this.indent).append("_builder.renderer(new Renderer").append(this.xmlTag.getAttribute("rad-id")).append("());\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
            for (Element childEl : ViewProcessor.getChildElements(this.xmlTag)) {
                String propertyName = childEl.getAttribute("rad-property");
                String childId = childEl.getAttribute("rad-id");
                TypeElement type = this.jenv.findClassThatTagCreates(childEl.getTagName());
                String createCall = "createBean";
                if (ViewProcessor.this.isComponent(type)) {
                    createCall = "createComponent";
                } else if (ViewProcessor.this.isNode(type)) {
                    createCall = "createNode";
                }
                createCall = createCall + childId + "()";
                if (childEl.getTagName().contains("-")) continue;
                if (propertyName != null && !propertyName.isEmpty()) {
                    if (propertiesInjected.contains(propertyName.toLowerCase())) continue;
                    ExecutableElement setter = this.builderClass.findSetter(propertyName, new String[0]);
                    ExecutableType setterType = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.builderClass.typeEl.asType(), setter);
                    TypeMirror propertyType = setterType.getParameterTypes().get(0);
                    if (propertyName.contains(".") || setter == null) continue;
                    propertiesInjected.add(propertyName.toLowerCase());
                    ViewProcessor.indent(sb, this.indent).append("// Set property ").append(propertyName).append(" with child tag ").append(childEl.getTagName()).append("\n");
                    ViewProcessor.indent(sb, this.indent);
                    this.builderClass.setProperty(sb, propertyName, "java:" + createCall, "_builder", propertyType.toString());
                    sb.append("\n");
                    continue;
                }
                if (addChild == null || !ViewProcessor.this.isComponent(type)) continue;
                ViewProcessor.indent(sb, this.indent).append("_builder.addChild(").append(createCall).append(");\n");
                childEl.setAttribute("rad-used-for", "builder-addChild");
            }
        }

        private boolean isMarginOrPadding(String pname) {
            if (!pname.contains(".")) {
                return false;
            }
            String leaf = pname.substring(pname.lastIndexOf(".") + 1);
            return leaf.startsWith("padding") || leaf.startsWith("margin");
        }

        private String getMarginOrPaddingUnitPropertyName(String pname) {
            String base = this.getMarginOrPaddingUnitPropertyBase(pname);
            String leaf = pname.substring(base.length() + 1);
            if (leaf.startsWith("padding")) {
                return base + ".paddingUnit" + leaf.substring("padding".length());
            }
            if (leaf.startsWith("margin")) {
                return base + ".marginUnit" + leaf.substring("margin".length());
            }
            throw new IllegalArgumentException("getUnitPropertyName expects padding or margin unit");
        }

        private String getMarginOrPaddingUnitPropertyBase(String pname) {
            if (!pname.contains(".")) {
                throw new IllegalArgumentException("getUnitPropertyName expects at least one .");
            }
            String base = pname.substring(0, pname.lastIndexOf("."));
            if (base.startsWith("bind-")) {
                base = base.substring(base.indexOf("-") + 1);
            }
            return base;
        }

        void writeProperties(StringBuilder sb) {
            ExecutableElement setText;
            String textContent = ViewProcessor.getTextContent(this.xmlTag);
            if (textContent != null && !textContent.isEmpty() && (setText = this.componentClass.findSetter("text", "java.lang.String")) != null) {
                ViewProcessor.indent(sb, this.indent);
                this.componentClass.setProperty(sb, "text", textContent.trim(), "_cmp");
            }
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int len = attributes.getLength();
            HashMap<String, String> addedAtts = new HashMap<String, String>();
            for (int i = 0; i < len; ++i) {
                String val;
                String bindProp;
                Attr attr = (Attr)attributes.item(i);
                String attName = attr.getName();
                if (attName.startsWith("bind-") && !attName.substring(attName.indexOf("-") + 1).contains("-") && !this.xmlTag.hasAttribute(bindProp = attName.substring(attName.indexOf("-") + 1)) && ((val = this.xmlTag.getAttribute(attName)).startsWith("java:") || val.contains("$") || val.contains("{") || val.contains("("))) {
                    addedAtts.put(bindProp, val);
                }
                if (!this.isMarginOrPadding(attName)) continue;
                addedAtts.put(this.getMarginOrPaddingUnitPropertyName(attName), "com.codename1.ui.plaf.Style.UNIT_TYPE_PIXELS");
            }
            for (String key : addedAtts.keySet()) {
                this.xmlTag.setAttribute(key, (String)addedAtts.get(key));
            }
            attributes = this.xmlTag.getAttributes();
            len = attributes.getLength();
            ArrayList<Attr> attributesList = new ArrayList<Attr>();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                attributesList.add(attr);
            }
            Collections.sort(attributesList, new AttributeComparator());
            for (Attr attr : attributesList) {
                String name = attr.getName();
                String value = attr.getValue();
                if (name.contains("-") || name.startsWith("_") && name.endsWith("_") || this.builderClass != null && !name.contains(".") && this.builderClass.findSetter(name, new String[0]) != null) continue;
                ViewProcessor.indent(sb, this.indent);
                sb.append("// ").append(name).append("=").append(value).append("\n");
                ViewProcessor.indent(sb, this.indent);
                ExecutableElement setter = this.componentClass.findSetter(name, new String[0]);
                if (name.contains(".") || setter != null) {
                    boolean deferToOnInit;
                    boolean bl = deferToOnInit = name.toLowerCase().startsWith("parent.") || name.toLowerCase().startsWith("componentform");
                    if (deferToOnInit) {
                        sb.append("{\n");
                        this.indent += 4;
                        sb.append("final ").append(this.jenv.findClassThatTagCreates(this.xmlTag.getTagName()).getQualifiedName()).append(" __fcmp = _cmp;\n");
                        sb.append("addInitOnceListener(()->");
                        this.componentClass.setProperty(sb, attr, "__fcmp");
                        sb.append(");\n");
                        this.indent -= 4;
                        sb.append("}\n");
                    } else {
                        this.componentClass.setProperty(sb, attr, "_cmp");
                    }
                }
                sb.append("\n");
            }
            for (Element childEl : ViewProcessor.getChildElements(this.xmlTag)) {
                if (childEl.getTagName().contains("-")) continue;
                String propertyName = childEl.getAttribute("rad-property");
                String childId = childEl.getAttribute("rad-id");
                TypeElement type = this.jenv.findClassThatTagCreates(childEl.getTagName());
                String createCall = "createBean";
                if (ViewProcessor.this.isComponent(type)) {
                    createCall = "createComponent";
                } else if (ViewProcessor.this.isNode(type)) {
                    createCall = "createNode";
                }
                createCall = createCall + childId + "()";
                if (propertyName != null && !propertyName.isEmpty()) {
                    if (!propertyName.contains(".") && this.builderClass.findSetter(propertyName, new String[0]) != null) continue;
                    ViewProcessor.indent(sb, this.indent).append("// Set property ").append(propertyName).append(" with child tag ").append(childEl.getTagName()).append("\n");
                    ViewProcessor.indent(sb, this.indent);
                    this.componentClass.setProperty(sb, propertyName, "java:" + createCall, "_cmp");
                    sb.append("\n");
                    continue;
                }
                boolean first = true;
                for (ExecutableElement injectableSetter : this.componentClass.findInjectableSettersForType(type)) {
                    if (createCall.startsWith("createBean") && !this.jenv.rootBuilder.containsBeanBuilderFor(type.getQualifiedName())) continue;
                    ViewProcessor.indent(sb, this.indent).append("// Injectable property ").append(injectableSetter.getSimpleName()).append(" being set with tag ").append(childEl.getTagName()).append("\n");
                    ViewProcessor.indent(sb, this.indent);
                    if (first) {
                        first = false;
                        sb.append("{\n");
                        this.indent += 4;
                        ViewProcessor.indent(sb, this.indent).append(type.getQualifiedName()).append(" _tmpProperty = ").append(createCall).append(";\n");
                    }
                    childEl.setAttribute("rad-property", injectableSetter.getSimpleName().toString());
                    this.componentClass.setProperty(sb, injectableSetter.getSimpleName().toString(), "java:_tmpProperty", "_cmp");
                }
                if (first) continue;
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
        }

        void writeHrefLink(StringBuilder sb) throws XMLParseException {
            String href = this.xmlTag.getAttribute("rad-href");
            if (href.isEmpty()) {
                return;
            }
            Element bindAction = ViewProcessor.getChildElementsByTagName(this.xmlTag, "bind-action").stream().findFirst().orElse(null);
            boolean isJavaExpression = href.startsWith("java:");
            String javaExpression = isJavaExpression ? href.substring(href.indexOf(":") + 1) : null;
            StringBuilder bindScript = new StringBuilder();
            if (bindAction != null) {
                bindScript.append(ViewProcessor.getTextContent(bindAction));
            }
            if (isJavaExpression) {
                ViewProcessor.indent(bindScript, this.indent).append(javaExpression);
                if (!javaExpression.endsWith(";")) {
                    bindScript.append(";");
                }
                bindScript.append("\n");
            } else {
                String explicitParams = null;
                if (href.contains("(") && href.endsWith(")")) {
                    explicitParams = href.substring(href.indexOf("("), href.length() - 1);
                    href = href.substring(0, href.indexOf("("));
                }
                String entitySelector = null;
                if (href.contains("{") && href.contains("}") && href.indexOf("}") > href.indexOf("{")) {
                    entitySelector = href.substring(href.indexOf("{") + 1, href.lastIndexOf("}"));
                    if (entitySelector.isEmpty()) {
                        entitySelector = this.xmlTag.hasAttribute("rad-href-trigger") ? "event.getEntity()" : "context.getEntity()";
                    }
                    href = href.substring(0, href.indexOf("{")) + href.substring(href.lastIndexOf("}") + 1);
                }
                String rel = "child";
                if (href.contains(" ")) {
                    rel = href.substring(href.indexOf(" ") + 1);
                    href = href.substring(0, href.indexOf(" "));
                }
                if ((href.startsWith("http://") || href.startsWith("https://")) && !"_blank".equals(rel)) {
                    ViewProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "http:// and https:// urls only supported with _blank target currently. Change your rad-href attribute to rad-href=\"" + href + " _blank\"", this.jenv.rootBuilder.parentClass);
                    throw new IllegalArgumentException("http:// and https:// urls only supported with _blank target currently. Change your rad-href attribute to rad-href=\"" + href + " _blank\"");
                }
                if (!(href.startsWith("#") || href.startsWith("http://") || href.startsWith("https://"))) {
                    throw new IllegalArgumentException("Unsupported rad-href value.  Only FormController addresses are allowed.  Of the form #FormControllerClassName.  http:// and https:// addresses are also allowed");
                }
                boolean linkToNewForm = true;
                if (rel != null && ("sheet".equalsIgnoreCase(rel) || rel.startsWith("sel:") || rel.startsWith("sheet-"))) {
                    linkToNewForm = false;
                }
                boolean openExternalWebpage = "_blank".equals(rel) && (href.startsWith("http://") || href.startsWith("https://"));
                String formControllerClass = href.substring(1);
                TypeElement formControllerTypeEl = this.jenv.lookupClass(formControllerClass);
                if (formControllerTypeEl == null && !openExternalWebpage) {
                    String fqn = this.jenv.rootBuilder.packageName + "." + formControllerClass;
                    formControllerTypeEl = this.jenv.lookupClass(fqn);
                }
                TypeElement viewTypeEl = null;
                if (!openExternalWebpage && formControllerTypeEl != null && ViewProcessor.this.isEntityView(formControllerTypeEl)) {
                    viewTypeEl = formControllerTypeEl;
                    TypeElement markerControllerInterface = this.jenv.lookupClass("I" + formControllerTypeEl.getSimpleName() + "Controller");
                    if (markerControllerInterface != null) {
                        formControllerTypeEl = markerControllerInterface;
                    } else {
                        markerControllerInterface = this.jenv.lookupClass(formControllerTypeEl.getSimpleName() + "FormController");
                        if (markerControllerInterface != null) {
                            formControllerTypeEl = markerControllerInterface;
                        } else {
                            markerControllerInterface = this.jenv.lookupClass(formControllerTypeEl.getSimpleName() + "Controller");
                            if (markerControllerInterface != null) {
                                formControllerTypeEl = markerControllerInterface;
                            }
                        }
                    }
                }
                if (openExternalWebpage) {
                    ViewProcessor.indent(bindScript, this.indent).append("com.codename1.ui.CN.execute(\"").append(StringEscapeUtils.escapeJava((String)href)).append("\");\n");
                } else if (linkToNewForm) {
                    String selectorParam;
                    String string = selectorParam = entitySelector == null ? "" : ", " + entitySelector;
                    String paramsString = explicitParams == null ? (rel.equals("child") ? "{formController" + selectorParam + "}" : (rel.equals("sibling") ? "{parentFormController" + selectorParam + "}" : (rel.equals("top") ? "{applicationController" + selectorParam + "}" : (rel.equals("section") ? "{sectionController" + selectorParam + "}" : "{formController" + selectorParam + "}")))) : "{" + explicitParams.substring(1, explicitParams.length() - 1) + "}";
                    paramsString = "new Object[]" + paramsString;
                    ViewProcessor.indent(bindScript, this.indent).append("com.codename1.rad.controllers.FormController _rad_href_controller = (com.codename1.rad.controllers.FormController)getContext().getController().createObjectWithFactory(").append(formControllerTypeEl.getQualifiedName()).append(".class, ").append(paramsString).append(");\n");
                    ViewProcessor.indent(bindScript, this.indent).append("if (_rad_href_controller == null) {\n");
                    PackageElement packageElement = ViewProcessor.this.elements().getPackageOf(this.jenv.rootBuilder.parentClass);
                    Element dummyTag = null;
                    if (explicitParams == null) {
                        dummyTag = this.xmlTag.getOwnerDocument().createElement(formControllerClass);
                        if (rel.equals("child")) {
                            dummyTag.setAttribute("_0_", "formController");
                        } else if (rel.equals("sibling")) {
                            dummyTag.setAttribute("_0_", "parentFormController");
                        } else if (rel.equals("top")) {
                            dummyTag.setAttribute("_0_", "applicationController");
                        } else if (rel.equals("section")) {
                            dummyTag.setAttribute("_0_", "sectionController");
                        } else {
                            dummyTag.setAttribute("_0_", "formController");
                        }
                        if (entitySelector != null) {
                            dummyTag.setAttribute("_1_", entitySelector);
                        }
                    }
                    if (formControllerTypeEl != null) {
                        List candidateControllerClasses = this.jenv.findInstantiatableClassesAssignableTo(packageElement, dummyTag, new String[]{"com.codename1.rad.controllers.FormController", formControllerTypeEl.getQualifiedName().toString()});
                        if (candidateControllerClasses.isEmpty()) {
                            throw new XMLParseException("Cannot find any instantiatable FormController classes that can be assigned to " + formControllerTypeEl.getQualifiedName() + ".  Referenced in rad-href attribute of " + this.xmlTag, this.xmlTag, null);
                        }
                        JavaClassProxy controllerClass = (JavaClassProxy)candidateControllerClasses.get(0);
                        ViewProcessor.indent(bindScript, this.indent).append("    _rad_href_controller = ");
                        String fentitySelector = entitySelector;
                        if (explicitParams == null) {
                            TypeElement entityParamType;
                            TypeElement entityParamTypeWrapperType;
                            JavaMethodProxy constructor = controllerClass.getEligibleConstructors(dummyTag).stream().filter(m -> fentitySelector == null ? m.getNumParams() <= 1 : true).filter(m -> m.getNumParams() == 0 || ViewProcessor.this.isA(m.getParameterType(0), "com.codename1.rad.controllers.Controller")).sorted((a, b) -> b.getNumParams() - a.getNumParams()).findFirst().orElse(null);
                            if (constructor == null) {
                                throw new XMLParseException("No suitable constructors found for class " + controllerClass, this.xmlTag, null);
                            }
                            if (dummyTag.hasAttribute("_1_") && (entityParamTypeWrapperType = this.jenv.lookupClass((entityParamType = constructor.getParameterType(1)).getQualifiedName() + "Wrapper")) != null) {
                                dummyTag.setAttribute("_1_", entityParamTypeWrapperType.getQualifiedName() + ".wrap(" + dummyTag.getAttribute("_1_") + ")");
                            }
                            constructor.callAsConstructor(bindScript, dummyTag, false);
                        } else {
                            bindScript.append("new ").append(controllerClass.getQualifiedName()).append(explicitParams);
                        }
                        bindScript.append(";\n");
                    }
                    ViewProcessor.indent(bindScript, this.indent).append("}\n");
                    ViewProcessor.indent(bindScript, this.indent).append("_rad_href_controller.show();\n");
                } else {
                    if (viewTypeEl == null) {
                        throw new IllegalStateException("rad-href attribute points to a view that cannot be found");
                    }
                    ViewProcessor.indent(bindScript, this.indent).append("com.codename1.rad.controllers.ViewController _rad_href_controller = new com.codename1.rad.controllers.ViewController(getContext().getController());\n");
                    Object dummyTag = null;
                    DeclaredType viewDeclaredType = (DeclaredType)viewTypeEl.asType();
                    JavaClassProxy viewJavaClass = this.jenv.newJavaClassProxy(viewTypeEl);
                    ExecutableElement getEntityMethod = viewJavaClass.findGetter("entity", new String[0]);
                    ExecutableType getEntityMethodType = (ExecutableType)ViewProcessor.this.types().asMemberOf(viewDeclaredType, getEntityMethod);
                    TypeMirror returnTypeMirror = getEntityMethodType.getReturnType();
                    String returnTypeStr = returnTypeMirror.toString();
                    entitySelector = entitySelector == null ? "new " + returnTypeStr + "Impl()" : returnTypeStr + "Wrapper.wrap(" + entitySelector + ")";
                    ViewProcessor.indent(bindScript, this.indent).append("_rad_href_controller.setView(new " + viewJavaClass.getQualifiedName() + "(_rad_href_controller.createViewContext(" + returnTypeStr + ".class, " + entitySelector + ")));\n");
                    if (rel.toLowerCase().startsWith("sheet-") || "sheet".equalsIgnoreCase(rel)) {
                        ViewProcessor.indent(bindScript, this.indent).append("Sheet _sheet = new Sheet(Sheet.getCurrentSheet(), _rad_href_controller.getTitle());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("_sheet.getContentPane().setLayout(new BorderLayout());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("_sheet.getContentPane().add(BorderLayout.CENTER, _rad_href_controller.getView());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("_rad_href_controller.addEventListener(evt->{\n");
                        this.indent += 4;
                        ViewProcessor.indent(bindScript, this.indent).append("if (evt instanceof FormController.FormBackEvent) {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    evt.consume();\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    _sheet.back();\n");
                        ViewProcessor.indent(bindScript, this.indent).append("}\n");
                        this.indent -= 4;
                        ViewProcessor.indent(bindScript, this.indent).append("});\n");
                        if (rel.endsWith("-top") || rel.endsWith("-north")) {
                            ViewProcessor.indent(bindScript, this.indent).append("_sheet.setPosition(BorderLayout.NORTH);\n");
                        } else if (rel.endsWith("-left") || rel.endsWith("-west")) {
                            ViewProcessor.indent(bindScript, this.indent).append("_sheet.setPosition(BorderLayout.WEST);\n");
                        } else if (rel.endsWith("-right") || rel.endsWith("-east")) {
                            ViewProcessor.indent(bindScript, this.indent).append("_sheet.setPosition(BorderLayout.EAST);\n");
                        } else if (rel.endsWith("-bottom") || rel.endsWith("-south")) {
                            ViewProcessor.indent(bindScript, this.indent).append("_sheet.setPosition(BorderLayout.SOUTH);\n");
                        } else if (rel.endsWith("-center")) {
                            ViewProcessor.indent(bindScript, this.indent).append("_sheet.setPosition(BorderLayout.CENTER);\n");
                        }
                        ViewProcessor.indent(bindScript, this.indent).append("_sheet.show();\n");
                    } else if (rel.startsWith("sel:")) {
                        Transitions transitions;
                        Transition t;
                        rel = rel.substring(rel.indexOf(":") + 1);
                        ViewProcessor.indent(bindScript, this.indent).append("Container _targetContainer = com.codename1.ui.ComponentSelector.select(\"").append(StringEscapeUtils.escapeJava((String)rel)).append("\", ").append(this.jenv.rootBuilder.className).append(".this).asComponent(Container.class);\n");
                        ViewProcessor.indent(bindScript, this.indent).append("if (_targetContainer == null) {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    com.codename1.io.Log.e(new IllegalArgumentException(\"Cannot find target container at ").append(StringEscapeUtils.escapeJava((String)rel)).append("\"));\n");
                        ViewProcessor.indent(bindScript, this.indent).append("} else {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    if (!(_targetContainer.getLayout() instanceof BorderLayout)) {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("        _targetContainer.setLayout(new BorderLayout());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    }\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    if (_targetContainer.getComponentCount() > 1) {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("        _targetContainer.removeAll();\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    }\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    if (_targetContainer.getComponentCount() == 0) {\n");
                        ViewProcessor.indent(bindScript, this.indent).append("        _targetContainer.add(BorderLayout.CENTER, new Container());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("        _targetContainer.getComponentAt(0).setWidth(_targetContainer.getWidth());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("        _targetContainer.getComponentAt(0).setHeight(_targetContainer.getHeight());\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    }\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    com.codename1.ui.animations.Transition _transition = null;\n");
                        if (this.xmlTag.hasAttribute("rad-transition") && (t = (transitions = Transitions.parse(this.xmlTag.getAttribute("rad-transition"))).get("rad-href")) != null) {
                            t.buildTransitionObject(bindScript, this.indent, "_transition");
                        }
                        ViewProcessor.indent(bindScript, this.indent).append("    _targetContainer.replace(_targetContainer.getComponentAt(0), _rad_href_controller.getView(), _transition);\n");
                        ViewProcessor.indent(bindScript, this.indent).append("    if (_transition == null) _targetContainer.revalidateWithAnimationSafety();\n");
                        ViewProcessor.indent(bindScript, this.indent).append("}\n");
                    } else {
                        throw new IllegalStateException("Unsupported target for rad-href attribute.  Expected either sheet, sheet-*, or sel:*");
                    }
                }
            }
            if (this.xmlTag.hasAttribute("rad-href-trigger")) {
                String triggerCategory = this.xmlTag.getAttribute("rad-href-trigger");
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("com.codename1.rad.nodes.ActionNode _tmp_trigger_action = viewController.getViewNode().getInheritedAction(").append(triggerCategory).append(");\n");
                ViewProcessor.indent(sb, this.indent).append("if (_tmp_trigger_action == null) throw new IllegalStateException(\"Cannot find action for category \"+").append(triggerCategory).append("+\".\");\n");
                ViewProcessor.indent(sb, this.indent).append("viewController.addActionListener(_tmp_trigger_action, event -> {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("if (event.isConsumed()) return;\n");
                ViewProcessor.indent(sb, this.indent).append(ViewProcessor.reformat(bindScript.toString(), this.indent));
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("});\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            } else if (bindAction == null) {
                ViewProcessor.indent(sb, this.indent).append("_cmp.addActionListener(event -> {\n");
                ViewProcessor.indent(sb, this.indent).append("    if (event.isConsumed()) return;\n");
                sb.append((CharSequence)bindScript);
                ViewProcessor.indent(sb, this.indent).append("});\n");
            } else {
                bindAction.setTextContent(bindScript.toString());
            }
        }

        void writeViewController(StringBuilder sb) {
            Element viewControllerTag = ViewProcessor.getChildElementByTagName(this.xmlTag, "view-controller");
            if (viewControllerTag == null) {
                return;
            }
            this.hasViewController = true;
            String controllerExtends = viewControllerTag.getAttribute("extends");
            if (controllerExtends.isEmpty()) {
                controllerExtends = "ViewController";
            }
            ViewProcessor.indent(sb, this.indent).append("ViewController viewController = new ").append(controllerExtends).append("(context.getController());\n");
        }

        void writeChildren(StringBuilder sb) {
            NodeList childNodes = this.xmlTag.getChildNodes();
            int numChildNodes = childNodes.getLength();
            if (this.componentClass.isContainer()) {
                ViewProcessor.indent(sb, this.indent).append("Container _tmp_old_currentContainer = _currentContainer;\n");
                ViewProcessor.indent(sb, this.indent).append("_currentContainer = _cmp;\n");
            }
            ViewProcessor.indent(sb, this.indent).append("// ").append(numChildNodes).append(" child nodes\n");
            for (int i = 0; i < numChildNodes; ++i) {
                String slotId;
                Element childEl;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || (childEl = (Element)child).hasAttribute("rad-property") || childEl.hasAttribute("rad-used-for")) continue;
                String childId = childEl.getAttribute("rad-id");
                if (this.componentClass.isContainer() && childEl.getTagName().equalsIgnoreCase("define-slot")) {
                    ViewProcessor.indent(sb, this.indent).append("// Define slot ").append(childEl.getAttribute("id")).append("\n");
                    ViewProcessor.indent(sb, this.indent).append("{\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("com.codename1.rad.ui.Slot _slot = new com.codename1.rad.ui.Slot(");
                    slotId = childEl.getAttribute("id");
                    sb.append(slotId).append(", this);\n");
                    for (Element slotChild : ViewProcessor.getChildElements(childEl)) {
                        if (!this.jenv.isComponentTag(slotChild.getTagName())) continue;
                        sb.append("_slot.setContent(").append("createComponent").append(slotChild.getAttribute("rad-id")).append("());\n");
                        break;
                    }
                    ViewProcessor.indent(sb, this.indent);
                    Object constraint = childEl.getAttribute("layout-constraint");
                    if (constraint == null || ((String)constraint).isEmpty()) {
                        ViewProcessor.indent(sb, this.indent).append("_cmp.addComponent(_slot);\n");
                    } else {
                        constraint = !((String)constraint).startsWith("java:") ? "_builder.parseConstraint(\"" + StringEscapeUtils.escapeJava((String)constraint) + "\")" : ((String)constraint).substring(((String)constraint).indexOf(":") + 1);
                        ViewProcessor.indent(sb, this.indent).append("_cmp.addComponent(").append((String)constraint).append(", _slot);\n");
                    }
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    continue;
                }
                if (this.componentClass.isContainer() && childEl.getTagName().equalsIgnoreCase("fill-slot")) {
                    ViewProcessor.indent(sb, this.indent).append("// fill slot ").append(childEl.getAttribute("id")).append("\n");
                    ViewProcessor.indent(sb, this.indent).append("{\n");
                    this.indent += 4;
                    slotId = childEl.getAttribute("id");
                    if (slotId.startsWith("java:")) {
                        slotId = slotId.substring(slotId.indexOf(":") + 1);
                    } else if (!slotId.contains(".")) {
                        slotId = this.componentClass.getQualifiedName() + "." + slotId;
                    }
                    for (Element slotChild : ViewProcessor.getChildElements(childEl)) {
                        if (!this.jenv.isComponentTag(slotChild.getTagName())) continue;
                        ViewProcessor.indent(sb, this.indent).append("viewController.fillSlot(").append(slotId).append(", evt -> {\n");
                        ViewProcessor.indent(sb, this.indent).append("    if (!_cmp.contains(evt.getSlot())) return;\n");
                        ViewProcessor.indent(sb, this.indent).append("    evt.getSlot().setContent(createComponent").append(slotChild.getAttribute("rad-id")).append("());\n");
                        ViewProcessor.indent(sb, this.indent).append("});\n");
                        break;
                    }
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    continue;
                }
                if (childEl.getTagName().equalsIgnoreCase("var")) continue;
                if (childEl.getTagName().equalsIgnoreCase("script")) {
                    ViewProcessor.indent(sb, this.indent).append("// <script> tag\n");
                    ViewProcessor.indent(sb, this.indent).append("script").append(childEl.getAttribute("rad-id")).append("(_cmp);\n");
                    continue;
                }
                TypeElement type = this.jenv.findClassThatTagCreates(childEl.getTagName());
                String createCall = "createBean";
                if (ViewProcessor.this.isComponent(type)) {
                    createCall = "createComponent";
                } else if (ViewProcessor.this.isNode(type)) {
                    createCall = "createNode";
                }
                createCall = createCall + childId + "()";
                ViewProcessor.indent(sb, this.indent).append("// Child tag ").append(childEl.getTagName()).append(" is type ").append(this.jenv.findClassThatTagCreates(childEl.getTagName())).append("\n");
                if (this.componentClass.isContainer() && this.jenv.isComponentTag(childEl.getTagName())) {
                    ViewProcessor.indent(sb, this.indent).append("// Add child component ").append(" with child tag ").append(childEl.getTagName()).append("\n");
                    String constraint = childEl.getAttribute("layout-constraint");
                    String condition = childEl.getAttribute("rad-condition");
                    if (!condition.isEmpty()) {
                        ViewProcessor.indent(sb, this.indent).append("if (").append(condition).append(") {\n");
                        this.indent += 4;
                    }
                    if (constraint == null || constraint.isEmpty()) {
                        ViewProcessor.indent(sb, this.indent).append("{\n");
                        ViewProcessor.indent(sb, this.indent).append("    com.codename1.ui.Component _childCmp = ").append(createCall).append(";\n");
                        ViewProcessor.indent(sb, this.indent).append("    if (_childCmp.getClientProperty(\"RAD_NO_ADD\") == null) {\n");
                        ViewProcessor.indent(sb, this.indent).append("        _cmp.addComponent(_childCmp);\n");
                        ViewProcessor.indent(sb, this.indent).append("    }\n");
                        ViewProcessor.indent(sb, this.indent).append("}\n");
                    } else {
                        constraint = !constraint.startsWith("java:") ? "_builder.parseConstraint(\"" + StringEscapeUtils.escapeJava((String)constraint) + "\")" : constraint.substring(constraint.indexOf(":") + 1);
                        ViewProcessor.indent(sb, this.indent).append("_cmp.addComponent(").append(constraint).append(", ").append(createCall).append(");\n");
                    }
                    if (condition.isEmpty()) continue;
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    continue;
                }
                if (type == null || !this.jenv.rootBuilder.containsBeanBuilderFor(type.getQualifiedName())) continue;
                ViewProcessor.indent(sb, this.indent).append("// Create bean ").append(type.getQualifiedName()).append("\n");
                ViewProcessor.indent(sb, this.indent).append("createBean").append(childEl.getAttribute("rad-id")).append("();\n");
            }
            if (this.componentClass.isContainer()) {
                ViewProcessor.indent(sb, this.indent).append("_currentContainer = _tmp_old_currentContainer;\n");
            }
        }

        boolean isInsideRowTemplate() {
            return ViewProcessor.isElementInsideRowTemplate(this.xmlTag);
        }

        void writeBinding(StringBuilder sb, String attName, String attValue) throws XMLParseException {
            Transitions transitions;
            JavaClassProxy componentBinder;
            JavaMethodProxy binderMethodProxy;
            String propName;
            if (!attName.startsWith("bind-")) {
                throw new IllegalArgumentException("AttName must start with bind-");
            }
            String leafPropName = propName = attName.substring(attName.indexOf("-") + 1);
            String rootPropName = propName;
            if (propName.contains(".")) {
                leafPropName = leafPropName.substring(leafPropName.lastIndexOf(".") + 1);
                rootPropName = propName.substring(0, propName.lastIndexOf("."));
            }
            if ((binderMethodProxy = (componentBinder = this.jenv.newJavaClassProxy(ViewProcessor.this.elements().getTypeElement("com.codename1.rad.ui.builders.ComponentBinder"))).findMethodProxy("bind" + leafPropName, 3)) != null) {
                JavaPropertySelector rootPropertySelector;
                if (leafPropName.equals(propName)) {
                    if (attValue.startsWith("java:")) {
                        throw new XMLParseException("The binding " + attName + " doesn't support java expressions.", this.xmlTag, null);
                    }
                    ViewProcessor.indent(sb, this.indent).append("{\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("// Binding for ").append(attName).append("=").append(attValue).append("\n");
                    ViewProcessor.indent(sb, this.indent).append("PropertySelector _propertySelector = ");
                    this.jenv.createRADPropertySelector(sb, attValue);
                    sb.append(";\n");
                    ViewProcessor.indent(sb, this.indent).append(componentBinder.getQualifiedName()).append(".").append(binderMethodProxy.methodEl.getSimpleName()).append("(this, _propertySelector, _cmp);\n");
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    this.indent -= 4;
                    return;
                }
                try {
                    rootPropertySelector = ViewProcessor.this.createPropertySelector(this.componentClass, rootPropName, "com.codename1.ui.Component");
                }
                catch (Exception ex) {
                    rootPropertySelector = null;
                }
                if (rootPropertySelector != null && rootPropertySelector.classProxy.isComponent()) {
                    ViewProcessor.indent(sb, this.indent).append("{\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("// Binding for ").append(attName).append("=").append(attValue).append("\n");
                    ViewProcessor.indent(sb, this.indent).append(rootPropertySelector.getter().getReturnType().getQualifiedName()).append(" _tmpCmp = null;\n");
                    rootPropertySelector.assignVar(sb, "_cmp", "_tmpCmp", "null");
                    sb.append("\n");
                    ViewProcessor.indent(sb, this.indent).append("if (_tmpCmp != null) {\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("PropertySelector _propertySelector = ");
                    this.jenv.createRADPropertySelector(sb, attValue);
                    sb.append(";\n");
                    ViewProcessor.indent(sb, this.indent).append(componentBinder.getQualifiedName()).append(".").append(binderMethodProxy.methodEl.getSimpleName()).append("(this, _propertySelector, _tmpCmp);\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                    return;
                }
            }
            JavaPropertySelector propertySelector = ViewProcessor.this.createPropertySelector(this.componentClass, propName);
            ViewProcessor.indent(sb, this.indent).append("{\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("// Binding for ").append(attName).append("=").append(attValue).append("\n");
            ViewProcessor.indent(sb, this.indent).append("final ").append(this.componentClass.getQualifiedName()).append(" _fcmp = _cmp;\n");
            boolean parseAsJava = false;
            if (attValue.startsWith("java:")) {
                attValue = ViewProcessor.this.expandRADModelVars(this.jenv, attValue.substring(attValue.indexOf(":") + 1), false);
                parseAsJava = true;
            } else if (attValue.contains("$") || attValue.contains("{") || attValue.contains(",")) {
                parseAsJava = true;
            }
            ViewProcessor.indent(sb, this.indent).append("PropertySelector _propertySelector = ");
            if (parseAsJava) {
                sb.append("null");
                attValue = ViewProcessor.this.expandRADModelVars(this.jenv, attValue, false);
            } else {
                this.jenv.createRADPropertySelector(sb, attValue);
            }
            sb.append(";\n");
            ViewProcessor.indent(sb, this.indent).append("Runnable _onUpdate = ()-> {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("try {\n");
            this.indent += 4;
            String paramType = propertySelector.getPropertyType(true);
            if (propertySelector.isReadable()) {
                ViewProcessor.indent(sb, this.indent).append(propertySelector.getPropertyType(false)).append(" _oldVal = ").append(propertySelector.getPropertyNullValue(true)).append(";\n");
                ViewProcessor.indent(sb, this.indent);
                propertySelector.assignVar(sb, "_fcmp", "_oldVal", propertySelector.getPropertyNullValue(true));
                sb.append("\n");
            } else {
                ViewProcessor.indent(sb, this.indent);
                propertySelector.assignVar(sb, "_fcmp", "_oldVal", propertySelector.getPropertyNullValue(true));
                sb.append("\n");
            }
            TypeElement param = propertySelector.setter().getParameterType(0);
            if (parseAsJava) {
                ViewProcessor.indent(sb, this.indent).append(paramType).append(" _newVal = ").append(attValue).append(";\n");
            } else {
                ViewProcessor.indent(sb, this.indent).append(paramType).append(" _newVal = ");
                if (param.asType().getKind() == TypeKind.BOOLEAN || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Boolean")) {
                    sb.append("!_propertySelector.isFalsey()");
                } else if (param.asType().getKind() == TypeKind.FLOAT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Float")) {
                    sb.append("_propertySelector.getFloat(0f)");
                } else if (param.asType().getKind() == TypeKind.INT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Integer")) {
                    sb.append("_propertySelector.getInt(0)");
                } else if (param.asType().getKind() == TypeKind.DOUBLE || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Double")) {
                    sb.append("_propertySelector.getDouble(0.0)");
                } else if (paramType.equals("java.lang.String")) {
                    sb.append("_propertySelector.getText(\"\")");
                } else if (paramType.equals("java.util.Date")) {
                    sb.append("_propertySelector.getDate(null)");
                } else {
                    sb.append("_propertySelector.exists() ? (").append(paramType).append(")").append("_propertySelector.getLeafEntity().get(_propertySelector.getLeafProperty()) : null");
                }
                sb.append(";\n");
            }
            ViewProcessor.indent(sb, this.indent).append("if (!java.util.Objects.equals(_newVal, _oldVal)) {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent);
            Transition t = null;
            if (this.xmlTag.hasAttribute("rad-transition")) {
                transitions = Transitions.parse(this.xmlTag.getAttribute("rad-transition"));
                t = transitions.get(propName);
            }
            if (t == null && (propName.equalsIgnoreCase("hidden") || propName.toLowerCase().endsWith(".hidden"))) {
                transitions = Transitions.parse(propName + " 0s");
                t = transitions.get(propName);
            }
            if (t != null && propName.equalsIgnoreCase("uiid") && t.getDurationMs() > 0) {
                sb.append("{com.codename1.ui.animations.ComponentAnimation _anim = _fcmp.createStyleAnimation(_newVal, ").append(t.getDurationMs()).append("); com.codename1.ui.AnimationManager _animMgr = _fcmp.getAnimationManager(); ");
                sb.append("if (_animMgr != null) _animMgr.addAnimation(_anim);}\n");
            } else {
                propertySelector.setProperty(sb, "_fcmp", "_newVal");
                sb.append("\n");
                if (t != null) {
                    ViewProcessor.indent(sb, this.indent);
                    boolean animateParent = true;
                    if ("layout".equalsIgnoreCase(propName)) {
                        animateParent = false;
                    }
                    t.writeTransitionCallForBinding(sb, "_fcmp", animateParent);
                }
                sb.append("\n");
            }
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("} catch (Exception ex){ex.printStackTrace();}\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("};\n");
            ViewProcessor.indent(sb, this.indent).append("if (view instanceof com.codename1.rad.ui.AbstractEntityView) {\n");
            ViewProcessor.indent(sb, this.indent).append("    ((com.codename1.rad.ui.AbstractEntityView)view).addUpdateListener(_onUpdate);\n");
            ViewProcessor.indent(sb, this.indent).append("} else {\n");
            ViewProcessor.indent(sb, this.indent).append("    addUpdateListener(_onUpdate);\n");
            ViewProcessor.indent(sb, this.indent).append("}\n");
            if (!parseAsJava) {
                ViewProcessor.indent(sb, this.indent).append("com.codename1.ui.events.ActionListener<PropertyChangeEvent> _pce = pcl -> {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("_onUpdate.run();\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("};\n");
                ViewProcessor.indent(sb, this.indent).append("Runnable _onBind = () -> {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("_propertySelector.addPropertyChangeListener(_pce);\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("};\n");
                ViewProcessor.indent(sb, this.indent).append("Runnable _onUnbind = () -> {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("_propertySelector.removePropertyChangeListener(_pce);\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("};\n");
                ViewProcessor.indent(sb, this.indent).append("addBindListener(_onBind);\n");
                ViewProcessor.indent(sb, this.indent).append("addUnbindListener(_onUnbind);\n");
            }
            if (propertySelector.isReadable() && !parseAsJava) {
                JavaMethodProxy addActionListenerMethod;
                ViewProcessor.indent(sb, this.indent).append("Runnable onCommit = () -> {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append(paramType).append(" _newVal = ").append(propertySelector.getPropertyNullValue(false)).append(";\n");
                ViewProcessor.indent(sb, this.indent);
                propertySelector.assignVar(sb, "_fcmp", "_newVal", propertySelector.getPropertyNullValue(false));
                sb.append("\n");
                ViewProcessor.indent(sb, this.indent).append(paramType).append(" _oldVal = ");
                if (param.asType().getKind() == TypeKind.BOOLEAN || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Boolean")) {
                    sb.append("!_propertySelector.isFalsey()");
                } else if (param.asType().getKind() == TypeKind.FLOAT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Float")) {
                    sb.append("_propertySelector.getFloat(0f)");
                } else if (param.asType().getKind() == TypeKind.INT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Integer")) {
                    sb.append("_propertySelector.getInt(0)");
                } else if (param.asType().getKind() == TypeKind.DOUBLE || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Double")) {
                    sb.append("_propertySelector.getDouble(0.0)");
                } else if (paramType.equals("java.lang.String")) {
                    sb.append("_propertySelector.getText(\"\")");
                } else if (paramType.equals("java.util.Date")) {
                    sb.append("_propertySelector.getDate(null)");
                } else {
                    sb.append("_propertySelector.exists() ? (").append(paramType).append(")").append("_propertySelector.getLeafEntity().get(_propertySelector.getLeafProperty()) : null");
                }
                sb.append(";\n");
                ViewProcessor.indent(sb, this.indent).append("if (!java.util.Objects.equals(_newVal, _oldVal)) {\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("_propertySelector.");
                if (param.asType().getKind() == TypeKind.BOOLEAN || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Boolean")) {
                    sb.append("setBoolean");
                } else if (param.asType().getKind() == TypeKind.FLOAT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Float")) {
                    sb.append("setFloat");
                } else if (param.asType().getKind() == TypeKind.INT || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Integer")) {
                    sb.append("setInt");
                } else if (param.asType().getKind() == TypeKind.DOUBLE || ViewProcessor.this.isA(ViewProcessor.this.toTypeElement(param.asType()), "java.lang.Double")) {
                    sb.append("setDouble");
                } else if (paramType.equals("java.lang.String")) {
                    sb.append("setText");
                } else if (paramType.equals("java.util.Date")) {
                    sb.append("setDate");
                } else {
                    XMLParseException ex = new XMLParseException("Failed to create binding for attribute " + attName + " in tag " + this.xmlTag + " because the property type " + param.asType() + " is not supported for bindings. If binding to a java expression, rememver to prefix attribute value with 'java:'", this.xmlTag, null);
                    ex.attributeName = attName;
                    ex.attributeValue = attValue;
                    throw ex;
                }
                sb.append("(_newVal);\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("};\n");
                JavaMethodProxy addDataChangedListenerMethod = this.componentClass.findMethodProxy("addDataChangedListener", 1);
                if (addDataChangedListenerMethod != null) {
                    ExecutableElement addDataChangedListener = addDataChangedListenerMethod.methodEl;
                    int numParams = addDataChangedListener.getParameters().size();
                    ViewProcessor.indent(sb, this.indent).append("_fcmp.").append(addDataChangedListener.getSimpleName().toString()).append("((");
                    sb.append("type, index");
                    sb.append(") -> onCommit.run());\n");
                }
                if ((addActionListenerMethod = this.componentClass.findMethodProxy("addActionListener", 1)) != null) {
                    ExecutableElement addActionListener = addActionListenerMethod.methodEl;
                    int numParams = addActionListener.getParameters().size();
                    ViewProcessor.indent(sb, this.indent).append("_fcmp.").append(addActionListener.getSimpleName().toString()).append("((evt");
                    sb.append(") -> onCommit.run());\n");
                }
            }
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("} // END Binding for property ").append(attName).append("\n");
        }

        void writeBindings(StringBuilder sb) throws XMLParseException {
            XMLParseException[] errors = new XMLParseException[1];
            ViewProcessor.forEachAttribute(this.xmlTag, attr -> {
                if (errors[0] != null) {
                    return null;
                }
                if (attr.getName().startsWith("bind-")) {
                    try {
                        this.writeBinding(sb, attr.getName(), attr.getValue());
                    }
                    catch (XMLParseException ex) {
                        errors[0] = ex;
                    }
                }
                return null;
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }

        void writeActionBindings(StringBuilder sb) throws XMLParseException {
            XMLParseException[] errors = new XMLParseException[1];
            this.writeHrefLink(sb);
            ViewProcessor.forEachChild(this.xmlTag, el -> {
                boolean inherit;
                String tagName = el.getTagName();
                if (!tagName.equalsIgnoreCase("bind-action")) {
                    return null;
                }
                if (errors[0] != null) {
                    return null;
                }
                String category = el.getAttribute("category");
                boolean bl = inherit = !"false".equalsIgnoreCase(el.getAttribute("inherit"));
                if (category.isEmpty()) {
                    errors[0] = new XMLParseException("bind-action tag missing category attribute.  Tag: " + el, (Element)el, null);
                    return null;
                }
                String trigger = "action";
                if (el.hasAttribute("on")) {
                    trigger = el.getAttribute("on");
                }
                JavaMethodProxy addListenerMethod = this.componentClass.findMethodProxy("add" + trigger + "listener", 1);
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                String defaultHandler = ViewProcessor.getTextContent(el);
                String inheritedStr = inherit ? "Inherited" : "";
                ViewProcessor.indent(sb, this.indent).append("ActionNode __action = getViewNode().get").append(inheritedStr).append("Action(").append(category).append(");\n");
                ViewProcessor.indent(sb, this.indent).append("if (__action == null) _cmp.setVisible(false);\n");
                ViewProcessor.indent(sb, this.indent).append("else {\n");
                ViewProcessor.indent(sb, this.indent).append("    ").append(this.componentClass.getQualifiedName()).append(" _fcmp = _cmp;\n");
                if (!defaultHandler.trim().isEmpty()) {
                    ViewProcessor.indent(sb, this.indent).append("    // Creating proxy copy of action because a default handler was provided\n");
                    ViewProcessor.indent(sb, this.indent).append("    // and we don't want to modify the original action.\n");
                    ViewProcessor.indent(sb, this.indent).append("    __action = (ActionNode)__action.createProxy(__action.getParent());\n");
                    ViewProcessor.indent(sb, this.indent).append("    class AfterActionCallback_ implements ActionNode.AfterActionCallback {\n");
                    ViewProcessor.indent(sb, this.indent).append("        public void onSucess(com.codename1.ui.events.ActionEvent evt) {\n");
                    ViewProcessor.indent(sb, this.indent).append("            ActionNode.ActionNodeEvent event = (ActionNode.ActionNodeEvent)evt;\n");
                    ViewProcessor.indent(sb, this.indent).append("            if (event.isConsumed()) return;\n");
                    ViewProcessor.indent(sb, this.indent).append("            ").append(this.componentClass.getQualifiedName()).append(" it = _fcmp;\n");
                    ViewProcessor.indent(sb, this.indent).append("            ").append(ViewProcessor.reformat(defaultHandler, this.indent + 12)).append("\n");
                    ViewProcessor.indent(sb, this.indent).append("        }\n");
                    ViewProcessor.indent(sb, this.indent).append("    }\n");
                    ViewProcessor.indent(sb, this.indent).append("    __action.addAfterActionCallback(new AfterActionCallback_());\n");
                }
                ViewProcessor.indent(sb, this.indent).append("    ActionNode _action = __action;\n");
                if (ViewProcessor.this.isA(this.componentClass.typeEl, "com.codename1.ui.Button") || ViewProcessor.this.isA(this.componentClass.typeEl, "com.codename1.components.MultiButton")) {
                    ViewProcessor.indent(sb, this.indent).append("    com.codename1.rad.ui.DefaultActionViewFactory.initUI(_fcmp, context.getEntity(), _action);\n");
                    ViewProcessor.indent(sb, this.indent).append("    Runnable _onUpdate = () -> {\n");
                    ViewProcessor.indent(sb, this.indent).append("        com.codename1.rad.ui.DefaultActionViewFactory.update(_fcmp, context.getEntity(), _action);\n");
                    ViewProcessor.indent(sb, this.indent).append("    };\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("com.codename1.ui.events.ActionListener<PropertyChangeEvent> _pce = pcl -> {\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("_onUpdate.run();\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("};\n");
                    ViewProcessor.indent(sb, this.indent).append("Runnable _onBind = () -> {\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("context.getEntity().addPropertyChangeListener(_pce);\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("};\n");
                    ViewProcessor.indent(sb, this.indent).append("Runnable _onUnbind = () -> {\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append("context.getEntity().removePropertyChangeListener(_pce);\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("};\n");
                    ViewProcessor.indent(sb, this.indent).append("addBindListener(_onBind);\n");
                    ViewProcessor.indent(sb, this.indent).append("addUnbindListener(_onUnbind);\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("    if (view instanceof com.codename1.rad.ui.AbstractEntityView) {\n");
                    ViewProcessor.indent(sb, this.indent).append("        ((com.codename1.rad.ui.AbstractEntityView)view).addUpdateListener(_onUpdate);\n");
                    ViewProcessor.indent(sb, this.indent).append("    } else {\n");
                    ViewProcessor.indent(sb, this.indent).append("        addUpdateListener(_onUpdate);\n");
                    ViewProcessor.indent(sb, this.indent).append("    }\n");
                }
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
                return null;
            });
            if (errors[0] != null) {
                throw errors[0];
            }
        }

        private Element xmlTagParent() {
            Node parent = this.xmlTag.getParentNode();
            if (parent instanceof Element) {
                return (Element)parent;
            }
            return null;
        }

        private Element getRowTemplateTag(Element startingPoint) {
            Element parent;
            if (startingPoint == null) {
                startingPoint = this.xmlTag;
            }
            if (startingPoint.getTagName().equalsIgnoreCase("row-template")) {
                return startingPoint;
            }
            Element element = parent = startingPoint.getParentNode() instanceof Element ? (Element)startingPoint.getParentNode() : null;
            if (parent == null) {
                return null;
            }
            return this.getRowTemplateTag(parent);
        }

        private Element getListViewTag() {
            Element rowTemplate = this.getRowTemplateTag(null);
            if (rowTemplate == null) {
                return null;
            }
            return (Element)rowTemplate.getParentNode();
        }

        void writeBuilderMethod(StringBuilder sb) throws XMLParseException {
            String varName;
            ViewProcessor.indent(sb, this.indent).append("private ").append(this.componentClass.getQualifiedName()).append(" createComponent").append(this.xmlTag.getAttribute("rad-id")).append("() {\n");
            this.indent += 4;
            this.writeViewController(sb);
            if (this.xmlTag.hasAttribute("rad-href-trigger") && this.xmlTag.hasAttribute("rad-href")) {
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                String trigger = this.xmlTag.getAttribute("rad-href-trigger");
                ViewProcessor.indent(sb, this.indent).append("ActionNode _tmp_trigger_action = viewController.getViewNode().getInheritedAction(").append(trigger).append(");\n");
                ViewProcessor.indent(sb, this.indent).append("if (_tmp_trigger_action == null) {\n");
                ViewProcessor.indent(sb, this.indent).append("    viewController.getViewNode().setAttributes(com.codename1.rad.ui.UI.actions(").append(trigger).append(", com.codename1.rad.ui.UI.action()));\n");
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
            String rowModelType = "Entity";
            String rowModelTypeWrapper = null;
            if (this.isInsideRowTemplate()) {
                Element listViewTag = this.getListViewTag();
                if (listViewTag.hasAttribute("row-type")) {
                    rowModelType = listViewTag.getAttribute("row-type");
                    TypeElement rowModelTypeEl = this.jenv.lookupClass(rowModelType);
                    if (rowModelTypeEl == null) {
                        throw new XMLParseException("Cannot find class corresponding to " + rowModelType + " from tag " + listViewTag, listViewTag, null);
                    }
                    rowModelType = rowModelTypeEl.getQualifiedName().toString();
                    if (this.jenv.lookupClass(rowModelType + "Wrapper") != null) {
                        rowModelTypeWrapper = rowModelType + "Wrapper";
                    }
                }
                ViewProcessor.indent(sb, this.indent).append(rowModelType).append(" rowModel = ");
                if (rowModelTypeWrapper != null) {
                    sb.append(rowModelTypeWrapper).append(".wrap(this.rowModel);\n");
                } else {
                    sb.append("this.rowModel;\n");
                }
                ViewProcessor.indent(sb, this.indent).append("int rowIndex = this.rowIndex;\n");
                ViewProcessor.indent(sb, this.indent).append("boolean rowSelected = this.rowSelected;\n");
                ViewProcessor.indent(sb, this.indent).append("boolean rowFocused = this.rowFocused;\n");
                ViewProcessor.indent(sb, this.indent).append("EntityListView rowList = this.rowList;\n");
                ViewProcessor.indent(sb, this.indent).append("ViewContext<").append(rowModelType).append("> context = (ViewContext<").append(rowModelType).append(">)this.subContext;\n");
            }
            ViewProcessor.indent(sb, this.indent).append("java.util.Map<String,String> attributes = new java.util.HashMap<String,String>();\n");
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int numAtts = attributes.getLength();
            for (int i = 0; i < numAtts; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                ViewProcessor.indent(sb, this.indent).append(" attributes.put(\"").append(StringEscapeUtils.escapeJava((String)attribute.getName())).append("\", \"").append(StringEscapeUtils.escapeJava((String)attribute.getValue())).append("\");\n");
            }
            if (this.builderClass != null) {
                ViewProcessor.indent(sb, this.indent).append(this.builderClass.getQualifiedName()).append(" _builder = ").append("new ").append(this.builderClass.getQualifiedName()).append("(context, \"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
                ViewProcessor.indent(sb, this.indent).append("_builder.setParentContainer(_currentContainer, null);\n");
                if (ViewProcessor.this.isA(this.componentClass.typeEl, "com.codename1.rad.ui.entityviews.EntityListView") && !this.componentClass.typeEl.getQualifiedName().contentEquals("com.codename1.rad.ui.entityviews.EntityListView") && this.builderClass.getQualifiedName().contentEquals("com.codename1.rad.ui.builders.EntityListViewBuilder")) {
                    if (this.xmlTag.hasAttribute("view-model") && !this.xmlTag.hasAttribute("model")) {
                        this.xmlTag.setAttribute("model", this.xmlTag.getAttribute("view-model"));
                    }
                    ViewProcessor.indent(sb, this.indent).append("_builder.listViewFactory((listModel, listNode) -> {\n");
                    this.indent += 4;
                    JavaMethodProxy constructor = this.componentClass.getPublicConstructors().stream().filter(m -> m.getNumParams() == 2 && ViewProcessor.this.isA(m.getParameterType(0), "com.codename1.rad.models.EntityList") && ViewProcessor.this.isA(m.getParameterType(1), "com.codename1.rad.nodes.ListNode")).findFirst().orElse(null);
                    if (constructor == null) {
                        constructor = this.componentClass.getPublicConstructors().stream().filter(m -> m.getNumParams() == 1 && ViewProcessor.this.isA(m.getParameterType(0), "com.codename1.rad.nodes.ListNode")).findFirst().orElse(null);
                    }
                    if (constructor == null) {
                        constructor = this.componentClass.getPublicConstructors().stream().filter(m -> m.getNumParams() == 1 && ViewProcessor.this.isA(m.getParameterType(0), "com.codename1.rad.models.EntityList")).findFirst().orElse(null);
                    }
                    if (constructor == null) {
                        throw new XMLParseException("Cannot find suitable constructor for EntityListView subclass " + this.componentClass + ".", this.xmlTag, null);
                    }
                    int numConstructorParams = constructor.getNumParams();
                    for (JavaMethodProxy m2 : this.componentClass.getPublicConstructors()) {
                        if (m2.getNumParams() <= numConstructorParams) continue;
                        boolean isBetter = true;
                        for (int i = numConstructorParams; i < m2.getNumParams(); ++i) {
                            VariableElement varEl = m2.methodEl.getParameters().get(i);
                            Inject anno = varEl.getAnnotation(Inject.class);
                            if (anno != null && !anno.name().isEmpty() && this.xmlTag.hasAttribute(anno.name())) continue;
                            isBetter = false;
                        }
                        if (!isBetter) continue;
                        constructor = m2;
                        numConstructorParams = m2.getNumParams();
                    }
                    if (ViewProcessor.this.isA(constructor.getParameterType(0), "com.codename1.rad.models.EntityList")) {
                        String entityListType = constructor.getParameterType(0).getQualifiedName().toString();
                        ViewProcessor.indent(sb, this.indent).append("if (!").append(entityListType).append(".class.isAssignableFrom(listModel.getClass())) {\n");
                        ViewProcessor.indent(sb, this.indent).append("    EntityList tmp = (EntityList) new ").append(entityListType).append("();\n");
                        ViewProcessor.indent(sb, this.indent).append("    for (Object e : listModel) tmp.add((Entity)e);\n");
                        ViewProcessor.indent(sb, this.indent).append("    listModel = (").append(entityListType).append(")tmp;\n");
                        ViewProcessor.indent(sb, this.indent).append("}\n");
                    }
                    ViewProcessor.indent(sb, this.indent).append("return new ").append(this.componentClass.getQualifiedName()).append("(");
                    if (constructor.getNumParams() > 0) {
                        sb.append("(").append(constructor.getParameterType(0).getQualifiedName()).append(")");
                        if (ViewProcessor.this.isA(constructor.getParameterType(0), "com.codename1.rad.models.EntityList")) {
                            sb.append("listModel");
                        } else if (ViewProcessor.this.isA(constructor.getParameterType(0), "com.codename1.rad.nodes.ListNode")) {
                            sb.append("listNode");
                        } else {
                            throw new XMLParseException("EntityListView subclasses should have public constructor that accepts either an EntityList or ListNode as the first argument.", this.xmlTag, null);
                        }
                    }
                    if (constructor.getNumParams() > 1) {
                        sb.append(",(").append(constructor.getParameterType(1).getQualifiedName()).append(")");
                        if (ViewProcessor.this.isA(constructor.getParameterType(1), "com.codename1.rad.models.EntityList")) {
                            sb.append("listModel");
                        } else if (ViewProcessor.this.isA(constructor.getParameterType(1), "com.codename1.rad.nodes.ListNode")) {
                            sb.append("listNode");
                        } else {
                            throw new XMLParseException("EntityListView subclasses should have public constructor that accepts either an EntityList or ListNode as the second argument.", this.xmlTag, null);
                        }
                    }
                    if (constructor.getNumParams() > 2) {
                        for (int i = 2; i < constructor.getNumParams(); ++i) {
                            String val = this.xmlTag.getAttribute(constructor.methodEl.getParameters().get(i).getAnnotation(Inject.class).name());
                            val = new AttributeSanitizer(constructor.classProxy.env).sanitize(constructor.getParameterType(i), constructor.methodEl.getParameters().get(i), constructor.isArrayParameter(i), val);
                            sb.append(", ").append(val);
                        }
                    }
                    sb.append(");\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("});\n");
                }
                this.writeBuilderProperties(sb);
            }
            ViewProcessor.indent(sb, this.indent).append(this.componentClass.typeEl.getQualifiedName()).append(" _cmp = ");
            if (this.builderMethod != null) {
                this.builderMethod.callStatic(sb, this.xmlTag, false);
                sb.append(";\n");
                ViewProcessor.indent(sb, this.indent);
                sb.append("com.codename1.rad.ui.builders.SimpleComponentDecorator<").append(this.componentClass.getQualifiedName()).append("> _builder = new com.codename1.rad.ui.builders.SimpleComponentDecorator<").append(this.componentClass.getQualifiedName()).append(">(_cmp, context, ");
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
            } else if (this.builderClass != null) {
                sb.append("(").append(this.componentClass.getQualifiedName()).append(")").append("_builder.getComponent();\n");
            } else {
                JavaMethodProxy constructor = this.componentClass.getBestConstructor(this.xmlTag);
                if (constructor == null) {
                    throw new XMLParseException("No applicable constructor found for tag " + this.xmlTag.getTagName(), this.xmlTag, null);
                }
                constructor.callAsConstructor(sb, this.xmlTag, false);
                sb.append(";\n");
                ViewProcessor.indent(sb, this.indent);
                sb.append("com.codename1.rad.ui.builders.SimpleComponentDecorator<").append(this.componentClass.getQualifiedName()).append("> _builder = new com.codename1.rad.ui.builders.SimpleComponentDecorator<").append(this.componentClass.getQualifiedName()).append(">(_cmp, context, ");
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
            }
            if (this.isInsideRowTemplate() && ViewProcessor.this.isEntityView(this.jenv.findClassThatTagCreates(this.xmlTag.getTagName()))) {
                sb.append("if (").append(this.jenv.rootBuilder.className).append(".this.rowView == null) {\n");
                sb.append("    ").append(this.jenv.rootBuilder.className).append(".this.rowView = (EntityView)_cmp;\n");
                sb.append("    ").append(this.jenv.rootBuilder.className).append(".this.subContext.setEntityView((EntityView)_cmp);\n");
                sb.append("}\n");
            }
            if (this.isInsideRowTemplate()) {
                ViewProcessor.indent(sb, this.indent).append("EntityView<").append(rowModelType).append("> view = (EntityView<").append(rowModelType).append(">)").append(this.jenv.rootBuilder.className).append(".this.rowView;\n");
                ViewProcessor.indent(sb, this.indent).append("EntityView<").append(rowModelType).append("> rowView = view;\n");
            }
            this.writeProperties(sb);
            this.writeVariables(sb);
            ViewProcessor.indent(sb, this.indent).append("// Create child components\n");
            this.writeChildren(sb);
            ViewProcessor.indent(sb, this.indent).append("// Set up bindings\n");
            this.writeBindings(sb);
            ViewProcessor.indent(sb, this.indent).append("// Set up action Bindings\n");
            this.writeActionBindings(sb);
            if (this.hasViewController) {
                ViewProcessor.indent(sb, this.indent).append("viewController.setView(_cmp);\n");
            }
            if ((varName = this.getVarName()) != null) {
                ViewProcessor.indent(sb, this.indent).append(varName).append(" = ").append("_cmp;\n");
            }
            if (this.xmlTag.hasAttribute("rad-leadComponent")) {
                ViewProcessor.indent(sb, this.indent).append("{\n");
                this.indent += 4;
                ViewProcessor.indent(sb, this.indent).append("com.codename1.ui.ComponentSelector _leadComponentSelector = com.codename1.ui.ComponentSelector.select(\"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getAttribute("rad-leadComponent"))).append("\", _cmp);\n");
                ViewProcessor.indent(sb, this.indent).append("if (!_leadComponentSelector.isEmpty()) {\n");
                ViewProcessor.indent(sb, this.indent).append("    _cmp.setLeadComponent(_leadComponentSelector.asComponent());\n");
                ViewProcessor.indent(sb, this.indent).append("}\n");
                this.indent -= 4;
                ViewProcessor.indent(sb, this.indent).append("}\n");
            }
            ViewProcessor.indent(sb, this.indent).append("return _cmp;\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
        }

        private String getVarName() {
            if (this.xmlTag.hasAttribute("rad-var")) {
                String varName = this.xmlTag.getAttribute("rad-var");
                if (varName.isEmpty()) {
                    return null;
                }
                char firstChar = varName.charAt(0);
                switch (firstChar) {
                    case '#': 
                    case '+': 
                    case '-': {
                        return varName.substring(1);
                    }
                }
                return varName;
            }
            if (this.xmlTag.hasAttribute("id")) {
                return this.xmlTag.getAttribute("id").replace(' ', '_').replace('-', '_');
            }
            if (this.xmlTag.hasAttribute("name")) {
                return this.xmlTag.getAttribute("name").replace(' ', '_').replace('-', '_');
            }
            return null;
        }
    }

    private class JavaNodeBuilder
    extends JavaBuilder {
        private JavaMethodProxy builderMethod;
        private JavaClassProxy builderClass;
        private JavaClassProxy nodeClass;
        private List<JavaNodeBuilder> children;

        JavaNodeBuilder(Element xmlTag, JavaEnvironment jenv, JavaClassProxy builderClass, JavaClassProxy nodeClass) throws ClassNotFoundException {
            this.children = new ArrayList<JavaNodeBuilder>();
            this.xmlTag = xmlTag;
            this.jenv = jenv;
            this.builderMethod = null;
            this.builderClass = builderClass;
            this.nodeClass = this.builderMethod != null ? jenv.newJavaClassProxy(this.builderMethod.getReturnType()) : (nodeClass == null ? jenv.newJavaClassProxy(builderClass.findMethodProxy("getNode", 0).getReturnType()) : nodeClass);
        }

        void writeBuilderMethod(StringBuilder sb) throws XMLParseException {
            ViewProcessor.indent(sb, this.indent).append("private ").append(this.nodeClass.getQualifiedName()).append(" createNode").append(this.xmlTag.getAttribute("rad-id")).append("() {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append("java.util.Map<String,String> attributes = new java.util.HashMap<String,String>();\n");
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int numAtts = attributes.getLength();
            for (int i = 0; i < numAtts; ++i) {
                Attr attribute = (Attr)attributes.item(i);
                ViewProcessor.indent(sb, this.indent).append(" attributes.put(\"").append(StringEscapeUtils.escapeJava((String)attribute.getName())).append("\", \"").append(StringEscapeUtils.escapeJava((String)attribute.getValue())).append("\");\n");
            }
            if (this.builderClass != null) {
                ViewProcessor.indent(sb, this.indent).append(this.builderClass.getQualifiedName()).append(" _builder = ").append("new ").append(this.builderClass.getQualifiedName()).append("(context, \"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
            }
            ViewProcessor.indent(sb, this.indent).append(this.nodeClass.typeEl.getQualifiedName()).append(" _node = ");
            if (this.builderMethod != null) {
                this.builderMethod.callStatic(sb, this.xmlTag, false);
                sb.append(";\n");
                ViewProcessor.indent(sb, this.indent).append("com.codename1.rad.ui.builders.SimpleNodeBuilder<").append(this.nodeClass.getQualifiedName()).append("> _builder = new com.codename1.rad.ui.builders.SimpleNodeBuilder<").append(this.nodeClass.getQualifiedName()).append(">(_node, context, ");
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
            } else if (this.builderClass != null) {
                sb.append("_builder.getNode();\n");
            } else {
                sb.append("new ").append(this.nodeClass.getQualifiedName()).append("();\n");
                ViewProcessor.indent(sb, this.indent).append("com.codename1.rad.ui.builders.SimpleNodeBuilder<").append(this.nodeClass.getQualifiedName()).append("> _builder = new com.codename1.rad.ui.builders.SimpleNodeBuilder<").append(this.nodeClass.getQualifiedName()).append(">(_node, context, ");
                sb.append("\"").append(StringEscapeUtils.escapeJava((String)this.xmlTag.getTagName())).append("\", attributes);\n");
            }
            this.writeProperties(sb);
            this.writeVariables(sb);
            ViewProcessor.indent(sb, this.indent).append("// Create child nodes\n");
            this.writeChildren(sb);
            ViewProcessor.indent(sb, this.indent).append("return _node;\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
        }

        void writeProperties(StringBuilder sb) {
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int len = attributes.getLength();
            ArrayList<Attr> attributesList = new ArrayList<Attr>();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                attributesList.add(attr);
            }
            Collections.sort(attributesList, new AttributeComparator());
            for (Attr attr : attributesList) {
                String name = attr.getName();
                String value = attr.getValue();
                if (name.contains("-") || name.startsWith("_") && name.endsWith("_")) continue;
                ViewProcessor.indent(sb, this.indent);
                sb.append("// ").append(name).append("=").append(value).append("\n");
                ViewProcessor.indent(sb, this.indent);
                if (name.contains(".") || this.builderClass == null) {
                    this.nodeClass.setProperty(sb, attr, "_node");
                } else {
                    this.builderClass.setProperty(sb, attr, "_builder");
                }
                sb.append("\n");
            }
        }

        void writeChildren(StringBuilder sb) {
            NodeList childNodes = this.xmlTag.getChildNodes();
            int numChildNodes = childNodes.getLength();
            ViewProcessor.indent(sb, this.indent).append("// ").append(numChildNodes).append(" child nodes\n");
            for (int i = 0; i < numChildNodes; ++i) {
                Element childEl;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || (childEl = (Element)child).hasAttribute("rad-used-for")) continue;
                String propertyName = childEl.getAttribute("rad-property");
                String childId = childEl.getAttribute("rad-id");
                String createNodeCall = "createNode" + childId + "()";
                if (propertyName != null && !propertyName.isEmpty()) {
                    ViewProcessor.indent(sb, this.indent).append("// Set property ").append(propertyName).append(" with child tag ").append(childEl.getTagName()).append("\n");
                    ViewProcessor.indent(sb, this.indent);
                    if (propertyName.contains(".") || this.builderClass == null) {
                        this.nodeClass.setProperty(sb, propertyName, "java:" + createNodeCall, "_node", "com.codename1.rad.nodes.Node");
                    } else {
                        this.builderClass.setProperty(sb, propertyName, "java:" + createNodeCall, "_node", "com.codename1.rad.nodes.Node");
                    }
                    sb.append("\n");
                    continue;
                }
                if (childEl.getTagName().equalsIgnoreCase("var")) continue;
                if (childEl.getTagName().equalsIgnoreCase("script")) {
                    ViewProcessor.indent(sb, this.indent).append("// <script> tag\n");
                    ViewProcessor.indent(sb, this.indent).append("script").append(childEl.getAttribute("rad-id")).append("(_cmp);\n");
                    continue;
                }
                ViewProcessor.indent(sb, this.indent).append("// Child tag ").append(childEl.getTagName()).append(" is type ").append(this.jenv.findClassThatTagCreates(childEl.getTagName())).append("\n");
                if (!this.jenv.isNodeTag(childEl.getTagName(), true)) continue;
                ViewProcessor.indent(sb, this.indent).append("// Add child node ").append(" with child tag ").append(childEl.getTagName()).append("\n");
                ViewProcessor.indent(sb, this.indent).append("_node.setAttributes(createNode").append(childEl.getAttribute("rad-id")).append("());\n");
            }
        }
    }

    private class JavaBeanBuilder
    extends JavaBuilder {
        private JavaClassProxy beanClass;
        private List<JavaNodeBuilder> children;

        JavaBeanBuilder(Element xmlTag, JavaEnvironment jenv, JavaClassProxy beanClass) throws ClassNotFoundException {
            this.children = new ArrayList<JavaNodeBuilder>();
            this.xmlTag = xmlTag;
            this.jenv = jenv;
            JavaClassProxy javaClassProxy = this.beanClass = beanClass == null ? jenv.newJavaClassProxy(jenv.findClassThatTagCreates(xmlTag.getTagName())) : beanClass;
            if (beanClass.typeEl.getKind() == ElementKind.INTERFACE) {
                if (beanClass.getQualifiedName().equals("com.codename1.rad.models.Entity")) {
                    TypeElement implementationClass = jenv.lookupClass("com.codename1.rad.models.BaseEntity");
                    if (implementationClass != null && ViewProcessor.this.isA(implementationClass, beanClass.typeEl.getQualifiedName().toString())) {
                        beanClass = jenv.newJavaClassProxy(implementationClass);
                    }
                } else {
                    TypeElement implementationClass = jenv.lookupClass(beanClass.typeEl.getQualifiedName() + "Impl");
                    if (implementationClass != null && ViewProcessor.this.isA(implementationClass, beanClass.typeEl.getQualifiedName().toString())) {
                        beanClass = jenv.newJavaClassProxy(implementationClass);
                    }
                }
            }
        }

        void writeBuilderMethod(StringBuilder sb) throws XMLParseException {
            ViewProcessor.indent(sb, this.indent).append("private ").append(this.beanClass.getQualifiedName()).append(" createBean").append(this.xmlTag.getAttribute("rad-id")).append("() {\n");
            this.indent += 4;
            ViewProcessor.indent(sb, this.indent).append(this.beanClass.typeEl.getQualifiedName()).append(" _bean = ");
            JavaMethodProxy constructor = this.beanClass.getBestConstructor(this.xmlTag);
            if (constructor == null) {
                System.out.println("Bean class: " + this.beanClass.typeEl);
                System.out.println("XML tag: " + this.xmlTag);
                System.out.println("Class that tag creates: " + this.jenv.findClassThatTagCreates(this.xmlTag.getTagName()));
                throw new XMLParseException("[" + this.jenv.rootBuilder.className + "] Cannot find suitable constructor to build tag " + this.xmlTag.getTagName() + " with class beanClass " + this.beanClass.typeEl.getQualifiedName(), this.xmlTag, null);
            }
            constructor.callAsConstructor(sb, this.xmlTag, false);
            sb.append(";\n");
            this.writeProperties(sb);
            this.writeVariables(sb);
            ViewProcessor.indent(sb, this.indent).append("// Create child nodes\n");
            this.writeChildren(sb);
            ViewProcessor.indent(sb, this.indent).append("return _bean;\n");
            this.indent -= 4;
            ViewProcessor.indent(sb, this.indent).append("}\n");
        }

        void writeProperties(StringBuilder sb) {
            String textContent;
            if (this.beanClass != null) {
                HashSet<String> propertiesInjected = new HashSet<String>();
                for (ExecutableElement setter : this.beanClass.findInjectableSetters()) {
                    String setterName = setter.getSimpleName().toString();
                    if (ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, setterName)) continue;
                    String propName = setterName;
                    if ((!setterName.startsWith("set") ? ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, "set" + propName) : ViewProcessor.this.hasAttributeIgnoreCase(this.xmlTag, propName = setterName.substring(3))) || propertiesInjected.contains(propName.toLowerCase())) continue;
                    propertiesInjected.add(propName.toLowerCase());
                    ExecutableType et = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.beanClass.typeEl.asType(), setter);
                    TypeMirror propertyType = et.getParameterTypes().get(0);
                    ViewProcessor.indent(sb, this.indent).append("{\n");
                    this.indent += 4;
                    ViewProcessor.indent(sb, this.indent).append(propertyType).append(" _injectedValue = ");
                    this.jenv.writeInjectedValue(sb, (TypeElement)((DeclaredType)propertyType).asElement(), this.xmlTag, propName, true);
                    sb.append(";\n");
                    ViewProcessor.indent(sb, this.indent).append("if (_injectedValue != null) ").append("_bean.").append(setter.getSimpleName()).append("((").append(propertyType.toString()).append(")_injectedValue);\n");
                    this.indent -= 4;
                    ViewProcessor.indent(sb, this.indent).append("}\n");
                }
            }
            if ((textContent = ViewProcessor.getTextContent(this.xmlTag)) != null && !textContent.isEmpty()) {
                ExecutableElement setText;
                ExecutableElement executableElement = setText = this.beanClass != null ? this.beanClass.findSetter("text", "java.lang.String") : null;
                if (setText != null) {
                    ViewProcessor.indent(sb, this.indent);
                    this.beanClass.setProperty(sb, "text", textContent.trim(), "_bean");
                    sb.append("\n");
                }
            }
            NamedNodeMap attributes = this.xmlTag.getAttributes();
            int len = attributes.getLength();
            ArrayList<Attr> attributesList = new ArrayList<Attr>();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                attributesList.add(attr);
            }
            Collections.sort(attributesList, new AttributeComparator());
            for (Attr attr : attributesList) {
                String name = attr.getName();
                if (name.startsWith("_") && name.endsWith("_") || name.contains("-")) continue;
                String value = attr.getValue();
                ViewProcessor.indent(sb, this.indent);
                sb.append("// ").append(name).append("=").append(value).append("\n");
                ViewProcessor.indent(sb, this.indent);
                this.beanClass.setProperty(sb, attr, "_bean");
                sb.append("\n");
            }
        }

        void writeChildren(StringBuilder sb) {
            NodeList childNodes = this.xmlTag.getChildNodes();
            int numChildNodes = childNodes.getLength();
            ViewProcessor.indent(sb, this.indent).append("// ").append(numChildNodes).append(" child nodes\n");
            for (int i = 0; i < numChildNodes; ++i) {
                Element childEl;
                Node child = childNodes.item(i);
                if (!(child instanceof Element) || (childEl = (Element)child).hasAttribute("rad-used-for")) continue;
                String propertyName = childEl.getAttribute("rad-property");
                String childId = childEl.getAttribute("rad-id");
                String createBeanCall = "createBean" + childId + "()";
                if (propertyName != null && !propertyName.isEmpty()) {
                    ViewProcessor.indent(sb, this.indent).append("// Set property ").append(propertyName).append(" with child tag ").append(childEl.getTagName()).append("\n");
                    ViewProcessor.indent(sb, this.indent);
                    if (this.jenv.isComponentTag(childEl.getTagName())) {
                        createBeanCall = "createComponent" + childId + "()";
                    } else if (this.jenv.isNodeTag(childEl.getTagName(), false)) {
                        createBeanCall = "createNode" + childId + "()";
                    }
                    this.beanClass.setProperty(sb, propertyName, "java:" + createBeanCall, "_bean", null);
                    sb.append("\n");
                    continue;
                }
                if (childEl.getTagName().equalsIgnoreCase("var")) continue;
                if (childEl.getTagName().equalsIgnoreCase("script")) {
                    ViewProcessor.indent(sb, this.indent).append("// <script> tag\n");
                    ViewProcessor.indent(sb, this.indent).append("script").append(childEl.getAttribute("rad-id")).append("(_cmp);\n");
                    continue;
                }
                TypeElement type = this.jenv.findClassThatTagCreates(childEl.getTagName());
                if (type == null || !this.jenv.rootBuilder.containsBeanBuilderFor(type.getQualifiedName())) continue;
                ViewProcessor.indent(sb, this.indent).append("// Create bean ").append(type.getQualifiedName()).append("\n");
                ViewProcessor.indent(sb, this.indent).append("createBean").append(childEl.getAttribute("rad-id")).append("();\n");
            }
        }
    }

    private class JavaBuilder {
        protected JavaEnvironment jenv;
        protected int indent = 0;
        protected Element xmlTag;

        private JavaBuilder() {
        }

        void writeVariables(StringBuilder sb) {
            this.writeVariables(sb, this.xmlTag);
        }

        void writeVariables(StringBuilder sb, Element el) {
            NodeList childNodes = el.getChildNodes();
            int numChildNodes = childNodes.getLength();
            ViewProcessor.indent(sb, this.indent).append("// ").append(numChildNodes).append(" child nodes\n");
            for (int i = 0; i < numChildNodes; ++i) {
                Node n = childNodes.item(i);
                if (!(n instanceof Element)) continue;
                Element childEl = (Element)childNodes.item(i);
                if (childEl.getTagName().equalsIgnoreCase("private") || childEl.getTagName().equalsIgnoreCase("public") || childEl.getTagName().equalsIgnoreCase("protected")) {
                    this.writeVariables(sb, childEl);
                    continue;
                }
                if (!childEl.getTagName().equalsIgnoreCase("var")) continue;
                if (childEl.hasAttribute("lookup") && childEl.hasAttribute("name")) {
                    ViewProcessor.indent(sb, this.indent).append(childEl.getAttribute("name")).append("=").append("getContext().getController().lookup(").append(childEl.getAttribute("lookup")).append(".class);\n");
                    continue;
                }
                if (childEl.hasAttribute("value") && childEl.hasAttribute("name")) {
                    String value = childEl.getAttribute("value");
                    if (value.startsWith("string:")) {
                        value = "\"" + StringEscapeUtils.escapeJava((String)value.substring(value.indexOf(":") + 1)) + "\"";
                    } else if (value.startsWith("java:")) {
                        value = value.substring(value.indexOf(":") + 1);
                    }
                    ViewProcessor.indent(sb, this.indent).append(childEl.getAttribute("name")).append("=").append(value).append(";\n");
                    continue;
                }
                ViewProcessor.indent(sb, this.indent).append("// <var name='").append(childEl.getAttribute("name")).append("'> skipped because no value or lookup key specified\n");
            }
        }
    }

    private class JavaMethodProxy {
        private JavaClassProxy classProxy;
        private String methodName;
        private ExecutableElement methodEl;
        private ExecutableType executableType;

        JavaMethodProxy(JavaClassProxy classProxy, String methodName, int numParams) throws NoSuchMethodException {
            if (classProxy == null) {
                throw new IllegalArgumentException("JavaMethodProxy constructor requires non-null classProxy");
            }
            this.classProxy = classProxy;
            this.methodName = methodName;
            this.methodEl = classProxy.findMethod(methodName, numParams);
            if (this.methodEl == null) {
                throw new NoSuchMethodException(methodName);
            }
        }

        JavaMethodProxy(JavaClassProxy classProxy, ExecutableElement methodEl) {
            this.classProxy = classProxy;
            if (this.classProxy == null) {
                throw new IllegalArgumentException("JavaMethodProxy constructor requires non-null classProxy");
            }
            this.methodName = methodEl.getSimpleName().toString();
            this.methodEl = methodEl;
        }

        public String toString() {
            return "JavaMethodProxy{classProxy=" + this.classProxy + ", methodName='" + this.methodName + '\'' + ", methodEl=" + this.methodEl + ", executableType=" + this.executableType + '}';
        }

        ExecutableType executableType() {
            if (this.executableType == null) {
                this.executableType = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.classProxy.typeEl.asType(), this.methodEl);
            }
            return this.executableType;
        }

        TypeElement getReturnType() {
            switch (this.methodEl.getReturnType().getKind()) {
                case VOID: {
                    return null;
                }
            }
            ExecutableType et = this.executableType();
            return ViewProcessor.this.toTypeElement(this.executableType().getReturnType());
        }

        ExecutableType getExecutableType() {
            ExecutableType et = (ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.classProxy.typeEl.asType(), this.methodEl);
            return et;
        }

        TypeElement getParameterType(int paramIndex) {
            if (this.methodEl.getParameters().size() <= paramIndex) {
                throw new IllegalArgumentException("Cannot get parameter " + paramIndex + " from " + this.methodEl + " because it only has " + this.methodEl.getParameters().size() + " parameters");
            }
            return this.getParameterTypes().get(paramIndex);
        }

        boolean isParameterInjectable(int index) {
            return this.methodEl.getParameters().get(index).getAnnotation(Inject.class) != null;
        }

        boolean isArrayParameter(int index) {
            List<? extends TypeMirror> mirrors = this.getExecutableType().getParameterTypes();
            return mirrors.get(index).getKind() == TypeKind.ARRAY;
        }

        List<TypeElement> getParameterTypes() {
            List<? extends TypeMirror> mirrors = this.getExecutableType().getParameterTypes();
            ArrayList<TypeElement> out = new ArrayList<TypeElement>(mirrors.size());
            for (TypeMirror typeMirror : mirrors) {
                TypeElement el = ViewProcessor.this.toTypeElement(typeMirror, true);
                if (el == null) {
                    throw new IllegalStateException("Failed to find type element for TypeMirror " + typeMirror + " kind=" + (Object)((Object)typeMirror.getKind()) + ", method=" + this.methodEl);
                }
                out.add(el);
            }
            return out;
        }

        int getNumParams() {
            return this.methodEl.getParameters().size();
        }

        List<String> getParameterNames() {
            List<? extends VariableElement> params = this.methodEl.getParameters();
            if (params == null) {
                throw new IllegalStateException("method getParameters() returned null for method " + this.methodEl + " of class " + this.classProxy.typeEl);
            }
            ArrayList<String> out = new ArrayList<String>(params.size());
            for (VariableElement variableElement : params) {
                out.add(variableElement.getSimpleName().toString());
            }
            return out;
        }

        void callAsConstructor(StringBuilder appendTo, Element xmlTag, boolean allowNullParams) {
            appendTo.append("new ").append(this.classProxy.getQualifiedName()).append("(");
            this.writeCallParams(appendTo, xmlTag, allowNullParams);
            appendTo.append(")");
        }

        void callStatic(StringBuilder appendTo, Element xmlTag, boolean allowNullParams) {
            appendTo.append(this.classProxy.getQualifiedName()).append(".").append(this.methodEl.getSimpleName()).append("(");
            this.writeCallParams(appendTo, xmlTag, allowNullParams);
            appendTo.append(")");
        }

        void writeCallParams(StringBuilder appendTo, Element xmlTag) {
            this.writeCallParams(appendTo, xmlTag, false);
        }

        void writeCallParams(StringBuilder appendTo, Element xmlTag, boolean allowNull) {
            List<String> paramNames = this.getParameterNames();
            List<TypeElement> paramTypes = this.getParameterTypes();
            int numParams = paramNames.size();
            for (int i = 0; i < numParams; ++i) {
                String arrayParamPrefix = "";
                String arrayParamSuffix = "";
                if (i > 0) {
                    appendTo.append(", ");
                }
                this.classProxy.env.writeInjectedValue(appendTo, this.getParameterType(i), xmlTag, String.valueOf(i), this.isParameterInjectable(i));
            }
        }
    }

    private static enum ImageScale {
        None,
        Scale,
        ScaleToFill;

    }

    public static enum ImageMask {
        None,
        Circle,
        RoundRect;

    }

    public class ImageParameters {
        private String url;
        private String width;
        private String height;
        private ImageMask mask = ImageMask.None;
        private ImageScale scale = ImageScale.Scale;
        private String aspect = "1.85";
        private String rawUrl;

        ImageParameters(String str) {
            this.rawUrl = str;
            this.url = str;
            int spacePos = str.indexOf(" ");
            if (spacePos > 0) {
                String params = str.substring(spacePos + 1).trim();
                this.url = str.substring(0, spacePos);
                StringTokenizer strtok = new StringTokenizer(params, ";");
                while (strtok.hasMoreTokens()) {
                    String value;
                    String nextTok = strtok.nextToken().trim();
                    int colonPos = nextTok.indexOf(":");
                    String key = colonPos > 0 ? nextTok.substring(0, colonPos).trim() : nextTok;
                    String string = value = colonPos > 0 ? nextTok.substring(colonPos + 1).trim() : null;
                    if ("width".equals(key)) {
                        this.width = ViewProcessor.this.isScalar(value) ? ViewProcessor.this.formatScalarAsArgumentValue(value) : value;
                        continue;
                    }
                    if ("height".equals(key)) {
                        this.height = ViewProcessor.this.isScalar(value) ? ViewProcessor.this.formatScalarAsArgumentValue(value) : value;
                        continue;
                    }
                    if ("mask".equals(key)) {
                        if ("circle".equalsIgnoreCase(value)) {
                            this.mask = ImageMask.Circle;
                            continue;
                        }
                        if (!"roundrect".equalsIgnoreCase(value)) continue;
                        this.mask = ImageMask.RoundRect;
                        continue;
                    }
                    if ("scale".equals(key)) {
                        if ("fill".equalsIgnoreCase(value)) {
                            this.scale = ImageScale.ScaleToFill;
                            continue;
                        }
                        if (!"none".equalsIgnoreCase(value)) continue;
                        this.scale = ImageScale.None;
                        continue;
                    }
                    if (!"aspect".equals(key)) continue;
                    this.aspect = value;
                }
            }
        }

        void writeAsURLImage(StringBuilder buf, JavaEnvironment jenv) {
            String adapterParam;
            String storageKey;
            String w = this.width;
            String h = this.height;
            if (w == null && h != null) {
                w = this.mask == ImageMask.Circle ? h : "(int)Math.round(" + this.aspect + "*" + h + ")";
            } else if (w != null && h == null) {
                h = this.mask == ImageMask.Circle ? w : "(int)Math.round(" + w + "/" + this.aspect + ")";
            } else if (w == null && h == null) {
                h = "100";
                w = "100";
            }
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update((this.rawUrl + w + h + (Object)((Object)this.mask) + (Object)((Object)this.scale)).toString().getBytes("utf-8"));
                byte[] digest = md.digest();
                storageKey = "urlImage@" + Base64.getEncoder().encodeToString(digest);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ViewProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create checksum for URL image storage key of " + this.rawUrl, jenv.rootBuilder.parentClass);
                storageKey = "urlImage@null";
            }
            block1 : switch (this.mask) {
                case Circle: {
                    adapterParam = "com.codename1.rad.ui.image.ImageUtil.createRoundMaskAdapter(" + w + ")";
                    break;
                }
                case RoundRect: {
                    String cacheid = "RoundRect" + w + "x" + h;
                    adapterParam = "com.codename1.rad.ui.image.ImageUtil.createRoundRectMaskAdapter(2f, " + w + ", " + h + ")";
                    break;
                }
                default: {
                    switch (this.scale) {
                        case Scale: {
                            adapterParam = "com.codename1.ui.URLImage.RESIZE_SCALE";
                            break block1;
                        }
                        case ScaleToFill: {
                            adapterParam = "com.codename1.ui.URLImage.RESIZE_SCALE_TO_FILL";
                            break block1;
                        }
                    }
                    adapterParam = "null";
                }
            }
            buf.append("com.codename1.rad.ui.UI.createImageToStorage(\"").append(StringEscapeUtils.escapeJava((String)this.url)).append("\", ").append("com.codename1.rad.ui.image.ImageUtil.createPlaceholder(").append(w).append(",").append(h).append("), \"").append(StringEscapeUtils.escapeJava((String)storageKey)).append("\", ").append(adapterParam).append(")");
        }
    }

    public class MediaParameters {
        private String url;
        private String mimeType;
        private String rawUrl;

        MediaParameters(String str) {
            this.rawUrl = str;
            this.url = str;
            int spacePos = str.indexOf(" ");
            if (spacePos > 0) {
                String params = str.substring(spacePos + 1).trim();
                this.url = str.substring(0, spacePos);
                StringTokenizer strtok = new StringTokenizer(params, ";");
                while (strtok.hasMoreTokens()) {
                    String value;
                    String nextTok = strtok.nextToken().trim();
                    int colonPos = nextTok.indexOf(":");
                    String key = colonPos > 0 ? nextTok.substring(0, colonPos).trim() : nextTok;
                    String string = value = colonPos > 0 ? nextTok.substring(colonPos + 1).trim() : null;
                    if ("mimetype".equalsIgnoreCase(key)) {
                        this.mimeType = value;
                        continue;
                    }
                    if (value != null) continue;
                    this.mimeType = key;
                }
            }
        }

        void writeAsURLMedia(StringBuilder buf, JavaEnvironment jenv) {
            String mime = this.mimeType;
            if (mime == null) {
                String baseUrl = this.url.toLowerCase();
                if (baseUrl.indexOf(63) > 0) {
                    baseUrl = baseUrl.substring(0, baseUrl.indexOf(63));
                }
                mime = baseUrl.endsWith(".mp4") ? "video/mp4" : (baseUrl.endsWith(".mp3") ? "audio/mpeg" : (baseUrl.endsWith(".wav") ? "audio/wav" : (baseUrl.endsWith(".aac") ? "audio/aac" : (baseUrl.endsWith(".avi") ? "audio/avi" : (baseUrl.endsWith(".mpeg") ? "video/mpeg" : (baseUrl.endsWith(".oga") ? "audio/ogg" : (baseUrl.endsWith(".ogv") ? "video/ogg" : (baseUrl.endsWith(".opus") ? "audio/opus" : (baseUrl.endsWith(".ts") ? "video/mp2t" : (baseUrl.endsWith(".weba") ? "audio/webm" : (baseUrl.endsWith(".webm") ? "video/webm" : (baseUrl.endsWith(".3gp") ? "video/3gpp" : (baseUrl.endsWith(".3g2") ? "video/3gpp2" : null)))))))))))));
            }
            if (mime != null) {
                mime = "\"" + StringEscapeUtils.escapeJava((String)mime) + "\"";
            }
            buf.append("NonNull.suppressErrors(com.codename1.media.Media.class, () -> {");
            buf.append("return com.codename1.media.MediaManager.createMedia(\"").append(StringEscapeUtils.escapeJava((String)this.url)).append("\", ").append(mime).append(")");
            buf.append("})");
        }
    }

    public class AttributeSanitizer {
        private final JavaEnvironment env;

        public AttributeSanitizer(JavaEnvironment env) {
            this.env = env;
        }

        public String sanitize(TypeElement parameterType, VariableElement paramVar, boolean isArray, String value) {
            boolean treatAsString;
            boolean bl = treatAsString = !isArray && ViewProcessor.this.isA(parameterType, "java.lang.String") || value.startsWith("string:");
            if (value.startsWith("java:")) {
                treatAsString = false;
            }
            if (value.startsWith("java:") || value.startsWith("string:")) {
                value = value.substring(value.indexOf(":") + 1);
            }
            if (!treatAsString) {
                List enumValues = parameterType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
                String fValue = value;
                String enumConstant = enumValues.stream().filter(s -> s.equalsIgnoreCase(fValue)).findFirst().orElse(null);
                if (enumConstant != null) {
                    value = parameterType.getQualifiedName() + "." + enumConstant;
                } else if (parameterType.getQualifiedName().contentEquals("com.codename1.ui.Image") && (value.startsWith("http://") || value.startsWith("https://") || value.startsWith("jar://"))) {
                    ImageParameters imageParams = new ImageParameters(value);
                    StringBuilder imageParamsBuilder = new StringBuilder();
                    imageParams.writeAsURLImage(imageParamsBuilder, this.env);
                    value = imageParamsBuilder.toString();
                } else if (parameterType.getQualifiedName().contentEquals("com.codename1.media.Media") && (value.startsWith("http://") || value.startsWith("https://") || value.startsWith("jar://"))) {
                    MediaParameters mediaParams = new MediaParameters(value);
                    StringBuilder mediaParamBuilder = new StringBuilder();
                    mediaParams.writeAsURLMedia(mediaParamBuilder, this.env);
                    value = mediaParamBuilder.toString();
                } else if ((value.startsWith("csv:") || value.startsWith("strings:")) && parameterType.getQualifiedName().contentEquals("java.lang.String") && isArray) {
                    StringBuilder csvBuilder = new StringBuilder();
                    String csvValues = value.substring(value.indexOf(":") + 1);
                    StringTokenizer strtok = new StringTokenizer(csvValues, ",");
                    boolean first = true;
                    csvBuilder.append("new String[]{");
                    while (strtok.hasMoreTokens()) {
                        String nextTok = strtok.nextToken().trim();
                        if (first) {
                            first = false;
                        } else {
                            csvBuilder.append(", ");
                        }
                        csvBuilder.append("\"").append(StringEscapeUtils.escapeJava((String)nextTok)).append("\"");
                    }
                    csvBuilder.append("}");
                    value = csvBuilder.toString();
                } else if ((value.startsWith("csv:") || value.startsWith("strings:")) && ViewProcessor.this.isStringListModel(parameterType, paramVar)) {
                    StringBuilder csvBuilder = new StringBuilder();
                    String csvValues = value.substring(value.indexOf(":") + 1);
                    StringTokenizer strtok = new StringTokenizer(csvValues, ",");
                    boolean first = true;
                    if (ViewProcessor.this.isA(parameterType, "com.codename1.ui.list.MultipleSelectionListModel")) {
                        csvBuilder.append("com.codename1.rad.ui.builders.ButtonListPropertyViewBuilder.createMultipleSelectionListModel(String.class, ");
                    } else {
                        csvBuilder.append("com.codename1.rad.ui.builders.ButtonListPropertyViewBuilder.createSingleSelectionListModel(String.class, ");
                    }
                    while (strtok.hasMoreTokens()) {
                        String nextTok = strtok.nextToken().trim();
                        if (first) {
                            first = false;
                        } else {
                            csvBuilder.append(", ");
                        }
                        csvBuilder.append("\"").append(StringEscapeUtils.escapeJava((String)nextTok)).append("\"");
                    }
                    csvBuilder.append(")");
                    value = csvBuilder.toString();
                } else if ((value.startsWith("list:") || value.startsWith("objects:")) && isArray) {
                    StringBuilder csvBuilder = new StringBuilder();
                    String csvValues = value.substring(value.indexOf(":") + 1);
                    StringTokenizer strtok = new StringTokenizer(csvValues, ",");
                    boolean first = true;
                    csvBuilder.append("new ").append(parameterType.getQualifiedName()).append("[]{");
                    while (strtok.hasMoreTokens()) {
                        String nextTok = strtok.nextToken().trim();
                        if (first) {
                            first = false;
                        } else {
                            csvBuilder.append(", ");
                        }
                        csvBuilder.append(nextTok);
                    }
                    csvBuilder.append("}");
                    value = csvBuilder.toString();
                } else if (ViewProcessor.this.isScalar(value)) {
                    value = ViewProcessor.this.formatScalarAsArgumentValue(value);
                } else if (parameterType.getQualifiedName().contentEquals("com.codename1.ui.Font") && ViewProcessor.this.isFontLiteral(value)) {
                    value = ViewProcessor.this.formatFontAsArgumentValue(value);
                }
            }
            value = treatAsString ? ViewProcessor.this.expandRADModelVars(this.env, value, true) : ViewProcessor.this.expandRADModelVars(this.env, value, false);
            return value;
        }
    }

    private class JavaClassProxy {
        private String className;
        private TypeElement typeEl;
        private JavaEnvironment env;
        private JavaClassType classType;
        private List<ExecutableElement> setters = null;
        private List<ExecutableElement> getters = null;
        List<ExecutableElement> methods = null;

        String getQualifiedName() {
            return this.typeEl.getQualifiedName().toString();
        }

        JavaClassType getClassType() {
            if (this.classType == null) {
                this.classType = ViewProcessor.this.isComponent(this.typeEl) ? JavaClassType.COMPONENT : (ViewProcessor.this.isA(this.typeEl, "com.codename1.rad.models.Entity") ? JavaClassType.ENTITY : (ViewProcessor.this.isNode(this.typeEl) ? JavaClassType.NODE : JavaClassType.OTHER));
            }
            return this.classType;
        }

        public String toString() {
            return this.typeEl.toString();
        }

        boolean isEntity() {
            return this.getClassType() == JavaClassType.ENTITY;
        }

        boolean isComponent() {
            return this.getClassType() == JavaClassType.COMPONENT;
        }

        boolean isNode() {
            return this.getClassType() == JavaClassType.NODE;
        }

        String getSimpleName() {
            return this.typeEl.getSimpleName().toString();
        }

        boolean isComponentBuilder() {
            return ViewProcessor.this.isA(this.typeEl, "com.codename1.rad.ui.ComponentBuilder");
        }

        JavaClassProxy(String className, JavaEnvironment env) throws ClassNotFoundException {
            this.className = className;
            this.env = env;
            if (env == null) {
                throw new IllegalArgumentException("JavaClassProxy constructor requires non-null JavaEnvironment");
            }
            this.typeEl = env.findClassBySimpleName(className);
            if (this.typeEl == null) {
                throw new ClassNotFoundException();
            }
        }

        JavaClassProxy(TypeElement typeEl, JavaEnvironment jenv) {
            this.className = typeEl.getSimpleName().toString();
            this.env = jenv;
            if (this.env == null) {
                throw new IllegalArgumentException("JavaClassProxy constructor requires non-null JavaEnvironment");
            }
            this.typeEl = typeEl;
        }

        List<ExecutableElement> findSetters() {
            if (this.setters == null) {
                this.setters = this.findMethods().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getParameters().size() == 1).collect(Collectors.toList());
            }
            return this.setters;
        }

        List<ExecutableElement> findSetters(String propertyName) {
            return this.findSetters().stream().filter(e -> e.getKind() == ElementKind.METHOD && (e.getSimpleName().toString().equalsIgnoreCase(propertyName) || e.getSimpleName().toString().equalsIgnoreCase("set" + propertyName)) && e.getParameters().size() == 1).collect(Collectors.toList());
        }

        List<ExecutableElement> findInjectableSetters() {
            return this.findSetters().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getParameters().size() == 1 && e.getParameters().get(0).getAnnotation(Inject.class) != null).collect(Collectors.toList());
        }

        List<ExecutableElement> findInjectableSettersForType(TypeElement type) {
            return this.findSetters().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getParameters().size() == 1 && e.getParameters().get(0).getAnnotation(Inject.class) != null && ViewProcessor.this.isA(type, ((ExecutableType)ViewProcessor.this.types().asMemberOf((DeclaredType)this.typeEl.asType(), (javax.lang.model.element.Element)e)).getParameterTypes().get(0).toString())).collect(Collectors.toList());
        }

        List<ExecutableElement> findGetters() {
            if (this.getters == null) {
                this.getters = this.findMethods().stream().filter(e -> e.getKind() == ElementKind.METHOD && e.getParameters().size() == 0 && e.getReturnType().getKind() != TypeKind.VOID).collect(Collectors.toList());
            }
            return this.getters;
        }

        List<ExecutableElement> findGetters(String propertyName) {
            return this.findGetters().stream().filter(e -> e.getKind() == ElementKind.METHOD && (e.getSimpleName().toString().equalsIgnoreCase(propertyName) || e.getSimpleName().toString().equalsIgnoreCase("get" + propertyName) || e.getSimpleName().toString().equalsIgnoreCase("is" + propertyName)) && e.getParameters().size() == 0 && e.getReturnType().getKind() != TypeKind.VOID).collect(Collectors.toList());
        }

        ExecutableElement findSetter(String propertyName, String ... type) {
            for (String t : type) {
                ExecutableElement out = this.findSetters(propertyName).stream().filter(e -> e.getParameters().get(0).asType().toString().equalsIgnoreCase(t) || ViewProcessor.this.isA(e.getParameters().get(0).asType(), t)).findAny().orElse(null);
                if (out == null) continue;
                return out;
            }
            return this.findSetters(propertyName).stream().findAny().orElse(null);
        }

        ExecutableElement findGetter(String propertyName, String ... type) {
            for (String t : type) {
                ExecutableElement out = this.findGetters(propertyName).stream().filter(e -> e.getParameters().get(0).asType().toString().equalsIgnoreCase(t) || ViewProcessor.this.isA(e.getParameters().get(0).asType(), t)).findAny().orElse(null);
                if (out == null) continue;
                return out;
            }
            return this.findGetters(propertyName).stream().findAny().orElse(null);
        }

        JavaMethodProxy findGetterProxy(String propertyName, String ... type) {
            ExecutableElement getter = this.findGetter(propertyName, type);
            if (getter == null) {
                return null;
            }
            return this.findMethodProxy(getter.getSimpleName().toString(), 0);
        }

        List<ExecutableElement> findMethods() {
            if (this.methods == null) {
                this.methods = ViewProcessor.this.elements().getAllMembers(this.typeEl).stream().filter(e -> e.getKind() == ElementKind.METHOD).collect(Collectors.toList());
            }
            return this.methods;
        }

        ExecutableElement findMethod(String methodName, int numParams) {
            return ViewProcessor.this.elements().getAllMembers(this.typeEl).stream().filter(e -> e.getKind() == ElementKind.METHOD && methodName.equalsIgnoreCase(e.getSimpleName().toString()) && ((ExecutableElement)e).getParameters().size() == numParams).findAny().orElse(null);
        }

        JavaMethodProxy findMethodProxy(String methodName, int numParams) {
            ExecutableElement el = this.findMethod(methodName, numParams);
            if (el == null) {
                return null;
            }
            return new JavaMethodProxy(this, el);
        }

        Element createXmlTag() {
            return this.env.rootElement.getOwnerDocument().createElement(this.typeEl.getSimpleName().toString());
        }

        JavaMethodProxy getBestConstructor(Element xmlTag) {
            Comparator comparator = (c1, c2) -> ((JavaMethodProxy)c2).methodEl.getParameters().size() - ((JavaMethodProxy)c1).methodEl.getParameters().size();
            List<JavaMethodProxy> constructors = this.getEligibleConstructors(xmlTag);
            constructors.sort(comparator);
            if (constructors.isEmpty()) {
                return null;
            }
            return constructors.get(0);
        }

        List<JavaMethodProxy> getPublicConstructors() {
            ArrayList<JavaMethodProxy> out = new ArrayList<JavaMethodProxy>();
            for (ExecutableElement el : ViewProcessor.this.env().getTypeElementHelper(this.typeEl).getPublicConstructors()) {
                out.add(new JavaMethodProxy(this, el));
            }
            return out;
        }

        List<JavaMethodProxy> getEligibleConstructors(Element xmlTag) {
            ArrayList<JavaMethodProxy> out = new ArrayList<JavaMethodProxy>();
            Set indexedParams = ViewProcessor.extractIndexedParameters(xmlTag);
            ArrayList<String> injectableTypes = new ArrayList<String>();
            injectableTypes.add("com.codename1.rad.ui.EntityView");
            injectableTypes.add("com.codename1.rad.ui.ViewContext");
            injectableTypes.add("com.codename1.rad.models.Entity");
            injectableTypes.add("com.codename1.rad.models.BaseEntity");
            injectableTypes.add("com.codename1.rad.controllers.ApplicationController");
            injectableTypes.add("com.codename1.rad.controllers.Controller");
            injectableTypes.add("com.codename1.rad.controllers.FormController");
            injectableTypes.add("com.codename1.rad.controllers.AppSectionController");
            injectableTypes.add("com.codename1.rad.controllers.ViewController");
            injectableTypes.add("com.codename1.rad.nodes.ViewNode");
            injectableTypes.add("com.codename1.rad.nodes.ListNode");
            for (JavaMethodProxy constructor : this.getPublicConstructors()) {
                boolean eligible = true;
                int index = -1;
                for (String paramName : constructor.getParameterNames()) {
                    TypeElement wrapperType;
                    TypeElement viewModelType;
                    TypeElement paramType = constructor.getParameterType(++index);
                    if (indexedParams.contains(index)) continue;
                    if (!constructor.isParameterInjectable(index)) {
                        eligible = false;
                        break;
                    }
                    if (constructor.isArrayParameter(index)) continue;
                    String paramTypeStr = paramType.toString();
                    if (injectableTypes.contains(paramType.toString()) || ViewProcessor.this.isA(this.env.rootBuilder.parentClass, paramType.toString())) continue;
                    boolean matchingInterface = false;
                    for (String iface : this.env.rootBuilder.viewImplements.split(",")) {
                        TypeElement ifaceType = this.env.lookupClass(iface = iface.trim());
                        if (ifaceType == null || !ViewProcessor.this.isA(ifaceType, paramType.toString())) continue;
                        matchingInterface = true;
                        break;
                    }
                    if (matchingInterface || ViewProcessor.this.isA(viewModelType = this.env.lookupClass(this.env.rootBuilder.viewModelType), paramType.getQualifiedName().toString()) || ViewProcessor.this.isA(paramType, "com.codename1.rad.models.Entity") && (wrapperType = this.env.lookupClass(this.env.rootBuilder.viewModelType + "Wrapper")) != null) continue;
                    boolean foundInjectableType = false;
                    for (JavaClassProxy injectableType : this.env.rootBuilder.injectableTypes.values()) {
                        if (!ViewProcessor.this.isA(injectableType.typeEl, paramType.getQualifiedName().toString())) continue;
                        foundInjectableType = true;
                        break;
                    }
                    if (foundInjectableType) continue;
                    eligible = false;
                    break;
                }
                if (!eligible) continue;
                out.add(constructor);
            }
            return out;
        }

        void setProperties(StringBuilder appendTo, Element tag, String receiverVar) {
            NamedNodeMap attributes = tag.getAttributes();
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (attr.getName().contains("-")) continue;
                appendTo.append("        ");
                this.setProperty(appendTo, attr, receiverVar);
                appendTo.append("\n");
            }
        }

        void setProperty(StringBuilder appendTo, Attr attribute, String receiverVar) {
            this.setProperty(appendTo, attribute, receiverVar, "java.lang.String");
        }

        void setProperty(StringBuilder appendTo, Attr attribute, String receiverVar, String propType) {
            this.setProperty(appendTo, attribute.getName(), attribute.getValue(), receiverVar, propType);
        }

        void setProperty(StringBuilder appendTo, String attName, String attValue, String receiverVar) {
            this.setProperty(appendTo, attName, attValue, receiverVar, "java.lang.String");
        }

        void setProperty(StringBuilder appendTo, String attName, String attValue, String receiverVar, String propType) {
            String propertyName = attName;
            JavaPropertySelector propertySelector = ViewProcessor.this.createPropertySelector(this, propertyName, propType);
            if (!propertySelector.isWritable() && this.isComponentBuilder()) {
                propertySelector = ViewProcessor.this.createPropertySelector(this, "component." + propertyName, propType);
            }
            String value = attValue;
            if (!propertySelector.isWritable()) {
                if (this.isEntity()) {
                    appendTo.append("{");
                    if (value.startsWith("java:")) {
                        appendTo.append("Object _newVal = ").append(ViewProcessor.this.expandRADModelVars(this.env, value.substring(value.indexOf(":") + 1), false)).append(";");
                        appendTo.append("ContentType _contentType = ").append("_newVal == null ? ContentType.Text : ContentType.createObjectType(_newVal);");
                    }
                    this.env.createRADPropertySelector(appendTo, attName.replace('.', '/'), receiverVar);
                    if (value.startsWith("string:")) {
                        appendTo.append(".setText(").append(ViewProcessor.this.expandRADModelVars(this.env, value.substring(value.indexOf(":") + 1), true)).append(")");
                    } else if (value.startsWith("java:")) {
                        appendTo.append(".set(_contentType, ").append(ViewProcessor.this.expandRADModelVars(this.env, value.substring(value.indexOf(":") + 1), false)).append(")");
                    } else {
                        appendTo.append(".setText(").append(ViewProcessor.this.expandRADModelVars(this.env, value, true)).append(")");
                    }
                    appendTo.append("}");
                }
                throw new IllegalArgumentException("Cannot set property " + propertyName + " on class " + this.typeEl.getQualifiedName() + " because it has no suitable setter method.");
            }
            JavaMethodProxy setter = propertySelector.setter();
            if (setter == null) {
                throw new IllegalStateException("Cannot find setter method for property selector while working on setting property for attribute " + attName + " with value " + attValue);
            }
            TypeElement paramType = setter.getParameterType(0);
            if (paramType == null) {
                throw new IllegalStateException("No parameter type found for first parameter of setter method " + setter);
            }
            VariableElement paramVar = setter.methodEl.getParameters().get(0);
            value = new AttributeSanitizer(this.env).sanitize(paramType, paramVar, setter.isArrayParameter(0), value);
            propertySelector.setProperty(appendTo, receiverVar, value);
        }

        public boolean isContainer() {
            return this.isComponent() && ViewProcessor.this.isContainer(this.typeEl);
        }
    }

    private static enum JavaClassType {
        ENTITY,
        COMPONENT,
        NODE,
        OTHER;

    }

    private class JavaPropertySelector {
        private JavaClassProxy classProxy;
        private String selector;
        private JavaPropertySelector parent;
        private JavaMethodProxy getter;
        private boolean getterLoaded;
        private boolean setterLoaded;
        private JavaMethodProxy setter;
        private String propType = "java.lang.String";

        JavaPropertySelector(JavaPropertySelector parent, String selector) {
            this(parent, selector, "java.lang.String");
        }

        JavaPropertySelector(JavaPropertySelector parent, String selector, String propType) {
            this.propType = propType;
            this.parent = parent;
            this.selector = selector;
            if (selector.contains(".")) {
                throw new IllegalArgumentException("JavaPropertySelector constructor cannot take multipart selectors.  Use createPropertySelector() instead");
            }
            TypeElement classProxyType = ViewProcessor.this.elements().getTypeElement(parent.getPropertyType(false));
            if (classProxyType == null) {
                throw new IllegalStateException("Cannot determine class proxy type for property selector from the parent.  Looking for " + parent.getPropertyType(false));
            }
            this.classProxy = parent.classProxy.env.newJavaClassProxy(classProxyType);
        }

        JavaPropertySelector(JavaClassProxy classProxy, String selector) {
            this(classProxy, selector, "java.lang.String");
        }

        JavaPropertySelector(JavaClassProxy classProxy, String selector, String propType) {
            this.propType = propType;
            this.classProxy = classProxy;
            this.selector = selector;
            if (selector.contains(".")) {
                throw new IllegalArgumentException("JavaPropertySelector constructor cannot take multipart selectors.  Use createPropertySelector() instead");
            }
        }

        JavaMethodProxy getter() {
            if (!this.getterLoaded) {
                this.getterLoaded = true;
                this.getter = this.classProxy.findMethodProxy("get" + this.selector, 0);
                if (this.getter == null) {
                    this.getter = this.classProxy.findMethodProxy("is" + this.selector, 0);
                }
            }
            return this.getter;
        }

        JavaMethodProxy setter() {
            if (!this.setterLoaded) {
                this.setterLoaded = true;
                ExecutableElement setterEl = this.classProxy.findSetter(this.selector, this.propType);
                if (setterEl != null) {
                    this.setter = new JavaMethodProxy(this.classProxy, setterEl);
                }
            }
            return this.setter;
        }

        public String getPropertyType(boolean forWriting) {
            if (forWriting) {
                if (!this.isWritable()) {
                    throw new IllegalStateException("Cannot get property type for reading on property " + this.selector + " of class " + this.classProxy.typeEl + " because the property is not writable");
                }
                return this.setter().getParameterType(0).getQualifiedName().toString();
            }
            if (!this.isReadable()) {
                throw new IllegalStateException("Cannot get property type for reading on property " + this.selector + " of class " + this.classProxy.typeEl + " because the property is not readable");
            }
            return this.getter().getReturnType().getQualifiedName().toString();
        }

        public String getPropertyNullValue(boolean forWriting) {
            String propertyType = this.getPropertyType(forWriting);
            TypeElement typeEl = ViewProcessor.this.elements().getTypeElement(propertyType);
            switch (typeEl.asType().getKind()) {
                case INT: 
                case SHORT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BYTE: 
                case CHAR: {
                    return "0";
                }
                case BOOLEAN: {
                    return "false";
                }
            }
            return null;
        }

        boolean isWritable() {
            return this.setter() != null;
        }

        boolean isReadable() {
            return this.getter() != null;
        }

        JavaClassProxy getClassProxy() {
            return this.classProxy;
        }

        JavaPropertySelector getParent() {
            return this.parent;
        }

        boolean isRootSelector() {
            return this.parent == null;
        }

        JavaPropertySelector getRoot() {
            if (this.isRootSelector()) {
                return this;
            }
            return this.parent.getRoot();
        }

        void assignVar(StringBuilder appendTo, String receiverVar, String targetVar, String defaultValue) {
            if (!this.isReadable()) {
                throw new IllegalStateException("Cannot appendGetter on property selector " + this + " because the property is not readable (i.e. has no suitable getter method).");
            }
            if (this.parent != null) {
                ArrayList<JavaPropertySelector> chain = new ArrayList<JavaPropertySelector>();
                for (JavaPropertySelector currSelector = this; currSelector != null; currSelector = currSelector.getParent()) {
                    chain.add(currSelector);
                }
                String varName = "__tmp_" + targetVar;
                String indexVarName = "__tmp_" + targetVar + "Counter";
                appendTo.append("{Object ").append(varName).append("= null;");
                appendTo.append("for (int ").append(indexVarName).append("=0; ").append(indexVarName).append("<").append(chain.size()).append(";").append(indexVarName).append("++){");
                appendTo.append("if (").append(indexVarName).append(">0 && ").append(varName).append("==null){").append(targetVar).append("=").append(defaultValue).append(";break;}");
                appendTo.append("switch (").append(indexVarName).append(") {");
                int len = chain.size();
                for (int i = 0; i < len; ++i) {
                    int selectorIndex = len - i - 1;
                    JavaPropertySelector selector = (JavaPropertySelector)chain.get(selectorIndex);
                    appendTo.append("case ").append(i).append(": ");
                    String thisVarName = varName;
                    if (i == 0) {
                        thisVarName = receiverVar;
                    }
                    appendTo.append(varName).append("=((").append(selector.getClassProxy().className).append(")").append(thisVarName).append(").").append(selector.getter().methodEl.getSimpleName()).append("();break;");
                }
                appendTo.append("}");
                appendTo.append("if (").append(indexVarName).append("==").append(chain.size() - 1).append(") ").append(targetVar).append("=(").append(this.getter().getReturnType().toString()).append(")((").append(varName).append("==null)?").append(defaultValue).append(":").append(varName).append(");}");
                appendTo.append("}");
            } else {
                String varName = "__tmp_" + targetVar;
                appendTo.append("{").append("Object ").append(varName).append("=").append(receiverVar).append(".").append(this.getter().methodEl.getSimpleName().toString()).append("();");
                appendTo.append(targetVar).append("=(").append(varName).append("==null)?").append(defaultValue).append(":(").append(this.getter().getReturnType().toString()).append(")").append(varName).append(";}");
            }
        }

        void setProperty(StringBuilder appendTo, String receiverVar, String value) {
            if (this.parent != null) {
                String varName = "__tmpReceiver_" + receiverVar;
                appendTo.append("{").append(this.classProxy.typeEl.getQualifiedName()).append(" ").append(varName).append(" = null;");
                this.parent.assignVar(appendTo, receiverVar, varName, "null");
                appendTo.append("if (").append(varName).append("!=null)").append(varName).append(".").append(this.setter().methodEl.getSimpleName()).append("(").append(value).append(");}");
            } else {
                appendTo.append(receiverVar).append(".").append(this.setter().methodEl.getSimpleName()).append("(").append(value).append(");");
            }
        }
    }

    public class JavaEnvironment {
        private Map<String, JavaClassProxy> javaClassProxyMap = new HashMap<String, JavaClassProxy>();
        private boolean buildingIndex = false;
        final Map<String, TypeElement> tagCache = new HashMap<String, TypeElement>();
        final Map<String, TypeElement> lookupClassCache = new HashMap<String, TypeElement>();
        final Map<String, TypeElement> simpleNameClassCache = new HashMap<String, TypeElement>();
        final Element rootElement;
        private JavaClassProxy viewModelType;
        private EntityViewBuilder rootBuilder;
        private List<String> imports = new ArrayList<String>();
        private Map<String, Boolean> tagHasComponentBuilder = new HashMap<String, Boolean>();
        private Map<String, TypeElement> tagComponentBuilderClass = new HashMap<String, TypeElement>();
        private Map<String, Boolean> tagHasNodeBuilder = new HashMap<String, Boolean>();
        private Map<String, TypeElement> tagNodeBuilderClass = new HashMap<String, TypeElement>();

        public JavaClassProxy newJavaClassProxy(String qualifiedName) throws ClassNotFoundException {
            if (!this.javaClassProxyMap.containsKey(qualifiedName)) {
                JavaClassProxy proxy = new JavaClassProxy(qualifiedName, this);
                this.javaClassProxyMap.put(qualifiedName, proxy);
            }
            return this.javaClassProxyMap.get(qualifiedName);
        }

        public JavaClassProxy newJavaClassProxy(TypeElement typeElement) {
            String qualifiedName = typeElement.getQualifiedName().toString();
            if (!this.javaClassProxyMap.containsKey(qualifiedName)) {
                JavaClassProxy proxy = new JavaClassProxy(typeElement, this);
                this.javaClassProxyMap.put(qualifiedName, proxy);
            }
            return this.javaClassProxyMap.get(qualifiedName);
        }

        public void buildIndex() {
        }

        String getRootViewQualifiedName() {
            return this.rootBuilder.packageName + "." + this.rootBuilder.className;
        }

        JavaEnvironment(Element rootElement) {
            this.rootElement = rootElement;
        }

        public boolean isA(TypeMirror m, String qualifiedName) {
            return ViewProcessor.this.isA(m, qualifiedName);
        }

        public boolean isA(TypeElement e, String qualifiedName) {
            return ViewProcessor.this.isA(e, qualifiedName);
        }

        void setViewModelType(String type) {
            TypeElement typeEl = this.lookupClass(type);
            if (typeEl == null) {
                typeEl = this.lookupClass("com.codename1.rad.models.Entity");
            }
            this.viewModelType = this.newJavaClassProxy(typeEl);
        }

        private List<Element> getChildrenOfType(Element root, String type) {
            ArrayList<Element> out = new ArrayList<Element>();
            for (Element child : ViewProcessor.getChildElements(root)) {
                TypeElement el = this.findClassThatTagCreates(child.getTagName());
                if (!this.isA(el, type)) continue;
                out.add(child);
            }
            return out;
        }

        public DeclaredType createDeclaredType(final String name, final TypeMirror ... typeArgs) {
            return new ProcessingEnvironmentWrapper.RDeclaredType(){
                private List<TypeMirror> typeArguments;
                {
                    this.typeArguments = new ArrayList<TypeMirror>(Arrays.asList(typeArgs));
                }

                @Override
                public javax.lang.model.element.Element asElement() {
                    return JavaEnvironment.this.lookupClass(name);
                }

                @Override
                public TypeMirror getEnclosingType() {
                    return ViewProcessor.this.elements().getPackageElement(JavaEnvironment.this.rootBuilder.packageName).asType();
                }

                @Override
                public List<? extends TypeMirror> getTypeArguments() {
                    return this.typeArguments;
                }

                @Override
                public TypeKind getKind() {
                    return TypeKind.DECLARED;
                }

                @Override
                public <R, P> R accept(TypeVisitor<R, P> v, P p) {
                    return v.visit(this);
                }

                @Override
                public List<? extends AnnotationMirror> getAnnotationMirrors() {
                    return new ArrayList();
                }

                @Override
                public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                    return null;
                }

                @Override
                public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
                    return null;
                }
            };
        }

        boolean isRADContext(Element el) {
            Element parentEl;
            if (el.hasAttribute("is-rad-context")) {
                return "true".equalsIgnoreCase(el.getAttribute("is-rad-context"));
            }
            Node parentNode = el.getParentNode();
            if (parentNode instanceof Element && this.isRADContext(parentEl = (Element)parentNode)) {
                el.setAttribute("is-rad-context", "true");
                return true;
            }
            TypeElement componentClass = this.findClassThatTagCreates(el.getTagName());
            if (componentClass != null && this.isA(componentClass, "com.codename1.rad.nodes.Node")) {
                el.setAttribute("is-rad-context", "true");
                return true;
            }
            el.setAttribute("is-rad-context", "false");
            return false;
        }

        private List<JavaClassProxy> findInstantiatableClassesAssignableTo(PackageElement _contextPackage, Element xmlTag, String ... types) {
            PackageElement contextPackage = (PackageElement)ViewProcessor.this.wrap(_contextPackage);
            List<Object> candidates = new ArrayList();
            for (String importPath : this.imports) {
                if ((importPath = importPath.substring(importPath.indexOf(" ") + 1)).contains(" ")) continue;
                if (importPath.endsWith(".*")) {
                    PackageElement packageElement = ViewProcessor.this.elements().getPackageElement(importPath.substring(0, importPath.lastIndexOf(".")));
                    candidates.addAll(this.findClassesAssignableTo(new ArrayList<TypeElement>(), packageElement, types));
                    continue;
                }
                TypeElement typeElement = ViewProcessor.this.elements().getTypeElement(importPath);
                if (typeElement == null) continue;
                candidates.addAll(this.findClassesAssignableTo(new ArrayList<TypeElement>(), typeElement, types));
            }
            candidates = candidates.stream().filter(el -> el.getModifiers().contains((Object)Modifier.PUBLIC) || ViewProcessor.this.elements().getPackageOf((javax.lang.model.element.Element)el).equals(contextPackage)).filter(el -> !el.getModifiers().contains((Object)Modifier.PRIVATE) && !el.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(el -> el.getKind() == ElementKind.CLASS).collect(Collectors.toList());
            List<JavaClassProxy> candidateProxies = new ArrayList<JavaClassProxy>();
            for (TypeElement typeElement : candidates) {
                candidateProxies.add(this.newJavaClassProxy(typeElement));
            }
            if (xmlTag != null) {
                candidateProxies = candidateProxies.stream().filter(p -> p.getBestConstructor(xmlTag) != null).collect(Collectors.toList());
            }
            return candidateProxies;
        }

        private List<TypeElement> findClassesAssignableTo(List<TypeElement> out, TypeElement root, String ... types) {
            boolean isAssignable = true;
            for (String type : types) {
                if (this.isA(root, type)) continue;
                isAssignable = false;
                break;
            }
            if (isAssignable) {
                out.add(root);
            }
            return out;
        }

        private List<TypeElement> findClassesAssignableTo(List<TypeElement> out, PackageElement root, String ... types) {
            ProcessingEnvironmentWrapper.PackageWrapper wrapper = (ProcessingEnvironmentWrapper.PackageWrapper)ViewProcessor.this.wrap(root);
            HashSet<TypeElement> outSet = new HashSet<TypeElement>();
            boolean first = true;
            for (String fqn : types) {
                TypeElement typeEl = ViewProcessor.this.elements().getTypeElement(fqn);
                if (typeEl == null) continue;
                if (first) {
                    first = false;
                    outSet.addAll(wrapper.getSubtypesOf(typeEl));
                    continue;
                }
                outSet.retainAll(wrapper.getSubtypesOf(typeEl));
            }
            return new ArrayList<TypeElement>(outSet);
        }

        private void writeImports(StringBuilder sb) {
            for (String importPath : this.imports) {
                if (importPath.endsWith("**") && this.imports.contains(importPath = importPath.substring(0, importPath.length() - 1))) continue;
                sb.append(importPath).append(";\n");
            }
        }

        void createRADPropertySelector(StringBuilder sb, String tagPath) {
            this.createRADPropertySelector(sb, tagPath, "context.getEntity()");
        }

        void createRADPropertySelector(StringBuilder sb, String tagPath, String rootElement) {
            sb.append("new PropertySelector(").append(rootElement).append(", ");
            StringTokenizer stringTokenizer = new StringTokenizer(tagPath, "/");
            boolean first = true;
            while (stringTokenizer.hasMoreTokens()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(".createChildSelector(");
                }
                String tok = stringTokenizer.nextToken();
                sb.append(tok).append(")");
            }
        }

        boolean isComponentTag(String tagName) {
            TypeElement el = this.findClassThatTagCreates(tagName);
            return el != null && ViewProcessor.this.isComponent(el);
        }

        boolean isNodeTag(String tagName, boolean inNodeContext) {
            TypeElement el = this.findClassThatTagCreates(tagName, inNodeContext ? "com.codename1.rad.nodes.Node" : null);
            return el != null && ViewProcessor.this.isNode(el);
        }

        boolean isContainerTag(String tagName) {
            TypeElement el = this.findClassThatTagCreates(tagName);
            return el != null && ViewProcessor.this.isContainer(el);
        }

        TypeElement findClassThatTagCreates(String tag) {
            return this.findClassThatTagCreates(tag, null);
        }

        TypeElement findClassThatTagCreates(String tag, String isa) {
            TypeElement el;
            JavaClassProxy builderClass;
            String tagKey = tag + ":" + isa;
            if (this.tagCache.containsKey(tagKey = tagKey.toLowerCase())) {
                return this.tagCache.get(tagKey);
            }
            if (isa == null || isa.equals("com.codename1.ui.Component")) {
                ClassIndex index;
                if (!this.buildingIndex && (index = (ClassIndex)ViewProcessor.this.cache.get(ClassIndex.class)) != null) {
                    return (TypeElement)index.tagToComponentMap.get(tag.toLowerCase());
                }
                builderClass = this.findComponentBuilderForTag(tag);
                if (builderClass != null && (el = builderClass.findMethodProxy("getComponent", 0).getReturnType()) != null) {
                    this.tagCache.put(tagKey, el);
                    return el;
                }
            }
            if (isa != null && isa.equals("com.codename1.rad.nodes.Node") && (builderClass = this.findNodeBuilderForTag(tag)) != null && (el = builderClass.findMethodProxy("getNode", 0).getReturnType()) != null) {
                this.tagCache.put(tagKey, el);
                return el;
            }
            TypeElement cls = this.findClassBySimpleName(tag, isa);
            if (cls == null) {
                cls = this.lookupClass(tag);
                if (isa != null && !this.isA(cls, isa)) {
                    cls = null;
                }
            }
            if (cls != null) {
                this.tagCache.put(tagKey, cls);
                return cls;
            }
            return null;
        }

        TypeElement lookupClass(String className) {
            if (this.lookupClassCache.containsKey(className)) {
                return this.lookupClassCache.get(className);
            }
            TypeElement typeEl = ViewProcessor.this.elements().getTypeElement(className);
            if (typeEl != null) {
                this.lookupClassCache.put(className, typeEl);
                return typeEl;
            }
            for (String importPath : this.imports) {
                if (importPath.startsWith("import ")) {
                    importPath = importPath.substring(importPath.indexOf(" ") + 1);
                }
                if (importPath.contains(" ")) continue;
                if (importPath.endsWith(".*")) {
                    ProcessingEnvironmentWrapper.PackageWrapper pkgWrap;
                    TypeElement el;
                    PackageElement pkg = ViewProcessor.this.elements().getPackageElement(importPath.substring(0, importPath.lastIndexOf(".")));
                    if (pkg == null || (el = (pkgWrap = (ProcessingEnvironmentWrapper.PackageWrapper)ViewProcessor.this.wrap(pkg)).getEnclosedTypeIgnoreCase(className)) == null) continue;
                    return el;
                }
                TypeElement el = ViewProcessor.this.elements().getTypeElement(importPath);
                if (el == null) continue;
                if (className.equalsIgnoreCase(el.getSimpleName().toString())) {
                    return el;
                }
                if (!className.startsWith(el.getSimpleName() + ".") || (el = ViewProcessor.this.elements().getTypeElement(el.getQualifiedName() + className.substring(className.indexOf(".")))) == null) continue;
                return el;
            }
            return null;
        }

        TypeElement findClassBySimpleName(PackageElement searchRoot, String className, boolean deep, String isa) {
            if (searchRoot == null) {
                return null;
            }
            searchRoot = (PackageElement)ViewProcessor.this.wrap(searchRoot);
            List classes = searchRoot.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.INTERFACE).collect(Collectors.toList());
            for (TypeElement cls : classes) {
                TypeElement typeElement;
                if (className.equalsIgnoreCase(cls.getSimpleName().toString()) && (isa == null || this.isA(cls, isa))) {
                    return cls;
                }
                if (!deep || (typeElement = this.findClassBySimpleName(cls, className, false, deep, isa)) == null) continue;
                return typeElement;
            }
            if (deep) {
                List packages = searchRoot.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.PACKAGE).collect(Collectors.toList());
                for (PackageElement pkg : packages) {
                    TypeElement typeElement = this.findClassBySimpleName(pkg = (PackageElement)ViewProcessor.this.wrap(pkg), className, deep, isa);
                    if (typeElement == null) continue;
                    return typeElement;
                }
            }
            return null;
        }

        TypeElement findClassBySimpleName(TypeElement searchRoot, String className, boolean glob, boolean deep, String isa) {
            if (!glob && searchRoot.getSimpleName().toString().equalsIgnoreCase(className) && (isa == null || this.isA(searchRoot, isa))) {
                return searchRoot;
            }
            if (glob || deep) {
                List classes = searchRoot.getEnclosedElements().stream().filter(e -> e.getModifiers().contains((Object)Modifier.STATIC) && (e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.INTERFACE)).collect(Collectors.toList());
                for (TypeElement cls : classes) {
                    TypeElement typeElement;
                    if (className.equalsIgnoreCase(cls.getSimpleName().toString()) && (isa == null || this.isA(cls, isa))) {
                        return cls;
                    }
                    if (!deep || (typeElement = this.findClassBySimpleName(cls, className, false, deep, isa)) == null) continue;
                    return typeElement;
                }
            }
            return null;
        }

        TypeElement findClassBySimpleName(String name) {
            return this.findClassBySimpleName(name, null);
        }

        TypeElement findClassBySimpleName(String name, String isa) {
            String key = name.toLowerCase() + ":" + isa;
            if (this.simpleNameClassCache.containsKey(key)) {
                return this.simpleNameClassCache.get(key);
            }
            for (String importPath : this.imports) {
                if ((importPath = importPath.substring(importPath.indexOf(" ") + 1)).contains(" ")) continue;
                if (importPath.endsWith(".*")) {
                    String packageName = importPath.substring(0, importPath.lastIndexOf("."));
                    PackageElement pkg = ViewProcessor.this.elements().getPackageElement(packageName);
                    TypeElement builder = ((ProcessingEnvironmentWrapper.PackageWrapper)(pkg = (PackageElement)ViewProcessor.this.wrap(pkg))).getEnclosedTypeIgnoreCase(name);
                    if (builder != null && isa != null && !this.isA(builder, isa)) {
                        builder = null;
                    }
                    if (builder == null) continue;
                    this.simpleNameClassCache.put(key, builder);
                    return builder;
                }
                TypeElement matchingType = ViewProcessor.this.elements().getTypeElement(importPath);
                if (matchingType == null || !matchingType.getSimpleName().toString().equalsIgnoreCase(name)) continue;
                TypeElement builder = matchingType;
                if (builder != null && isa != null && !this.isA(builder, isa)) {
                    builder = null;
                }
                if (builder == null) continue;
                this.simpleNameClassCache.put(key, builder);
                return builder;
            }
            return null;
        }

        TypeElement findComponentBuilderClass(String tagName) {
            String lcTagName = tagName.toLowerCase();
            Boolean hasComponentBuilder = this.tagHasComponentBuilder.get(lcTagName);
            if (hasComponentBuilder != null && !hasComponentBuilder.booleanValue()) {
                return null;
            }
            TypeElement cached = this.tagComponentBuilderClass.get(lcTagName);
            if (cached != null) {
                return cached;
            }
            TypeElement out = this._findComponentBuilderClass(tagName);
            if (out == null) {
                this.tagHasComponentBuilder.put(lcTagName, false);
                return null;
            }
            this.tagHasComponentBuilder.put(lcTagName, true);
            this.tagComponentBuilderClass.put(lcTagName, out);
            return out;
        }

        TypeElement _findComponentBuilderClass(String tagName) {
            ArrayList deepSearches = new ArrayList(0);
            for (String importPath : this.imports) {
                if ((importPath = importPath.substring(importPath.indexOf(" ") + 1)).contains(" ")) continue;
                if (importPath.endsWith(".*")) {
                    PackageElement pkg = ViewProcessor.this.elements().getPackageElement(importPath.substring(0, importPath.lastIndexOf(".")));
                    if (pkg == null) continue;
                    ProcessingEnvironmentWrapper.PackageWrapper pkgWrap = (ProcessingEnvironmentWrapper.PackageWrapper)ViewProcessor.this.wrap(pkg);
                    for (TypeElement el : pkgWrap.getEnclosedTypeElementsWithTag(tagName)) {
                        if (!this.isA(el, "com.codename1.rad.ui.ComponentBuilder")) continue;
                        return el;
                    }
                    continue;
                }
                TypeElement el = ViewProcessor.this.elements().getTypeElement(importPath);
                if (el == null || !this.isA(el, "com.codename1.rad.ui.ComponentBuilder")) continue;
                return el;
            }
            return null;
        }

        TypeElement findNodeBuilderClass(String tagName) {
            String lcTagName = tagName.toLowerCase();
            Boolean hasNodeBuilder = this.tagHasNodeBuilder.get(lcTagName);
            if (hasNodeBuilder != null && !hasNodeBuilder.booleanValue()) {
                return null;
            }
            TypeElement cached = this.tagNodeBuilderClass.get(lcTagName);
            if (cached != null) {
                return cached;
            }
            TypeElement out = this._findNodeBuilderClass(tagName);
            if (out == null) {
                this.tagHasNodeBuilder.put(lcTagName, false);
                return null;
            }
            this.tagHasNodeBuilder.put(lcTagName, true);
            this.tagNodeBuilderClass.put(lcTagName, out);
            return out;
        }

        TypeElement _findNodeBuilderClass(String tagName) {
            ArrayList deepSearches = new ArrayList(0);
            for (String importPath : this.imports) {
                if ((importPath = importPath.substring(importPath.indexOf(" ") + 1)).contains(" ")) continue;
                if (importPath.endsWith(".*")) {
                    PackageElement pkg = ViewProcessor.this.elements().getPackageElement(importPath.substring(0, importPath.lastIndexOf(".")));
                    if (pkg == null) continue;
                    ProcessingEnvironmentWrapper.PackageWrapper pkgWrap = (ProcessingEnvironmentWrapper.PackageWrapper)ViewProcessor.this.wrap(pkg);
                    for (TypeElement el : pkgWrap.getEnclosedTypeElementsWithTag(tagName)) {
                        if (!this.isA(el, "com.codename1.rad.nodes.NodeBuilder")) continue;
                        return el;
                    }
                    continue;
                }
                TypeElement matchingType = ViewProcessor.this.elements().getTypeElement(importPath);
                if (matchingType == null || !this.isA(matchingType, "com.codename1.rad.nodes.NodeBuilder")) continue;
                return matchingType;
            }
            return null;
        }

        void addImports(String imports) {
            StringTokenizer strtok = new StringTokenizer(imports, ";\n");
            while (strtok.hasMoreTokens()) {
                String nextTok = strtok.nextToken().trim();
                if (nextTok.isEmpty()) continue;
                if (nextTok.contains(".") && nextTok.contains(" ")) {
                    String packageName = nextTok.substring(nextTok.indexOf(" ") + 1, nextTok.lastIndexOf("."));
                    String parentPackage = packageName.contains(".") ? packageName.substring(0, packageName.lastIndexOf(".") + 1) : "";
                    PackageElement packageEl = ViewProcessor.this.elements().getPackageElement(parentPackage + "builders");
                    if (packageEl != null && !packageEl.getEnclosedElements().isEmpty() && !this.imports.contains("import " + parentPackage + "builders.*")) {
                        this.imports.add("import " + parentPackage + "builders.*");
                    }
                    if ((packageEl = ViewProcessor.this.elements().getPackageElement(packageName + ".builders")) != null && !packageEl.getEnclosedElements().isEmpty() && !this.imports.contains("import " + packageName + ".builders.*")) {
                        this.imports.add("import " + packageName + ".builders.*");
                    }
                }
                if (this.imports.contains(nextTok)) continue;
                this.imports.add(nextTok);
            }
        }

        JavaClassProxy findComponentBuilderForTag(String tag) {
            TypeElement builderEl = this.findComponentBuilderClass(tag);
            if (builderEl == null) {
                TypeElement actualTypeEl = this.findClassBySimpleName(tag);
                if (this.isA(actualTypeEl, "com.codename1.rad.ui.entityviews.EntityListView")) {
                    return this.findComponentBuilderForTag("entityList");
                }
                return null;
            }
            return this.newJavaClassProxy(builderEl);
        }

        JavaClassProxy findNodeBuilderForTag(String tag) {
            TypeElement builderEl = this.findNodeBuilderClass(tag);
            if (builderEl == null) {
                return null;
            }
            return this.newJavaClassProxy(builderEl);
        }

        boolean isTypeInjectableViaLookup(TypeElement type) {
            String name = type.getQualifiedName().toString();
            return !name.equals("com.codename1.rad.models.Entity") && !name.equals("com.codename1.rad.models.BaseEntity") && !name.equals("com.codename1.rad.models.EntityList") && !this.isA(type, "com.codename1.rad.ui.ViewContext") && !name.startsWith("java.") && !name.startsWith("javax.") && !name.startsWith("com.codename1.rad.ui.EntityView") && !name.startsWith("com.codename1.rad.ui.entityviews.EntityListView") && !name.startsWith("com.codename1.rad.ui.AbstractEntityView") && !name.startsWith("com.codename1.rad.nodes.Node") && !name.startsWith("com.codename1.rad.nodes.ViewNode") && !name.startsWith("com.codename1.rad.nodes.ListNode") && !name.startsWith("com.codename1.rad.models.Attribute") && !name.startsWith("com.codename1.rad.models.Tag") && !name.startsWith("com.codename1.rad.controllers.") && !name.startsWith("com.codename1.ui.");
        }

        String quoteString(String value, TypeElement paramType) {
            if (value.startsWith("java:")) {
                return value.substring(value.indexOf(":") + 1);
            }
            if (this.isA(paramType, "java.lang.String")) {
                if (value.startsWith("string:")) {
                    value = value.substring(value.indexOf(":") + 1);
                }
                return '\"' + StringEscapeUtils.escapeJava((String)value) + '\"';
            }
            if (value.startsWith("string:")) {
                return '\"' + StringEscapeUtils.escapeJava((String)value.substring(value.indexOf(":") + 1)) + '\"';
            }
            return value;
        }

        void writeInjectedValueFromContext(StringBuilder appendTo, TypeElement paramType, Element tagContext, String defaultValue) {
            boolean isArray = paramType.asType().getKind() == TypeKind.ARRAY;
            TypeElement componentType = isArray ? (TypeElement)((DeclaredType)((ArrayType)((Object)paramType)).getComponentType()).asElement() : paramType;
            boolean isEntity = this.isA(componentType, "com.codename1.rad.models.Entity");
            boolean isComponent = !isEntity && this.isA(componentType, "com.codename1.ui.Component");
            boolean isNode = !isEntity && !isComponent && this.isA(componentType, "com.codename1.rad.nodes.Node");
            TypeElement entityWrapperClass = null;
            if (isEntity && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity") && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                entityWrapperClass = this.lookupClass(componentType.getQualifiedName() + "Wrapper");
            }
            TypeElement entityImplClass = null;
            if (isEntity && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity") && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                entityImplClass = this.lookupClass(componentType.getQualifiedName() + "Impl");
            }
            if (isEntity) {
                JavaClassProxy parentTagClassProxy;
                JavaMethodProxy getEntityProxy;
                TypeElement entityReturnType;
                TypeElement parentTagClass;
                Element parentTag;
                TypeElement tagClass = this.rootBuilder.jenv.findClassThatTagCreates(tagContext.getTagName());
                if (entityWrapperClass == null && tagClass != null && tagClass.getQualifiedName().contentEquals("com.codename1.rad.ui.ViewContext") && (parentTag = (Element)tagContext.getParentNode()) != null && (parentTagClass = this.rootBuilder.jenv.findClassThatTagCreates(parentTag.getTagName())) != null && this.isA(parentTagClass, "com.codename1.rad.ui.EntityView") && (entityReturnType = (getEntityProxy = (parentTagClassProxy = this.rootBuilder.jenv.newJavaClassProxy(parentTagClass)).findMethodProxy("getEntity", 0)).getReturnType()) != null && !entityReturnType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity") && !entityReturnType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList") && !entityReturnType.getQualifiedName().contentEquals("com.codename1.rad.models.BaseEntity")) {
                    if (entityReturnType.getKind() == ElementKind.INTERFACE) {
                        entityWrapperClass = this.lookupClass(entityReturnType.getQualifiedName() + "Wrapper");
                        entityImplClass = this.lookupClass(entityReturnType.getQualifiedName() + "Impl");
                    } else if (entityReturnType.getKind() == ElementKind.CLASS) {
                        entityImplClass = entityReturnType;
                    }
                }
                if (entityWrapperClass != null) {
                    appendTo.append(entityWrapperClass.getQualifiedName()).append(".wrap(");
                }
                if (tagContext.hasAttribute("view-model")) {
                    String vmString = tagContext.getAttribute("view-model");
                    if (vmString.startsWith("java:")) {
                        vmString = vmString.substring(vmString.indexOf(":") + 1);
                    }
                    if ("new".equals(vmString)) {
                        if (entityImplClass == null) {
                            throw new IllegalArgumentException("Cannot find model implementation for entity type " + componentType.getQualifiedName() + " to fill view-model=\"new\" attribute. XML tag: " + tagContext + " parent tag: " + tagContext.getParentNode());
                        }
                        appendTo.append("new ").append(entityImplClass.getQualifiedName()).append("()");
                    } else {
                        appendTo.append(ViewProcessor.this.expandRADModelVars(this.rootBuilder.jenv, vmString, false));
                    }
                } else {
                    appendTo.append("context.getEntity()");
                }
                if (entityWrapperClass != null) {
                    appendTo.append(")");
                }
            } else if (isNode) {
                JavaMethodProxy nodeConstructor;
                JavaClassProxy paramTypeProxy = this.newJavaClassProxy(componentType);
                if (paramTypeProxy.typeEl.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    paramTypeProxy = this.newJavaClassProxy(this.lookupClass("com.codename1.rad.nodes.ViewNode"));
                }
                if ((nodeConstructor = paramTypeProxy.getBestConstructor(tagContext.getOwnerDocument().createElement(paramTypeProxy.getSimpleName()))) == null) {
                    throw new IllegalArgumentException("Cannot find suitable constructor for class " + paramTypeProxy.getQualifiedName() + " in order to inject property into tag " + tagContext.getTagName());
                }
                appendTo.append("_setParent(").append(paramTypeProxy.getQualifiedName()).append(".class, ");
                nodeConstructor.callAsConstructor(appendTo, tagContext.getOwnerDocument().createElement(paramTypeProxy.getSimpleName()), false);
                appendTo.append(")");
            } else if (componentType.getQualifiedName().contentEquals("com.codename1.rad.controllers.ApplicationController")) {
                appendTo.append("applicationController");
            } else if (componentType.getQualifiedName().contentEquals("com.codename1.rad.controllers.FormController")) {
                appendTo.append("formController");
            } else if (componentType.getQualifiedName().contentEquals("com.codename1.rad.controllers.ViewController")) {
                appendTo.append("context.getController()");
            } else if (componentType.getQualifiedName().contentEquals("com.codename1.rad.controllers.Controller")) {
                appendTo.append("context.getController()");
            } else if (this.isA(componentType, "com.codename1.rad.ui.ViewContext")) {
                JavaMethodProxy contextConstructor;
                JavaClassProxy paramClass = this.newJavaClassProxy(componentType);
                Element vcTag = tagContext.getOwnerDocument().createElement(paramType.getQualifiedName().toString());
                List<Element> nodeChildren = this.getChildrenOfType(tagContext, "com.codename1.rad.nodes.Node");
                nodeChildren.addAll(this.getChildrenOfType(tagContext, "com.codename1.rad.models.Entity"));
                nodeChildren.addAll(this.getChildrenOfType(tagContext, "com.codename1.rad.controllers.Controller"));
                for (Element nodeChild : nodeChildren) {
                    if (nodeChild.hasAttribute("rad-property")) continue;
                    vcTag.appendChild(nodeChild.cloneNode(true));
                }
                tagContext.appendChild(vcTag);
                if (tagContext.hasAttribute("view-model")) {
                    vcTag.setAttribute("view-model", tagContext.getAttribute("view-model"));
                }
                if ((contextConstructor = paramClass.getBestConstructor(vcTag)) == null) {
                    StringBuilder err = new StringBuilder();
                    err.append("Type variables of " + paramClass.typeEl + ": " + paramClass.typeEl.getTypeParameters()).append("\n");
                    for (TypeParameterElement typeParameterElement : paramClass.typeEl.getTypeParameters()) {
                        err.append("Bounds:").append(typeParameterElement.getBounds()).append("\n");
                    }
                    err.append("Found constructors:\n");
                    for (JavaMethodProxy javaMethodProxy : paramClass.getPublicConstructors()) {
                        err.append(javaMethodProxy.methodEl).append("\n");
                        err.append("Type variables of ").append(javaMethodProxy.methodEl).append(":").append(javaMethodProxy.executableType().getTypeVariables()).append("\n");
                        err.append("Parameter types: ").append(javaMethodProxy.getParameterTypes()).append("\n");
                    }
                    throw new IllegalArgumentException("Failed to find constructor for  tag " + vcTag);
                }
                contextConstructor.callAsConstructor(appendTo, vcTag, false);
            } else {
                appendTo.append(defaultValue);
            }
        }

        void writeInjectedValue(StringBuilder appendTo, TypeElement paramType, Element tagContext, String propertyName, boolean useInjection) {
            TypeElement componentType;
            String lcPropertyName = propertyName == null ? null : propertyName.toLowerCase();
            String attributeName = Character.isDigit(propertyName.charAt(0)) ? "_" + propertyName + "_" : propertyName;
            HashMap lcAttributes = new HashMap();
            ViewProcessor.forEachAttribute(tagContext, attr -> {
                lcAttributes.put(attr.getName().toLowerCase(), attr.getValue());
                return null;
            });
            String arrayParamPrefix = "";
            String arrayParamSuffix = "";
            boolean isArray = paramType.asType().getKind() == TypeKind.ARRAY;
            TypeElement typeElement = componentType = isArray ? (TypeElement)((DeclaredType)((ArrayType)((Object)paramType)).getComponentType()).asElement() : paramType;
            if (isArray) {
                arrayParamPrefix = "new " + paramType + "[]{";
                arrayParamSuffix = "}";
            }
            boolean useLookup = useInjection && this.isTypeInjectableViaLookup(componentType);
            boolean isEntity = this.isA(componentType, "com.codename1.rad.models.Entity");
            boolean isComponent = !isEntity && this.isA(componentType, "com.codename1.ui.Component");
            boolean isNode = !isEntity && !isComponent && this.isA(componentType, "com.codename1.rad.nodes.Node");
            TypeElement entityWrapperClass = null;
            if (isEntity && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.Entity") && !componentType.getQualifiedName().contentEquals("com.codename1.rad.models.EntityList")) {
                entityWrapperClass = this.lookupClass(componentType.getQualifiedName() + "Wrapper");
            }
            if (lcAttributes.containsKey(attributeName.toLowerCase())) {
                if (entityWrapperClass != null) {
                    appendTo.append(entityWrapperClass.getQualifiedName()).append(".wrap(");
                }
                appendTo.append(this.quoteString((String)lcAttributes.get(attributeName.toLowerCase()), componentType));
                if (entityWrapperClass != null) {
                    appendTo.append(")");
                }
                return;
            }
            Stream<Element> childStream = ViewProcessor.getChildElements(tagContext).stream().filter(e -> !e.hasAttribute("rad-used-for")).filter(e -> propertyName.equalsIgnoreCase(e.getAttribute("rad-property")) || useInjection && !e.hasAttribute("rad-property")).filter(e -> {
                if (propertyName.equalsIgnoreCase(e.getAttribute("rad-property"))) {
                    return true;
                }
                TypeElement el = this.findClassThatTagCreates(e.getTagName(), componentType.getQualifiedName().toString());
                return el != null;
            });
            if (isArray) {
                List childElements = childStream.collect(Collectors.toList());
                if (useLookup && childElements.isEmpty()) {
                    appendTo.append("nonNullEntries(").append(arrayParamPrefix).append("viewController.lookup(").append(componentType.getQualifiedName()).append(".class)").append(arrayParamSuffix).append(", ");
                }
                appendTo.append(arrayParamPrefix);
                if (!childElements.isEmpty()) {
                    for (Element childElement : childElements) {
                        childElement.setAttribute("rad-property", propertyName);
                        childElement.setAttribute("rad-used-for", propertyName);
                        if (entityWrapperClass != null) {
                            appendTo.append(entityWrapperClass.getQualifiedName()).append(".wrap(");
                        }
                        if (isComponent) {
                            appendTo.append("createComponent").append(childElement.getAttribute("rad-id")).append("()");
                        } else if (isNode) {
                            appendTo.append("_setParent(").append(componentType.getQualifiedName()).append(".class, ").append("createNode").append(childElement.getAttribute("rad-id")).append("())");
                        } else {
                            appendTo.append("createBean").append(childElement.getAttribute("rad-id")).append("()");
                        }
                        if (entityWrapperClass == null) continue;
                        appendTo.append(")");
                    }
                } else if (useInjection) {
                    this.writeInjectedValueFromContext(appendTo, paramType, tagContext, "");
                }
                appendTo.append(arrayParamSuffix);
                if (useLookup && childElements.isEmpty()) {
                    appendTo.append(")");
                }
                return;
            }
            Element childElement = childStream.findFirst().orElse(null);
            if (useLookup && childElement == null) {
                appendTo.append("nonNull(context.getController().lookup(").append(componentType.getQualifiedName()).append(".class), ");
            }
            if (childElement != null) {
                childElement.setAttribute("rad-property", propertyName);
                childElement.setAttribute("rad-used-for", propertyName);
                if (entityWrapperClass != null) {
                    appendTo.append(entityWrapperClass.getQualifiedName()).append(".wrap(");
                }
                if (ViewProcessor.this.isComponent(paramType)) {
                    appendTo.append("createComponent").append(childElement.getAttribute("rad-id")).append("()");
                } else if (ViewProcessor.this.isNode(paramType)) {
                    appendTo.append("_setParent(").append(paramType.getQualifiedName()).append(".class, ").append("createNode").append(childElement.getAttribute("rad-id")).append("())");
                } else {
                    appendTo.append("createBean").append(childElement.getAttribute("rad-id")).append("()");
                }
                if (entityWrapperClass != null) {
                    appendTo.append(")");
                }
            } else if (!useInjection) {
                appendTo.append("null");
            } else {
                this.writeInjectedValueFromContext(appendTo, paramType, tagContext, "null");
            }
            if (useLookup && childElement == null) {
                appendTo.append(")");
            }
        }

        private static /* synthetic */ boolean lambda$buildIndex$0(javax.lang.model.element.Element e) {
            return e.getKind() == ElementKind.METHOD && e.getSimpleName().contentEquals("getComponent") && ((ExecutableElement)e).getParameters().isEmpty();
        }

        private class ClassIndex {
            private Set<String> componentIndex = new HashSet<String>();
            private Set<String> containerIndex = new HashSet<String>();
            private Set<String> componentBuilderIndex = new HashSet<String>();
            private Map<String, TypeElement> componentBuilderMap = new HashMap<String, TypeElement>();
            private Map<String, TypeElement> tagToComponentMap = new HashMap<String, TypeElement>();

            private ClassIndex() {
            }

            static /* synthetic */ Set access$600(ClassIndex x0) {
                return x0.containerIndex;
            }

            static /* synthetic */ Set access$700(ClassIndex x0) {
                return x0.componentBuilderIndex;
            }

            static /* synthetic */ Map access$800(ClassIndex x0) {
                return x0.componentBuilderMap;
            }
        }
    }

    private class RoundCache {
        Map<String, Boolean> isComponent = new HashMap<String, Boolean>();
        Map<String, Boolean> isContainer = new HashMap<String, Boolean>();
        Map<String, Boolean> isEntityView = new HashMap<String, Boolean>();
        Map<String, Boolean> isNode = new HashMap<String, Boolean>();

        private RoundCache() {
        }
    }
}

