/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.RADDoc;
import com.codename1.rad.annotations.processors.ViewProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class XMLSchemaGenerator {
    private ViewProcessor.JavaEnvironment env;
    private ProcessingEnvironment processingEnvironment;
    private File rootDirectory;
    private TypeElement javaClass;
    private TypeElement builderClass;
    private int indent = 0;
    private String checksum;
    private Map<String, TypeElement> allTags = new HashMap<String, TypeElement>();
    private boolean writeElements;
    private boolean partialSchema;
    private List<File> includes = new ArrayList<File>();
    private List<XMLSchemaGenerator> subGenerators = new ArrayList<XMLSchemaGenerator>();
    private Set<TypeElement> enumTypes = new HashSet<TypeElement>();
    private Set<AttributeGroup> requiredAttributeGroups = new HashSet<AttributeGroup>();
    private Set<AttributeGroup> writtenAttributeGroups = new HashSet<AttributeGroup>();

    public void setPartialSchema(boolean partial) {
        this.partialSchema = partial;
    }

    public XMLSchemaGenerator(ProcessingEnvironment processingEnvironment, ViewProcessor.JavaEnvironment env, File rootDirectory, TypeElement javaClass, TypeElement builderClass) {
        this.processingEnvironment = processingEnvironment;
        this.env = env;
        this.rootDirectory = rootDirectory;
        this.javaClass = javaClass;
        this.builderClass = builderClass;
    }

    public void setAllTags(Map<String, TypeElement> tags) {
        this.allTags.clear();
        this.allTags.putAll(tags);
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void addInclude(File includeFile) {
        this.includes.add(includeFile);
    }

    public void addSubGenerator(XMLSchemaGenerator generator) {
        this.subGenerators.add(generator);
    }

    public void writeToFile() throws IOException {
        if (this.getSchemaFile().exists()) {
            return;
        }
        this.getSchemaFile().getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(this.getSchemaFile());){
            fos.write(this.writeSchema(new StringBuilder()).toString().getBytes("utf-8"));
        }
    }

    public File getCommonDir() {
        File cn1PropertiesFile = new File("codenameone_settings.properties");
        for (File dir = this.rootDirectory; dir != null; dir = dir.getParentFile()) {
            if (!(cn1PropertiesFile = new File(dir, cn1PropertiesFile.getName())).exists()) continue;
            return cn1PropertiesFile.getParentFile();
        }
        return null;
    }

    public File getSchemaFile() throws IOException {
        if (this.writeElements) {
            File commonDir = this.getCommonDir();
            if (commonDir == null) {
                throw new IOException("Cannot locate schema file for view " + this.javaClass);
            }
            File radViews = new File(commonDir, "src" + File.separator + "main" + File.separator + "rad" + File.separator + "views");
            return new File(radViews, this.javaClass.getQualifiedName().toString().replace('.', File.separatorChar) + ".xsd");
        }
        String path = this.javaClass.getQualifiedName().toString().replace('.', File.separatorChar);
        File out = new File(this.rootDirectory, path + ".xsd");
        if (this.partialSchema && !out.exists()) {
            return new File(this.rootDirectory, path + "-partial.xsd");
        }
        return out;
    }

    private String toCamelCase(String str) {
        int lowerCaseIndex = -1;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            lowerCaseIndex = i;
            break;
        }
        if (lowerCaseIndex < 0) {
            return str.toLowerCase();
        }
        if (lowerCaseIndex == 0) {
            return str;
        }
        return str.substring(0, lowerCaseIndex).toLowerCase() + str.substring(lowerCaseIndex);
    }

    public void setWriteElements(boolean writeElements) {
        this.writeElements = writeElements;
    }

    public StringBuilder writeSchema(StringBuilder sb) throws IOException {
        return this.writeSchema(sb, true);
    }

    private File getAttributeGroupFile(AttributeGroup group) {
        return new File(this.getCommonDir(), "target" + File.separator + "generated-sources" + File.separator + "rad" + File.separator + "xmlSchemas" + File.separator + group.prefix + "-" + group.type + "-" + group.depth + ".attgroup.xml");
    }

    /*
     * WARNING - void declaration
     */
    public StringBuilder writeSchema(StringBuilder sb, boolean writeHeader) throws IOException {
        if (writeHeader) {
            sb.append("<?xml version=\"1.0\"?>\n");
        }
        if (this.writeElements) {
            sb.append("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n");
        }
        if (this.checksum != null) {
            sb.append("<!-- ").append(this.checksum).append(" -->\n");
        }
        this.indent += 2;
        for (File file : this.includes) {
            String content;
            try (FileInputStream fis = new FileInputStream(file);){
                byte[] bytes2 = new byte[(int)file.length()];
                fis.read(bytes2);
                content = new String(bytes2, "UTF-8");
            }
            content = content.trim();
            if (content.startsWith("====\n")) {
                int headMatterEndPos = content.indexOf("====\n", 5);
                if (headMatterEndPos < 0) {
                    throw new IOException("Invalid content found in file " + file + ".  Found head matter with no end separator.");
                }
                String headMatter = content.substring(5, headMatterEndPos + 5).trim();
                if ((content = content.substring(headMatterEndPos + 5).trim()).startsWith("<?xml")) {
                    content = content.substring(content.indexOf("?>") + 2).trim();
                }
                StringTokenizer strtok = new StringTokenizer(headMatter, "\n");
                while (strtok.hasMoreTokens()) {
                    TypeElement requiredType;
                    String nextTok = strtok.nextToken().trim();
                    if (nextTok.startsWith("requireAttributeGroup ")) {
                        String string;
                        String type;
                        String attGroupCoords = nextTok.substring(nextTok.indexOf(" ") + 1);
                        String prefix = attGroupCoords.substring(0, attGroupCoords.indexOf(":"));
                        File attgroupFile = this.getAttributeGroupFile(new AttributeGroup(prefix, type = attGroupCoords.substring(prefix.length() + 1, attGroupCoords.indexOf(":", prefix.length() + 1)), Integer.parseInt(string = attGroupCoords.substring(attGroupCoords.lastIndexOf(":") + 1))));
                        if (!attgroupFile.exists()) {
                            throw new IOException("Cannot find attribute group file at " + attgroupFile + " required by " + file + " while processing schema for " + this.javaClass);
                        }
                        FileInputStream fis = new FileInputStream(attgroupFile);
                        try {
                            byte[] bytes3 = new byte[(int)attgroupFile.length()];
                            fis.read(bytes3);
                            String tmp = new String(bytes3, "UTF-8").trim();
                            if (tmp.startsWith("<?xml")) {
                                tmp = tmp.substring(tmp.indexOf("?>") + 2).trim();
                            }
                            content = tmp + "\n" + content;
                            continue;
                        }
                        finally {
                            fis.close();
                            continue;
                        }
                    }
                    if (!nextTok.startsWith("require ") || (requiredType = this.processingEnvironment.getElementUtils().getTypeElement(nextTok.substring(nextTok.indexOf(" ") + 1).trim())) == null) continue;
                    File requiredTypeFile = this.getClassSchemaFile(requiredType);
                    if (!requiredTypeFile.exists()) {
                        throw new IOException("Cannot find type schema " + requiredTypeFile + " required by " + file + " while processing schema for " + this.javaClass);
                    }
                    try (FileInputStream fis = new FileInputStream(requiredTypeFile);){
                        byte[] byArray = new byte[(int)requiredTypeFile.length()];
                        fis.read(byArray);
                        String tmp = new String(byArray, "UTF-8").trim();
                        if (tmp.startsWith("<?xml")) {
                            tmp = tmp.substring(tmp.indexOf("?>") + 2).trim();
                        }
                        content = tmp + "\n" + content;
                    }
                }
            }
            this.indent(sb, this.indent).append(content).append("\n");
        }
        if (!this.writeElements) {
            HashSet parentMembers = new HashSet();
            Object var4_6 = null;
            TypeElement superType = null;
            TypeMirror superclass = this.javaClass.getSuperclass();
            if (superclass != null && superclass.getKind() == TypeKind.DECLARED) {
                superType = (TypeElement)((DeclaredType)superclass).asElement();
            }
            if (superType != null) {
                String string = superType.getQualifiedName().toString().replace('.', '_');
                TypeElement fSuperType = superType;
                DeclaredType fDeclaredSuperType = (DeclaredType)fSuperType.asType();
                this.processingEnvironment.getElementUtils().getAllMembers(superType).forEach(e -> {
                    ExecutableType methodMirror;
                    TypeMirror methodReturnType;
                    TypeMirror tm;
                    if (e.getKind() == ElementKind.METHOD && e.getSimpleName().toString().startsWith("get") && (tm = this.processingEnvironment.getTypeUtils().asMemberOf(fDeclaredSuperType, (Element)e)).getKind() == TypeKind.EXECUTABLE && ((methodReturnType = (methodMirror = (ExecutableType)tm).getReturnType()).getKind() == TypeKind.TYPEVAR || methodReturnType.getKind() == TypeKind.WILDCARD)) {
                        return;
                    }
                    parentMembers.add(e);
                });
            }
            String complexTypeName = this.javaClass.getQualifiedName().toString().replace('.', '_');
            HashSet<String> attributeNames = new HashSet<String>();
            for (TypeElement clazz : new TypeElement[]{this.javaClass, this.builderClass}) {
                void var4_8;
                if (clazz == null) {
                    this.indent(sb, this.indent).append("<xs:complexType name=\"").append(complexTypeName).append("-impl\">\n");
                    this.indent(sb, this.indent).append("  <xs:complexContent>\n");
                    this.indent(sb, this.indent).append("    <xs:extension base=\"").append(complexTypeName).append("\"/>\n");
                    this.indent(sb, this.indent).append("  </xs:complexContent>\n");
                    this.indent(sb, this.indent).append("</xs:complexType>\n");
                    continue;
                }
                if (clazz == this.builderClass) {
                    this.indent(sb, this.indent).append("<xs:complexType name=\"").append(complexTypeName).append("-impl\">\n");
                    this.indent += 2;
                    this.indent(sb, this.indent).append("<xs:complexContent>\n");
                    this.indent += 2;
                    this.indent(sb, this.indent).append("<xs:extension base=\"").append(complexTypeName).append("\">\n");
                    this.indent += 2;
                } else {
                    String mixed = var4_8 != null ? "" : " mixed=\"true\"";
                    this.indent(sb, this.indent).append("<xs:complexType name=\"").append(complexTypeName).append("\"").append(mixed).append(">\n");
                    this.indent += 2;
                    if (var4_8 != null) {
                        this.indent(sb, this.indent).append("<xs:complexContent>\n");
                        this.indent += 2;
                        this.indent(sb, this.indent).append("<xs:extension base=\"").append((String)var4_8).append("\">\n");
                        this.indent += 2;
                    } else {
                        this.indent(sb, this.indent).append("<xs:sequence><xs:any minOccurs=\"0\" maxOccurs=\"unbounded\" processContents=\"lax\"/></xs:sequence>");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"layout-constraint\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"layout-rows\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"layout-columns\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-transition\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-leadComponent\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-implements\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-href\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-href-trigger\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"view-model\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"view-controller\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-extends\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-model\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-var\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-property\" type=\"xs:string\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"rad-condition\" type=\"xs:string\"/>\n");
                    }
                }
                if (clazz.getQualifiedName().contentEquals("com.codename1.ui.Component")) {
                    TypeElement componentBinder = this.processingEnvironment.getElementUtils().getTypeElement("com.codename1.rad.ui.builders.ComponentBinder");
                    for (Element member : this.processingEnvironment.getElementUtils().getAllMembers(componentBinder)) {
                        if (member.getKind() != ElementKind.METHOD || !member.getSimpleName().toString().startsWith("bind")) continue;
                        String propertyName = this.toCamelCase(member.getSimpleName().toString().substring(4));
                        this.indent(sb, this.indent).append("<xs:attribute name=\"bind-").append(propertyName).append("\" type=\"xs:string\"/>\n");
                    }
                }
                for (Element element2 : this.processingEnvironment.getElementUtils().getAllMembers(clazz)) {
                    TypeMirror retTypeMirror;
                    if (var4_8 != null && parentMembers.contains(element2) || element2.getKind() != ElementKind.METHOD) continue;
                    ExecutableElement methodEl = (ExecutableElement)element2;
                    if (methodEl.getParameters().size() == 1) {
                        ExecutableType methodType;
                        String methodName;
                        String propertyName = methodName = methodEl.getSimpleName().toString();
                        if (clazz == this.javaClass && !methodName.startsWith("set") || clazz == this.builderClass && !methodName.startsWith("set") && !this.env.isA((methodType = (ExecutableType)this.processingEnvironment.getTypeUtils().asMemberOf((DeclaredType)this.builderClass.asType(), methodEl)).getReturnType(), "com.codename1.rad.ui.ComponentBuilder")) continue;
                        if (methodName.startsWith("set")) {
                            propertyName = propertyName.substring(3);
                        }
                        if (propertyName.isEmpty() || attributeNames.contains((propertyName = this.toCamelCase(propertyName)).toLowerCase())) continue;
                        attributeNames.add(propertyName.toLowerCase());
                        TypeMirror paramTypeMirror = methodEl.getParameters().get(0).asType();
                        List enumValues = null;
                        TypeElement parameterType = null;
                        if (paramTypeMirror.getKind() == TypeKind.DECLARED) {
                            parameterType = (TypeElement)((DeclaredType)paramTypeMirror).asElement();
                            enumValues = parameterType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
                        }
                        String type = "xs:string";
                        if (enumValues != null && !enumValues.isEmpty()) {
                            type = parameterType.getQualifiedName().toString().replace('.', '_');
                            this.enumTypes.add(parameterType);
                        }
                        this.indent(sb, this.indent).append("<xs:attribute name=\"").append(propertyName).append("\" type=\"").append(type).append("\"/>\n");
                        if (clazz != this.javaClass) continue;
                        this.indent(sb, this.indent).append("<xs:attribute name=\"").append("bind-" + propertyName).append("\" type=\"xs:string\"/>\n");
                        continue;
                    }
                    if (clazz != this.javaClass || methodEl.getParameters().size() != 0 || !methodEl.getSimpleName().toString().startsWith("get")) continue;
                    boolean useAttributeGroups = true;
                    ExecutableType methodType = (ExecutableType)this.processingEnvironment.getTypeUtils().asMemberOf((DeclaredType)clazz.asType(), methodEl);
                    String propertyName = this.toCamelCase(methodEl.getSimpleName().toString().substring(3));
                    if (methodType == null || methodType.getReturnType() == null || !this.env.isA(methodType.getReturnType(), "com.codename1.ui.plaf.Style") && !methodEl.getSimpleName().contentEquals("getComponentForm") && !methodEl.getSimpleName().contentEquals("getParent") && !this.env.isA(methodType.getReturnType(), "com.codename1.rad.nodes.ActionNode.Builder") && (methodEl.getAnnotation(RADDoc.class) == null || !methodEl.getAnnotation(RADDoc.class).generateSubattributeHints() || methodType.getReturnType().getKind() != TypeKind.DECLARED) || (retTypeMirror = methodType.getReturnType()).getKind() != TypeKind.DECLARED) continue;
                    TypeElement retType = (TypeElement)((DeclaredType)retTypeMirror).asElement();
                    if (useAttributeGroups) {
                        this.indent(sb, this.indent).append("<xs:attributeGroup ref=\"").append(this.getAttributeGroupName((DeclaredType)retTypeMirror, propertyName + ".", 2)).append("\" />\n");
                        this.addRequiredAttributeGroup(new AttributeGroup(propertyName + ".", retType.getQualifiedName().toString(), 2));
                        continue;
                    }
                    for (Element element3 : this.processingEnvironment.getElementUtils().getAllMembers(retType)) {
                        String subMethodName = element3.getSimpleName().toString();
                        if (element3.getKind() != ElementKind.METHOD || !subMethodName.startsWith("set") || ((ExecutableElement)element3).getParameters().size() != 1) continue;
                        List enumValues = null;
                        TypeElement parameterType = null;
                        TypeMirror parameterTypeMirror = ((ExecutableElement)element3).getParameters().get(0).asType();
                        if (parameterTypeMirror.getKind() == TypeKind.DECLARED) {
                            parameterType = (TypeElement)((DeclaredType)parameterTypeMirror).asElement();
                            enumValues = parameterType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
                        }
                        String type = "xs:string";
                        if (enumValues != null && !enumValues.isEmpty()) {
                            type = parameterType.toString().replace('.', '_');
                            this.enumTypes.add(parameterType);
                        }
                        this.indent(sb, this.indent).append("<xs:attribute name=\"").append(propertyName).append(".").append(this.toCamelCase(subMethodName.toString().substring(3))).append("\" type=\"").append(type).append("\"/>\n");
                        this.indent(sb, this.indent).append("<xs:attribute name=\"bind-").append(propertyName).append(".").append(this.toCamelCase(subMethodName.toString().substring(3))).append("\" type=\"xs:string\"/>\n");
                    }
                }
                if (clazz == this.builderClass || var4_8 != null) {
                    this.indent -= 2;
                    this.indent(sb, this.indent).append("</xs:extension>\n");
                    this.indent -= 2;
                    this.indent(sb, this.indent).append("</xs:complexContent>\n");
                }
                this.indent -= 2;
                this.indent(sb, this.indent).append("</xs:complexType>\n");
            }
            for (TypeElement enumType : this.enumTypes) {
                this.indent(sb, this.indent).append("<xs:simpleType name=\"").append(enumType.getQualifiedName().toString().replace('.', '_')).append("\">\n");
                this.indent(sb, this.indent).append("  <xs:restriction base=\"xs:string\">\n");
                List enumValues = enumType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
                for (String enumVal : enumValues) {
                    this.indent(sb, this.indent).append("    <xs:enumeration value=\"").append(enumVal).append("\" />\n");
                }
                this.indent(sb, this.indent).append("  </xs:restriction>\n");
                this.indent(sb, this.indent).append("</xs:simpleType>\n");
            }
            for (XMLSchemaGenerator subGenerator : this.subGenerators) {
                subGenerator.writeSchema(sb, false);
            }
        }
        if (this.writeElements) {
            this.indent(sb, this.indent).append("<xs:element name=\"script\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"import\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"view-model\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:sequence>\n");
            this.indent(sb, this.indent).append("      <xs:element ref=\"define-property\" minOccurs=\"0\" maxOccurs=\"unbounded\"/>\n");
            this.indent(sb, this.indent).append("    </xs:sequence>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"extends\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"implements\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"form-controller\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"extends\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"implements\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"view-controller\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"extends\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"bind-action\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"category\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"inherit\" type=\"xs:boolean\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"on\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"define-tag\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"name\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"value\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"type\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"initialValue\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"use-taglib\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"package\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"class\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"define-property\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"name\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"type\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"initialValue\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"define-category\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"name\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"value\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"var\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"value\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"lookup\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"name\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"type\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"define-slot\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:sequence>\n");
            this.indent(sb, this.indent).append("      <xs:any minOccurs=\"0\" maxOccurs=\"1\" />\n");
            this.indent(sb, this.indent).append("    </xs:sequence>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"id\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"fill-slot\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:sequence>\n");
            this.indent(sb, this.indent).append("      <xs:any minOccurs=\"0\" maxOccurs=\"1\"/>\n");
            this.indent(sb, this.indent).append("    </xs:sequence>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"id\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            this.indent(sb, this.indent).append("<xs:element name=\"row-template\">\n");
            this.indent(sb, this.indent).append("  <xs:complexType>\n");
            this.indent(sb, this.indent).append("    <xs:sequence>\n");
            this.indent(sb, this.indent).append("      <xs:any minOccurs=\"0\" maxOccurs=\"1\"/>\n");
            this.indent(sb, this.indent).append("    </xs:sequence>\n");
            this.indent(sb, this.indent).append("    <xs:attribute name=\"case\" type=\"xs:string\"/>\n");
            this.indent(sb, this.indent).append("  </xs:complexType>\n");
            this.indent(sb, this.indent).append("</xs:element>\n");
            for (Map.Entry entry : this.allTags.entrySet()) {
                if (!((TypeElement)entry.getValue()).getModifiers().contains((Object)Modifier.PUBLIC) || ((TypeElement)entry.getValue()).getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                this.indent(sb, this.indent).append("<xs:element name=\"").append((String)entry.getKey()).append("\" type=\"").append(((TypeElement)entry.getValue()).getQualifiedName().toString().replace('.', '_')).append("-impl\"/>\n");
            }
        }
        if (this.writeElements) {
            this.indent -= 2;
            this.indent(sb, this.indent).append("</xs:schema>\n");
        } else {
            StringBuilder stringBuilder;
            boolean includeHeadmatter = !this.requiredAttributeGroups.isEmpty() || !this.enumTypes.isEmpty();
            StringBuilder stringBuilder2 = stringBuilder = includeHeadmatter ? new StringBuilder() : null;
            if (includeHeadmatter) {
                stringBuilder.append("====\n");
            }
            if (!this.requiredAttributeGroups.isEmpty()) {
                HashSet<AttributeGroup> currentRound = new HashSet<AttributeGroup>(this.requiredAttributeGroups);
                while (!currentRound.isEmpty()) {
                    for (AttributeGroup group : currentRound) {
                        stringBuilder.append("requireAttributeGroup ").append(group.prefix).append(":").append(group.type).append(":").append(group.depth).append("\n");
                        File attGroupFile = this.getAttributeGroupFile(group);
                        if (!attGroupFile.exists()) {
                            StringBuilder attGroupContent = new StringBuilder();
                            this.writeAttributeGroup(attGroupContent, (DeclaredType)this.env.lookupClass(group.type).asType(), group.prefix, group.depth);
                            attGroupFile.getParentFile().mkdirs();
                            try (FileOutputStream fos = new FileOutputStream(attGroupFile);){
                                fos.write(attGroupContent.toString().getBytes("UTF-8"));
                            }
                        }
                        this.writtenAttributeGroups.add(group);
                    }
                    currentRound.clear();
                    currentRound.addAll(this.requiredAttributeGroups);
                    currentRound.removeAll(this.writtenAttributeGroups);
                }
            }
            if (!this.enumTypes.isEmpty()) {
                for (TypeElement enumType : this.enumTypes) {
                    stringBuilder.append("require ").append(enumType.getQualifiedName()).append("\n");
                    File enumSchemaFile = this.getClassSchemaFile(enumType);
                    if (enumSchemaFile.exists()) continue;
                    enumSchemaFile.getParentFile().mkdirs();
                    StringBuilder enumSchemaContent = new StringBuilder();
                    this.writeEnumType(enumSchemaContent, enumType);
                    try (FileOutputStream fos = new FileOutputStream(enumSchemaFile);){
                        fos.write(enumSchemaContent.toString().getBytes("UTF-8"));
                    }
                }
            }
            if (includeHeadmatter) {
                stringBuilder.append("====\n");
                sb.insert(0, stringBuilder);
            }
        }
        return sb;
    }

    private File getClassSchemaFile(TypeElement enumType) {
        return new File(this.getCommonDir(), "target" + File.separator + "generated-sources" + File.separator + "rad" + File.separator + "xmlSchemas" + File.separator + enumType.getQualifiedName().toString().replace('.', File.separatorChar) + ".xsd");
    }

    private void writeEnumType(StringBuilder sb, TypeElement enumType) {
        this.indent(sb, this.indent).append("<xs:simpleType name=\"").append(enumType.getQualifiedName().toString().replace('.', '_')).append("\">\n");
        this.indent(sb, this.indent).append("  <xs:restriction base=\"xs:string\">\n");
        List enumValues = enumType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
        for (String enumVal : enumValues) {
            this.indent(sb, this.indent).append("    <xs:enumeration value=\"").append(enumVal).append("\" />\n");
        }
        this.indent(sb, this.indent).append("  </xs:restriction>\n");
        this.indent(sb, this.indent).append("</xs:simpleType>\n");
    }

    private String getAttributeGroupName(DeclaredType type, String prefix, int depth) {
        TypeElement typeEl = (TypeElement)type.asElement();
        return prefix.replace('.', '_') + "-" + typeEl.getQualifiedName().toString().replace('.', '_') + "-" + depth;
    }

    private void writeAttributeGroup(StringBuilder sb, DeclaredType type, String prefix, int depth) {
        TypeElement typeEl = (TypeElement)type.asElement();
        String groupName = this.getAttributeGroupName(type, prefix, depth);
        this.indent(sb, this.indent).append("<xs:attributeGroup name=\"").append(groupName).append("\">\n");
        this.indent += 2;
        this.processingEnvironment.getElementUtils().getAllMembers(typeEl).forEach(el -> {
            if (el.getKind() != ElementKind.METHOD) {
                return;
            }
            ExecutableElement methodEl = (ExecutableElement)el;
            TypeMirror mirror = this.processingEnvironment.getTypeUtils().asMemberOf(type, methodEl);
            if (mirror.getKind() != TypeKind.EXECUTABLE) {
                return;
            }
            ExecutableType methodType = (ExecutableType)mirror;
            if (methodEl.getSimpleName().toString().startsWith("set") && methodEl.getParameters().size() == 1 && methodEl.getReturnType().getKind() == TypeKind.VOID && ((ExecutableElement)el).getEnclosingElement().equals(typeEl)) {
                String propertyName = methodEl.getSimpleName().toString().substring(3);
                if (propertyName.isEmpty()) {
                    return;
                }
                propertyName = this.toCamelCase(propertyName);
                TypeMirror paramTypeMirror = methodType.getParameterTypes().get(0);
                List enumValues = null;
                TypeElement parameterType = null;
                if (paramTypeMirror.getKind() == TypeKind.DECLARED) {
                    parameterType = (TypeElement)((DeclaredType)paramTypeMirror).asElement();
                    enumValues = parameterType.getEnclosedElements().stream().filter(element -> element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)).map(Object::toString).collect(Collectors.toList());
                }
                String typeAttStr = "xs:string";
                if (enumValues != null && !enumValues.isEmpty()) {
                    typeAttStr = parameterType.getQualifiedName().toString().replace('.', '_');
                    this.enumTypes.add(parameterType);
                }
                this.indent(sb, this.indent).append("<xs:attribute name=\"").append(prefix).append(propertyName).append("\" type=\"").append(typeAttStr).append("\"/>\n");
                this.indent(sb, this.indent).append("<xs:attribute name=\"bind-").append(prefix).append(propertyName).append("\" type=\"").append("xs:string").append("\"/>\n");
                return;
            }
            if (depth > 0 && methodEl.getSimpleName().toString().startsWith("get") && methodEl.getParameters().size() == 0 && methodType.getReturnType().getKind() == TypeKind.DECLARED && ((ExecutableElement)el).getEnclosingElement().equals(typeEl)) {
                String propertyName = methodEl.getSimpleName().toString().substring(3);
                if (propertyName.isEmpty()) {
                    return;
                }
                propertyName = this.toCamelCase(propertyName);
                DeclaredType returnType = (DeclaredType)methodType.getReturnType();
                RADDoc radDoc = methodEl.getAnnotation(RADDoc.class);
                TypeElement returnTypeEl = (TypeElement)(returnType.asElement().getKind() == ElementKind.CLASS || returnType.asElement().getKind() == ElementKind.INTERFACE ? returnType.asElement() : null);
                if (returnTypeEl != null && (radDoc != null && radDoc.generateSubattributeHints() || returnTypeEl.getQualifiedName().contentEquals("com.codename1.ui.plaf.Style") || this.env.isA(returnType, "com.codename1.rad.nodes.ActionNode.Builder") || methodEl.getSimpleName().contentEquals("getComponentForm") || methodEl.getSimpleName().contentEquals("getParent"))) {
                    this.indent(sb, this.indent).append("<xs:attributeGroup ref=\"").append(this.getAttributeGroupName(returnType, prefix + propertyName + ".", depth - 1)).append("\"/>\n");
                    this.addRequiredAttributeGroup(new AttributeGroup(prefix + propertyName + ".", returnTypeEl.getQualifiedName().toString(), depth - 1));
                }
            }
        });
        ArrayList<TypeMirror> superTypes = new ArrayList<TypeMirror>();
        if (typeEl.getSuperclass() != null) {
            superTypes.add(typeEl.getSuperclass());
        }
        superTypes.forEach(superMirror -> {
            if (superMirror.getKind() == TypeKind.DECLARED) {
                DeclaredType superType = (DeclaredType)superMirror;
                Element superTypeEl = superType.asElement();
                if (superTypeEl == null) {
                    return;
                }
                if (superTypeEl.getKind() == ElementKind.CLASS || superTypeEl.getKind() == ElementKind.INTERFACE) {
                    this.indent(sb, this.indent).append("<xs:attributeGroup ref=\"").append(this.getAttributeGroupName(superType, prefix, depth)).append("\"/>\n");
                    this.addRequiredAttributeGroup(new AttributeGroup(prefix, ((TypeElement)superTypeEl).getQualifiedName().toString(), depth));
                }
            }
        });
        this.indent -= 2;
        this.indent(sb, this.indent).append("</xs:attributeGroup>\n");
    }

    private StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private void addRequiredAttributeGroup(AttributeGroup group) {
        if (this.writtenAttributeGroups.contains(group)) {
            return;
        }
        this.requiredAttributeGroups.add(group);
    }

    private class AttributeGroup {
        private String prefix;
        private String type;
        private int depth;

        public AttributeGroup(String prefix, String type, int depth) {
            this.prefix = prefix;
            this.type = type;
            this.depth = depth;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeGroup that = (AttributeGroup)o;
            return this.depth == that.depth && this.prefix.equals(that.prefix) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.type, this.depth);
        }
    }
}

