/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.processors.HelperFunctions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

class StaleXMLSchemaGarbageCollector
implements Runnable {
    private final File javaSourcesDirectory;
    private final File radViewsDirectory;

    StaleXMLSchemaGarbageCollector(File javaSourcesDirectory, File radViewsDirectory) {
        this.javaSourcesDirectory = javaSourcesDirectory;
        this.radViewsDirectory = radViewsDirectory;
    }

    private Collection<File> getAllJavaSourceFiles() {
        return this.getAllJavaSourceFiles(this.javaSourcesDirectory, new LinkedHashSet<File>());
    }

    private Collection<File> getAllJavaSourceFiles(File directory, Collection<File> out) {
        for (File child : directory.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".java")) {
                out.add(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.getAllJavaSourceFiles(child, out);
        }
        return out;
    }

    private Collection<File> getAllSchemaFiles() {
        return this.getAllSchemaFilesInDirectory(this.radViewsDirectory, new LinkedHashSet<File>());
    }

    private Collection<File> getAllSchemaFilesInDirectory(File directory, Collection<File> out) {
        for (File child : directory.listFiles()) {
            if (child.isFile() && child.getName().endsWith(".xsd")) {
                out.add(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.getAllSchemaFilesInDirectory(child, out);
        }
        return out;
    }

    private String getRelativePath(File javaSourceFile) {
        String javaSourcesPath = this.javaSourcesDirectory.getAbsolutePath().replace("\\", "/");
        String sourceFilePath = javaSourceFile.getAbsolutePath().replace("\\", "/");
        if (sourceFilePath.startsWith(javaSourcesPath)) {
            String relativePath = sourceFilePath.substring(javaSourcesPath.length());
            if (relativePath.startsWith("/")) {
                relativePath = relativePath.substring(1);
            }
            return relativePath;
        }
        throw new IllegalArgumentException("Source file " + javaSourceFile + " is not in the java sources directory. " + this.javaSourcesDirectory);
    }

    private String getNormalizedClassName(File javaSourceFile) {
        String name = this.getRelativePath(javaSourceFile).replace("/", "_");
        if (name.endsWith(".java") || name.endsWith(".kt")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    private boolean containsString(File haystack, String needle) {
        try {
            boolean out = HelperFunctions.fileContainsString(needle, haystack);
            return out;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private Collection<File> findSchemasUsingJavaClass(File javaSourceFile) {
        return this.findSchemasUsingJavaClass(javaSourceFile, this.getAllSchemaFiles());
    }

    private Collection<File> findSchemasUsingJavaClass(File javaSourceFile, Collection<File> schemas) {
        ArrayList out = new ArrayList();
        String normalizedClassName = this.getNormalizedClassName(javaSourceFile);
        return schemas.stream().filter(schemaFile -> this.containsString((File)schemaFile, normalizedClassName)).collect(Collectors.toList());
    }

    private Collection<File> findDirtySchemas() {
        LinkedHashSet<File> cleanSchemas = new LinkedHashSet<File>(this.getAllSchemaFiles());
        LinkedHashSet<File> dirtySchemas = new LinkedHashSet<File>();
        for (File javaSourceFile : this.getAllJavaSourceFiles()) {
            if (cleanSchemas.isEmpty()) {
                return dirtySchemas;
            }
            long lastModified = javaSourceFile.lastModified();
            Collection schemasUsingJavaClass = this.findSchemasUsingJavaClass(javaSourceFile, cleanSchemas).stream().filter(schemaFile -> schemaFile.lastModified() < lastModified).collect(Collectors.toList());
            cleanSchemas.removeAll(schemasUsingJavaClass);
            dirtySchemas.addAll(schemasUsingJavaClass);
        }
        return dirtySchemas;
    }

    @Override
    public void run() {
        this.findDirtySchemas().forEach(schemaFile -> schemaFile.delete());
    }
}

