/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.RAD;
import com.codename1.rad.annotations.processors.ProcessingEnvironmentWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public abstract class BaseProcessor
extends AbstractProcessor {
    abstract void installTypes(Set<? extends TypeElement> var1, RoundEnvironment var2);

    boolean isA(TypeMirror mirror, String fqn) {
        if (mirror == null) {
            throw new IllegalArgumentException("isA() received null type argument.  isA requires a non-null value for its mirror type");
        }
        TypeElement superclass = this.elements().getTypeElement(fqn);
        if (superclass == null) {
            throw new IllegalArgumentException("Cannot find class " + fqn);
        }
        if (this.types().isSubtype(mirror, superclass.asType())) {
            return true;
        }
        if (mirror instanceof DeclaredType) {
            return this.isA((TypeElement)((DeclaredType)mirror).asElement(), fqn);
        }
        return false;
    }

    boolean processSchemas(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(RAD.class);
        for (Element element : annotatedElements) {
        }
        return false;
    }

    String getEntityNameFor(TypeElement el) {
        if (el.getKind() == ElementKind.CLASS && el.getSimpleName().toString().startsWith("Abstract")) {
            return el.getSimpleName().toString().substring("Abstract".length());
        }
        if (el.getKind() == ElementKind.INTERFACE) {
            return el.getSimpleName().toString();
        }
        throw new IllegalArgumentException("TypeElement is not an entity. Classes must begin with Abstract, and Interface must begin with I");
    }

    PackageElement getPackageElement(Element el) {
        if (el == null) {
            return null;
        }
        if (el.getKind() == ElementKind.PACKAGE) {
            return (PackageElement)el;
        }
        return this.getPackageElement(el.getEnclosingElement());
    }

    void validateTag(String tag, Element sourceElement) {
        Element field = this.findField(tag, sourceElement);
        if (field == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The tag " + tag + " could not be found. Be sure that it is available as a public, protected, or package-private static field in this class/interface or a superclass/interface.", sourceElement);
        }
    }

    String[] extractTags(Element e) {
        RAD anno = e.getAnnotation(RAD.class);
        if (anno == null) {
            return new String[0];
        }
        String[] out = e.getAnnotation(RAD.class).tag();
        for (int i = 0; i < out.length; ++i) {
            this.validateTag(out[i], e);
        }
        return out;
    }

    Element findField(String name, Element source) {
        Element parent;
        if (source == null || source.getKind() == ElementKind.PACKAGE) {
            return null;
        }
        if (source instanceof TypeElement) {
            for (Element element : this.processingEnv.getElementUtils().getAllMembers((TypeElement)source)) {
                if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().contentEquals(name)) continue;
                return element;
            }
        }
        if ((parent = source.getEnclosingElement()) != null) {
            return this.findField(name, parent);
        }
        return null;
    }

    boolean isEntitySubclass(TypeElement el) {
        DeclaredType superType = (DeclaredType)el.getSuperclass();
        if (superType == null) {
            return false;
        }
        TypeElement superTypeEl = (TypeElement)superType.asElement();
        return superTypeEl.getQualifiedName().contentEquals("com.codename1.rad.models.Entity");
    }

    protected ProcessingEnvironmentWrapper env() {
        return (ProcessingEnvironmentWrapper)this.processingEnv;
    }

    protected ProcessingEnvironmentWrapper.ElementsWrapper elements() {
        return (ProcessingEnvironmentWrapper.ElementsWrapper)this.processingEnv.getElementUtils();
    }

    protected ProcessingEnvironmentWrapper.TypesWrapper types() {
        return (ProcessingEnvironmentWrapper.TypesWrapper)this.processingEnv.getTypeUtils();
    }

    boolean isA(TypeElement el, String qualifiedName) {
        String baseName;
        if (el == null) {
            return false;
        }
        if (el.getQualifiedName().contentEquals(qualifiedName)) {
            return true;
        }
        String elQualifiedNameString = el.getQualifiedName().toString();
        if (elQualifiedNameString.contains("<")) {
            elQualifiedNameString = elQualifiedNameString.substring(0, elQualifiedNameString.indexOf("<")).trim();
        }
        if ((baseName = qualifiedName).contains("<")) {
            baseName = baseName.substring(0, baseName.indexOf("<") + 1).trim();
        }
        if (baseName.equals(elQualifiedNameString)) {
            return true;
        }
        TypeElement superclass = this.elements().getTypeElement(qualifiedName);
        if (superclass == null) {
            throw new IllegalArgumentException("Cannot find type " + qualifiedName);
        }
        DeclaredType mirror = superclass.getTypeParameters().size() == ((DeclaredType)el.asType()).getTypeArguments().size() ? this.types().getDeclaredType(superclass, ((DeclaredType)el.asType()).getTypeArguments().toArray(new TypeMirror[0])) : (DeclaredType)superclass.asType();
        if (mirror == null) {
            throw new IllegalArgumentException("getDeclaredType() returned null for " + superclass + " wth type arguments " + ((DeclaredType)el.asType()).getTypeArguments());
        }
        if (this.types().isSubtype(el.asType(), mirror)) {
            return true;
        }
        for (TypeMirror typeMirror : this.types().directSupertypes(el.asType())) {
            if (!this.isA(typeMirror, qualifiedName)) continue;
            return true;
        }
        return false;
    }

    List<ExecutableElement> getAllTaggedAndAbstractMethods(List<ExecutableElement> out, TypeElement el) {
        if (out == null) {
            out = new ArrayList<ExecutableElement>();
        }
        List<ExecutableElement> fout = out;
        if (el == null) {
            return out;
        }
        el.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).filter(e -> e.getAnnotation(RAD.class) != null).filter(e -> e.getAnnotation(RAD.class).tag().length > 0).forEach(e -> fout.add((ExecutableElement)e));
        this.getAllTaggedAndAbstractMethods(out, (TypeElement)this.processingEnv.getTypeUtils().asElement(el.getSuperclass()));
        for (TypeMirror typeMirror : el.getInterfaces()) {
            this.getAllTaggedAndAbstractMethods(out, (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror));
        }
        return out;
    }
}

