/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.rad.annotations.processors;

import com.codename1.rad.annotations.Autogenerated;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class HelperFunctions {
    HelperFunctions() {
    }

    public static String toCamelCase(String str) {
        int lowerCaseIndex = -1;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            lowerCaseIndex = i;
            break;
        }
        if (lowerCaseIndex < 0) {
            return str.toLowerCase();
        }
        if (lowerCaseIndex == 0) {
            return str;
        }
        return str.substring(0, lowerCaseIndex).toLowerCase() + str.substring(lowerCaseIndex);
    }

    static String _(String qualifiedName) {
        if (qualifiedName == null) {
            return "";
        }
        return qualifiedName;
    }

    static String reformat(String content, int indentLevel) {
        int oldLevel = HelperFunctions.getIndentLevel(content);
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(content);
        int delta = indentLevel - oldLevel;
        String lineSeparator = HelperFunctions.getLineSeparator(content);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (delta > 0) {
                for (int i = 0; i < delta; ++i) {
                    sb.append(' ');
                }
                sb.append(line);
                sb.append(lineSeparator);
                continue;
            }
            int lineIndent = HelperFunctions.getIndentLevel(line);
            if (lineIndent + delta >= 0) {
                sb.append(line.substring(-delta));
            } else {
                sb.append(line.substring(lineIndent));
            }
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    static int getIndentLevel(String content) {
        Scanner scanner = new Scanner(content);
        block5: while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().isEmpty()) continue;
            int count = 0;
            int len = line.length();
            block6: for (int i = 0; i < len; ++i) {
                char c = line.charAt(i);
                switch (c) {
                    case ' ': {
                        ++count;
                        continue block6;
                    }
                    case '\t': {
                        ++count;
                        continue block6;
                    }
                    case '\n': {
                        continue block5;
                    }
                }
            }
            return count;
        }
        return 0;
    }

    static String getLineSeparator(String content) {
        if (content.contains("\r\n")) {
            return "\r\n";
        }
        if (content.contains("\n")) {
            return "\n";
        }
        return System.lineSeparator();
    }

    static Set<Integer> extractIndexedParameters(org.w3c.dom.Element element) {
        HashSet<Integer> out = new HashSet<Integer>();
        HelperFunctions.forEachAttribute(element, attr -> {
            String name = attr.getName();
            if (name.startsWith("_") && name.endsWith("_") && name.length() > 2 && Character.isDigit(name.charAt(1))) {
                try {
                    out.add(Integer.parseInt(name.substring(1, name.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        });
        HelperFunctions.forEachChild(element, child -> {
            String name;
            if (child.hasAttribute("rad-property") && (name = child.getAttribute("rad-property")).length() > 0 && Character.isDigit(name.charAt(0))) {
                try {
                    out.add(Integer.parseInt(name));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        });
        return out;
    }

    static boolean isElementInsideRowTemplate(org.w3c.dom.Element el) {
        if (el.getTagName().equalsIgnoreCase("row-template")) {
            return true;
        }
        Node parentNode = el.getParentNode();
        if (parentNode instanceof org.w3c.dom.Element) {
            org.w3c.dom.Element parentEl = (org.w3c.dom.Element)parentNode;
            return HelperFunctions.isElementInsideRowTemplate(parentEl);
        }
        return false;
    }

    static StringBuilder indent(StringBuilder sb, int num) {
        for (int i = 0; i < num; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    static void forEach(org.w3c.dom.Element root, Function<org.w3c.dom.Element, Void> callback) {
        callback.apply(root);
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (!(n instanceof org.w3c.dom.Element)) continue;
            org.w3c.dom.Element childEl = (org.w3c.dom.Element)n;
            HelperFunctions.forEach(childEl, callback);
        }
    }

    static void forEachChild(org.w3c.dom.Element root, Function<org.w3c.dom.Element, Void> callback) {
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (!(n instanceof org.w3c.dom.Element)) continue;
            org.w3c.dom.Element childEl = (org.w3c.dom.Element)n;
            callback.apply(childEl);
        }
    }

    static List<org.w3c.dom.Element> getChildElements(org.w3c.dom.Element root) {
        ArrayList<org.w3c.dom.Element> out = new ArrayList<org.w3c.dom.Element>();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            org.w3c.dom.Element childEl = (org.w3c.dom.Element)n;
            out.add(childEl);
        }
        return out;
    }

    static String getTextContent(org.w3c.dom.Element root) {
        if (HelperFunctions.getDescendantTextContent(root).isEmpty()) {
            return root.getTextContent().trim();
        }
        return "";
    }

    static String getDescendantTextContent(org.w3c.dom.Element root) {
        StringBuilder out = new StringBuilder();
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            out.append(n.getTextContent()).append(" ");
        }
        return out.toString().trim();
    }

    static List<org.w3c.dom.Element> getDescendantElements(List<org.w3c.dom.Element> out, org.w3c.dom.Element root) {
        NodeList children = root.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            org.w3c.dom.Element childEl = (org.w3c.dom.Element)n;
            out.add(childEl);
            HelperFunctions.getDescendantElements(out, childEl);
        }
        return out;
    }

    static List<org.w3c.dom.Element> getChildElementsByTagName(org.w3c.dom.Element root, String tagName) {
        return HelperFunctions.getChildElements(root).stream().filter(e -> e.getTagName().equalsIgnoreCase(tagName)).collect(Collectors.toList());
    }

    static List<org.w3c.dom.Element> getDescendantElementsByTagName(org.w3c.dom.Element root, String tagName) {
        return HelperFunctions.getDescendantElements(new ArrayList<org.w3c.dom.Element>(), root).stream().filter(e -> e.getTagName().equalsIgnoreCase(tagName)).collect(Collectors.toList());
    }

    static org.w3c.dom.Element getChildElementByTagName(org.w3c.dom.Element root, String tagName) {
        for (org.w3c.dom.Element child : HelperFunctions.getChildElements(root)) {
            if (!child.getTagName().equals(tagName)) continue;
            return child;
        }
        return null;
    }

    static void forEachAttribute(org.w3c.dom.Element el, Function<Attr, Void> callback) {
        NamedNodeMap attributes = el.getAttributes();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attributes.item(i);
            callback.apply(attr);
        }
    }

    static String getSimpleName(Element e) {
        return e.getSimpleName().toString();
    }

    static String[] mergeUnique(String[] s1, String[] s2) {
        ArrayList<String> out = new ArrayList<String>(s1.length + s2.length);
        for (String s : s1) {
            if (out.contains(s)) continue;
            out.add(s);
        }
        for (String s : s2) {
            if (out.contains(s)) continue;
            out.add(s);
        }
        return out.toArray(new String[out.size()]);
    }

    static String getPropName(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return null;
    }

    static boolean isAutogenerated(TypeElement el) {
        return el.getAnnotation(Autogenerated.class) != null;
    }

    static boolean isPrimitive(TypeMirror el) {
        switch (el.getKind()) {
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INT: 
            case LONG: 
            case CHAR: 
            case SHORT: 
            case BYTE: {
                return true;
            }
        }
        return false;
    }

    static void touch(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("touch path is null");
        }
        if (Files.exists(path, new LinkOption[0])) {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        } else {
            Files.createFile(path, new FileAttribute[0]);
        }
    }

    static File findPom(File startingPoint) {
        if (startingPoint == null) {
            return null;
        }
        if (startingPoint.isDirectory()) {
            File pom = new File(startingPoint, "pom.xml");
            if (pom.exists()) {
                return pom;
            }
            return HelperFunctions.findPom(startingPoint.getParentFile());
        }
        return HelperFunctions.findPom(startingPoint.getParentFile());
    }

    static File getCodenameOneSettingProperties() throws IOException {
        File rootDirectory = HelperFunctions.findPom(new File(System.getProperty("user.dir"))).getParentFile();
        File cn1Settings = new File(rootDirectory, "codenameone_settings.properties");
        if (!cn1Settings.exists()) {
            cn1Settings = new File(rootDirectory, "common" + File.separator + cn1Settings.getName());
        }
        if (!cn1Settings.exists()) {
            cn1Settings = new File(rootDirectory.getParentFile(), "common" + File.separator + cn1Settings.getName());
        }
        if (!cn1Settings.exists()) {
            cn1Settings = new File(rootDirectory.getParentFile(), cn1Settings.getName());
        }
        if (!cn1Settings.exists()) {
            throw new IOException("Cannot find Codename One project directory in which to generate XML schemas.");
        }
        return cn1Settings;
    }

    static boolean fileContainsString(String needle, File haystack) throws IOException {
        List<String> wholeData = Files.readAllLines(haystack.toPath());
        for (String wholeDatum : wholeData) {
            if (!wholeDatum.contains(needle)) continue;
            return true;
        }
        return false;
    }
}

