/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final long serialVersionUID = 362498820763181265L;
    transient int elementCount;
    transient Entry<K, V>[] elementData;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;
    final float loadFactor;
    int threshold;

    Entry<K, V>[] newElementArray(int s) {
        return new Entry[s];
    }

    public HashMap() {
        this(16);
    }

    public HashMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static final int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public HashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        capacity = HashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(HashMap.calculateCapacity(map.size()));
        super.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V> m = this.getEntry(key);
        return m != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (int i = 0; i < this.elementData.length; ++i) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (HashMap.areEqualValues(value, entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = 0; i < this.elementData.length; ++i) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        Entry<K, V> m = this.getEntry(key);
        if (m != null) {
            return (V)m.value;
        }
        return null;
    }

    final Entry<K, V> getEntry(Object key) {
        Entry<K, V> m;
        if (key == null) {
            m = this.findNullKeyEntry();
        } else {
            int hash = HashMap.computeHashCode(key);
            int index = hash & this.elementData.length - 1;
            m = this.findNonNullKeyEntry(key, index, hash);
        }
        return m;
    }

    final Entry<K, V> findNonNullKeyEntry(Object key, int index, int keyHash) {
        Entry<K, V> m = this.elementData[index];
        while (!(m == null || m.origKeyHash == keyHash && HashMap.areEqualKeys(key, m.key))) {
            m = m.next;
        }
        return m;
    }

    final Entry<K, V> findNullKeyEntry() {
        Entry<K, V> m = this.elementData[0];
        while (m != null && m.key != null) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return HashMap.this.size();
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    Entry entry = HashMap.this.removeEntry(key);
                    return entry != null;
                }

                @Override
                public Iterator<K> iterator() {
                    return new KeyIterator(HashMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    V putImpl(K key, V value) {
        Entry<Object, V> entry;
        if (key == null) {
            entry = this.findNullKeyEntry();
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(null, 0, 0);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        } else {
            int hash = HashMap.computeHashCode(key);
            int index = hash & this.elementData.length - 1;
            entry = this.findNonNullKeyEntry(key, index, hash);
            if (entry == null) {
                ++this.modCount;
                entry = this.createHashedEntry(key, index, hash);
                if (++this.elementCount > this.threshold) {
                    this.rehash();
                }
            }
        }
        Object result = entry.value;
        entry.value = value;
        return (V)result;
    }

    Entry<K, V> createEntry(K key, int index, V value) {
        Entry<K, V> entry = new Entry<K, V>(key, value);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    Entry<K, V> createHashedEntry(K key, int index, int hash) {
        Entry<K, int> entry = new Entry<K, int>(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(Map<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    void rehash(int capacity) {
        int length = HashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        Entry<K, V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<K, V> entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index = entry.origKeyHash & length - 1;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry = this.removeEntry(key);
        if (entry != null) {
            return (V)entry.value;
        }
        return null;
    }

    final void removeEntry(Entry<K, V> entry) {
        int index = entry.origKeyHash & this.elementData.length - 1;
        Entry<K, V> m = this.elementData[index];
        if (m == entry) {
            this.elementData[index] = entry.next;
        } else {
            while (m.next != entry) {
                m = m.next;
            }
            m.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
    }

    final Entry<K, V> removeEntry(Object key) {
        Entry<K, V> entry;
        int index = 0;
        Entry<K, V> last = null;
        if (key != null) {
            int hash = HashMap.computeHashCode(key);
            index = hash & this.elementData.length - 1;
            entry = this.elementData[index];
            while (!(entry == null || entry.origKeyHash == hash && HashMap.areEqualKeys(key, entry.key))) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && entry.key != null) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return HashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return HashMap.this.size();
                }

                @Override
                public void clear() {
                    HashMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new ValueIterator(HashMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    static int computeHashCode(Object key) {
        return key.hashCode();
    }

    static boolean areEqualKeys(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    static boolean areEqualValues(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HashMapEntrySet<KT, VT>
    extends AbstractSet<Map.Entry<KT, VT>> {
        private final HashMap<KT, VT> associatedMap;

        public HashMapEntrySet(HashMap<KT, VT> hm) {
            this.associatedMap = hm;
        }

        HashMap<KT, VT> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry oEntry;
            Entry<KT, VT> entry;
            if (object instanceof Map.Entry && HashMapEntrySet.valuesEq(entry = this.associatedMap.getEntry((oEntry = (Map.Entry)object).getKey()), oEntry)) {
                this.associatedMap.removeEntry(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry oEntry = (Map.Entry)object;
                Entry<KT, VT> entry = this.associatedMap.getEntry(oEntry.getKey());
                return HashMapEntrySet.valuesEq(entry, oEntry);
            }
            return false;
        }

        private static boolean valuesEq(Entry entry, Map.Entry<?, ?> oEntry) {
            return entry != null && (entry.value == null ? oEntry.getValue() == null : HashMap.areEqualValues(entry.value, oEntry.getValue()));
        }

        @Override
        public Iterator<Map.Entry<KT, VT>> iterator() {
            return new EntryIterator<KT, VT>(this.associatedMap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        ValueIterator(HashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        KeyIterator(HashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(HashMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AbstractMapIterator<K, V> {
        private int position = 0;
        int expectedModCount;
        Entry<K, V> futureEntry;
        Entry<K, V> currentEntry;
        Entry<K, V> prevEntry;
        final HashMap<K, V> associatedMap;

        AbstractMapIterator(HashMap<K, V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K, V>
    extends MapEntry<K, V> {
        final int origKeyHash;
        Entry<K, V> next;

        Entry(K theKey, int hash) {
            super(theKey, null);
            this.origKeyHash = hash;
        }

        Entry(K theKey, V theValue) {
            super(theKey, theValue);
            this.origKeyHash = theKey == null ? 0 : HashMap.computeHashCode(theKey);
        }
    }
}

