/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String str;
    private int markpos = -1;
    private int pos;
    private int count;

    public StringReader(String str) {
        this.str = str;
        this.count = str.length();
    }

    public void close() {
        this.str = null;
    }

    private boolean isClosed() {
        return this.str == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readLimit) throws IOException {
        if (readLimit < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("String reader already closed");
            }
            this.markpos = this.pos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("String reader already closed");
            }
            if (this.pos != this.count) {
                return this.str.charAt(this.pos++);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("StringReader already closed");
            }
            if (offset < 0 || offset > buf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (len < 0 || len > buf.length - offset) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos == this.count) {
                return -1;
            }
            int end = this.pos + len > this.count ? this.count : this.pos + len;
            this.str.getChars(this.pos, end, buf, offset);
            int read = end - this.pos;
            this.pos = end;
            return read;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("String reader already closed");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("StringReader already closed");
            }
            this.pos = this.markpos != -1 ? this.markpos : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("StringReader already closed");
            }
            int minSkip = -this.pos;
            int maxSkip = this.count - this.pos;
            if (maxSkip == 0 || ns > (long)maxSkip) {
                ns = maxSkip;
            } else if (ns < (long)minSkip) {
                ns = minSkip;
            }
            this.pos = (int)((long)this.pos + ns);
            return ns;
        }
    }
}

