/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMap<K, V>
implements Map<K, V> {
    Set<K> keySet;
    Collection<V> valuesCollection;

    protected AbstractMap() {
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        if (key != null) {
            while (it.hasNext()) {
                if (!key.equals(it.next().getKey())) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (it.next().getKey() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        if (value != null) {
            while (it.hasNext()) {
                if (!value.equals(it.next().getValue())) continue;
                return true;
            }
        } else {
            while (it.hasNext()) {
                if (it.next().getValue() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    K key = entry.getKey();
                    V mine = entry.getValue();
                    Object theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        if (key != null) {
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (!key.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        } else {
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = 0;
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        while (it.hasNext()) {
            result += it.next().hashCode();
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        Iterator<Map.Entry<K, V>> setIterator;
                        {
                            this.setIterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.setIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.setIterator.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.setIterator.remove();
                        }
                    };
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        if (key != null) {
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (!key.equals(entry.getKey())) continue;
                it.remove();
                return entry.getValue();
            }
        } else {
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                if (entry.getKey() != null) continue;
                it.remove();
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer(this.size() * 28);
        buffer.append('{');
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            K key = entry.getKey();
            if (key != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = entry.getValue();
            if (value != this) {
                buffer.append(value);
            } else {
                buffer.append("(this Map)");
            }
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        Iterator<Map.Entry<K, V>> setIterator;
                        {
                            this.setIterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.setIterator.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.setIterator.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.setIterator.remove();
                        }
                    };
                }
            };
        }
        return this.valuesCollection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = -8499721149061103585L;
        private K key;
        private V value;

        public SimpleEntry(K theKey, V theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            V result = this.value;
            this.value = object;
            return result;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        private static final long serialVersionUID = 7138329143949025153L;
        private K key;
        private V value;

        public SimpleImmutableEntry(K theKey, V theValue) {
            this.key = theKey;
            this.value = theValue;
        }

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

