/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Random;

public class ThreadLocalRandom
extends Random {
    private static final ThreadLocal<ThreadLocalRandom> current = new ThreadLocal<ThreadLocalRandom>(){

        @Override
        protected ThreadLocalRandom initialValue() {
            return new ThreadLocalRandom();
        }
    };

    private ThreadLocalRandom() {
    }

    public static ThreadLocalRandom current() {
        return current.get();
    }

    @Override
    public void setSeed(long seed) {
        throw new UnsupportedOperationException();
    }

    public int nextInt(int origin, int bound) {
        int value;
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        int range = bound - origin;
        if (range > 0) {
            return this.nextInt(range) + origin;
        }
        while ((value = this.nextInt()) < origin || value >= bound) {
        }
        return value;
    }

    public long nextLong(long bound) {
        long result;
        long value;
        if (bound <= 0L) {
            throw new IllegalArgumentException();
        }
        while ((value = this.nextLong()) - (result = value % bound) + (bound - 1L) >= 0L) {
        }
        return result;
    }

    public long nextLong(long origin, long bound) {
        long value;
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        long range = bound - origin;
        if (range > 0L) {
            return this.nextLong(range) + origin;
        }
        while ((value = this.nextLong()) < origin || value >= bound) {
        }
        return value;
    }

    public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException();
        }
        double value = this.nextDouble() * bound;
        if (value == bound) {
            value = Math.nextDown(value);
        }
        return value;
    }

    public double nextDouble(double origin, double bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException();
        }
        return origin + this.nextDouble(bound - origin);
    }
}

