/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.MapEntry;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMap<K, V>
extends AbstractMap<K, V>
implements NavigableMap<K, V> {
    private static final long serialVersionUID = 919286545866124006L;
    transient int size;
    transient Node<K, V> root;
    Comparator<? super K> comparator;
    transient int modCount;
    transient Set<Map.Entry<K, V>> entrySet;
    transient NavigableMap<K, V> descendingMap;
    transient NavigableSet<K> navigableKeySet;

    public TreeMap() {
    }

    public TreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
    }

    public TreeMap(Map<? extends K, ? extends V> map) {
        this();
        this.putAll(map);
    }

    public TreeMap(SortedMap<K, ? extends V> map) {
        this(map.comparator());
        Node<K, V> lastNode = null;
        for (Map.Entry entry : map.entrySet()) {
            lastNode = this.addToLast(lastNode, entry.getKey(), entry.getValue());
        }
    }

    Node<K, V> addToLast(Node<K, V> last, K key, V value) {
        if (last == null) {
            last = this.createNode(key, value);
            this.root = last;
            this.size = 1;
        } else if (last.size == 64) {
            Node<K, V> newNode = this.createNode(key, value);
            this.attachToRight(last, newNode);
            this.balance(newNode);
            ++this.size;
            last = newNode;
        } else {
            this.appendFromRight(last, key, value);
            ++this.size;
        }
        return last;
    }

    @Override
    public void clear() {
        this.root = null;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsKey(Object key) {
        Comparable<Object> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        Object keyK = key;
        Node<K, V> node = this.root;
        while (node != null) {
            int result;
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int n = result = object != null ? object.compareTo(keys[left_idx]) : -this.comparator.compare(keys[left_idx], keyK);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                return true;
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                return true;
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >>> 1;
                result = this.cmp(object, keyK, keys[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    return true;
                }
                high = mid - 1;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.root == null) {
            return false;
        }
        Node<K, V> node = TreeMap.minimum(this.root);
        if (value != null) {
            while (node != null) {
                int to = node.right_idx;
                V[] values = node.values;
                for (int i = node.left_idx; i <= to; ++i) {
                    if (!value.equals(values[i])) continue;
                    return true;
                }
                node = node.next;
            }
        } else {
            while (node != null) {
                int to = node.right_idx;
                V[] values = node.values;
                for (int i = node.left_idx; i <= to; ++i) {
                    if (values[i] != null) continue;
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    private boolean containsValue(Entry<K, V> node, Object value) {
        if (value == null ? node.value == null : value.equals(node.value)) {
            return true;
        }
        if (node.left != null && this.containsValue(node.left, value)) {
            return true;
        }
        return node.right != null && this.containsValue(node.right, value);
    }

    Entry<K, V> find(Object keyObj) {
        Comparable<Object> object = this.comparator == null ? TreeMap.toComparable(keyObj) : null;
        Object keyK = keyObj;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                return this.createEntry(node, left_idx);
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                return this.createEntry(node, right_idx);
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >> 1;
                result = this.cmp(object, keyK, keys[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    return this.createEntry(node, mid);
                }
                high = mid - 1;
            }
            return null;
        }
        return null;
    }

    Entry<K, V> createEntry(Node<K, V> node, int index) {
        Entry entry = new Entry(node.keys[index], node.values[index]);
        entry.node = node;
        entry.index = index;
        return entry;
    }

    Entry<K, V> findSmallestEntry() {
        if (null != this.root) {
            Node<K, V> node = TreeMap.minimum(this.root);
            Entry ret = new Entry(node.keys[node.left_idx], node.values[node.left_idx]);
            ret.node = node;
            ret.index = node.left_idx;
            return ret;
        }
        return null;
    }

    Entry<K, V> findBiggestEntry() {
        if (null != this.root) {
            Node<K, V> node = TreeMap.maximum(this.root);
            Entry ret = new Entry(node.keys[node.right_idx], node.values[node.right_idx]);
            ret.node = node;
            ret.index = node.right_idx;
            return ret;
        }
        return null;
    }

    Entry<K, V> findCeilingEntry(K key) {
        if (this.root == null) {
            return null;
        }
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        Node<K, V> foundNode = null;
        int foundIndex = 0;
        block0: while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int right_idx = node.right_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                foundNode = node;
                foundIndex = left_idx;
                node = node.left;
                continue;
            }
            if (result == 0) {
                foundNode = node;
                foundIndex = left_idx;
                break;
            }
            if (left_idx != right_idx) {
                result = this.cmp(object, key, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            foundNode = node;
            foundIndex = right_idx;
            if (result == 0) break;
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high && result != 0) {
                mid = low + high >> 1;
                result = this.cmp(object, key, keys[mid]);
                if (result <= 0) {
                    foundNode = node;
                    foundIndex = mid;
                    high = mid - 1;
                } else {
                    low = mid + 1;
                }
                if (result != 0 && (low != high || high != mid)) continue;
                break block0;
            }
            break block0;
        }
        if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) > 0) {
            foundNode = null;
        }
        if (foundNode != null) {
            return this.createEntry(foundNode, foundIndex);
        }
        return null;
    }

    Entry<K, V> findFloorEntry(K key) {
        if (this.root == null) {
            return null;
        }
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        Node<K, V> foundNode = null;
        int foundIndex = 0;
        block0: while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            foundNode = node;
            foundIndex = left_idx;
            if (result == 0) break;
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, key, keys[right_idx]);
            }
            if (result >= 0) {
                foundNode = node;
                foundIndex = right_idx;
                if (result == 0) break;
                node = node.right;
                continue;
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high && result != 0) {
                mid = low + high >> 1;
                result = this.cmp(object, key, keys[mid]);
                if (result >= 0) {
                    foundNode = node;
                    foundIndex = mid;
                    low = mid + 1;
                } else {
                    high = mid;
                }
                if (result != 0 && (low != high || high != mid)) continue;
                break block0;
            }
            break block0;
        }
        if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) < 0) {
            foundNode = null;
        }
        if (foundNode != null) {
            return this.createEntry(foundNode, foundIndex);
        }
        return null;
    }

    Entry<K, V> findLowerEntry(K key) {
        if (this.root == null) {
            return null;
        }
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        Node<K, V> foundNode = null;
        int foundIndex = 0;
        block0: while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result <= 0) {
                node = node.left;
                continue;
            }
            foundNode = node;
            foundIndex = left_idx;
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, key, keys[right_idx]);
            }
            if (result > 0) {
                foundNode = node;
                foundIndex = right_idx;
                node = node.right;
                continue;
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >> 1;
                result = this.cmp(object, key, keys[mid]);
                if (result > 0) {
                    foundNode = node;
                    foundIndex = mid;
                    low = mid + 1;
                } else {
                    high = mid;
                }
                if (low != high || high != mid) continue;
                break block0;
            }
            break block0;
        }
        if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) <= 0) {
            foundNode = null;
        }
        if (foundNode != null) {
            return this.createEntry(foundNode, foundIndex);
        }
        return null;
    }

    Entry<K, V> findHigherEntry(K key) {
        if (this.root == null) {
            return null;
        }
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        Node<K, V> foundNode = null;
        int foundIndex = 0;
        block0: while (node != null) {
            K[] keys = node.keys;
            int right_idx = node.right_idx;
            int result = this.cmp(object, keyK, keys[right_idx]);
            if (result >= 0) {
                node = node.right;
                continue;
            }
            foundNode = node;
            foundIndex = right_idx;
            int left_idx = node.left_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, key, keys[left_idx]);
            }
            if (result < 0) {
                foundNode = node;
                foundIndex = left_idx;
                node = node.left;
                continue;
            }
            foundNode = node;
            foundIndex = right_idx;
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >> 1;
                result = this.cmp(object, key, keys[mid]);
                if (result < 0) {
                    foundNode = node;
                    foundIndex = mid;
                    high = mid - 1;
                } else {
                    low = mid + 1;
                }
                if (low != high || high != mid) continue;
                break block0;
            }
            break block0;
        }
        if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) >= 0) {
            foundNode = null;
        }
        if (foundNode != null) {
            return this.createEntry(foundNode, foundIndex);
        }
        return null;
    }

    @Override
    public K firstKey() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.minimum(this.root);
            return node.keys[node.left_idx];
        }
        throw new NoSuchElementException();
    }

    Node<K, V> findNode(K key) {
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                return node;
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            return node;
        }
        return null;
    }

    @Override
    public V get(Object key) {
        Comparable<Object> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        Object keyK = key;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                return node.values[left_idx];
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                return node.values[right_idx];
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >>> 1;
                result = this.cmp(object, keyK, keys[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    return node.values[mid];
                }
                high = mid - 1;
            }
            return null;
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public Iterator<K> iterator() {
                    return new UnboundedKeyIterator(TreeMap.this);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public K lastKey() {
        if (this.root != null) {
            Node<K, V> node = TreeMap.maximum(this.root);
            return node.keys[node.right_idx];
        }
        throw new NoSuchElementException();
    }

    static <K, V> Entry<K, V> maximum(Entry<K, V> x) {
        while (x.right != null) {
            x = x.right;
        }
        return x;
    }

    static <K, V> Entry<K, V> minimum(Entry<K, V> x) {
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    static <K, V> Entry<K, V> predecessor(Entry<K, V> x) {
        if (x.left != null) {
            return TreeMap.maximum(x.left);
        }
        Entry y = x.parent;
        while (y != null && x == y.left) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    private static <K, V> Node<K, V> successor(Node<K, V> x) {
        if (x.right != null) {
            return TreeMap.minimum(x.right);
        }
        Node y = x.parent;
        while (y != null && x == y.right) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    private int cmp(Comparable<K> object, K key1, K key2) {
        return object != null ? object.compareTo(key2) : this.comparator.compare(key1, key2);
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    private V putImpl(K key, V value) {
        if (this.root == null) {
            this.root = this.createNode(key, value);
            this.size = 1;
            ++this.modCount;
            return null;
        }
        Comparable<K> object = this.comparator == null ? TreeMap.toComparable(key) : null;
        K keyK = key;
        Node<K, V> node = this.root;
        Node<K, V> prevNode = null;
        int result = 0;
        while (node != null) {
            prevNode = node;
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                Object res = node.values[left_idx];
                node.values[left_idx] = value;
                return res;
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                Object res = node.values[right_idx];
                node.values[right_idx] = value;
                return res;
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >>> 1;
                result = this.cmp(object, keyK, keys[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    Object res = node.values[mid];
                    node.values[mid] = value;
                    return res;
                }
                high = mid - 1;
            }
            result = low;
            break;
        }
        ++this.size;
        ++this.modCount;
        if (node == null) {
            if (prevNode == null) {
                this.root = this.createNode(key, value);
            } else if (prevNode.size < 64) {
                if (result < 0) {
                    this.appendFromLeft(prevNode, key, value);
                } else {
                    this.appendFromRight(prevNode, key, value);
                }
            } else {
                Node<K, V> newNode = this.createNode(key, value);
                if (result < 0) {
                    this.attachToLeft(prevNode, newNode);
                } else {
                    this.attachToRight(prevNode, newNode);
                }
                this.balance(newNode);
            }
        } else if (node.size < 64) {
            int left_idx = node.left_idx;
            int right_idx = node.right_idx;
            if (left_idx == 0 || right_idx != 63 && right_idx - result <= result - left_idx) {
                int right_idxPlus1 = right_idx + 1;
                System.arraycopy(node.keys, result, node.keys, result + 1, right_idxPlus1 - result);
                System.arraycopy(node.values, result, node.values, result + 1, right_idxPlus1 - result);
                node.right_idx = right_idxPlus1;
                node.keys[result] = key;
                node.values[result] = value;
            } else {
                int left_idxMinus1 = left_idx - 1;
                System.arraycopy(node.keys, left_idx, node.keys, left_idxMinus1, result - left_idx);
                System.arraycopy(node.values, left_idx, node.values, left_idxMinus1, result - left_idx);
                node.left_idx = left_idxMinus1;
                node.keys[result - 1] = key;
                node.values[result - 1] = value;
            }
            ++node.size;
        } else {
            Object movedValue;
            Object movedKey;
            boolean removeFromStart;
            Node previous = node.prev;
            Node nextNode = node.next;
            boolean attachFromLeft = false;
            Node<K, V> attachHere = null;
            if (previous == null) {
                if (nextNode != null && nextNode.size < 64) {
                    removeFromStart = false;
                } else {
                    removeFromStart = true;
                    attachFromLeft = true;
                    attachHere = node;
                }
            } else if (nextNode == null) {
                if (previous.size < 64) {
                    removeFromStart = true;
                } else {
                    removeFromStart = false;
                    attachFromLeft = false;
                    attachHere = node;
                }
            } else if (previous.size < 64) {
                removeFromStart = nextNode.size < 64 ? previous.size < nextNode.size : true;
            } else if (nextNode.size < 64) {
                removeFromStart = false;
            } else if (node.right == null) {
                attachHere = node;
                attachFromLeft = false;
                removeFromStart = false;
            } else {
                attachHere = nextNode;
                attachFromLeft = true;
                removeFromStart = false;
            }
            if (removeFromStart) {
                movedKey = node.keys[0];
                movedValue = node.values[0];
                int resMunus1 = result - 1;
                System.arraycopy(node.keys, 1, node.keys, 0, resMunus1);
                System.arraycopy(node.values, 1, node.values, 0, resMunus1);
                node.keys[resMunus1] = key;
                node.values[resMunus1] = value;
            } else {
                movedKey = node.keys[63];
                movedValue = node.values[63];
                System.arraycopy(node.keys, result, node.keys, result + 1, 63 - result);
                System.arraycopy(node.values, result, node.values, result + 1, 63 - result);
                node.keys[result] = key;
                node.values[result] = value;
            }
            if (attachHere == null) {
                if (removeFromStart) {
                    this.appendFromRight(previous, movedKey, movedValue);
                } else {
                    this.appendFromLeft(nextNode, movedKey, movedValue);
                }
            } else {
                Node newNode = this.createNode(movedKey, movedValue);
                if (attachFromLeft) {
                    this.attachToLeft(attachHere, newNode);
                } else {
                    this.attachToRight(attachHere, newNode);
                }
                this.balance(newNode);
            }
        }
        return null;
    }

    private void appendFromLeft(Node<K, V> node, K keyObj, V value) {
        if (node.left_idx == 0) {
            int new_right = node.right_idx + 1;
            System.arraycopy(node.keys, 0, node.keys, 1, new_right);
            System.arraycopy(node.values, 0, node.values, 1, new_right);
            node.right_idx = new_right;
        } else {
            --node.left_idx;
        }
        ++node.size;
        node.keys[node.left_idx] = keyObj;
        node.values[node.left_idx] = value;
    }

    private void attachToLeft(Node<K, V> node, Node<K, V> newNode) {
        Node predecessor;
        newNode.parent = node;
        node.left = newNode;
        newNode.prev = predecessor = node.prev;
        newNode.next = node;
        if (predecessor != null) {
            predecessor.next = newNode;
        }
        node.prev = newNode;
    }

    private void appendFromRight(Node<K, V> node, K keyObj, V value) {
        if (node.right_idx == 63) {
            int left_idx = node.left_idx;
            int left_idxMinus1 = left_idx - 1;
            System.arraycopy(node.keys, left_idx, node.keys, left_idxMinus1, 64 - left_idx);
            System.arraycopy(node.values, left_idx, node.values, left_idxMinus1, 64 - left_idx);
            node.left_idx = left_idxMinus1;
        } else {
            ++node.right_idx;
        }
        ++node.size;
        node.keys[node.right_idx] = keyObj;
        node.values[node.right_idx] = value;
    }

    private void attachToRight(Node<K, V> node, Node<K, V> newNode) {
        Node successor;
        newNode.parent = node;
        node.right = newNode;
        newNode.prev = node;
        newNode.next = successor = node.next;
        if (successor != null) {
            successor.prev = newNode;
        }
        node.next = newNode;
    }

    private Node<K, V> createNode(K keyObj, V value) {
        Node node = new Node();
        node.keys[0] = keyObj;
        node.values[0] = value;
        node.left_idx = 0;
        node.right_idx = 0;
        node.size = 1;
        return node;
    }

    void balance(Node<K, V> x) {
        x.color = true;
        while (x != this.root && x.parent.color) {
            Node y;
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (y != null && y.color) {
                    x.parent.color = false;
                    y.color = false;
                    x.parent.parent.color = true;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    this.leftRotate(x);
                }
                x.parent.color = false;
                x.parent.parent.color = true;
                this.rightRotate(x.parent.parent);
                continue;
            }
            y = x.parent.parent.left;
            if (y != null && y.color) {
                x.parent.color = false;
                y.color = false;
                x.parent.parent.color = true;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                this.rightRotate(x);
            }
            x.parent.color = false;
            x.parent.parent.color = true;
            this.leftRotate(x.parent.parent);
        }
        this.root.color = false;
    }

    private void rightRotate(Node<K, V> x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != null) {
            y.right.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.right) {
            x.parent.right = y;
        } else {
            x.parent.left = y;
        }
        y.right = x;
        x.parent = y;
    }

    private void leftRotate(Node<K, V> x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Comparable<Object> object;
        Comparable<Object> comparable = object = this.comparator == null ? TreeMap.toComparable(key) : null;
        if (this.size == 0) {
            return null;
        }
        Object keyK = key;
        Node<K, V> node = this.root;
        while (node != null) {
            K[] keys = node.keys;
            int left_idx = node.left_idx;
            int result = this.cmp(object, keyK, keys[left_idx]);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result == 0) {
                Object value = node.values[left_idx];
                this.removeLeftmost(node);
                return value;
            }
            int right_idx = node.right_idx;
            if (left_idx != right_idx) {
                result = this.cmp(object, keyK, keys[right_idx]);
            }
            if (result > 0) {
                node = node.right;
                continue;
            }
            if (result == 0) {
                Object value = node.values[right_idx];
                this.removeRightmost(node);
                return value;
            }
            int low = left_idx + 1;
            int mid = 0;
            int high = right_idx - 1;
            while (low <= high) {
                mid = low + high >>> 1;
                result = this.cmp(object, keyK, keys[mid]);
                if (result > 0) {
                    low = mid + 1;
                    continue;
                }
                if (result == 0) {
                    Object value = node.values[mid];
                    this.removeMiddleElement(node, mid);
                    return value;
                }
                high = mid - 1;
            }
            return null;
        }
        return null;
    }

    K removeLeftmost(Node<K, V> node) {
        Object key;
        int index = node.left_idx;
        Object v0 = key = index + 1 <= node.right_idx ? node.keys[index + 1] : null;
        if (node.size == 1) {
            this.deleteNode(node);
        } else if (node.prev != null && 63 - node.prev.right_idx > node.size) {
            Node prev = node.prev;
            int size = node.right_idx - index;
            System.arraycopy(node.keys, index + 1, prev.keys, prev.right_idx + 1, size);
            System.arraycopy(node.values, index + 1, prev.values, prev.right_idx + 1, size);
            prev.right_idx += size;
            prev.size += size;
            this.deleteNode(node);
        } else if (node.next != null && node.next.left_idx > node.size) {
            int next_new_left;
            Node next = node.next;
            int size = node.right_idx - index;
            next.left_idx = next_new_left = next.left_idx - size;
            System.arraycopy(node.keys, index + 1, next.keys, next_new_left, size);
            System.arraycopy(node.values, index + 1, next.values, next_new_left, size);
            next.size += size;
            this.deleteNode(node);
        } else {
            node.keys[index] = null;
            node.values[index] = null;
            ++node.left_idx;
            --node.size;
            Node prev = node.prev;
            key = null;
            if (prev != null && prev.size == 1) {
                ++node.size;
                --node.left_idx;
                node.keys[node.left_idx] = prev.keys[prev.left_idx];
                node.values[node.left_idx] = prev.values[prev.left_idx];
                this.deleteNode(prev);
            }
        }
        ++this.modCount;
        --this.size;
        return key;
    }

    K removeRightmost(Node<K, V> node) {
        Object key;
        int index = node.right_idx;
        Object v0 = key = node != null && node.next != null ? node.next.keys[node.next.left_idx] : null;
        if (node.size == 1) {
            this.deleteNode(node);
        } else if (node.prev != null && 63 - node.prev.right_idx > node.size) {
            Node prev = node.prev;
            int left_idx = node.left_idx;
            int size = index - left_idx;
            System.arraycopy(node.keys, left_idx, prev.keys, prev.right_idx + 1, size);
            System.arraycopy(node.values, left_idx, prev.values, prev.right_idx + 1, size);
            prev.right_idx += size;
            prev.size += size;
            this.deleteNode(node);
        } else if (node.next != null && node.next.left_idx > node.size) {
            int next_new_left;
            Node next = node.next;
            int left_idx = node.left_idx;
            int size = index - left_idx;
            next.left_idx = next_new_left = next.left_idx - size;
            System.arraycopy(node.keys, left_idx, next.keys, next_new_left, size);
            System.arraycopy(node.values, left_idx, next.values, next_new_left, size);
            next.size += size;
            this.deleteNode(node);
        } else {
            node.keys[index] = null;
            node.values[index] = null;
            --node.right_idx;
            --node.size;
            Node next = node.next;
            key = null;
            if (next != null && next.size == 1) {
                ++node.size;
                ++node.right_idx;
                node.keys[node.right_idx] = next.keys[next.left_idx];
                node.values[node.right_idx] = next.values[next.left_idx];
                this.deleteNode(next);
            }
        }
        ++this.modCount;
        --this.size;
        return key;
    }

    K removeMiddleElement(Node<K, V> node, int index) {
        K ret = null;
        if (node.prev != null && 63 - node.prev.right_idx > node.size) {
            Node prev = node.prev;
            int left_idx = node.left_idx;
            int size = index - left_idx;
            System.arraycopy(node.keys, left_idx, prev.keys, prev.right_idx + 1, size);
            System.arraycopy(node.values, left_idx, prev.values, prev.right_idx + 1, size);
            prev.right_idx += size;
            size = node.right_idx - index;
            System.arraycopy(node.keys, index + 1, prev.keys, prev.right_idx + 1, size);
            System.arraycopy(node.values, index + 1, prev.values, prev.right_idx + 1, size);
            ret = prev.keys[prev.right_idx + 1];
            prev.right_idx += size;
            prev.size += node.size - 1;
            this.deleteNode(node);
        } else if (node.next != null && node.next.left_idx > node.size) {
            int next_new_left;
            Node next = node.next;
            int left_idx = node.left_idx;
            next.left_idx = next_new_left = next.left_idx - node.size + 1;
            int size = index - left_idx;
            System.arraycopy(node.keys, left_idx, next.keys, next_new_left, size);
            System.arraycopy(node.values, left_idx, next.values, next_new_left, size);
            next_new_left += size;
            size = node.right_idx - index;
            System.arraycopy(node.keys, index + 1, next.keys, next_new_left, size);
            System.arraycopy(node.values, index + 1, next.values, next_new_left, size);
            ret = next.keys[next_new_left];
            next.size += node.size - 1;
            this.deleteNode(node);
        } else {
            int moveFromRight = node.right_idx - index;
            int left_idx = node.left_idx;
            int moveFromLeft = index - left_idx;
            if (moveFromRight <= moveFromLeft) {
                System.arraycopy(node.keys, index + 1, node.keys, index, moveFromRight);
                System.arraycopy(node.values, index + 1, node.values, index, moveFromRight);
                Node next = node.next;
                if (next != null && next.size == 1) {
                    node.keys[node.right_idx] = next.keys[next.left_idx];
                    node.values[node.right_idx] = next.values[next.left_idx];
                    ret = node.keys[index];
                    this.deleteNode(next);
                } else {
                    node.keys[node.right_idx] = null;
                    node.values[node.right_idx] = null;
                    --node.right_idx;
                    --node.size;
                }
            } else {
                System.arraycopy(node.keys, left_idx, node.keys, left_idx + 1, moveFromLeft);
                System.arraycopy(node.values, left_idx, node.values, left_idx + 1, moveFromLeft);
                Node prev = node.prev;
                if (prev != null && prev.size == 1) {
                    node.keys[left_idx] = prev.keys[prev.left_idx];
                    node.values[left_idx] = prev.values[prev.left_idx];
                    ret = node.keys[index + 1];
                    this.deleteNode(prev);
                } else {
                    node.keys[left_idx] = null;
                    node.values[left_idx] = null;
                    ++node.left_idx;
                    --node.size;
                }
            }
        }
        ++this.modCount;
        --this.size;
        return ret;
    }

    private void deleteNode(Node<K, V> node) {
        if (node.right == null) {
            if (node.left != null) {
                this.attachToParent(node, node.left);
            } else {
                this.attachNullToParent(node);
            }
            this.fixNextChain(node);
        } else if (node.left == null) {
            this.attachToParent(node, node.right);
            this.fixNextChain(node);
        } else {
            Node toMoveUp = node.next;
            this.fixNextChain(node);
            if (toMoveUp.right == null) {
                this.attachNullToParent(toMoveUp);
            } else {
                this.attachToParent(toMoveUp, toMoveUp.right);
            }
            toMoveUp.left = node.left;
            if (node.left != null) {
                node.left.parent = toMoveUp;
            }
            toMoveUp.right = node.right;
            if (node.right != null) {
                node.right.parent = toMoveUp;
            }
            this.attachToParentNoFixup(node, toMoveUp);
            toMoveUp.color = node.color;
        }
    }

    private void attachToParentNoFixup(Node<K, V> toDelete, Node<K, V> toConnect) {
        Node parent;
        toConnect.parent = parent = toDelete.parent;
        if (parent == null) {
            this.root = toConnect;
        } else if (toDelete == parent.left) {
            parent.left = toConnect;
        } else {
            parent.right = toConnect;
        }
    }

    private void attachToParent(Node<K, V> toDelete, Node<K, V> toConnect) {
        this.attachToParentNoFixup(toDelete, toConnect);
        if (!toDelete.color) {
            this.fixup(toConnect);
        }
    }

    private void attachNullToParent(Node<K, V> toDelete) {
        Node parent = toDelete.parent;
        if (parent == null) {
            this.root = null;
        } else {
            if (toDelete == parent.left) {
                parent.left = null;
            } else {
                parent.right = null;
            }
            if (!toDelete.color) {
                this.fixup(parent);
            }
        }
    }

    private void fixNextChain(Node<K, V> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        }
    }

    private void fixup(Node<K, V> x) {
        while (x != this.root && !x.color) {
            Node w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w == null) {
                    x = x.parent;
                    continue;
                }
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    this.leftRotate(x.parent);
                    w = x.parent.right;
                    if (w == null) {
                        x = x.parent;
                        continue;
                    }
                }
                if (!(w.left != null && w.left.color || w.right != null && w.right.color)) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (w.right == null || !w.right.color) {
                    w.left.color = false;
                    w.color = true;
                    this.rightRotate(w);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                w.right.color = false;
                this.leftRotate(x.parent);
                x = this.root;
                continue;
            }
            w = x.parent.left;
            if (w == null) {
                x = x.parent;
                continue;
            }
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                this.rightRotate(x.parent);
                w = x.parent.left;
                if (w == null) {
                    x = x.parent;
                    continue;
                }
            }
            if (!(w.left != null && w.left.color || w.right != null && w.right.color)) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (w.left == null || !w.left.color) {
                w.right.color = false;
                w.color = true;
                this.leftRotate(w);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            w.left.color = false;
            this.rightRotate(x.parent);
            x = this.root;
        }
        x.color = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TreeMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public Iterator<V> iterator() {
                    return new UnboundedValueIterator(TreeMap.this);
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.newImmutableEntry(this.findSmallestEntry());
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.newImmutableEntry(this.findBiggestEntry());
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        Entry<K, V> node = this.findSmallestEntry();
        AbstractMap.SimpleImmutableEntry<K, V> result = this.newImmutableEntry(node);
        if (null != node) {
            this.remove(node.key);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        Entry<K, V> node = this.findBiggestEntry();
        AbstractMap.SimpleImmutableEntry<K, V> result = this.newImmutableEntry(node);
        if (null != node) {
            this.remove(node.key);
        }
        return result;
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.newImmutableEntry(this.findHigherEntry(key));
    }

    @Override
    public K higherKey(K key) {
        Map.Entry<K, V> entry = this.higherEntry(key);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.newImmutableEntry(this.findLowerEntry(key));
    }

    @Override
    public K lowerKey(K key) {
        Map.Entry<K, V> entry = this.lowerEntry(key);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.newImmutableEntry(this.findCeilingEntry(key));
    }

    @Override
    public K ceilingKey(K key) {
        Map.Entry<K, V> entry = this.ceilingEntry(key);
        return null == entry ? null : (K)entry.getKey();
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.newImmutableEntry(this.findFloorEntry(key));
    }

    @Override
    public K floorKey(K key) {
        Map.Entry<K, V> entry = this.floorEntry(key);
        return null == entry ? null : (K)entry.getKey();
    }

    final AbstractMap.SimpleImmutableEntry<K, V> newImmutableEntry(Entry<K, V> entry) {
        return null == entry ? null : new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    private static <T> Comparable<T> toComparable(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return (Comparable)obj;
    }

    int keyCompare(K left, K right) {
        return null != this.comparator() ? this.comparator().compare(left, right) : TreeMap.toComparable(left).compareTo(right);
    }

    static <K, V> Node<K, V> minimum(Node<K, V> x) {
        if (x == null) {
            return null;
        }
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    static <K, V> Node<K, V> maximum(Node<K, V> x) {
        if (x == null) {
            return null;
        }
        while (x.right != null) {
            x = x.right;
        }
        return x;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public int size() {
                    return TreeMap.this.size;
                }

                @Override
                public void clear() {
                    TreeMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    if (object instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)object;
                        Object key = entry.getKey();
                        Object v1 = TreeMap.this.get(key);
                        Object v2 = entry.getValue();
                        return v1 == null ? v2 == null && TreeMap.this.containsKey(key) : v1.equals(v2);
                    }
                    return false;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new UnboundedEntryIterator(TreeMap.this);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return null != this.navigableKeySet ? this.navigableKeySet : (this.navigableKeySet = new AscendingSubMap(this).navigableKeySet());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return null != this.descendingMap ? this.descendingMap : (this.descendingMap = new DescendingSubMap(this));
    }

    @Override
    public NavigableMap<K, V> subMap(K start, boolean startInclusive, K end, boolean endInclusive) {
        if (this.keyCompare(start, end) <= 0) {
            return new AscendingSubMap(start, startInclusive, this, end, endInclusive);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NavigableMap<K, V> headMap(K end, boolean inclusive) {
        this.keyCompare(end, end);
        return new AscendingSubMap(this, end, inclusive);
    }

    @Override
    public NavigableMap<K, V> tailMap(K start, boolean inclusive) {
        this.keyCompare(start, start);
        return new AscendingSubMap(start, inclusive, this);
    }

    @Override
    public SortedMap<K, V> subMap(K startKey, K endKey) {
        if (this.comparator == null ? TreeMap.toComparable(startKey).compareTo(endKey) <= 0 : this.comparator.compare(startKey, endKey) <= 0) {
            return new SubMap(startKey, this, endKey);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SortedMap<K, V> headMap(K endKey) {
        return this.headMap(endKey, false);
    }

    @Override
    public SortedMap<K, V> tailMap(K startKey) {
        return this.tailMap(startKey, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnboundedValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        UnboundedValueIterator(TreeMap<K, V> map, Node<K, V> startNode, int startOffset) {
            super(map, startNode, startOffset);
        }

        UnboundedValueIterator(TreeMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return this.lastNode.values[this.lastOffset];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnboundedKeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        UnboundedKeyIterator(TreeMap<K, V> map, Node<K, V> startNode, int startOffset) {
            super(map, startNode, startOffset);
        }

        UnboundedKeyIterator(TreeMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return this.lastNode.keys[this.lastOffset];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnboundedEntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        UnboundedEntryIterator(TreeMap<K, V> map, Node<K, V> startNode, int startOffset) {
            super(map, startNode, startOffset);
        }

        UnboundedEntryIterator(TreeMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.makeNext();
            int idx = this.lastOffset;
            return new TreeMapEntry(this.lastNode.keys[idx], this.lastNode.values[idx], this.lastNode, idx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TreeMapEntry<K, V>
    extends MapEntry<K, V> {
        Node<K, V> node;
        int index;

        TreeMapEntry(K theKey, V theValue, Node<K, V> node, int index) {
            super(theKey, theValue);
            this.node = node;
            this.index = index;
        }

        @Override
        public V setValue(V object) {
            Object result = this.value;
            this.value = object;
            this.node.values[this.index] = object;
            return (V)result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AbstractMapIterator<K, V> {
        TreeMap<K, V> backingMap;
        int expectedModCount;
        Node<K, V> node;
        Node<K, V> lastNode;
        int offset;
        int lastOffset;

        AbstractMapIterator(TreeMap<K, V> map, Node<K, V> startNode, int startOffset) {
            this.backingMap = map;
            this.expectedModCount = map.modCount;
            if (startNode != null) {
                this.node = startNode;
                this.offset = startOffset;
            } else {
                Entry<K, V> entry = map.findSmallestEntry();
                if (entry != null) {
                    this.node = map.findSmallestEntry().node;
                    this.offset = this.node.left_idx;
                }
            }
        }

        AbstractMapIterator(TreeMap<K, V> map, Node<K, V> startNode) {
            this(map, startNode, startNode == null ? 0 : startNode.left_idx);
        }

        AbstractMapIterator(TreeMap<K, V> map) {
            this(map, TreeMap.minimum(map.root));
        }

        public boolean hasNext() {
            return this.node != null;
        }

        final void makeNext() {
            if (this.expectedModCount != this.backingMap.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != this.node.right_idx) {
                ++this.offset;
            } else {
                this.node = this.node.next;
                if (this.node != null) {
                    this.offset = this.node.left_idx;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void remove() {
            if (this.expectedModCount != this.backingMap.modCount) throw new ConcurrentModificationException();
            if (this.lastNode == null) throw new IllegalStateException();
            int idx = this.lastOffset;
            Object key = null;
            if (idx == this.lastNode.left_idx) {
                key = this.backingMap.removeLeftmost(this.lastNode);
            } else if (idx == this.lastNode.right_idx) {
                key = this.backingMap.removeRightmost(this.lastNode);
            } else {
                int lastRight = this.lastNode.right_idx;
                key = this.backingMap.removeMiddleElement(this.node, idx);
                if (null == key && lastRight > this.lastNode.right_idx) {
                    --this.offset;
                }
            }
            if (null != key) {
                Entry<K, V> entry = this.backingMap.find(key);
                this.node = entry.node;
                this.offset = entry.index;
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        private final Comparator<? super K> reverseComparator;

        DescendingSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            super(start, startKeyInclusive, map, end, endKeyInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map) {
            super(start, startKeyInclusive, map);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            super(map, end, endKeyInclusive);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        DescendingSubMap(TreeMap<K, V> map) {
            super(map);
            this.reverseComparator = Collections.reverseOrder(this.m.comparator);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.reverseComparator;
        }

        @Override
        public SortedMap<K, V> subMap(K start, K end) {
            if (!this.checkLowerBound(start) || !this.checkUpperBound(start)) {
                throw new IllegalArgumentException();
            }
            int result = -1;
            if (this.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(end, this.hi) : TreeMap.toComparable(end).compareTo(this.hi);
            }
            if (!this.hiInclusive && start.equals(end) ? result < 0 : result <= 0) {
                if (null != this.comparator() ? this.comparator().compare(start, end) > 0 : TreeMap.toComparable(start).compareTo(end) > 0) {
                    throw new IllegalArgumentException();
                }
                return new DescendingSubMap<K, V>(start, true, this.m, end, false);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Entry result;
            if (!this.fromStart) {
                result = this.m.findBiggestEntry();
            } else {
                Entry entry = result = this.loInclusive ? this.m.findFloorEntry(this.lo) : this.m.findLowerEntry(this.lo);
            }
            if (result == null || !this.isInRange(result.key)) {
                return null;
            }
            return this.m.newImmutableEntry(result);
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Entry result;
            if (!this.toEnd) {
                result = this.m.findSmallestEntry();
            } else {
                Entry entry = result = this.hiInclusive ? this.m.findCeilingEntry(this.hi) : this.m.findHigherEntry(this.hi);
            }
            if (result != null && !this.isInRange(result.key)) {
                return null;
            }
            return this.m.newImmutableEntry(result);
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Entry node = null;
            node = this.fromStart ? (this.loInclusive ? this.m.findFloorEntry(this.lo) : this.m.findLowerEntry(this.lo)) : this.m.findBiggestEntry();
            if (node != null && this.fromStart && (this.loInclusive ? this.m.keyCompare(this.lo, node.key) < 0 : this.m.keyCompare(this.lo, node.key) <= 0)) {
                node = null;
            }
            if (node != null && this.toEnd && (this.hiInclusive ? this.m.keyCompare(this.hi, node.key) > 0 : this.m.keyCompare(this.hi, node.key) >= 0)) {
                node = null;
            }
            AbstractMap.SimpleImmutableEntry result = this.m.newImmutableEntry(node);
            if (null != node) {
                this.m.remove(node.key);
            }
            return result;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Entry node = null;
            node = this.toEnd ? (this.hiInclusive ? this.m.findCeilingEntry(this.hi) : this.m.findHigherEntry(this.hi)) : this.m.findSmallestEntry();
            if (node != null && this.fromStart && (this.loInclusive ? this.m.keyCompare(this.lo, node.key) < 0 : this.m.keyCompare(this.lo, node.key) <= 0)) {
                node = null;
            }
            if (node != null && this.toEnd && (this.hiInclusive ? this.m.keyCompare(this.hi, node.key) > 0 : this.m.keyCompare(this.hi, node.key) >= 0)) {
                node = null;
            }
            AbstractMap.SimpleImmutableEntry result = this.m.newImmutableEntry(node);
            if (null != node) {
                this.m.remove(node.key);
            }
            return result;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Entry entry = this.m.findLowerEntry(key);
            if (null != entry && this.fromStart && !this.checkLowerBound(entry.getKey())) {
                Entry entry2 = entry = this.loInclusive ? this.m.findFloorEntry(this.lo) : this.m.findLowerEntry(this.lo);
            }
            if (null != entry && !this.isInRange(entry.getKey())) {
                entry = null;
            }
            return this.m.newImmutableEntry(entry);
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Entry entry = this.m.findHigherEntry(key);
            if (null != entry && this.toEnd && !this.checkUpperBound(entry.getKey())) {
                Entry entry2 = entry = this.hiInclusive ? this.m.findCeilingEntry(this.hi) : this.m.findHigherEntry(this.hi);
            }
            if (null != entry && !this.isInRange(entry.getKey())) {
                entry = null;
            }
            return this.m.newImmutableEntry(entry);
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            Comparable object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
            Entry entry = null;
            entry = this.toEnd && this.m.cmp(object, key, this.lo) >= 0 ? (this.loInclusive ? this.m.findFloorEntry(this.lo) : this.m.findLowerEntry(this.lo)) : this.m.findFloorEntry(key);
            if (null != entry && this.toEnd && !this.checkUpperBound(entry.getKey())) {
                entry = null;
            }
            return this.m.newImmutableEntry(entry);
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            Comparable object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
            Entry entry = null;
            entry = this.fromStart && this.m.cmp(object, key, this.hi) <= 0 ? (this.hiInclusive ? this.m.findCeilingEntry(this.hi) : this.m.findHigherEntry(this.hi)) : this.m.findCeilingEntry(key);
            if (null != entry && this.fromStart && !this.checkLowerBound(entry.getKey())) {
                entry = null;
            }
            return this.m.newImmutableEntry(entry);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new DescendingSubMapEntrySet(this);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new DescendingSubMapKeySet(this);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.fromStart && this.toEnd) {
                return new AscendingSubMap(this.hi, this.hiInclusive, this.m, this.lo, this.loInclusive);
            }
            if (this.fromStart) {
                return new AscendingSubMap(this.m, this.lo, this.loInclusive);
            }
            if (this.toEnd) {
                return new AscendingSubMap(this.hi, this.hiInclusive, this.m);
            }
            return new AscendingSubMap(this.m);
        }

        int keyCompare(K left, K right) {
            return null != this.reverseComparator ? this.reverseComparator.compare(left, right) : TreeMap.toComparable(left).compareTo(right);
        }

        @Override
        public NavigableMap<K, V> subMap(K start, boolean startKeyInclusive, K end, boolean endKeyInclusive) {
            if (!this.checkUpperBound(start)) {
                throw new IllegalArgumentException();
            }
            if (this.fromStart && (this.loInclusive || !startKeyInclusive && (!endKeyInclusive || !start.equals(end)) ? this.keyCompare(start, this.lo) < 0 : this.keyCompare(start, this.lo) <= 0) || this.toEnd && (!this.hiInclusive && endKeyInclusive ? this.keyCompare(end, this.hi) >= 0 : this.keyCompare(end, this.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (this.keyCompare(start, end) > 0) {
                throw new IllegalArgumentException();
            }
            return new DescendingSubMap<K, V>(start, startKeyInclusive, this.m, end, endKeyInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K end, boolean inclusive) {
            this.keyCompare(end, end);
            K inclusiveEnd = end;
            boolean isInRange = true;
            if (null != inclusiveEnd) {
                int result;
                if (this.toEnd) {
                    int n = result = null != this.comparator() ? this.comparator().compare(inclusiveEnd, this.hi) : TreeMap.toComparable(inclusiveEnd).compareTo(this.hi);
                    boolean bl = this.hiInclusive || !inclusive ? result <= 0 : (isInRange = result < 0);
                }
                if (this.fromStart) {
                    int n = result = null != this.comparator() ? this.comparator().compare(inclusiveEnd, this.lo) : TreeMap.toComparable(inclusiveEnd).compareTo(this.lo);
                    boolean bl = isInRange && (this.loInclusive || !inclusive ? result >= 0 : result > 0) ? true : (isInRange = false);
                }
            }
            if (isInRange) {
                if (this.fromStart) {
                    return new DescendingSubMap<Object, V>(this.lo, this.loInclusive, this.m, end, inclusive);
                }
                return new DescendingSubMap<K, V>(this.m, end, inclusive);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public NavigableMap<K, V> tailMap(K start, boolean inclusive) {
            this.keyCompare(start, start);
            K inclusiveStart = start;
            boolean isInRange = true;
            if (null != inclusiveStart) {
                int result;
                if (this.toEnd) {
                    int n = result = null != this.comparator() ? this.comparator().compare(inclusiveStart, this.hi) : TreeMap.toComparable(inclusiveStart).compareTo(this.hi);
                    boolean bl = this.hiInclusive || !inclusive ? result <= 0 : (isInRange = result < 0);
                }
                if (this.fromStart) {
                    int n = result = null != this.comparator() ? this.comparator().compare(inclusiveStart, this.lo) : TreeMap.toComparable(inclusiveStart).compareTo(this.lo);
                    boolean bl = isInRange && (this.loInclusive || !inclusive ? result >= 0 : result > 0) ? true : (isInRange = false);
                }
            }
            if (isInRange) {
                if (this.toEnd) {
                    return new DescendingSubMap<Object, V>(start, inclusive, this.m, this.hi, this.hiInclusive);
                }
                return new DescendingSubMap<K, V>(start, inclusive, this.m);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Collection<V> values() {
            if (this.valuesCollection == null) {
                if (this.fromStart || this.toEnd) {
                    this.valuesCollection = new DescendingSubMapValuesCollection(this);
                    return this.valuesCollection;
                }
                this.valuesCollection = super.values();
            }
            return this.valuesCollection;
        }

        @Override
        NavigableSubMap<K, V> descendingSubMap() {
            if (this.fromStart && this.toEnd) {
                return new AscendingSubMap(this.hi, this.hiInclusive, this.m, this.lo, this.loInclusive);
            }
            if (this.fromStart) {
                return new AscendingSubMap(this.m, this.hi, this.hiInclusive);
            }
            if (this.toEnd) {
                return new AscendingSubMap(this.lo, this.loInclusive, this.m);
            }
            return new AscendingSubMap(this.m);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DescendingSubMapValuesCollection<K, V>
        extends AbstractCollection<V> {
            DescendingSubMap<K, V> subMap;

            public DescendingSubMapValuesCollection(DescendingSubMap<K, V> subMap) {
                this.subMap = subMap;
            }

            @Override
            public boolean isEmpty() {
                return this.subMap.isEmpty();
            }

            @Override
            public Iterator<V> iterator() {
                Entry from = this.subMap.m.find(this.subMap.firstKey());
                Entry to = this.subMap.m.findLowerEntry(this.subMap.lastKey());
                return new DescendingValueIterator(from.node, from == null ? 0 : from.index, this.subMap, to == null ? null : to.node, to == null ? 0 : to.index);
            }

            @Override
            public int size() {
                return this.subMap.size();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            static class DescendingValueIterator<K, V>
            extends BoundedMapIterator<K, V>
            implements Iterator<V> {
                public DescendingValueIterator(Node<K, V> startNode, int startOffset, DescendingSubMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
                    super(startNode, startOffset, map.m, finalNode, finalOffset);
                    this.node = startNode;
                    this.offset = startOffset;
                }

                @Override
                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (this.node != null) {
                        boolean endOfIterator;
                        boolean bl = endOfIterator = this.lastNode == this.finalNode && this.lastOffset == this.finalOffset;
                        if (endOfIterator) {
                            this.node = null;
                        } else {
                            if (this.expectedModCount != this.backingMap.modCount) {
                                throw new ConcurrentModificationException();
                            }
                            if (this.node == null) {
                                throw new NoSuchElementException();
                            }
                            this.lastNode = this.node;
                            this.lastOffset = this.offset;
                            if (this.offset != this.node.left_idx) {
                                --this.offset;
                            } else {
                                this.node = this.node.prev;
                                if (this.node != null) {
                                    this.offset = this.node.right_idx;
                                }
                            }
                        }
                    }
                    return this.lastNode.values[this.lastOffset];
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AscendingSubMap<K, V>
    extends NavigableSubMap<K, V> {
        AscendingSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            super(start, startKeyInclusive, map, end, endKeyInclusive);
        }

        AscendingSubMap(TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            super(map, end, endKeyInclusive);
        }

        AscendingSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map) {
            super(start, startKeyInclusive, map);
        }

        AscendingSubMap(TreeMap<K, V> map) {
            super(map);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            Entry ret = this.theSmallestEntry();
            if (ret != null) {
                return this.m.newImmutableEntry(ret);
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            Entry ret = this.theBiggestEntry();
            if (ret != null) {
                return this.m.newImmutableEntry(ret);
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Entry node = this.theSmallestEntry();
            AbstractMap.SimpleImmutableEntry result = this.m.newImmutableEntry(node);
            if (null != node) {
                this.m.remove(node.key);
            }
            return result;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Entry node = this.theBiggestEntry();
            AbstractMap.SimpleImmutableEntry result = this.m.newImmutableEntry(node);
            if (null != node) {
                this.m.remove(node.key);
            }
            return result;
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            Entry entry = ((NavigableSubMap)this).findHigherEntry(key);
            if (null != entry && this.isInRange(entry.key)) {
                return this.m.newImmutableEntry(entry);
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            Entry entry = ((NavigableSubMap)this).findLowerEntry(key);
            if (null != entry && this.isInRange(entry.key)) {
                return this.m.newImmutableEntry(entry);
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            Entry entry = ((NavigableSubMap)this).findCeilingEntry(key);
            if (null != entry && this.isInRange(entry.key)) {
                return this.m.newImmutableEntry(entry);
            }
            return null;
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            Entry entry = ((NavigableSubMap)this).findFloorEntry(key);
            if (null != entry && this.isInRange(entry.key)) {
                return this.m.newImmutableEntry(entry);
            }
            return null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AscendingSubMapEntrySet(this);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new AscendingSubMapKeySet(this);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            if (this.fromStart && this.toEnd) {
                return new DescendingSubMap(this.hi, this.hiInclusive, this.m, this.lo, this.loInclusive);
            }
            if (this.fromStart) {
                return new DescendingSubMap(this.m, this.lo, this.loInclusive);
            }
            if (this.toEnd) {
                return new DescendingSubMap(this.hi, this.hiInclusive, this.m);
            }
            return new DescendingSubMap(this.m);
        }

        @Override
        NavigableSubMap<K, V> descendingSubMap() {
            if (this.fromStart && this.toEnd) {
                return new DescendingSubMap(this.hi, this.hiInclusive, this.m, this.lo, this.loInclusive);
            }
            if (this.fromStart) {
                return new DescendingSubMap(this.m, this.lo, this.loInclusive);
            }
            if (this.toEnd) {
                return new DescendingSubMap(this.hi, this.hiInclusive, this.m);
            }
            return new DescendingSubMap(this.m);
        }

        @Override
        public NavigableMap<K, V> subMap(K start, boolean startKeyInclusive, K end, boolean endKeyInclusive) {
            if (this.fromStart && (this.loInclusive || !startKeyInclusive ? this.m.keyCompare(start, this.lo) < 0 : this.m.keyCompare(start, this.lo) <= 0) || this.toEnd && (!this.hiInclusive && (endKeyInclusive || startKeyInclusive && start.equals(end)) ? this.m.keyCompare(end, this.hi) >= 0 : this.m.keyCompare(end, this.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (this.m.keyCompare(start, end) > 0) {
                throw new IllegalArgumentException();
            }
            return new AscendingSubMap<K, V>(start, startKeyInclusive, this.m, end, endKeyInclusive);
        }

        @Override
        public NavigableMap<K, V> headMap(K end, boolean inclusive) {
            if (this.fromStart && (!this.loInclusive && inclusive ? this.m.keyCompare(end, this.lo) <= 0 : this.m.keyCompare(end, this.lo) < 0)) {
                throw new IllegalArgumentException();
            }
            if (this.toEnd && (!this.hiInclusive && inclusive ? this.m.keyCompare(end, this.hi) >= 0 : this.m.keyCompare(end, this.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (this.checkUpperBound(end)) {
                if (this.fromStart) {
                    return new AscendingSubMap<Object, V>(this.lo, this.loInclusive, this.m, end, inclusive);
                }
                return new AscendingSubMap<K, V>(this.m, end, inclusive);
            }
            return this;
        }

        @Override
        public NavigableMap<K, V> tailMap(K start, boolean inclusive) {
            if (this.fromStart && (!this.loInclusive && inclusive ? this.m.keyCompare(start, this.lo) <= 0 : this.m.keyCompare(start, this.lo) < 0)) {
                throw new IllegalArgumentException();
            }
            if (this.toEnd && (!this.hiInclusive && inclusive ? this.m.keyCompare(start, this.hi) >= 0 : this.m.keyCompare(start, this.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (this.checkLowerBound(start)) {
                if (this.toEnd) {
                    return new AscendingSubMap<Object, V>(start, inclusive, this.m, this.hi, this.hiInclusive);
                }
                return new AscendingSubMap<K, V>(start, inclusive, this.m);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullSubMapValuesCollection<K, V>
    extends SubMapValuesCollection<K, V> {
        SubMap<K, V> subMap;

        public NullSubMapValuesCollection(SubMap<K, V> subMap) {
            super(subMap);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public V next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new IllegalStateException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class NavigableSubMap<K, V>
    extends AbstractMap<K, V>
    implements NavigableMap<K, V> {
        final TreeMap<K, V> m;
        final K lo;
        final K hi;
        final boolean fromStart;
        final boolean toEnd;
        final boolean loInclusive;
        final boolean hiInclusive;

        NavigableSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            this.m = map;
            this.toEnd = true;
            this.fromStart = true;
            this.lo = start;
            this.hi = end;
            this.loInclusive = startKeyInclusive;
            this.hiInclusive = endKeyInclusive;
        }

        NavigableSubMap(K start, boolean startKeyInclusive, TreeMap<K, V> map) {
            this.m = map;
            this.fromStart = true;
            this.toEnd = false;
            this.lo = start;
            this.hi = null;
            this.loInclusive = startKeyInclusive;
            this.hiInclusive = false;
        }

        NavigableSubMap(TreeMap<K, V> map, K end, boolean endKeyInclusive) {
            this.m = map;
            this.fromStart = false;
            this.toEnd = true;
            this.lo = null;
            this.hi = end;
            this.loInclusive = false;
            this.hiInclusive = endKeyInclusive;
        }

        NavigableSubMap(TreeMap<K, V> map) {
            this.m = map;
            this.toEnd = false;
            this.fromStart = false;
            this.hi = null;
            this.lo = null;
            this.hiInclusive = false;
            this.loInclusive = false;
        }

        Node findNode(K key) {
            return this.m.findNode(key);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.m.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            this.checkNull(key);
            if (this.isInRange(key)) {
                return this.m.containsKey(key);
            }
            return false;
        }

        private void checkNull(Object key) {
            if (null == key && null == this.comparator()) {
                throw new NullPointerException();
            }
        }

        @Override
        public boolean isEmpty() {
            Iterator<K> it = this.keySet().iterator();
            return !it.hasNext();
        }

        @Override
        public int size() {
            return this.entrySet().size();
        }

        @Override
        public V put(K key, V value) {
            this.checkNull(key);
            if (this.isInRange(key)) {
                return this.m.put(key, value);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public V get(Object key) {
            this.checkNull(key);
            if (this.isInRange(key)) {
                return this.m.get(key);
            }
            return null;
        }

        @Override
        public V remove(Object key) {
            this.checkNull(key);
            if (this.isInRange(key)) {
                return this.m.remove(key);
            }
            return null;
        }

        @Override
        public abstract Map.Entry<K, V> firstEntry();

        @Override
        public abstract Map.Entry<K, V> lastEntry();

        @Override
        public abstract Map.Entry<K, V> pollFirstEntry();

        @Override
        public abstract Map.Entry<K, V> pollLastEntry();

        @Override
        public abstract Map.Entry<K, V> higherEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> lowerEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> ceilingEntry(K var1);

        @Override
        public abstract Map.Entry<K, V> floorEntry(K var1);

        abstract NavigableSubMap<K, V> descendingSubMap();

        @Override
        public K firstKey() {
            Map.Entry<K, V> node = this.firstEntry();
            if (node != null) {
                return node.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public K lastKey() {
            Map.Entry<K, V> node = this.lastEntry();
            if (node != null) {
                return node.getKey();
            }
            throw new NoSuchElementException();
        }

        @Override
        public K higherKey(K key) {
            Map.Entry<K, V> entry = this.higherEntry(key);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K lowerKey(K key) {
            Map.Entry<K, V> entry = this.lowerEntry(key);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K ceilingKey(K key) {
            Map.Entry<K, V> entry = this.ceilingEntry(key);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public K floorKey(K key) {
            Map.Entry<K, V> entry = this.floorEntry(key);
            return null == entry ? null : (K)entry.getKey();
        }

        @Override
        public abstract NavigableSet<K> navigableKeySet();

        @Override
        public abstract Set<Map.Entry<K, V>> entrySet();

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.descendingMap().navigableKeySet();
        }

        @Override
        public SortedMap<K, V> subMap(K start, K end) {
            if (!this.checkLowerBound(start) || !this.checkUpperBound(start)) {
                throw new IllegalArgumentException();
            }
            int result = -1;
            if (this.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(end, this.hi) : TreeMap.toComparable(end).compareTo(this.hi);
            }
            if (!this.hiInclusive && start.equals(end) ? result < 0 : result <= 0) {
                if (null != this.comparator() ? this.comparator().compare(start, end) > 0 : TreeMap.toComparable(start).compareTo(end) > 0) {
                    throw new IllegalArgumentException();
                }
                return new AscendingSubMap<K, V>(start, true, this.m, end, false);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedMap<K, V> headMap(K end) {
            int result;
            if (this.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(end, this.hi) : TreeMap.toComparable(end).compareTo(this.hi);
                if (result > 0) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.fromStart && (result = -(null != this.comparator() ? this.comparator().compare(this.lo, end) : TreeMap.toComparable(this.lo).compareTo(end))) < 0) {
                throw new IllegalArgumentException();
            }
            return this.headMap(end, false);
        }

        @Override
        public SortedMap<K, V> tailMap(K start) {
            int result;
            if (this.fromStart) {
                result = -(null != this.comparator() ? this.comparator().compare(this.lo, start) : TreeMap.toComparable(this.lo).compareTo(start));
                if (this.loInclusive ? result < 0 : result <= 0) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(start, this.hi) : TreeMap.toComparable(start).compareTo(this.hi);
                if (this.hiInclusive ? result > 0 : result >= 0) {
                    throw new IllegalArgumentException();
                }
            }
            return this.tailMap(start, true);
        }

        @Override
        public abstract NavigableMap<K, V> subMap(K var1, boolean var2, K var3, boolean var4);

        @Override
        public abstract NavigableMap<K, V> headMap(K var1, boolean var2);

        @Override
        public abstract NavigableMap<K, V> tailMap(K var1, boolean var2);

        final boolean checkUpperBound(K key) {
            if (this.toEnd) {
                int result;
                int n = result = null != this.comparator() ? this.comparator().compare(key, this.hi) : TreeMap.toComparable(key).compareTo(this.hi);
                return this.hiInclusive ? result <= 0 : result < 0;
            }
            return true;
        }

        final boolean checkLowerBound(K key) {
            if (this.fromStart) {
                int result = -(null != this.comparator() ? this.comparator().compare(this.lo, key) : TreeMap.toComparable(this.lo).compareTo(key));
                return this.loInclusive ? result >= 0 : result > 0;
            }
            return true;
        }

        final boolean isInRange(K key) {
            return this.checkUpperBound(key) && this.checkLowerBound(key);
        }

        final Entry<K, V> theSmallestEntry() {
            Entry<K, V> result = null;
            result = !this.fromStart ? this.m.findSmallestEntry() : (this.loInclusive ? this.m.findCeilingEntry(this.lo) : this.m.findHigherEntry(this.lo));
            return null != result && (!this.toEnd || this.checkUpperBound(result.getKey())) ? result : null;
        }

        final Entry<K, V> theBiggestEntry() {
            Entry<K, V> result = null;
            result = !this.toEnd ? this.m.findBiggestEntry() : (this.hiInclusive ? this.m.findFloorEntry(this.hi) : this.m.findLowerEntry(this.hi));
            return null != result && (!this.fromStart || this.checkLowerBound(result.getKey())) ? result : null;
        }

        final Entry<K, V> smallerOrEqualEntry(K key) {
            Entry<K, V> result = this.findFloorEntry(key);
            return null != result && (!this.fromStart || this.checkLowerBound(result.getKey())) ? result : null;
        }

        private Entry<K, V> findFloorEntry(K key) {
            Entry<K, V> node = this.findFloorEntryImpl(key);
            if (node == null) {
                return null;
            }
            if (!this.checkUpperBound(node.key)) {
                node = this.findEndNode();
            }
            if (node != null && this.fromStart && !this.checkLowerBound(node.key)) {
                Comparable object;
                Comparable comparable = object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
                if (this.cmp(object, key, this.lo) > 0) {
                    node = this.findStartNode();
                    if (node == null || this.cmp(object, key, node.key) < 0) {
                        return null;
                    }
                } else {
                    node = null;
                }
            }
            return node;
        }

        private int cmp(Comparable<K> object, K key1, K key2) {
            return object != null ? object.compareTo(key2) : this.comparator().compare(key1, key2);
        }

        private Entry<K, V> findFloorEntryImpl(K key) {
            Comparable object = this.comparator() == null ? TreeMap.toComparable(key) : null;
            K keyK = key;
            Node node = this.m.root;
            Node foundNode = null;
            int foundIndex = 0;
            block0: while (node != null) {
                int result;
                K[] keys = node.keys;
                int left_idx = node.left_idx;
                int n = result = object != null ? object.compareTo(keys[left_idx]) : -this.comparator().compare(keys[left_idx], keyK);
                if (result < 0) {
                    node = node.left;
                    continue;
                }
                foundNode = node;
                foundIndex = left_idx;
                if (result == 0) break;
                int right_idx = node.right_idx;
                if (left_idx != right_idx) {
                    result = this.cmp(object, key, keys[right_idx]);
                }
                if (result >= 0) {
                    foundNode = node;
                    foundIndex = right_idx;
                    if (result == 0) break;
                    node = node.right;
                    continue;
                }
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high && result != 0) {
                    mid = low + high >> 1;
                    result = this.cmp(object, key, keys[mid]);
                    if (result >= 0) {
                        foundNode = node;
                        foundIndex = mid;
                        low = mid + 1;
                    } else {
                        high = mid;
                    }
                    if (low != high || high != mid) continue;
                    break block0;
                }
                break block0;
            }
            if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) < 0) {
                foundNode = null;
            }
            if (foundNode != null) {
                return this.createEntry(foundNode, foundIndex);
            }
            return null;
        }

        Entry<K, V> createEntry(Node<K, V> node, int index) {
            Entry entry = new Entry(node.keys[index], node.values[index]);
            entry.node = node;
            entry.index = index;
            return entry;
        }

        final Entry<K, V> biggerOrEqualEntry(K key) {
            Entry<K, V> result = this.findCeilingEntry(key);
            return null != result && (!this.toEnd || this.checkUpperBound(result.getKey())) ? result : null;
        }

        private Entry<K, V> findStartNode() {
            if (this.fromStart) {
                if (this.loInclusive) {
                    return this.m.findCeilingEntry(this.lo);
                }
                return this.m.findHigherEntry(this.lo);
            }
            return this.theSmallestEntry();
        }

        private Entry<K, V> findEndNode() {
            if (this.hiInclusive) {
                return this.findFloorEntryImpl(this.hi);
            }
            return this.findLowerEntryImpl(this.hi);
        }

        private Entry<K, V> findCeilingEntry(K key) {
            Entry<K, V> node = this.findCeilingEntryImpl(key);
            if (null == node) {
                return null;
            }
            if (this.toEnd && !this.checkUpperBound(node.key)) {
                Comparable object;
                Comparable comparable = object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
                if (this.cmp(object, key, this.hi) < 0) {
                    node = this.findEndNode();
                    if (node != null && this.cmp(object, key, node.key) > 0) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (node != null && !this.checkLowerBound(node.key)) {
                node = this.findStartNode();
            }
            return node;
        }

        private Entry<K, V> findLowerEntryImpl(K key) {
            Comparable object = this.comparator() == null ? TreeMap.toComparable(key) : null;
            K keyK = key;
            Node node = this.m.root;
            Node foundNode = null;
            int foundIndex = 0;
            block0: while (node != null) {
                int result;
                K[] keys = node.keys;
                int left_idx = node.left_idx;
                int n = result = object != null ? object.compareTo(keys[left_idx]) : -this.comparator().compare(keys[left_idx], keyK);
                if (result <= 0) {
                    node = node.left;
                    continue;
                }
                foundNode = node;
                foundIndex = left_idx;
                int right_idx = node.right_idx;
                if (left_idx != right_idx) {
                    result = this.cmp(object, key, keys[right_idx]);
                }
                if (result > 0) {
                    foundNode = node;
                    foundIndex = right_idx;
                    node = node.right;
                    continue;
                }
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high) {
                    mid = low + high >> 1;
                    result = this.cmp(object, key, keys[mid]);
                    if (result > 0) {
                        foundNode = node;
                        foundIndex = mid;
                        low = mid + 1;
                    } else {
                        high = mid;
                    }
                    if (low != high || high != mid) continue;
                    break block0;
                }
                break block0;
            }
            if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) <= 0) {
                foundNode = null;
            }
            if (foundNode != null) {
                return this.createEntry(foundNode, foundIndex);
            }
            return null;
        }

        private Entry<K, V> findCeilingEntryImpl(K key) {
            Comparable object = this.comparator() == null ? TreeMap.toComparable(key) : null;
            K keyK = key;
            Node node = this.m.root;
            Node foundNode = null;
            int foundIndex = 0;
            block0: while (node != null) {
                K[] keys = node.keys;
                int left_idx = node.left_idx;
                int right_idx = node.right_idx;
                int result = this.cmp(object, keyK, keys[left_idx]);
                if (result < 0) {
                    foundNode = node;
                    foundIndex = left_idx;
                    node = node.left;
                    continue;
                }
                if (result == 0) {
                    foundNode = node;
                    foundIndex = left_idx;
                    break;
                }
                if (left_idx != right_idx) {
                    result = this.cmp(object, key, keys[right_idx]);
                }
                if (result > 0) {
                    node = node.right;
                    continue;
                }
                foundNode = node;
                foundIndex = right_idx;
                if (result == 0) break;
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high && result != 0) {
                    mid = low + high >> 1;
                    result = this.cmp(object, key, keys[mid]);
                    if (result <= 0) {
                        foundNode = node;
                        foundIndex = mid;
                        high = mid - 1;
                    } else {
                        low = mid + 1;
                    }
                    if (result != 0 && (low != high || high != mid)) continue;
                    break block0;
                }
                break block0;
            }
            if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) > 0) {
                foundNode = null;
            }
            if (foundNode != null) {
                return this.createEntry(foundNode, foundIndex);
            }
            return null;
        }

        final Entry<K, V> smallerEntry(K key) {
            Entry<K, V> result = this.findLowerEntry(key);
            return null != result && (!this.fromStart || this.checkLowerBound(result.getKey())) ? result : null;
        }

        private Entry<K, V> findLowerEntry(K key) {
            Entry<K, V> node = this.findLowerEntryImpl(key);
            if (null == node) {
                return null;
            }
            if (!this.checkUpperBound(node.key)) {
                node = this.findEndNode();
            }
            if (this.fromStart && !this.checkLowerBound(node.key)) {
                Comparable object;
                Comparable comparable = object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
                if (this.cmp(object, key, this.lo) > 0) {
                    node = this.findStartNode();
                    if (node == null || this.cmp(object, key, node.key) <= 0) {
                        return null;
                    }
                } else {
                    node = null;
                }
            }
            return node;
        }

        final Entry<K, V> biggerEntry(K key) {
            Entry<K, V> result = this.findHigherEntry(key);
            return null != result && (!this.toEnd || this.checkUpperBound(result.getKey())) ? result : null;
        }

        private Entry<K, V> findHigherEntry(K key) {
            Entry<K, V> node = this.findHigherEntryImpl(key);
            if (node == null) {
                return null;
            }
            if (this.toEnd && !this.checkUpperBound(node.key)) {
                Comparable object;
                Comparable comparable = object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
                if (this.cmp(object, key, this.hi) < 0) {
                    node = this.findEndNode();
                    if (node != null && this.cmp(object, key, node.key) >= 0) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            if (node != null && !this.checkLowerBound(node.key)) {
                node = this.findStartNode();
            }
            return node;
        }

        Entry<K, V> findHigherEntryImpl(K key) {
            Comparable object = this.m.comparator == null ? TreeMap.toComparable(key) : null;
            K keyK = key;
            Node node = this.m.root;
            Node foundNode = null;
            int foundIndex = 0;
            block0: while (node != null) {
                K[] keys = node.keys;
                int right_idx = node.right_idx;
                int result = this.cmp(object, keyK, keys[right_idx]);
                if (result >= 0) {
                    node = node.right;
                    continue;
                }
                foundNode = node;
                foundIndex = right_idx;
                int left_idx = node.left_idx;
                if (left_idx != right_idx) {
                    result = this.cmp(object, key, keys[left_idx]);
                }
                if (result < 0) {
                    foundNode = node;
                    foundIndex = left_idx;
                    node = node.left;
                    continue;
                }
                foundNode = node;
                foundIndex = right_idx;
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high) {
                    mid = low + high >> 1;
                    result = this.cmp(object, key, keys[mid]);
                    if (result < 0) {
                        foundNode = node;
                        foundIndex = mid;
                        high = mid - 1;
                    } else {
                        low = mid + 1;
                    }
                    if (low != high || high != mid) continue;
                    break block0;
                }
                break block0;
            }
            if (foundNode != null && this.cmp(object, keyK, foundNode.keys[foundIndex]) >= 0) {
                foundNode = null;
            }
            if (foundNode != null) {
                return this.createEntry(foundNode, foundIndex);
            }
            return null;
        }

        @Override
        public Collection<V> values() {
            if (this.valuesCollection == null) {
                if (!this.toEnd && !this.fromStart) {
                    this.valuesCollection = super.values();
                } else {
                    Map.Entry<K, V> lastEntry;
                    Entry<K, V> startEntry;
                    if (this.loInclusive) {
                        startEntry = this.fromStart ? this.m.ceilingEntry(this.lo) : this.theSmallestEntry();
                    } else {
                        Entry<K, V> entry = startEntry = this.fromStart ? this.m.findHigherEntry(this.lo) : this.theSmallestEntry();
                    }
                    if (startEntry == null) {
                        K key = this.m.isEmpty() ? this.lo : this.m.firstKey();
                        this.valuesCollection = new SubMapValuesCollection<K, V>(new SubMap<K, V>(key, true, this.m, key, true));
                        return this.valuesCollection;
                    }
                    Map.Entry<K, V> entry = lastEntry = this.toEnd ? this.m.ceilingEntry(this.hi) : null;
                    if (lastEntry != null && this.hiInclusive && lastEntry.getKey().equals(this.hi)) {
                        lastEntry = this.m.higherEntry(this.hi);
                    }
                    Object startK = startEntry == null ? null : (Object)startEntry.getKey();
                    Object lastK = lastEntry == null ? null : (Object)lastEntry.getKey();
                    this.valuesCollection = new SubMapValuesCollection<Object, V>(new SubMap<Object, V>(startK, true, this.m, lastK, lastK == null ? false : this.toEnd));
                }
            }
            return this.valuesCollection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescendingSubMapKeySet<K, V>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        NavigableSubMap<K, V> map;

        DescendingSubMapKeySet(NavigableSubMap<K, V> map) {
            this.map = map;
        }

        @Override
        public final Iterator<K> iterator() {
            return new DescendingSubMapKeyIterator<K, V>(this.map);
        }

        @Override
        public final Iterator<K> descendingIterator() {
            if (this.map.fromStart && this.map.toEnd) {
                return new AscendingSubMapKeyIterator(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m, this.map.lo, this.map.loInclusive));
            }
            if (this.map.toEnd) {
                return new AscendingSubMapKeyIterator(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m));
            }
            if (this.map.fromStart) {
                return new AscendingSubMapKeyIterator(new AscendingSubMap(this.map.m, this.map.lo, this.map.loInclusive));
            }
            return new AscendingSubMapKeyIterator(new AscendingSubMap(this.map.m));
        }

        @Override
        public int size() {
            int size = 0;
            DescendingSubMapEntryIterator<K, V> it = new DescendingSubMapEntryIterator<K, V>(this.map);
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public NavigableSet<K> descendingSet() {
            if (this.map.fromStart && this.map.toEnd) {
                return new AscendingSubMapKeySet(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m, this.map.lo, this.map.loInclusive));
            }
            if (this.map.toEnd) {
                return new AscendingSubMapKeySet(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m));
            }
            if (this.map.fromStart) {
                return new AscendingSubMapKeySet(new AscendingSubMap(this.map.m, this.map.lo, this.map.loInclusive));
            }
            return new AscendingSubMapKeySet(new AscendingSubMap(this.map.m));
        }

        @Override
        public K ceiling(K e) {
            Comparable object = this.map.comparator() == null ? TreeMap.toComparable(e) : null;
            Entry node = this.map.m.findFloorEntry(e);
            if (node != null && !this.map.checkUpperBound(node.key)) {
                return null;
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e, first.key) <= 0 && this.map.checkUpperBound(first.key) ? first : null;
            }
            return (K)(node == null ? null : node.key);
        }

        @Override
        public K floor(K e) {
            Entry node = this.map.m.findCeilingEntry(e);
            if (node != null && !this.map.checkUpperBound(node.key)) {
                Entry entry = node = this.map.hiInclusive ? this.map.m.findCeilingEntry(this.map.hi) : this.map.m.findHigherEntry(this.map.hi);
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Comparable object = this.map.comparator() == null ? TreeMap.toComparable(e) : null;
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e, first.key) > 0 && this.map.checkUpperBound(first.key) ? first : null;
            }
            return (K)(node == null ? null : node.key);
        }

        @Override
        public NavigableSet<K> headSet(K end, boolean endInclusive) {
            this.checkInRange(end, endInclusive);
            if (this.map.fromStart) {
                return new DescendingSubMapKeySet(new DescendingSubMap(this.map.lo, this.map.loInclusive, this.map.m, end, endInclusive));
            }
            return new DescendingSubMapKeySet(new DescendingSubMap(this.map.m, end, endInclusive));
        }

        @Override
        public K higher(K e) {
            Comparable object = this.map.comparator() == null ? TreeMap.toComparable(e) : null;
            Entry node = this.map.m.findLowerEntry(e);
            if (node != null && !this.map.checkUpperBound(node.key)) {
                return null;
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e, first.key) < 0 && this.map.checkUpperBound(first.key) ? first : null;
            }
            return (K)(node == null ? null : node.key);
        }

        @Override
        public K lower(K e) {
            Entry node = this.map.m.findHigherEntry(e);
            if (node != null && !this.map.checkUpperBound(node.key)) {
                Entry entry = node = this.map.hiInclusive ? this.map.m.findCeilingEntry(this.map.hi) : this.map.m.findHigherEntry(this.map.hi);
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Comparable object = this.map.comparator() == null ? TreeMap.toComparable(e) : null;
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e, first.key) > 0 && this.map.checkUpperBound(first.key) ? first : null;
            }
            return (K)(node == null ? null : node.key);
        }

        @Override
        public K pollFirst() {
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret.getKey();
        }

        @Override
        public K pollLast() {
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret.getKey();
        }

        @Override
        public NavigableSet<K> subSet(K start, boolean startInclusive, K end, boolean endInclusive) {
            this.checkInRange(start, startInclusive);
            this.checkInRange(end, endInclusive);
            if (null != this.map.comparator() ? this.map.comparator().compare(start, end) > 0 : TreeMap.toComparable(start).compareTo(end) > 0) {
                throw new IllegalArgumentException();
            }
            return new DescendingSubMapKeySet(new DescendingSubMap(start, startInclusive, this.map.m, end, endInclusive));
        }

        @Override
        public NavigableSet<K> tailSet(K start, boolean startInclusive) {
            this.checkInRange(start, startInclusive);
            if (this.map.toEnd) {
                return new DescendingSubMapKeySet(new DescendingSubMap(start, startInclusive, this.map.m, this.map.hi, this.map.hiInclusive));
            }
            return new DescendingSubMapKeySet(new DescendingSubMap(start, startInclusive, this.map.m));
        }

        void checkInRange(K key, boolean keyInclusive) {
            boolean isInRange = true;
            int result = 0;
            if (this.map.toEnd) {
                int n = result = null != this.map.comparator() ? this.map.comparator().compare(key, this.map.hi) : TreeMap.toComparable(key).compareTo(this.map.hi);
                boolean bl = !this.map.hiInclusive && keyInclusive ? result < 0 : (isInRange = result <= 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(key, this.map.lo) : TreeMap.toComparable(key).compareTo(this.map.lo);
                boolean bl = isInRange && (!this.map.loInclusive && keyInclusive ? result > 0 : result >= 0) ? true : (isInRange = false);
            }
            if (!isInRange) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public SortedSet<K> headSet(K end) {
            return this.headSet(end, false);
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public SortedSet<K> subSet(K start, K end) {
            return this.subSet(start, true, end, false);
        }

        @Override
        public SortedSet<K> tailSet(K start) {
            return this.tailSet(start, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AscendingSubMapKeySet<K, V>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        NavigableSubMap<K, V> map;

        AscendingSubMapKeySet(NavigableSubMap<K, V> map) {
            this.map = map;
        }

        @Override
        public final Iterator<K> iterator() {
            return new AscendingSubMapKeyIterator<K, V>(this.map);
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return new DescendingSubMapKeyIterator<K, V>(this.map.descendingSubMap());
        }

        @Override
        public int size() {
            int size = 0;
            AscendingSubMapEntryIterator<K, V> it = new AscendingSubMapEntryIterator<K, V>(this.map);
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public K ceiling(K e) {
            Entry ret = ((NavigableSubMap)this.map).findFloorEntry(e);
            if (ret != null && this.map.isInRange(ret.key)) {
                return (K)ret.key;
            }
            return null;
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return new DescendingSubMapKeySet<K, V>(this.map.descendingSubMap());
        }

        @Override
        public K floor(K e) {
            Entry ret = ((NavigableSubMap)this.map).findFloorEntry(e);
            if (ret != null && this.map.isInRange(ret.key)) {
                return (K)ret.key;
            }
            return null;
        }

        @Override
        public NavigableSet<K> headSet(K end, boolean endInclusive) {
            int result;
            boolean isInRange = true;
            if (this.map.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(end, this.map.hi) : TreeMap.toComparable(end).compareTo(this.map.hi);
                boolean bl = this.map.hiInclusive || !endInclusive ? result <= 0 : (isInRange = result < 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(end, this.map.lo) : TreeMap.toComparable(end).compareTo(this.map.lo);
                boolean bl = isInRange && (this.map.loInclusive || !endInclusive ? result >= 0 : result > 0) ? true : (isInRange = false);
            }
            if (isInRange) {
                if (this.map.fromStart) {
                    return new AscendingSubMapKeySet(new AscendingSubMap(this.map.lo, this.map.loInclusive, this.map.m, end, endInclusive));
                }
                return new AscendingSubMapKeySet(new AscendingSubMap(this.map.m, end, endInclusive));
            }
            throw new IllegalArgumentException();
        }

        @Override
        public K higher(K e) {
            Object ret = this.map.m.higherKey(e);
            if (ret != null && this.map.isInRange(ret)) {
                return ret;
            }
            return null;
        }

        @Override
        public K lower(K e) {
            Object ret = this.map.m.lowerKey(e);
            if (ret != null && this.map.isInRange(ret)) {
                return ret;
            }
            return null;
        }

        @Override
        public K pollFirst() {
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret.getKey();
        }

        @Override
        public K pollLast() {
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret.getKey();
        }

        @Override
        public NavigableSet<K> subSet(K start, boolean startInclusive, K end, boolean endInclusive) {
            if (this.map.fromStart && (this.map.loInclusive || !startInclusive ? this.map.m.keyCompare(start, this.map.lo) < 0 : this.map.m.keyCompare(start, this.map.lo) <= 0) || this.map.toEnd && (!this.map.hiInclusive && (endInclusive || startInclusive && start.equals(end)) ? this.map.m.keyCompare(end, this.map.hi) >= 0 : this.map.m.keyCompare(end, this.map.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (this.map.m.keyCompare(start, end) > 0) {
                throw new IllegalArgumentException();
            }
            return new AscendingSubMapKeySet(new AscendingSubMap(start, startInclusive, this.map.m, end, endInclusive));
        }

        @Override
        public NavigableSet<K> tailSet(K start, boolean startInclusive) {
            int result;
            boolean isInRange = true;
            if (this.map.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(start, this.map.hi) : TreeMap.toComparable(start).compareTo(this.map.hi);
                boolean bl = this.map.hiInclusive || !startInclusive ? result <= 0 : (isInRange = result < 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(start, this.map.lo) : TreeMap.toComparable(start).compareTo(this.map.lo);
                boolean bl = isInRange && (this.map.loInclusive || !startInclusive ? result >= 0 : result > 0) ? true : (isInRange = false);
            }
            if (isInRange) {
                if (this.map.toEnd) {
                    return new AscendingSubMapKeySet(new AscendingSubMap(start, startInclusive, this.map.m, this.map.hi, this.map.hiInclusive));
                }
                return new AscendingSubMapKeySet(new AscendingSubMap(start, startInclusive, this.map.m));
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.m.comparator;
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public SortedSet<K> headSet(K end) {
            return this.headSet(end, false);
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public SortedSet<K> subSet(K start, K end) {
            return this.subSet(start, true, end, false);
        }

        @Override
        public SortedSet<K> tailSet(K start) {
            return this.tailSet(start, true);
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescendingSubMapEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements NavigableSet<Map.Entry<K, V>> {
        NavigableSubMap<K, V> map;

        DescendingSubMapEntrySet(NavigableSubMap<K, V> map) {
            this.map = map;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new DescendingSubMapEntryIterator<K, V>(this.map);
        }

        @Override
        public int size() {
            int size = 0;
            DescendingSubMapEntryIterator<K, V> it = new DescendingSubMapEntryIterator<K, V>(this.map);
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public Map.Entry<K, V> ceiling(Map.Entry<K, V> e) {
            Entry node = this.map.m.findFloorEntry(e.getKey());
            if (!this.map.checkUpperBound(node.key)) {
                node = ((NavigableSubMap)this.map).findEndNode();
            }
            if (!this.map.checkLowerBound(node.key)) {
                Comparable object = this.map.comparator() == null ? TreeMap.toComparable(e.getKey()) : null;
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), first.getKey()) <= 0 ? first : null;
            }
            return node;
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> descendingSet() {
            if (this.map.fromStart && this.map.toEnd) {
                return new AscendingSubMapEntrySet(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m, this.map.lo, this.map.loInclusive));
            }
            if (this.map.fromStart) {
                return new AscendingSubMapEntrySet(new AscendingSubMap(this.map.m, this.map.lo, this.map.loInclusive));
            }
            if (this.map.toEnd) {
                return new AscendingSubMapEntrySet(new AscendingSubMap(this.map.hi, this.map.hiInclusive, this.map.m));
            }
            return new AscendingSubMapEntrySet(new AscendingSubMap(this.map.m));
        }

        @Override
        public Map.Entry<K, V> floor(Map.Entry<K, V> e) {
            Entry node = this.map.m.findCeilingEntry(e.getKey());
            if (!this.map.checkUpperBound(node.key)) {
                node = ((NavigableSubMap)this.map).findEndNode();
            }
            if (!this.map.checkLowerBound(node.key)) {
                Comparable object = this.map.m.comparator == null ? TreeMap.toComparable(e.getKey()) : null;
                Entry first = this.map.hiInclusive ? this.map.m.findCeilingEntry(this.map.hi) : this.map.m.findHigherEntry(this.map.hi);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), first.getKey()) < 0 ? first : null;
            }
            return node;
        }

        void checkInRange(K key, boolean keyInclusive) {
            boolean isInRange = true;
            int result = 0;
            if (this.map.toEnd) {
                int n = result = null != this.map.comparator() ? this.comparator().compare(key, this.map.hi) : TreeMap.toComparable(key).compareTo(this.map.hi);
                boolean bl = !this.map.hiInclusive && keyInclusive ? result < 0 : (isInRange = result <= 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(key, this.map.lo) : TreeMap.toComparable(key).compareTo(this.map.lo);
                boolean bl = isInRange && (!this.map.loInclusive && keyInclusive ? result > 0 : result >= 0) ? true : (isInRange = false);
            }
            if (!isInRange) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> end, boolean endInclusive) {
            boolean outRange = true;
            int result = 0;
            if (this.map.toEnd) {
                int n = result = null != this.map.comparator() ? this.comparator().compare(end.getKey(), this.map.hi) : TreeMap.toComparable(end.getKey()).compareTo(this.map.hi);
                boolean bl = !this.map.hiInclusive && endInclusive ? result >= 0 : (outRange = result > 0);
                if (outRange) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(end.getKey(), this.map.lo) : TreeMap.toComparable(end.getKey()).compareTo(this.map.lo);
                boolean bl = !this.map.loInclusive && endInclusive ? result <= 0 : (outRange = result < 0);
                if (outRange) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.map.fromStart) {
                return new DescendingSubMapEntrySet(new DescendingSubMap(this.map.lo, this.map.loInclusive, this.map.m, end.getKey(), endInclusive));
            }
            return new DescendingSubMapEntrySet(new DescendingSubMap(this.map.m, end.getKey(), endInclusive));
        }

        @Override
        public Map.Entry<K, V> higher(Map.Entry<K, V> e) {
            Comparable object;
            Entry node = this.map.m.findLowerEntry(e.getKey());
            if (node != null && !this.map.checkUpperBound(node.key)) {
                node = this.map.hiInclusive ? ((NavigableSubMap)this.map).findFloorEntryImpl(this.map.hi) : ((NavigableSubMap)this.map).findLowerEntryImpl(this.map.hi);
            }
            Comparable comparable = object = this.map.comparator() == null ? TreeMap.toComparable(e.getKey()) : null;
            if (node != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), node.key) > 0) {
                return null;
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Entry first = this.map.loInclusive ? this.map.m.findFloorEntry(this.map.lo) : this.map.m.findLowerEntry(this.map.lo);
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), first.getKey()) < 0 ? first : null;
            }
            return node;
        }

        @Override
        public Map.Entry<K, V> lower(Map.Entry<K, V> e) {
            Comparable object;
            Entry node = this.map.m.findHigherEntry(e.getKey());
            if (node != null && !this.map.checkUpperBound(node.key)) {
                node = this.map.loInclusive ? ((NavigableSubMap)this.map).findCeilingEntryImpl(this.map.hi) : this.map.findHigherEntryImpl(this.map.hi);
            }
            Comparable comparable = object = this.map.m.comparator == null ? TreeMap.toComparable(e.getKey()) : null;
            if (node != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), node.key) >= 0) {
                return null;
            }
            if (node != null && !this.map.checkLowerBound(node.key)) {
                Map.Entry<K, V> first = this.map.firstEntry();
                node = first != null && ((NavigableSubMap)this.map).cmp(object, e.getKey(), first.getKey()) < 0 ? ((NavigableSubMap)this.map).findStartNode() : null;
            }
            return node;
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret;
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret;
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> start, boolean startInclusive, Map.Entry<K, V> end, boolean endInclusive) {
            Comparable endobject;
            Comparable startobject = this.map.comparator() == null ? TreeMap.toComparable(start.getKey()) : null;
            Comparable comparable = endobject = this.map.comparator() == null ? TreeMap.toComparable(end.getKey()) : null;
            if (this.map.fromStart && (this.map.loInclusive || !startInclusive ? ((NavigableSubMap)this.map).cmp(startobject, start.getKey(), this.map.lo) < 0 : ((NavigableSubMap)this.map).cmp(startobject, start.getKey(), this.map.lo) <= 0) || this.map.toEnd && (!this.map.hiInclusive && endInclusive ? ((NavigableSubMap)this.map).cmp(endobject, end.getKey(), this.map.hi) >= 0 : ((NavigableSubMap)this.map).cmp(endobject, end.getKey(), this.map.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            if (((NavigableSubMap)this.map).cmp(startobject, start.getKey(), end.getKey()) > 0) {
                throw new IllegalArgumentException();
            }
            return new DescendingSubMapEntrySet(new DescendingSubMap(start.getKey(), startInclusive, this.map.m, end.getKey(), endInclusive));
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> start, boolean startInclusive) {
            if (this.map.toEnd) {
                return new DescendingSubMapEntrySet(new DescendingSubMap(start.getKey(), startInclusive, this.map.m, this.map.hi, this.map.hiInclusive));
            }
            return new DescendingSubMapEntrySet(new DescendingSubMap(start.getKey(), startInclusive, this.map.m));
        }

        @Override
        public Comparator comparator() {
            return this.map.comparator();
        }

        @Override
        public Map.Entry<K, V> first() {
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> end) {
            return this.headSet(end, false);
        }

        @Override
        public Map.Entry<K, V> last() {
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> start, Map.Entry<K, V> end) {
            return this.subSet(start, true, end, false);
        }

        int keyCompare(K left, K right) {
            return null != this.map.comparator() ? this.map.comparator().compare(left, right) : TreeMap.toComparable(left).compareTo(right);
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> start) {
            return this.tailSet(start, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AscendingSubMapEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements NavigableSet<Map.Entry<K, V>> {
        boolean hasStart;
        boolean hasEnd;
        boolean startInclusive;
        boolean endInclusive;
        Map.Entry<K, V> startEntry;
        Map.Entry<K, V> lastentry;
        NavigableSubMap<K, V> map;

        AscendingSubMapEntrySet(NavigableSubMap<K, V> map) {
            this.map = map;
        }

        AscendingSubMapEntrySet(NavigableSubMap<K, V> map, Map.Entry<K, V> startEntry, boolean startInclusive, Map.Entry<K, V> endEntry, boolean endInclusive) {
            if (startEntry != null) {
                this.hasStart = true;
                this.startEntry = startEntry;
                this.startInclusive = startInclusive;
            }
            if (endEntry != null) {
                this.hasEnd = true;
                this.lastentry = endEntry;
                this.endInclusive = endInclusive;
            }
            if (startEntry != null && endEntry != null) {
                this.map = (NavigableSubMap)map.subMap(startEntry.getKey(), startInclusive, endEntry.getKey(), endInclusive);
                return;
            }
            if (startEntry != null) {
                this.map = (NavigableSubMap)map.tailMap(startEntry.getKey(), startInclusive);
                return;
            }
            if (endEntry != null) {
                this.map = (NavigableSubMap)map.headMap(endEntry.getKey(), endInclusive);
                return;
            }
            this.map = map;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new AscendingSubMapEntryIterator<K, V>(this.map);
        }

        @Override
        public int size() {
            int size = 0;
            AscendingSubMapEntryIterator<K, V> it = new AscendingSubMapEntryIterator<K, V>(this.map);
            while (it.hasNext()) {
                it.next();
                ++size;
            }
            return size;
        }

        @Override
        public Map.Entry<K, V> ceiling(Map.Entry<K, V> e) {
            Map.Entry<K, V> entry = this.map.ceilingEntry(e.getKey());
            if (entry != null && this.map.isInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public Iterator<Map.Entry<K, V>> descendingIterator() {
            return new DescendingSubMapEntrySet<K, V>(this.map.descendingSubMap()).iterator();
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> descendingSet() {
            return new DescendingSubMapEntrySet<K, V>(this.map.descendingSubMap());
        }

        @Override
        public Map.Entry<K, V> floor(Map.Entry<K, V> e) {
            Map.Entry<K, V> entry = this.map.floorEntry(e.getKey());
            if (entry != null && this.map.isInRange(entry.getKey())) {
                return entry;
            }
            return null;
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> end, boolean endInclusive) {
            int result;
            boolean isInRange = true;
            K endKey = end.getKey();
            if (this.map.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(endKey, this.map.hi) : TreeMap.toComparable(endKey).compareTo(this.map.hi);
                boolean bl = !this.map.hiInclusive && endInclusive ? result < 0 : (isInRange = result <= 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(endKey, this.map.lo) : TreeMap.toComparable(endKey).compareTo(this.map.lo);
                boolean bl = isInRange && (!this.map.loInclusive && endInclusive ? result > 0 : result >= 0) ? true : (isInRange = false);
            }
            if (isInRange) {
                return new AscendingSubMapEntrySet<K, V>(this.map, null, false, end, endInclusive);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Map.Entry<K, V> higher(Map.Entry<K, V> e) {
            Comparator cmp = this.map.m.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(e.getKey());
                if (this.hasStart && object.compareTo(this.startEntry.getKey()) < 0) {
                    return this.map.higherEntry(this.startEntry.getKey());
                }
                if (this.hasEnd && object.compareTo(this.lastentry.getKey()) >= 0) {
                    return null;
                }
            } else {
                if (this.hasStart && cmp.compare(e.getKey(), this.startEntry.getKey()) < 0) {
                    return this.map.higherEntry(this.startEntry.getKey());
                }
                if (this.hasEnd && cmp.compare(e.getKey(), this.lastentry.getKey()) >= 0) {
                    return null;
                }
            }
            return this.map.higherEntry(e.getKey());
        }

        @Override
        public Map.Entry<K, V> lower(Map.Entry<K, V> e) {
            Comparator cmp = this.map.m.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(e.getKey());
                if (this.hasStart && object.compareTo(this.startEntry.getKey()) < 0) {
                    return null;
                }
                if (this.hasEnd && object.compareTo(this.lastentry.getKey()) >= 0) {
                    return this.map.lowerEntry(this.lastentry.getKey());
                }
            } else {
                if (this.hasStart && cmp.compare(e.getKey(), this.startEntry.getKey()) < 0) {
                    return null;
                }
                if (this.hasEnd && cmp.compare(e.getKey(), this.lastentry.getKey()) >= 0) {
                    return this.map.lowerEntry(this.lastentry.getKey());
                }
            }
            return this.map.lowerEntry(e.getKey());
        }

        @Override
        public Map.Entry<K, V> pollFirst() {
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret;
        }

        @Override
        public Map.Entry<K, V> pollLast() {
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                return null;
            }
            this.map.m.remove(ret.getKey());
            return ret;
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> start, boolean startInclusive, Map.Entry<K, V> end, boolean endInclusive) {
            if (this.map.m.keyCompare(start.getKey(), end.getKey()) > 0) {
                throw new IllegalArgumentException();
            }
            if (this.map.fromStart && (!this.map.loInclusive && endInclusive ? this.map.m.keyCompare(end.getKey(), this.map.lo) <= 0 : this.map.m.keyCompare(end.getKey(), this.map.lo) < 0)) {
                throw new IllegalArgumentException();
            }
            if (this.map.toEnd && (!this.map.hiInclusive && startInclusive ? this.map.m.keyCompare(start.getKey(), this.map.hi) >= 0 : this.map.m.keyCompare(start.getKey(), this.map.hi) > 0)) {
                throw new IllegalArgumentException();
            }
            return new AscendingSubMapEntrySet<K, V>(this.map, start, startInclusive, end, endInclusive);
        }

        @Override
        public NavigableSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> start, boolean startInclusive) {
            int result;
            boolean isInRange = true;
            if (this.map.toEnd) {
                int n = result = null != this.comparator() ? this.comparator().compare(start.getKey(), this.map.hi) : TreeMap.toComparable(start.getKey()).compareTo(this.map.hi);
                boolean bl = this.map.hiInclusive || !startInclusive ? result <= 0 : (isInRange = result < 0);
            }
            if (this.map.fromStart) {
                int n = result = null != this.comparator() ? this.comparator().compare(start.getKey(), this.map.lo) : TreeMap.toComparable(start.getKey()).compareTo(this.map.lo);
                boolean bl = isInRange && (this.map.loInclusive || !startInclusive ? result >= 0 : result > 0) ? true : (isInRange = false);
            }
            if (isInRange) {
                return new AscendingSubMapEntrySet<K, V>(this.map, start, startInclusive, null, false);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Comparator comparator() {
            return this.map.m.comparator;
        }

        @Override
        public Map.Entry<K, V> first() {
            if (this.hasStart) {
                if (this.startInclusive) {
                    return this.startEntry;
                }
                return this.map.floorEntry(this.startEntry.getKey());
            }
            Map.Entry<K, V> ret = this.map.firstEntry();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> headSet(Map.Entry<K, V> end) {
            return this.headSet(end, false);
        }

        @Override
        public Map.Entry<K, V> last() {
            if (this.hasEnd) {
                if (this.endInclusive) {
                    return this.lastentry;
                }
                return this.map.ceilingEntry(this.lastentry.getKey());
            }
            Map.Entry<K, V> ret = this.map.lastEntry();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            return ret;
        }

        @Override
        public SortedSet<Map.Entry<K, V>> subSet(Map.Entry<K, V> start, Map.Entry<K, V> end) {
            if (null != this.comparator() ? this.comparator().compare(start.getKey(), end.getKey()) > 0 : TreeMap.toComparable(start.getKey()).compareTo(end.getKey()) > 0) {
                throw new IllegalArgumentException();
            }
            if (!this.map.isInRange(start.getKey())) {
                throw new IllegalArgumentException();
            }
            if (!this.map.isInRange(end.getKey())) {
                throw new IllegalArgumentException();
            }
            return new AscendingSubMapEntrySet<K, V>(this.map, start, false, end, false);
        }

        @Override
        public SortedSet<Map.Entry<K, V>> tailSet(Map.Entry<K, V> start) {
            return this.tailSet(start, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubMapEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        SubMap<K, V> subMap;

        SubMapEntrySet(SubMap<K, V> map) {
            this.subMap = map;
        }

        @Override
        public boolean isEmpty() {
            return this.subMap.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            int fromIndex;
            Node from;
            if (this.subMap.hasStart) {
                ((SubMap)this.subMap).setFirstKey();
                from = this.subMap.firstKeyNode;
                fromIndex = this.subMap.firstKeyIndex;
            } else {
                from = TreeMap.minimum(((SubMap)this.subMap).backingMap.root);
                int n = fromIndex = from != null ? from.left_idx : 0;
            }
            if (from == null) {
                return new BoundedEntryIterator(null, 0, ((SubMap)this.subMap).backingMap, null, 0);
            }
            if (!this.subMap.hasEnd) {
                return new UnboundedEntryIterator(((SubMap)this.subMap).backingMap, from, from == null ? 0 : from.right_idx - fromIndex);
            }
            ((SubMap)this.subMap).setLastKey();
            Node to = this.subMap.lastKeyNode;
            Comparable object = ((SubMap)this.subMap).backingMap.comparator == null ? TreeMap.toComparable(this.subMap.endKey) : null;
            int toIndex = this.subMap.lastKeyIndex + (this.subMap.lastKeyNode != null && !this.subMap.lastKeyNode.keys[this.subMap.lastKeyIndex].equals(this.subMap.endKey) ? 1 : 0);
            if (this.subMap.lastKeyNode != null && toIndex > this.subMap.lastKeyNode.right_idx) {
                to = to.next;
                int n = toIndex = to != null ? to.left_idx : 0;
            }
            if (to == null) {
                return new UnboundedEntryIterator(((SubMap)this.subMap).backingMap, from, fromIndex);
            }
            return new BoundedEntryIterator(from, from == null ? 0 : fromIndex, ((SubMap)this.subMap).backingMap, to, to == null ? 0 : toIndex);
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object key;
            if (object instanceof Map.Entry && ((SubMap)this.subMap).isInRange(key = (entry = (Map.Entry)object).getKey())) {
                V v1 = this.subMap.get(key);
                Object v2 = entry.getValue();
                return v1 == null ? v2 == null && this.subMap.containsKey(key) : v1.equals(v2);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                Object key = entry.getKey();
                this.subMap.remove(key);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubMapKeySet<K, V>
    extends AbstractSet<K>
    implements Set<K> {
        SubMap<K, V> subMap;

        SubMapKeySet(SubMap<K, V> map) {
            this.subMap = map;
        }

        @Override
        public boolean contains(Object object) {
            return this.subMap.containsKey(object);
        }

        @Override
        public boolean isEmpty() {
            return this.subMap.isEmpty();
        }

        @Override
        public int size() {
            return this.subMap.size();
        }

        @Override
        public boolean remove(Object object) {
            return this.subMap.remove(object) != null;
        }

        @Override
        public Iterator<K> iterator() {
            int fromIndex;
            Node from;
            if (this.subMap.hasStart) {
                ((SubMap)this.subMap).setFirstKey();
                from = this.subMap.firstKeyNode;
                fromIndex = this.subMap.firstKeyIndex;
            } else {
                from = TreeMap.minimum(((SubMap)this.subMap).backingMap.root);
                int n = fromIndex = from != null ? from.left_idx : 0;
            }
            if (from == null) {
                return new BoundedKeyIterator(null, 0, ((SubMap)this.subMap).backingMap, null, 0);
            }
            if (!this.subMap.hasEnd) {
                return new UnboundedKeyIterator(((SubMap)this.subMap).backingMap, from, from == null ? 0 : from.right_idx - fromIndex);
            }
            ((SubMap)this.subMap).setLastKey();
            Node to = this.subMap.lastKeyNode;
            Comparable object = ((SubMap)this.subMap).backingMap.comparator == null ? TreeMap.toComparable(this.subMap.endKey) : null;
            int toIndex = this.subMap.lastKeyIndex + (this.subMap.lastKeyNode != null && !this.subMap.lastKeyNode.keys[this.subMap.lastKeyIndex].equals(this.subMap.endKey) ? 1 : 0);
            if (this.subMap.lastKeyNode != null && toIndex > this.subMap.lastKeyNode.right_idx) {
                to = to.next;
                int n = toIndex = to != null ? to.left_idx : 0;
            }
            if (to == null) {
                return new UnboundedKeyIterator(((SubMap)this.subMap).backingMap, from, fromIndex);
            }
            return new BoundedKeyIterator(from, from == null ? 0 : fromIndex, ((SubMap)this.subMap).backingMap, to, to == null ? 0 : toIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BoundedValueIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<V> {
        public BoundedValueIterator(Node<K, V> startNode, int startOffset, TreeMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
            super(startNode, startOffset, map, finalNode, finalOffset);
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.makeBoundedNext();
            return this.lastNode.values[this.lastOffset];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BoundedKeyIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<K> {
        public BoundedKeyIterator(Node<K, V> startNode, int startOffset, TreeMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
            super(startNode, startOffset, map, finalNode, finalOffset);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.makeBoundedNext();
            return this.lastNode.keys[this.lastOffset];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BoundedEntryIterator<K, V>
    extends BoundedMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        public BoundedEntryIterator(Node<K, V> startNode, int startOffset, TreeMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
            super(startNode, startOffset, map, finalNode, finalOffset);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.makeBoundedNext();
            int idx = this.lastOffset;
            return new MapEntry(this.lastNode.keys[idx], this.lastNode.values[idx]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BoundedMapIterator<K, V>
    extends AbstractMapIterator<K, V> {
        Node<K, V> finalNode;
        int finalOffset;

        BoundedMapIterator(Node<K, V> startNode, int startOffset, TreeMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
            super(map, startNode, startOffset);
            if (startNode == null && finalNode == null) {
                this.node = null;
                return;
            }
            if (finalNode != null) {
                this.finalNode = finalNode;
                this.finalOffset = finalOffset;
            } else {
                Entry<K, V> entry = map.findBiggestEntry();
                if (entry != null) {
                    this.finalNode = entry.node;
                    this.finalOffset = entry.index;
                } else {
                    this.node = null;
                    return;
                }
            }
            if (startNode != null) {
                if (this.node == this.finalNode && this.offset >= this.finalOffset) {
                    this.node = null;
                } else if (this.finalOffset < this.finalNode.right_idx) {
                    Comparable object;
                    Comparable comparable = object = this.backingMap.comparator == null ? TreeMap.toComparable(startNode.keys[startOffset]) : null;
                    if (this.backingMap.cmp(object, this.node.keys[this.offset], this.finalNode.keys[this.finalOffset]) > 0) {
                        this.node = null;
                    }
                }
            }
        }

        BoundedMapIterator(Node<K, V> startNode, TreeMap<K, V> map, Node<K, V> finalNode, int finalOffset) {
            this(startNode, startNode.left_idx, map, finalNode, finalOffset);
        }

        BoundedMapIterator(Node<K, V> startNode, int startOffset, TreeMap<K, V> map, Node<K, V> finalNode) {
            this(startNode, startOffset, map, finalNode, finalNode.right_idx);
        }

        void makeBoundedNext() {
            if (this.node != null) {
                boolean endOfIterator;
                boolean bl = endOfIterator = this.lastNode == this.finalNode && this.lastOffset == this.finalOffset;
                if (endOfIterator) {
                    this.node = null;
                } else {
                    this.makeNext();
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (this.finalNode == this.node && this.finalOffset == this.offset) {
                this.node = null;
            }
            return this.node != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubMapValuesCollection<K, V>
    extends AbstractCollection<V> {
        SubMap<K, V> subMap;

        public SubMapValuesCollection(SubMap<K, V> subMap) {
            this.subMap = subMap;
        }

        @Override
        public boolean isEmpty() {
            return this.subMap.isEmpty();
        }

        @Override
        public Iterator<V> iterator() {
            int fromIndex;
            Node from;
            if (this.subMap.hasStart) {
                ((SubMap)this.subMap).setFirstKey();
                from = this.subMap.firstKeyNode;
                fromIndex = this.subMap.firstKeyIndex;
            } else {
                from = TreeMap.minimum(((SubMap)this.subMap).backingMap.root);
                int n = fromIndex = from != null ? from.left_idx : 0;
            }
            if (!this.subMap.hasEnd) {
                return new UnboundedValueIterator(((SubMap)this.subMap).backingMap, from, from == null ? 0 : fromIndex);
            }
            ((SubMap)this.subMap).setLastKey();
            Node to = this.subMap.lastKeyNode;
            int toIndex = this.subMap.lastKeyIndex + (this.subMap.lastKeyNode != null && !this.subMap.lastKeyNode.keys[this.subMap.lastKeyIndex].equals(this.subMap.endKey) ? 1 : 0);
            if (to != null && toIndex > to.right_idx) {
                to = to.next;
                int n = toIndex = to != null ? to.left_idx : 0;
                if (to == null) {
                    return new UnboundedValueIterator(((SubMap)this.subMap).backingMap, from, from == null ? 0 : fromIndex);
                }
            }
            return new BoundedValueIterator(from, from == null ? 0 : fromIndex, ((SubMap)this.subMap).backingMap, to, to == null ? 0 : toIndex);
        }

        @Override
        public int size() {
            return this.subMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SubMap<K, V>
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        private TreeMap<K, V> backingMap;
        boolean hasStart;
        boolean hasEnd;
        K startKey;
        K endKey;
        transient Set<Map.Entry<K, V>> entrySet = null;
        transient int firstKeyModCount = -1;
        transient int lastKeyModCount = -1;
        transient Node<K, V> firstKeyNode;
        transient int firstKeyIndex;
        transient Node<K, V> lastKeyNode;
        transient int lastKeyIndex;

        SubMap(K start, TreeMap<K, V> map) {
            this.backingMap = map;
            this.hasStart = true;
            this.startKey = start;
        }

        SubMap(K start, TreeMap<K, V> map, K end) {
            this.backingMap = map;
            this.hasEnd = true;
            this.hasStart = true;
            this.startKey = start;
            this.endKey = end;
        }

        SubMap(K start, boolean hasStart, TreeMap<K, V> map, K end, boolean hasEnd) {
            this.backingMap = map;
            this.hasStart = hasStart;
            this.hasEnd = hasEnd;
            this.startKey = start;
            this.endKey = end;
        }

        SubMap(TreeMap<K, V> map, K end) {
            this.backingMap = map;
            this.hasEnd = true;
            this.endKey = end;
        }

        private void checkRange(K key) {
            Comparator cmp = this.backingMap.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(key);
                if (this.hasStart && object.compareTo(this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (this.hasStart && this.backingMap.comparator().compare(key, this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && this.backingMap.comparator().compare(key, this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            }
        }

        private boolean isInRange(K key) {
            Comparator cmp = this.backingMap.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(key);
                if (this.hasStart && object.compareTo(this.startKey) < 0) {
                    return false;
                }
                if (this.hasEnd && object.compareTo(this.endKey) >= 0) {
                    return false;
                }
            } else {
                if (this.hasStart && cmp.compare(key, this.startKey) < 0) {
                    return false;
                }
                if (this.hasEnd && cmp.compare(key, this.endKey) >= 0) {
                    return false;
                }
            }
            return true;
        }

        private boolean checkUpperBound(K key) {
            if (this.hasEnd) {
                Comparator cmp = this.backingMap.comparator;
                if (cmp == null) {
                    return TreeMap.toComparable(key).compareTo(this.endKey) < 0;
                }
                return cmp.compare(key, this.endKey) < 0;
            }
            return true;
        }

        private boolean checkLowerBound(K key) {
            if (this.hasStart && this.startKey != null) {
                Comparator cmp = this.backingMap.comparator;
                if (cmp == null) {
                    return TreeMap.toComparable(key).compareTo(this.startKey) >= 0;
                }
                return cmp.compare(key, this.startKey) >= 0;
            }
            return true;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.backingMap.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.isInRange(key)) {
                return this.backingMap.containsKey(key);
            }
            return false;
        }

        @Override
        public void clear() {
            this.keySet().clear();
        }

        @Override
        public boolean containsValue(Object value) {
            Iterator<V> it = this.values().iterator();
            if (value != null) {
                while (it.hasNext()) {
                    if (!value.equals(it.next())) continue;
                    return true;
                }
            } else {
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new SubMapEntrySet(this);
            }
            return this.entrySet;
        }

        private void setFirstKey() {
            if (this.firstKeyModCount == this.backingMap.modCount) {
                return;
            }
            Comparable object = this.backingMap.comparator == null ? TreeMap.toComparable(this.startKey) : null;
            K key = this.startKey;
            Node node = this.backingMap.root;
            Node foundNode = null;
            int foundIndex = -1;
            block0: while (node != null) {
                K[] keys = node.keys;
                int left_idx = node.left_idx;
                int result = ((TreeMap)this.backingMap).cmp(object, key, keys[left_idx]);
                if (result < 0) {
                    foundNode = node;
                    foundIndex = node.left_idx;
                    node = node.left;
                    continue;
                }
                if (result == 0) {
                    foundNode = node;
                    foundIndex = node.left_idx;
                    break;
                }
                int right_idx = node.right_idx;
                if (left_idx != right_idx) {
                    result = ((TreeMap)this.backingMap).cmp(object, key, keys[right_idx]);
                }
                if (result > 0) {
                    node = node.right;
                    continue;
                }
                if (result == 0) {
                    foundNode = node;
                    foundIndex = node.right_idx;
                    break;
                }
                foundNode = node;
                foundIndex = node.right_idx;
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high) {
                    mid = low + high >>> 1;
                    result = ((TreeMap)this.backingMap).cmp(object, key, keys[mid]);
                    if (result > 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (result == 0) {
                        foundNode = node;
                        foundIndex = mid;
                        break block0;
                    }
                    foundNode = node;
                    foundIndex = mid;
                    high = mid - 1;
                }
                break block0;
            }
            boolean isBounded = true;
            if (this.hasEnd && foundNode != null) {
                Comparator cmp = this.backingMap.comparator;
                if (cmp == null) {
                    isBounded = TreeMap.toComparable(foundNode.keys[foundIndex]).compareTo(this.endKey) <= 0;
                } else {
                    boolean bl = isBounded = cmp.compare(foundNode.keys[foundIndex], this.endKey) <= 0;
                }
            }
            if (foundNode != null && !isBounded) {
                foundNode = null;
            }
            this.firstKeyNode = foundNode;
            this.firstKeyIndex = foundIndex;
            this.firstKeyModCount = this.backingMap.modCount;
        }

        @Override
        public K firstKey() {
            if (this.backingMap.size > 0 && !this.startKey.equals(this.endKey)) {
                if (!this.hasStart) {
                    Node node = TreeMap.minimum(this.backingMap.root);
                    if (node != null && this.checkUpperBound(node.keys[node.left_idx])) {
                        return node.keys[node.left_idx];
                    }
                } else {
                    this.setFirstKey();
                    if (this.firstKeyNode != null) {
                        return this.firstKeyNode.keys[this.firstKeyIndex];
                    }
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public V get(Object key) {
            if (this.isInRange(key)) {
                return this.backingMap.get(key);
            }
            return null;
        }

        @Override
        public SortedMap<K, V> headMap(K endKey) {
            Comparator cmp = this.backingMap.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(endKey);
                if (this.hasStart && object.compareTo(this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && object.compareTo(this.endKey) > 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (this.hasStart && this.backingMap.comparator().compare(endKey, this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && this.backingMap.comparator().compare(endKey, this.endKey) >= 0) {
                    throw new IllegalArgumentException();
                }
            }
            if (this.hasStart) {
                return new SubMap<K, V>(this.startKey, this.backingMap, endKey);
            }
            return new SubMap<K, V>(this.backingMap, endKey);
        }

        @Override
        public boolean isEmpty() {
            Iterator<K> it = this.keySet().iterator();
            return !it.hasNext();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = new SubMapKeySet(this);
            }
            return this.keySet;
        }

        private void setLastKey() {
            if (this.lastKeyModCount == this.backingMap.modCount) {
                return;
            }
            Comparable object = this.backingMap.comparator == null ? TreeMap.toComparable(this.endKey) : null;
            K key = this.endKey;
            Node node = this.backingMap.root;
            Node foundNode = null;
            int foundIndex = -1;
            block0: while (node != null) {
                int result;
                K[] keys = node.keys;
                int left_idx = node.left_idx;
                int n = result = object != null ? object.compareTo(keys[left_idx]) : -this.backingMap.comparator.compare(keys[left_idx], key);
                if (result < 0) {
                    node = node.left;
                    continue;
                }
                int right_idx = node.right_idx;
                if (left_idx != right_idx) {
                    result = ((TreeMap)this.backingMap).cmp(object, key, keys[right_idx]);
                }
                if (result > 0) {
                    foundNode = node;
                    foundIndex = right_idx;
                    node = node.right;
                    continue;
                }
                if (result == 0) {
                    if (node.left_idx == node.right_idx) {
                        foundNode = node.prev;
                        if (foundNode == null) break;
                        foundIndex = foundNode.right_idx - 1;
                        break;
                    }
                    foundNode = node;
                    foundIndex = right_idx;
                    break;
                }
                foundNode = node;
                foundIndex = left_idx;
                int low = left_idx + 1;
                int mid = 0;
                int high = right_idx - 1;
                while (low <= high) {
                    mid = low + high >>> 1;
                    result = ((TreeMap)this.backingMap).cmp(object, key, keys[mid]);
                    if (result > 0) {
                        foundNode = node;
                        foundIndex = mid;
                        low = mid + 1;
                        continue;
                    }
                    if (result == 0) {
                        foundNode = node;
                        foundIndex = mid;
                        break block0;
                    }
                    high = mid - 1;
                }
                break block0;
            }
            if (foundNode != null && !this.checkLowerBound(foundNode.keys[foundIndex])) {
                foundNode = null;
            }
            this.lastKeyNode = foundNode;
            this.lastKeyIndex = foundIndex;
            this.lastKeyModCount = this.backingMap.modCount;
        }

        @Override
        public K lastKey() {
            if (this.backingMap.size > 0 && !this.startKey.equals(this.endKey)) {
                if (!this.hasEnd) {
                    Node node = TreeMap.maximum(this.backingMap.root);
                    if (node != null && this.checkLowerBound(node.keys[node.right_idx])) {
                        return node.keys[node.right_idx];
                    }
                } else {
                    this.setLastKey();
                    if (this.lastKeyNode != null) {
                        Comparable object;
                        Comparable comparable = object = this.backingMap.comparator == null ? TreeMap.toComparable(this.endKey) : null;
                        if (((TreeMap)this.backingMap).cmp(object, this.endKey, this.lastKeyNode.keys[this.lastKeyIndex]) != 0) {
                            return this.lastKeyNode.keys[this.lastKeyIndex];
                        }
                        if (this.lastKeyIndex != this.lastKeyNode.left_idx) {
                            Comparable comparable2 = object = this.backingMap.comparator == null ? TreeMap.toComparable(this.startKey) : null;
                            if (((TreeMap)this.backingMap).cmp(object, this.startKey, this.lastKeyNode.keys[this.lastKeyIndex - 1]) <= 0) {
                                return this.lastKeyNode.keys[this.lastKeyIndex - 1];
                            }
                        } else {
                            Node last = this.lastKeyNode.prev;
                            if (last != null) {
                                return last.keys[last.right_idx];
                            }
                        }
                    }
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public V put(K key, V value) {
            if (this.isInRange(key)) {
                return this.backingMap.put(key, value);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public V remove(Object key) {
            if (this.isInRange(key)) {
                return this.backingMap.remove(key);
            }
            return null;
        }

        @Override
        public SortedMap<K, V> subMap(K startKey, K endKey) {
            Comparator<K> c;
            this.checkRange(startKey);
            Comparator cmp = this.backingMap.comparator;
            if (cmp == null) {
                Comparable object = TreeMap.toComparable(endKey);
                if (this.hasStart && object.compareTo(startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && object.compareTo(endKey) > 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (this.hasStart && this.backingMap.comparator().compare(endKey, this.startKey) < 0) {
                    throw new IllegalArgumentException();
                }
                if (this.hasEnd && this.backingMap.comparator().compare(endKey, this.endKey) > 0) {
                    throw new IllegalArgumentException();
                }
            }
            if ((c = this.backingMap.comparator()) == null ? TreeMap.toComparable(startKey).compareTo(endKey) <= 0 : c.compare(startKey, endKey) <= 0) {
                return new SubMap<K, V>(startKey, this.backingMap, endKey);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public SortedMap<K, V> tailMap(K startKey) {
            this.checkRange(startKey);
            if (this.hasEnd) {
                return new SubMap<K, V>(startKey, this.backingMap, this.endKey);
            }
            return new SubMap<K, V>(startKey, this.backingMap);
        }

        @Override
        public Collection<V> values() {
            if (this.valuesCollection == null) {
                this.valuesCollection = new SubMapValuesCollection(this);
            }
            return this.valuesCollection;
        }

        @Override
        public int size() {
            int toIndex;
            Node<K, V> to;
            int fromIndex;
            Node<K, V> from;
            if (this.hasStart) {
                this.setFirstKey();
                from = this.firstKeyNode;
                fromIndex = this.firstKeyIndex;
            } else {
                from = TreeMap.minimum(this.backingMap.root);
                int n = fromIndex = from == null ? 0 : from.left_idx;
            }
            if (from == null) {
                return 0;
            }
            if (this.hasEnd) {
                Comparable object;
                this.setLastKey();
                to = this.lastKeyNode;
                toIndex = this.lastKeyIndex;
                Comparable comparable = object = this.backingMap.comparator == null ? TreeMap.toComparable(this.endKey) : null;
                if (to == null) {
                    return 0;
                }
                if (((TreeMap)this.backingMap).cmp(object, this.endKey, to.keys[toIndex]) != 0) {
                    toIndex = toIndex != to.keys.length ? ++toIndex : ((to = to.next) == null ? 0 : to.left_idx);
                }
            } else {
                to = TreeMap.maximum(this.backingMap.root);
                int n = toIndex = to == null ? 0 : to.right_idx;
            }
            if (to == null) {
                return 0;
            }
            if (from == to) {
                return toIndex - fromIndex + (this.hasEnd ? 0 : 1);
            }
            int sum = 0;
            while (from != to) {
                sum += from.right_idx - fromIndex + 1;
                from = from.next;
                fromIndex = from.left_idx;
            }
            return sum + toIndex - fromIndex + (this.hasEnd ? 0 : 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescendingSubMapKeyIterator<K, V>
    extends DescendingSubMapIterator<K, V>
    implements Iterator<K> {
        DescendingSubMapKeyIterator(NavigableSubMap<K, V> map) {
            super(map);
        }

        @Override
        public final K next() {
            return (K)this.getNext().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DescendingSubMapEntryIterator<K, V>
    extends DescendingSubMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        DescendingSubMapEntryIterator(NavigableSubMap<K, V> map) {
            super(map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.getNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class DescendingSubMapIterator<K, V>
    extends AbstractSubMapIterator<K, V> {
        DescendingSubMapIterator(NavigableSubMap<K, V> map) {
            super(map);
            Entry entry = map.fromStart ? (map.loInclusive ? map.m.findFloorEntry(map.lo) : map.m.findLowerEntry(map.lo)) : map.m.findBiggestEntry();
            if (entry != null) {
                if (!map.isInRange(entry.key)) {
                    this.node = null;
                    return;
                }
            } else {
                this.node = null;
                return;
            }
            this.node = entry.node;
            this.offset = entry.index;
            this.boundaryPair = this.getBoundaryNode();
            if (this.boundaryPair != null && map.m.keyCompare(this.boundaryPair.key, entry.key) > 0) {
                this.node = null;
            }
            if (map.toEnd && !map.hiInclusive && map.m.keyCompare(map.hi, entry.key) == 0) {
                this.node = null;
            }
        }

        @Override
        final Entry<K, V> getStartNode() {
            if (this.subMap.toEnd) {
                return this.subMap.hiInclusive ? this.subMap.smallerOrEqualEntry(this.subMap.hi) : this.subMap.smallerEntry(this.subMap.hi);
            }
            return this.subMap.theBiggestEntry();
        }

        @Override
        final Entry<K, V> getBoundaryNode() {
            if (this.subMap.toEnd) {
                return this.subMap.hiInclusive ? this.subMap.m.findCeilingEntry(this.subMap.hi) : this.subMap.m.findHigherEntry(this.subMap.hi);
            }
            return this.subMap.m.findSmallestEntry();
        }

        Entry<K, V> getNext() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != this.subMap.m.modCount) {
                throw new ConcurrentModificationException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != this.node.left_idx) {
                --this.offset;
            } else {
                this.node = this.node.prev;
                if (this.node != null) {
                    this.offset = this.node.right_idx;
                }
            }
            this.boundaryPair = this.getBoundaryNode();
            if (this.boundaryPair != null && this.boundaryPair.node == this.lastNode && this.boundaryPair.index == this.lastOffset) {
                this.node = null;
            }
            return this.createEntry(this.lastNode, this.lastOffset);
        }

        @Override
        public final boolean hasNext() {
            return this.node != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void remove() {
            Object key;
            if (this.expectedModCount != this.subMap.m.modCount) throw new ConcurrentModificationException();
            if (this.expectedModCount != this.subMap.m.modCount) return;
            Object v0 = key = this.node != null ? this.node.keys[this.offset] : null;
            if (this.lastNode == null) throw new IllegalStateException();
            int idx = this.lastOffset;
            if (idx == this.lastNode.left_idx) {
                this.subMap.m.removeLeftmost(this.lastNode);
            } else if (idx == this.lastNode.right_idx) {
                this.subMap.m.removeRightmost(this.lastNode);
            } else {
                this.subMap.m.removeMiddleElement(this.lastNode, idx);
            }
            if (null != key) {
                Entry entry = this.subMap.m.find(key);
                this.node = entry.node;
                this.offset = entry.index;
                this.boundaryPair = this.getBoundaryNode();
            } else {
                this.node = null;
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AscendingSubMapKeyIterator<K, V>
    extends AscendingSubMapIterator<K, V>
    implements Iterator<K> {
        AscendingSubMapKeyIterator(NavigableSubMap<K, V> map) {
            super(map);
        }

        @Override
        public final K next() {
            return (K)this.getNext().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AscendingSubMapEntryIterator<K, V>
    extends AscendingSubMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        AscendingSubMapEntryIterator(NavigableSubMap<K, V> map) {
            super(map);
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.getNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AscendingSubMapIterator<K, V>
    extends AbstractSubMapIterator<K, V> {
        AscendingSubMapIterator(NavigableSubMap<K, V> map) {
            super(map);
        }

        @Override
        final Entry<K, V> getBoundaryNode() {
            Entry entry = null;
            entry = this.subMap.toEnd ? (this.subMap.hiInclusive ? this.subMap.smallerOrEqualEntry(this.subMap.hi) : this.subMap.smallerEntry(this.subMap.hi)) : this.subMap.theBiggestEntry();
            if (entry == null) {
                entry = this.subMap.findStartNode();
            }
            return entry;
        }

        @Override
        final Entry<K, V> getStartNode() {
            if (this.subMap.fromStart) {
                return this.subMap.loInclusive ? this.subMap.biggerOrEqualEntry(this.subMap.lo) : this.subMap.biggerEntry(this.subMap.lo);
            }
            return this.subMap.theSmallestEntry();
        }

        Entry<K, V> getNext() {
            if (this.expectedModCount != this.subMap.m.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != this.node.right_idx) {
                ++this.offset;
            } else {
                this.node = this.node.next;
                if (this.node != null) {
                    this.offset = this.node.left_idx;
                }
            }
            if (this.lastNode != null) {
                this.boundaryPair = this.getBoundaryNode();
                if (this.boundaryPair != null && this.boundaryPair.node == this.lastNode && this.boundaryPair.index == this.lastOffset) {
                    this.node = null;
                }
                return this.createEntry(this.lastNode, this.lastOffset);
            }
            return null;
        }

        @Override
        public final boolean hasNext() {
            return null != this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractSubMapIterator<K, V> {
        final NavigableSubMap<K, V> subMap;
        int expectedModCount;
        Node<K, V> node;
        Node<K, V> lastNode;
        Entry<K, V> boundaryPair;
        int offset;
        int lastOffset;
        boolean getToEnd = false;

        AbstractSubMapIterator(NavigableSubMap<K, V> map) {
            this.subMap = map;
            this.expectedModCount = this.subMap.m.modCount;
            Entry entry = ((NavigableSubMap)map).findStartNode();
            if (entry != null && (!map.toEnd || map.checkUpperBound(entry.key))) {
                this.node = entry.node;
                this.offset = entry.index;
                this.boundaryPair = this.getBoundaryNode();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void remove() {
            Object key;
            if (this.expectedModCount != this.subMap.m.modCount) throw new ConcurrentModificationException();
            if (this.expectedModCount != this.subMap.m.modCount) return;
            Object k = key = this.node != null ? (Object)this.node.keys[this.offset] : null;
            if (this.lastNode == null) throw new IllegalStateException();
            int idx = this.lastOffset;
            if (idx == this.lastNode.left_idx) {
                this.subMap.m.removeLeftmost(this.lastNode);
            } else if (idx == this.lastNode.right_idx) {
                this.subMap.m.removeRightmost(this.lastNode);
            } else {
                int lastRight = this.lastNode.right_idx;
                key = this.subMap.m.removeMiddleElement(this.lastNode, idx);
                if (key == null && lastRight > this.lastNode.right_idx) {
                    --this.offset;
                }
            }
            if (null != key) {
                Entry entry = this.subMap.m.find(key);
                if (this.subMap.isInRange(key)) {
                    this.node = entry.node;
                    this.offset = entry.index;
                    this.boundaryPair = this.getBoundaryNode();
                } else {
                    this.node = null;
                }
            }
            if (this.node != null && !this.subMap.isInRange(this.node.keys[this.offset])) {
                this.node = null;
            }
            this.lastNode = null;
            ++this.expectedModCount;
        }

        final void makeNext() {
            if (this.expectedModCount != this.subMap.m.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.lastNode = this.node;
            this.lastOffset = this.offset;
            if (this.offset != this.lastNode.right_idx) {
                ++this.offset;
            } else {
                this.node = this.node.next;
                if (this.node != null) {
                    this.offset = this.node.left_idx;
                }
            }
            if (this.boundaryPair.node == this.lastNode && this.boundaryPair.index == this.lastOffset) {
                this.node = null;
            }
        }

        Entry<K, V> createEntry(Node<K, V> node, int index) {
            Entry entry = new Entry(node.keys[index], node.values[index]);
            entry.node = node;
            entry.index = index;
            return entry;
        }

        abstract Entry<K, V> getStartNode();

        abstract boolean hasNext();

        abstract Entry<K, V> getBoundaryNode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K, V>
    extends MapEntry<K, V> {
        Entry<K, V> parent;
        Entry<K, V> left;
        Entry<K, V> right;
        Node<K, V> node;
        int index;
        boolean color;

        public void setLocation(Node<K, V> node, int index, V value, K key) {
            this.node = node;
            this.index = index;
            this.value = value;
            this.key = key;
        }

        Entry(K theKey) {
            super(theKey);
        }

        Entry(K theKey, V theValue) {
            super(theKey, theValue);
        }

        @Override
        public V setValue(V object) {
            Object result = this.value;
            this.value = object;
            this.node.values[this.index] = this.value;
            return (V)result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<K, V> {
        static final int NODE_SIZE = 64;
        Node<K, V> prev;
        Node<K, V> next;
        Node<K, V> parent;
        Node<K, V> left;
        Node<K, V> right;
        V[] values;
        K[] keys = new Object[64];
        int left_idx = 0;
        int right_idx = -1;
        int size = 0;
        boolean color;

        public Node() {
            this.values = new Object[64];
        }
    }
}

