/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.ConnectionInfo;
import com.databricks.sdk.service.catalog.ConnectionType;
import com.databricks.sdk.service.catalog.ConnectionsImpl;
import com.databricks.sdk.service.catalog.ConnectionsService;
import com.databricks.sdk.service.catalog.CreateConnection;
import com.databricks.sdk.service.catalog.DeleteConnectionRequest;
import com.databricks.sdk.service.catalog.GetConnectionRequest;
import com.databricks.sdk.service.catalog.OptionsKvPairs;
import com.databricks.sdk.service.catalog.UpdateConnection;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ConnectionsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionsAPI.class);
    private final ConnectionsService impl;

    public ConnectionsAPI(ApiClient apiClient) {
        this.impl = new ConnectionsImpl(apiClient);
    }

    public ConnectionsAPI(ConnectionsService mock) {
        this.impl = mock;
    }

    public ConnectionInfo create(String name, ConnectionType connectionType, OptionsKvPairs optionsKvpairs) {
        return this.create(new CreateConnection().setName(name).setConnectionType(connectionType).setOptionsKvpairs(optionsKvpairs));
    }

    public ConnectionInfo create(CreateConnection request) {
        return this.impl.create(request);
    }

    public void delete(String nameArg) {
        this.delete(new DeleteConnectionRequest().setNameArg(nameArg));
    }

    public void delete(DeleteConnectionRequest request) {
        this.impl.delete(request);
    }

    public ConnectionInfo get(String nameArg) {
        return this.get(new GetConnectionRequest().setNameArg(nameArg));
    }

    public ConnectionInfo get(GetConnectionRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ConnectionInfo> list() {
        return this.impl.list().getConnections();
    }

    public ConnectionInfo update(String name, OptionsKvPairs optionsKvpairs, String nameArg) {
        return this.update(new UpdateConnection().setName(name).setOptionsKvpairs(optionsKvpairs).setNameArg(nameArg));
    }

    public ConnectionInfo update(UpdateConnection request) {
        return this.impl.update(request);
    }

    public ConnectionsService impl() {
        return this.impl;
    }
}

