/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.ChangeClusterOwner;
import com.databricks.sdk.service.compute.ClusterEvent;
import com.databricks.sdk.service.compute.ClusterInfo;
import com.databricks.sdk.service.compute.ClustersImpl;
import com.databricks.sdk.service.compute.ClustersService;
import com.databricks.sdk.service.compute.CreateCluster;
import com.databricks.sdk.service.compute.CreateClusterResponse;
import com.databricks.sdk.service.compute.DeleteCluster;
import com.databricks.sdk.service.compute.EditCluster;
import com.databricks.sdk.service.compute.GetClusterRequest;
import com.databricks.sdk.service.compute.GetEvents;
import com.databricks.sdk.service.compute.GetEventsResponse;
import com.databricks.sdk.service.compute.GetSparkVersionsResponse;
import com.databricks.sdk.service.compute.ListAvailableZonesResponse;
import com.databricks.sdk.service.compute.ListClustersRequest;
import com.databricks.sdk.service.compute.ListNodeTypesResponse;
import com.databricks.sdk.service.compute.PermanentDeleteCluster;
import com.databricks.sdk.service.compute.PinCluster;
import com.databricks.sdk.service.compute.ResizeCluster;
import com.databricks.sdk.service.compute.RestartCluster;
import com.databricks.sdk.service.compute.StartCluster;
import com.databricks.sdk.service.compute.State;
import com.databricks.sdk.service.compute.UnpinCluster;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ClustersAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ClustersAPI.class);
    private final ClustersService impl;

    public ClustersAPI(ApiClient apiClient) {
        this.impl = new ClustersImpl(apiClient);
    }

    public ClustersAPI(ClustersService mock) {
        this.impl = mock;
    }

    public ClusterInfo waitGetClusterRunning(String clusterId) throws TimeoutException {
        return this.waitGetClusterRunning(clusterId, Duration.ofMinutes(20L), null);
    }

    public ClusterInfo waitGetClusterRunning(String clusterId, Duration timeout, Consumer<ClusterInfo> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<State> targetStates = Arrays.asList(State.RUNNING);
        List<State> failureStates = Arrays.asList(State.ERROR, State.TERMINATED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            ClusterInfo poll = this.get(new GetClusterRequest().setClusterId(clusterId));
            State status = poll.getState();
            statusMessage = poll.getStateMessage();
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach RUNNING, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("clusterId=%s", clusterId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public ClusterInfo waitGetClusterTerminated(String clusterId) throws TimeoutException {
        return this.waitGetClusterTerminated(clusterId, Duration.ofMinutes(20L), null);
    }

    public ClusterInfo waitGetClusterTerminated(String clusterId, Duration timeout, Consumer<ClusterInfo> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<State> targetStates = Arrays.asList(State.TERMINATED);
        List<State> failureStates = Arrays.asList(State.ERROR);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            ClusterInfo poll = this.get(new GetClusterRequest().setClusterId(clusterId));
            State status = poll.getState();
            statusMessage = poll.getStateMessage();
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach TERMINATED, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("clusterId=%s", clusterId);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public void changeOwner(String clusterId, String ownerUsername) {
        this.changeOwner(new ChangeClusterOwner().setClusterId(clusterId).setOwnerUsername(ownerUsername));
    }

    public void changeOwner(ChangeClusterOwner request) {
        this.impl.changeOwner(request);
    }

    public Wait<ClusterInfo, CreateClusterResponse> create(String sparkVersion) {
        return this.create(new CreateCluster().setSparkVersion(sparkVersion));
    }

    public Wait<ClusterInfo, CreateClusterResponse> create(CreateCluster request) {
        CreateClusterResponse response = this.impl.create(request);
        return new Wait<ClusterInfo, CreateClusterResponse>((timeout, callback) -> this.waitGetClusterRunning(response.getClusterId(), timeout, callback), response);
    }

    public Wait<ClusterInfo, Void> delete(String clusterId) {
        return this.delete(new DeleteCluster().setClusterId(clusterId));
    }

    public Wait<ClusterInfo, Void> delete(DeleteCluster request) {
        this.impl.delete(request);
        return new Wait<ClusterInfo, Void>((timeout, callback) -> this.waitGetClusterTerminated(request.getClusterId(), timeout, callback));
    }

    public Wait<ClusterInfo, Void> edit(String clusterId, String sparkVersion) {
        return this.edit(new EditCluster().setClusterId(clusterId).setSparkVersion(sparkVersion));
    }

    public Wait<ClusterInfo, Void> edit(EditCluster request) {
        this.impl.edit(request);
        return new Wait<ClusterInfo, Void>((timeout, callback) -> this.waitGetClusterRunning(request.getClusterId(), timeout, callback));
    }

    public Iterable<ClusterEvent> events(String clusterId) {
        return this.events(new GetEvents().setClusterId(clusterId));
    }

    public Iterable<ClusterEvent> events(GetEvents request) {
        return new Paginator(request, this.impl::events, GetEventsResponse::getEvents, response -> response.getNextPage());
    }

    public ClusterInfo get(String clusterId) {
        return this.get(new GetClusterRequest().setClusterId(clusterId));
    }

    public ClusterInfo get(GetClusterRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ClusterInfo> list(ListClustersRequest request) {
        return this.impl.list(request).getClusters();
    }

    public ListNodeTypesResponse listNodeTypes() {
        return this.impl.listNodeTypes();
    }

    public ListAvailableZonesResponse listZones() {
        return this.impl.listZones();
    }

    public void permanentDelete(String clusterId) {
        this.permanentDelete(new PermanentDeleteCluster().setClusterId(clusterId));
    }

    public void permanentDelete(PermanentDeleteCluster request) {
        this.impl.permanentDelete(request);
    }

    public void pin(String clusterId) {
        this.pin(new PinCluster().setClusterId(clusterId));
    }

    public void pin(PinCluster request) {
        this.impl.pin(request);
    }

    public Wait<ClusterInfo, Void> resize(String clusterId) {
        return this.resize(new ResizeCluster().setClusterId(clusterId));
    }

    public Wait<ClusterInfo, Void> resize(ResizeCluster request) {
        this.impl.resize(request);
        return new Wait<ClusterInfo, Void>((timeout, callback) -> this.waitGetClusterRunning(request.getClusterId(), timeout, callback));
    }

    public Wait<ClusterInfo, Void> restart(String clusterId) {
        return this.restart(new RestartCluster().setClusterId(clusterId));
    }

    public Wait<ClusterInfo, Void> restart(RestartCluster request) {
        this.impl.restart(request);
        return new Wait<ClusterInfo, Void>((timeout, callback) -> this.waitGetClusterRunning(request.getClusterId(), timeout, callback));
    }

    public GetSparkVersionsResponse sparkVersions() {
        return this.impl.sparkVersions();
    }

    public Wait<ClusterInfo, Void> start(String clusterId) {
        return this.start(new StartCluster().setClusterId(clusterId));
    }

    public Wait<ClusterInfo, Void> start(StartCluster request) {
        this.impl.start(request);
        return new Wait<ClusterInfo, Void>((timeout, callback) -> this.waitGetClusterRunning(request.getClusterId(), timeout, callback));
    }

    public void unpin(String clusterId) {
        this.unpin(new UnpinCluster().setClusterId(clusterId));
    }

    public void unpin(UnpinCluster request) {
        this.impl.unpin(request);
    }

    public ClustersService impl() {
        return this.impl;
    }
}

