/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CreateRegisteredModelRequest;
import com.databricks.sdk.service.catalog.DeleteAliasRequest;
import com.databricks.sdk.service.catalog.DeleteRegisteredModelRequest;
import com.databricks.sdk.service.catalog.GetRegisteredModelRequest;
import com.databricks.sdk.service.catalog.ListRegisteredModelsRequest;
import com.databricks.sdk.service.catalog.ListRegisteredModelsResponse;
import com.databricks.sdk.service.catalog.RegisteredModelAlias;
import com.databricks.sdk.service.catalog.RegisteredModelInfo;
import com.databricks.sdk.service.catalog.RegisteredModelsService;
import com.databricks.sdk.service.catalog.SetRegisteredModelAliasRequest;
import com.databricks.sdk.service.catalog.UpdateRegisteredModelRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class RegisteredModelsImpl
implements RegisteredModelsService {
    private final ApiClient apiClient;

    public RegisteredModelsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RegisteredModelInfo create(CreateRegisteredModelRequest request) {
        String path = "/api/2.1/unity-catalog/models";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, RegisteredModelInfo.class, headers);
    }

    @Override
    public void delete(DeleteRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public void deleteAlias(DeleteAliasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/aliases/%s", request.getFullName(), request.getAlias());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public RegisteredModelInfo get(GetRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, RegisteredModelInfo.class, headers);
    }

    @Override
    public ListRegisteredModelsResponse list(ListRegisteredModelsRequest request) {
        String path = "/api/2.1/unity-catalog/models";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListRegisteredModelsResponse.class, headers);
    }

    @Override
    public RegisteredModelAlias setAlias(SetRegisteredModelAliasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/aliases/%s", request.getFullName(), request.getAlias());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, RegisteredModelAlias.class, headers);
    }

    @Override
    public RegisteredModelInfo update(UpdateRegisteredModelRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, RegisteredModelInfo.class, headers);
    }
}

