/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.files;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.files.DeleteFileRequest;
import com.databricks.sdk.service.files.DownloadRequest;
import com.databricks.sdk.service.files.DownloadResponse;
import com.databricks.sdk.service.files.FileInfo;
import com.databricks.sdk.service.files.FilesService;
import com.databricks.sdk.service.files.GetStatusRequest;
import com.databricks.sdk.service.files.UploadRequest;
import com.databricks.sdk.support.Generated;
import java.io.InputStream;
import java.util.HashMap;

@Generated
class FilesImpl
implements FilesService {
    private final ApiClient apiClient;

    public FilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/fs/files/%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public DownloadResponse download(DownloadRequest request) {
        String path = String.format("/api/2.0/fs/files/%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/octet-stream");
        InputStream response = this.apiClient.GET(path, request, InputStream.class, headers);
        return new DownloadResponse().setContents(response);
    }

    @Override
    public FileInfo getStatus(GetStatusRequest request) {
        String path = "/api/2.0/fs/get-status";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, FileInfo.class, headers);
    }

    @Override
    public void upload(UploadRequest request) {
        String path = String.format("/api/2.0/fs/files/%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        this.apiClient.PUT(path, request.getContents(), Void.class, headers);
    }
}

