/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateIpAccessList;
import com.databricks.sdk.service.settings.CreateIpAccessListResponse;
import com.databricks.sdk.service.settings.DeleteIpAccessListRequest;
import com.databricks.sdk.service.settings.FetchIpAccessListResponse;
import com.databricks.sdk.service.settings.GetIpAccessListRequest;
import com.databricks.sdk.service.settings.IpAccessListInfo;
import com.databricks.sdk.service.settings.IpAccessListsImpl;
import com.databricks.sdk.service.settings.IpAccessListsService;
import com.databricks.sdk.service.settings.ListType;
import com.databricks.sdk.service.settings.ReplaceIpAccessList;
import com.databricks.sdk.service.settings.UpdateIpAccessList;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class IpAccessListsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(IpAccessListsAPI.class);
    private final IpAccessListsService impl;

    public IpAccessListsAPI(ApiClient apiClient) {
        this.impl = new IpAccessListsImpl(apiClient);
    }

    public IpAccessListsAPI(IpAccessListsService mock) {
        this.impl = mock;
    }

    public CreateIpAccessListResponse create(String label, ListType listType, Collection<String> ipAddresses) {
        return this.create(new CreateIpAccessList().setLabel(label).setListType(listType).setIpAddresses(ipAddresses));
    }

    public CreateIpAccessListResponse create(CreateIpAccessList request) {
        return this.impl.create(request);
    }

    public void delete(String ipAccessListId) {
        this.delete(new DeleteIpAccessListRequest().setIpAccessListId(ipAccessListId));
    }

    public void delete(DeleteIpAccessListRequest request) {
        this.impl.delete(request);
    }

    public FetchIpAccessListResponse get(String ipAccessListId) {
        return this.get(new GetIpAccessListRequest().setIpAccessListId(ipAccessListId));
    }

    public FetchIpAccessListResponse get(GetIpAccessListRequest request) {
        return this.impl.get(request);
    }

    public Iterable<IpAccessListInfo> list() {
        return this.impl.list().getIpAccessLists();
    }

    public void replace(String ipAccessListId, String label, ListType listType, Collection<String> ipAddresses, boolean enabled) {
        this.replace(new ReplaceIpAccessList().setIpAccessListId(ipAccessListId).setLabel(label).setListType(listType).setIpAddresses(ipAddresses).setEnabled(enabled));
    }

    public void replace(ReplaceIpAccessList request) {
        this.impl.replace(request);
    }

    public void update(String ipAccessListId, String label, ListType listType, Collection<String> ipAddresses, boolean enabled) {
        this.update(new UpdateIpAccessList().setIpAccessListId(ipAccessListId).setLabel(label).setListType(listType).setIpAddresses(ipAddresses).setEnabled(enabled));
    }

    public void update(UpdateIpAccessList request) {
        this.impl.update(request);
    }

    public IpAccessListsService impl() {
        return this.impl;
    }
}

