/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.vectorsearch;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.vectorsearch.CreateVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.CreateVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.DeleteDataVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.DeleteDataVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.DeleteIndexRequest;
import com.databricks.sdk.service.vectorsearch.GetIndexRequest;
import com.databricks.sdk.service.vectorsearch.ListIndexesRequest;
import com.databricks.sdk.service.vectorsearch.ListVectorIndexesResponse;
import com.databricks.sdk.service.vectorsearch.QueryVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.QueryVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.SyncIndexRequest;
import com.databricks.sdk.service.vectorsearch.UpsertDataVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.UpsertDataVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.VectorIndex;
import com.databricks.sdk.service.vectorsearch.VectorSearchIndexesService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class VectorSearchIndexesImpl
implements VectorSearchIndexesService {
    private final ApiClient apiClient;

    public VectorSearchIndexesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateVectorIndexResponse createIndex(CreateVectorIndexRequest request) {
        String path = "/api/2.0/vector-search/indexes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateVectorIndexResponse.class, headers);
    }

    @Override
    public DeleteDataVectorIndexResponse deleteDataVectorIndex(DeleteDataVectorIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s/delete-data", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, DeleteDataVectorIndexResponse.class, headers);
    }

    @Override
    public void deleteIndex(DeleteIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s", request.getIndexName());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public VectorIndex getIndex(GetIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s", request.getIndexName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, VectorIndex.class, headers);
    }

    @Override
    public ListVectorIndexesResponse listIndexes(ListIndexesRequest request) {
        String path = "/api/2.0/vector-search/indexes";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListVectorIndexesResponse.class, headers);
    }

    @Override
    public QueryVectorIndexResponse queryIndex(QueryVectorIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s/query", request.getIndexName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, QueryVectorIndexResponse.class, headers);
    }

    @Override
    public void syncIndex(SyncIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s/sync", request.getIndexName());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.POST(path, request, Void.class, headers);
    }

    @Override
    public UpsertDataVectorIndexResponse upsertDataVectorIndex(UpsertDataVectorIndexRequest request) {
        String path = String.format("/api/2.0/vector-search/indexes/%s/upsert-data", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, UpsertDataVectorIndexResponse.class, headers);
    }
}

