/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.http;

import com.databricks.sdk.core.DatabricksException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;

public class Request {
    public static final String GET = "GET";
    public static final String DELETE = "DELETE";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    private final String method;
    private String url;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, List<String>> query = new TreeMap<String, List<String>>();
    private Optional<Boolean> redirectionBehavior = Optional.empty();
    private final InputStream bodyStream;
    private final String bodyString;
    private final boolean isBodyStreaming;
    private final boolean isBodyString;

    public Request(String method, String url) {
        this(method, url, null, null);
    }

    public Request(String method, String url, String bodyString) {
        this(method, url, null, bodyString);
    }

    public Request(String method, String url, InputStream bodyStream) {
        this(method, url, bodyStream, null);
    }

    private Request(String method, String url, InputStream bodyStream, String bodyString) {
        if (bodyStream != null && bodyString != null) {
            throw new IllegalArgumentException("At most one of bodyStream and bodyString can be non-null");
        }
        this.method = method;
        this.url = url;
        this.bodyStream = bodyStream;
        this.bodyString = bodyString;
        this.isBodyStreaming = bodyStream != null;
        this.isBodyString = bodyString != null;
    }

    public Request withHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public Request withHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Request withQueryParam(String key, String value) {
        List values = this.query.computeIfAbsent(key, k -> new ArrayList());
        values.add(value);
        return this;
    }

    public Request withUrl(String url) {
        this.url = url;
        return this;
    }

    protected static String mapToQuery(Map<String, List<String>> in) {
        StringJoiner joiner = new StringJoiner("&");
        for (Map.Entry<String, List<String>> entry : in.entrySet()) {
            try {
                String encodedKey = URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name());
                for (String value : entry.getValue()) {
                    String encodedValue = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
                    joiner.add(encodedKey + "=" + encodedValue);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new DatabricksException("Unable to encode query parameter: " + e.getMessage(), e);
            }
        }
        return joiner.toString();
    }

    public URI getUri() {
        URI uri = URI.create(this.url);
        if (!this.query.isEmpty()) {
            String rawQuery = uri.getRawQuery();
            rawQuery = rawQuery == null ? "" : rawQuery + "&";
            rawQuery = rawQuery + Request.mapToQuery(this.query);
            StringBuilder updatedUriString = new StringBuilder();
            if (uri.getScheme() != null) {
                updatedUriString.append(uri.getScheme()).append("://");
            }
            if (uri.getAuthority() != null) {
                updatedUriString.append(uri.getAuthority());
            }
            updatedUriString.append(uri.getPath());
            if (!rawQuery.isEmpty()) {
                updatedUriString.append("?").append(rawQuery);
            }
            if (uri.getFragment() != null) {
                updatedUriString.append("#").append(uri.getFragment());
            }
            return URI.create(updatedUriString.toString());
        }
        return uri;
    }

    public String getRequestLine() {
        URI uri = this.getUri();
        String path = uri.getPath();
        if (!this.query.isEmpty()) {
            path = path + "?" + uri.getQuery();
        }
        return String.format("%s %s", this.method, path);
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> getQuery() {
        return this.query;
    }

    public InputStream getBodyStream() {
        return this.bodyStream;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public boolean isBodyStreaming() {
        return this.isBodyStreaming;
    }

    public boolean isBodyString() {
        return this.isBodyString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return this.method.equals(request.method) && this.url.equals(request.url) && Objects.equals(this.query, request.query) && Objects.equals(this.bodyStream, request.bodyStream) && Objects.equals(this.redirectionBehavior, request.redirectionBehavior);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.url, this.query, this.bodyString);
    }

    public String toString() {
        return this.getRequestLine();
    }

    public Optional<Boolean> getRedirectionBehavior() {
        return this.redirectionBehavior;
    }

    public void setRedirectionBehavior(boolean redirectionBehavior) {
        this.redirectionBehavior = Optional.of(redirectionBehavior);
    }
}

