/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.files;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.files.CreateDirectoryRequest;
import com.databricks.sdk.service.files.DeleteDirectoryRequest;
import com.databricks.sdk.service.files.DeleteFileRequest;
import com.databricks.sdk.service.files.DownloadRequest;
import com.databricks.sdk.service.files.DownloadResponse;
import com.databricks.sdk.service.files.FilesService;
import com.databricks.sdk.service.files.ListDirectoryContentsRequest;
import com.databricks.sdk.service.files.ListDirectoryResponse;
import com.databricks.sdk.service.files.UploadRequest;
import com.databricks.sdk.support.Generated;
import java.io.InputStream;
import java.util.HashMap;

@Generated
class FilesImpl
implements FilesService {
    private final ApiClient apiClient;

    public FilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void createDirectory(CreateDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.PUT(path, null, Void.class, headers);
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public void deleteDirectory(DeleteDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public DownloadResponse download(DownloadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/octet-stream");
        InputStream response = this.apiClient.GET(path, request, InputStream.class, headers);
        return new DownloadResponse().setContents(response);
    }

    @Override
    public ListDirectoryResponse listDirectoryContents(ListDirectoryContentsRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListDirectoryResponse.class, headers);
    }

    @Override
    public void upload(UploadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        this.apiClient.PUT(path, request.getContents(), Void.class, headers);
    }
}

