/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.provisioning.CreateCustomerManagedKeyRequest;
import com.databricks.sdk.service.provisioning.CustomerManagedKey;
import com.databricks.sdk.service.provisioning.DeleteEncryptionKeyRequest;
import com.databricks.sdk.service.provisioning.EncryptionKeysService;
import com.databricks.sdk.service.provisioning.GetEncryptionKeyRequest;
import com.databricks.sdk.support.Generated;
import java.util.Collection;

@Generated
class EncryptionKeysImpl
implements EncryptionKeysService {
    private final ApiClient apiClient;

    public EncryptionKeysImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CustomerManagedKey create(CreateCustomerManagedKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, CustomerManagedKey.class);
    }

    @Override
    public void delete(DeleteEncryptionKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys/%s", this.apiClient.configuredAccountID(), request.getCustomerManagedKeyId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public CustomerManagedKey get(GetEncryptionKeyRequest request) {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys/%s", this.apiClient.configuredAccountID(), request.getCustomerManagedKeyId());
        return this.apiClient.GET(path, request, CustomerManagedKey.class);
    }

    @Override
    public Collection<CustomerManagedKey> list() {
        String path = String.format("/api/2.0/accounts/%s/customer-managed-keys", this.apiClient.configuredAccountID());
        return this.apiClient.getCollection(path, null, CustomerManagedKey.class);
    }
}

