// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.jobs;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

@Generated
public class NotebookTask {
  /**
   * Base parameters to be used for each run of this job. If the run is initiated by a call to
   * :method:jobs/runNow with parameters specified, the two parameters maps are merged. If the same
   * key is specified in `base_parameters` and in `run-now`, the value from `run-now` is used.
   *
   * <p>Use [task parameter variables] such as `{{job.id}}` to pass context about job runs.
   *
   * <p>If the notebook takes a parameter that is not specified in the job’s `base_parameters` or
   * the `run-now` override parameters, the default value from the notebook is used.
   *
   * <p>Retrieve these parameters in a notebook using [dbutils.widgets.get].
   *
   * <p>The JSON representation of this field cannot exceed 1MB.
   *
   * <p>[dbutils.widgets.get]:
   * https://docs.databricks.com/dev-tools/databricks-utils.html#dbutils-widgets [task parameter
   * variables]: https://docs.databricks.com/workflows/jobs/parameter-value-references.html
   */
  @JsonProperty("base_parameters")
  private Map<String, String> baseParameters;

  /**
   * The path of the notebook to be run in the Databricks workspace or remote repository. For
   * notebooks stored in the Databricks workspace, the path must be absolute and begin with a slash.
   * For notebooks stored in a remote repository, the path must be relative. This field is required.
   */
  @JsonProperty("notebook_path")
  private String notebookPath;

  /**
   * Optional location type of the notebook. When set to `WORKSPACE`, the notebook will be retrieved
   * from the local <Databricks> workspace. When set to `GIT`, the notebook will be retrieved from a
   * Git repository defined in `git_source`. If the value is empty, the task will use `GIT` if
   * `git_source` is defined and `WORKSPACE` otherwise.
   *
   * <p>* `WORKSPACE`: Notebook is located in <Databricks> workspace. * `GIT`: Notebook is located
   * in cloud Git provider.
   */
  @JsonProperty("source")
  private Source source;

  public NotebookTask setBaseParameters(Map<String, String> baseParameters) {
    this.baseParameters = baseParameters;
    return this;
  }

  public Map<String, String> getBaseParameters() {
    return baseParameters;
  }

  public NotebookTask setNotebookPath(String notebookPath) {
    this.notebookPath = notebookPath;
    return this;
  }

  public String getNotebookPath() {
    return notebookPath;
  }

  public NotebookTask setSource(Source source) {
    this.source = source;
    return this;
  }

  public Source getSource() {
    return source;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NotebookTask that = (NotebookTask) o;
    return Objects.equals(baseParameters, that.baseParameters)
        && Objects.equals(notebookPath, that.notebookPath)
        && Objects.equals(source, that.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(baseParameters, notebookPath, source);
  }

  @Override
  public String toString() {
    return new ToStringer(NotebookTask.class)
        .add("baseParameters", baseParameters)
        .add("notebookPath", notebookPath)
        .add("source", source)
        .toString();
  }
}
