/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.files;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.files.CreateDirectoryRequest;
import com.databricks.sdk.service.files.CreateDirectoryResponse;
import com.databricks.sdk.service.files.DeleteDirectoryRequest;
import com.databricks.sdk.service.files.DeleteDirectoryResponse;
import com.databricks.sdk.service.files.DeleteFileRequest;
import com.databricks.sdk.service.files.DeleteResponse;
import com.databricks.sdk.service.files.DownloadRequest;
import com.databricks.sdk.service.files.DownloadResponse;
import com.databricks.sdk.service.files.FilesService;
import com.databricks.sdk.service.files.GetDirectoryMetadataRequest;
import com.databricks.sdk.service.files.GetDirectoryMetadataResponse;
import com.databricks.sdk.service.files.GetMetadataRequest;
import com.databricks.sdk.service.files.GetMetadataResponse;
import com.databricks.sdk.service.files.ListDirectoryContentsRequest;
import com.databricks.sdk.service.files.ListDirectoryResponse;
import com.databricks.sdk.service.files.UploadRequest;
import com.databricks.sdk.service.files.UploadResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class FilesImpl
implements FilesService {
    private final ApiClient apiClient;

    public FilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void createDirectory(CreateDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.PUT(path, null, CreateDirectoryResponse.class, headers);
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public void deleteDirectory(DeleteDirectoryRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, DeleteDirectoryResponse.class, headers);
    }

    @Override
    public DownloadResponse download(DownloadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/octet-stream");
        return this.apiClient.GET(path, request, DownloadResponse.class, headers);
    }

    @Override
    public void getDirectoryMetadata(GetDirectoryMetadataRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.HEAD(path, request, GetDirectoryMetadataResponse.class, headers);
    }

    @Override
    public GetMetadataResponse getMetadata(GetMetadataRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        return this.apiClient.HEAD(path, request, GetMetadataResponse.class, headers);
    }

    @Override
    public ListDirectoryResponse listDirectoryContents(ListDirectoryContentsRequest request) {
        String path = String.format("/api/2.0/fs/directories%s", request.getDirectoryPath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListDirectoryResponse.class, headers);
    }

    @Override
    public void upload(UploadRequest request) {
        String path = String.format("/api/2.0/fs/files%s", request.getFilePath());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/octet-stream");
        this.apiClient.PUT(path, request.getContents(), UploadResponse.class, headers);
    }
}

