// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.catalog;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;

/** Specification of an online table. */
@Generated
public class OnlineTableSpec {
  /**
   * Whether to create a full-copy pipeline -- a pipeline that stops after creates a full copy of
   * the source table upon initialization and does not process any change data feeds (CDFs)
   * afterwards. The pipeline can still be manually triggered afterwards, but it always perform a
   * full copy of the source table and there are no incremental updates. This mode is useful for
   * syncing views or tables without CDFs to online tables. Note that the full-copy pipeline only
   * supports "triggered" scheduling policy.
   */
  @JsonProperty("perform_full_copy")
  private Boolean performFullCopy;

  /** ID of the associated pipeline. Generated by the server - cannot be set by the caller. */
  @JsonProperty("pipeline_id")
  private String pipelineId;

  /** Primary Key columns to be used for data insert/update in the destination. */
  @JsonProperty("primary_key_columns")
  private Collection<String> primaryKeyColumns;

  /** Pipeline runs continuously after generating the initial data. */
  @JsonProperty("run_continuously")
  private OnlineTableSpecContinuousSchedulingPolicy runContinuously;

  /**
   * Pipeline stops after generating the initial data and can be triggered later (manually, through
   * a cron job or through data triggers)
   */
  @JsonProperty("run_triggered")
  private OnlineTableSpecTriggeredSchedulingPolicy runTriggered;

  /** Three-part (catalog, schema, table) name of the source Delta table. */
  @JsonProperty("source_table_full_name")
  private String sourceTableFullName;

  /** Time series key to deduplicate (tie-break) rows with the same primary key. */
  @JsonProperty("timeseries_key")
  private String timeseriesKey;

  public OnlineTableSpec setPerformFullCopy(Boolean performFullCopy) {
    this.performFullCopy = performFullCopy;
    return this;
  }

  public Boolean getPerformFullCopy() {
    return performFullCopy;
  }

  public OnlineTableSpec setPipelineId(String pipelineId) {
    this.pipelineId = pipelineId;
    return this;
  }

  public String getPipelineId() {
    return pipelineId;
  }

  public OnlineTableSpec setPrimaryKeyColumns(Collection<String> primaryKeyColumns) {
    this.primaryKeyColumns = primaryKeyColumns;
    return this;
  }

  public Collection<String> getPrimaryKeyColumns() {
    return primaryKeyColumns;
  }

  public OnlineTableSpec setRunContinuously(
      OnlineTableSpecContinuousSchedulingPolicy runContinuously) {
    this.runContinuously = runContinuously;
    return this;
  }

  public OnlineTableSpecContinuousSchedulingPolicy getRunContinuously() {
    return runContinuously;
  }

  public OnlineTableSpec setRunTriggered(OnlineTableSpecTriggeredSchedulingPolicy runTriggered) {
    this.runTriggered = runTriggered;
    return this;
  }

  public OnlineTableSpecTriggeredSchedulingPolicy getRunTriggered() {
    return runTriggered;
  }

  public OnlineTableSpec setSourceTableFullName(String sourceTableFullName) {
    this.sourceTableFullName = sourceTableFullName;
    return this;
  }

  public String getSourceTableFullName() {
    return sourceTableFullName;
  }

  public OnlineTableSpec setTimeseriesKey(String timeseriesKey) {
    this.timeseriesKey = timeseriesKey;
    return this;
  }

  public String getTimeseriesKey() {
    return timeseriesKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OnlineTableSpec that = (OnlineTableSpec) o;
    return Objects.equals(performFullCopy, that.performFullCopy)
        && Objects.equals(pipelineId, that.pipelineId)
        && Objects.equals(primaryKeyColumns, that.primaryKeyColumns)
        && Objects.equals(runContinuously, that.runContinuously)
        && Objects.equals(runTriggered, that.runTriggered)
        && Objects.equals(sourceTableFullName, that.sourceTableFullName)
        && Objects.equals(timeseriesKey, that.timeseriesKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        performFullCopy,
        pipelineId,
        primaryKeyColumns,
        runContinuously,
        runTriggered,
        sourceTableFullName,
        timeseriesKey);
  }

  @Override
  public String toString() {
    return new ToStringer(OnlineTableSpec.class)
        .add("performFullCopy", performFullCopy)
        .add("pipelineId", pipelineId)
        .add("primaryKeyColumns", primaryKeyColumns)
        .add("runContinuously", runContinuously)
        .add("runTriggered", runTriggered)
        .add("sourceTableFullName", sourceTableFullName)
        .add("timeseriesKey", timeseriesKey)
        .toString();
  }
}
