/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.CreateInstancePool;
import com.databricks.sdk.service.compute.CreateInstancePoolResponse;
import com.databricks.sdk.service.compute.DeleteInstancePool;
import com.databricks.sdk.service.compute.DeleteInstancePoolResponse;
import com.databricks.sdk.service.compute.EditInstancePool;
import com.databricks.sdk.service.compute.EditInstancePoolResponse;
import com.databricks.sdk.service.compute.GetInstancePool;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetInstancePoolPermissionsRequest;
import com.databricks.sdk.service.compute.GetInstancePoolRequest;
import com.databricks.sdk.service.compute.InstancePoolPermissions;
import com.databricks.sdk.service.compute.InstancePoolPermissionsRequest;
import com.databricks.sdk.service.compute.InstancePoolsService;
import com.databricks.sdk.service.compute.ListInstancePools;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class InstancePoolsImpl
implements InstancePoolsService {
    private final ApiClient apiClient;

    public InstancePoolsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateInstancePoolResponse create(CreateInstancePool request) {
        String path = "/api/2.0/instance-pools/create";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateInstancePoolResponse.class, headers);
    }

    @Override
    public void delete(DeleteInstancePool request) {
        String path = "/api/2.0/instance-pools/delete";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, DeleteInstancePoolResponse.class, headers);
    }

    @Override
    public void edit(EditInstancePool request) {
        String path = "/api/2.0/instance-pools/edit";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, EditInstancePoolResponse.class, headers);
    }

    @Override
    public GetInstancePool get(GetInstancePoolRequest request) {
        String path = "/api/2.0/instance-pools/get";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetInstancePool.class, headers);
    }

    @Override
    public GetInstancePoolPermissionLevelsResponse getPermissionLevels(GetInstancePoolPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s/permissionLevels", request.getInstancePoolId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetInstancePoolPermissionLevelsResponse.class, headers);
    }

    @Override
    public InstancePoolPermissions getPermissions(GetInstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, InstancePoolPermissions.class, headers);
    }

    @Override
    public ListInstancePools list() {
        String path = "/api/2.0/instance-pools/list";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, ListInstancePools.class, headers);
    }

    @Override
    public InstancePoolPermissions setPermissions(InstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, InstancePoolPermissions.class, headers);
    }

    @Override
    public InstancePoolPermissions updatePermissions(InstancePoolPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/instance-pools/%s", request.getInstancePoolId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, InstancePoolPermissions.class, headers);
    }
}

