/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.AccountStorageCredentialsService;
import com.databricks.sdk.service.catalog.AccountsCreateStorageCredential;
import com.databricks.sdk.service.catalog.AccountsStorageCredentialInfo;
import com.databricks.sdk.service.catalog.AccountsUpdateStorageCredential;
import com.databricks.sdk.service.catalog.DeleteAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.GetAccountStorageCredentialRequest;
import com.databricks.sdk.service.catalog.ListAccountStorageCredentialsRequest;
import com.databricks.sdk.service.catalog.StorageCredentialInfo;
import com.databricks.sdk.support.Generated;
import java.util.Collection;
import java.util.HashMap;

@Generated
class AccountStorageCredentialsImpl
implements AccountStorageCredentialsService {
    private final ApiClient apiClient;

    public AccountStorageCredentialsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public AccountsStorageCredentialInfo create(AccountsCreateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, AccountsStorageCredentialInfo.class, headers);
    }

    @Override
    public void delete(DeleteAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public AccountsStorageCredentialInfo get(GetAccountStorageCredentialRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, AccountsStorageCredentialInfo.class, headers);
    }

    @Override
    public Collection<StorageCredentialInfo> list(ListAccountStorageCredentialsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials", this.apiClient.configuredAccountID(), request.getMetastoreId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.getCollection(path, null, StorageCredentialInfo.class, headers);
    }

    @Override
    public AccountsStorageCredentialInfo update(AccountsUpdateStorageCredential request) {
        String path = String.format("/api/2.0/accounts/%s/metastores/%s/storage-credentials/%s", this.apiClient.configuredAccountID(), request.getMetastoreId(), request.getStorageCredentialName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, AccountsStorageCredentialInfo.class, headers);
    }
}

