/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.service.serving.BuildLogsRequest;
import com.databricks.sdk.service.serving.BuildLogsResponse;
import com.databricks.sdk.service.serving.CreateServingEndpoint;
import com.databricks.sdk.service.serving.DeleteServingEndpointRequest;
import com.databricks.sdk.service.serving.EndpointCoreConfigInput;
import com.databricks.sdk.service.serving.EndpointStateConfigUpdate;
import com.databricks.sdk.service.serving.EndpointTag;
import com.databricks.sdk.service.serving.ExportMetricsRequest;
import com.databricks.sdk.service.serving.GetOpenApiRequest;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionLevelsResponse;
import com.databricks.sdk.service.serving.GetServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.GetServingEndpointRequest;
import com.databricks.sdk.service.serving.ListEndpointsResponse;
import com.databricks.sdk.service.serving.LogsRequest;
import com.databricks.sdk.service.serving.PatchServingEndpointTags;
import com.databricks.sdk.service.serving.PutRequest;
import com.databricks.sdk.service.serving.PutResponse;
import com.databricks.sdk.service.serving.QueryEndpointInput;
import com.databricks.sdk.service.serving.QueryEndpointResponse;
import com.databricks.sdk.service.serving.ServerLogsResponse;
import com.databricks.sdk.service.serving.ServingEndpoint;
import com.databricks.sdk.service.serving.ServingEndpointDetailed;
import com.databricks.sdk.service.serving.ServingEndpointPermissions;
import com.databricks.sdk.service.serving.ServingEndpointPermissionsRequest;
import com.databricks.sdk.service.serving.ServingEndpointsImpl;
import com.databricks.sdk.service.serving.ServingEndpointsService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import com.databricks.sdk.support.Wait;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ServingEndpointsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ServingEndpointsAPI.class);
    private final ServingEndpointsService impl;

    public ServingEndpointsAPI(ApiClient apiClient) {
        this.impl = new ServingEndpointsImpl(apiClient);
    }

    public ServingEndpointsAPI(ServingEndpointsService mock) {
        this.impl = mock;
    }

    public ServingEndpointDetailed waitGetServingEndpointNotUpdating(String name) throws TimeoutException {
        return this.waitGetServingEndpointNotUpdating(name, Duration.ofMinutes(20L), null);
    }

    public ServingEndpointDetailed waitGetServingEndpointNotUpdating(String name, Duration timeout, Consumer<ServingEndpointDetailed> callback) throws TimeoutException {
        long deadline = System.currentTimeMillis() + timeout.toMillis();
        List<EndpointStateConfigUpdate> targetStates = Arrays.asList(EndpointStateConfigUpdate.NOT_UPDATING);
        List<EndpointStateConfigUpdate> failureStates = Arrays.asList(EndpointStateConfigUpdate.UPDATE_FAILED);
        String statusMessage = "polling...";
        int attempt = 1;
        while (System.currentTimeMillis() < deadline) {
            ServingEndpointDetailed poll = this.get(new GetServingEndpointRequest().setName(name));
            EndpointStateConfigUpdate status = poll.getState().getConfigUpdate();
            statusMessage = String.format("current status: %s", new Object[]{status});
            if (targetStates.contains((Object)status)) {
                return poll;
            }
            if (callback != null) {
                callback.accept(poll);
            }
            if (failureStates.contains((Object)status)) {
                String msg = String.format("failed to reach NOT_UPDATING, got %s: %s", new Object[]{status, statusMessage});
                throw new IllegalStateException(msg);
            }
            String prefix = String.format("name=%s", name);
            int sleep = attempt;
            if (sleep > 10) {
                sleep = 10;
            }
            LOG.info("{}: ({}) {} (sleeping ~{}s)", new Object[]{prefix, status, statusMessage, sleep});
            try {
                Thread.sleep((long)((double)((long)sleep * 1000L) + Math.random() * 1000.0));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DatabricksException("Current thread was interrupted", e);
            }
            ++attempt;
        }
        throw new TimeoutException(String.format("timed out after %s: %s", timeout, statusMessage));
    }

    public BuildLogsResponse buildLogs(String name, String servedModelName) {
        return this.buildLogs(new BuildLogsRequest().setName(name).setServedModelName(servedModelName));
    }

    public BuildLogsResponse buildLogs(BuildLogsRequest request) {
        return this.impl.buildLogs(request);
    }

    public Wait<ServingEndpointDetailed, ServingEndpointDetailed> create(String name, EndpointCoreConfigInput config) {
        return this.create(new CreateServingEndpoint().setName(name).setConfig(config));
    }

    public Wait<ServingEndpointDetailed, ServingEndpointDetailed> create(CreateServingEndpoint request) {
        ServingEndpointDetailed response = this.impl.create(request);
        return new Wait<ServingEndpointDetailed, ServingEndpointDetailed>((timeout, callback) -> this.waitGetServingEndpointNotUpdating(response.getName(), timeout, callback), response);
    }

    public void delete(String name) {
        this.delete(new DeleteServingEndpointRequest().setName(name));
    }

    public void delete(DeleteServingEndpointRequest request) {
        this.impl.delete(request);
    }

    public void exportMetrics(String name) {
        this.exportMetrics(new ExportMetricsRequest().setName(name));
    }

    public void exportMetrics(ExportMetricsRequest request) {
        this.impl.exportMetrics(request);
    }

    public ServingEndpointDetailed get(String name) {
        return this.get(new GetServingEndpointRequest().setName(name));
    }

    public ServingEndpointDetailed get(GetServingEndpointRequest request) {
        return this.impl.get(request);
    }

    public void getOpenApi(String name) {
        this.getOpenApi(new GetOpenApiRequest().setName(name));
    }

    public void getOpenApi(GetOpenApiRequest request) {
        this.impl.getOpenApi(request);
    }

    public GetServingEndpointPermissionLevelsResponse getPermissionLevels(String servingEndpointId) {
        return this.getPermissionLevels(new GetServingEndpointPermissionLevelsRequest().setServingEndpointId(servingEndpointId));
    }

    public GetServingEndpointPermissionLevelsResponse getPermissionLevels(GetServingEndpointPermissionLevelsRequest request) {
        return this.impl.getPermissionLevels(request);
    }

    public ServingEndpointPermissions getPermissions(String servingEndpointId) {
        return this.getPermissions(new GetServingEndpointPermissionsRequest().setServingEndpointId(servingEndpointId));
    }

    public ServingEndpointPermissions getPermissions(GetServingEndpointPermissionsRequest request) {
        return this.impl.getPermissions(request);
    }

    public Iterable<ServingEndpoint> list() {
        return new Paginator(null, v -> this.impl.list(), ListEndpointsResponse::getEndpoints, response -> null);
    }

    public ServerLogsResponse logs(String name, String servedModelName) {
        return this.logs(new LogsRequest().setName(name).setServedModelName(servedModelName));
    }

    public ServerLogsResponse logs(LogsRequest request) {
        return this.impl.logs(request);
    }

    public Iterable<EndpointTag> patch(String name) {
        return this.patch(new PatchServingEndpointTags().setName(name));
    }

    public Iterable<EndpointTag> patch(PatchServingEndpointTags request) {
        return this.impl.patch(request);
    }

    public PutResponse put(String name) {
        return this.put(new PutRequest().setName(name));
    }

    public PutResponse put(PutRequest request) {
        return this.impl.put(request);
    }

    public QueryEndpointResponse query(String name) {
        return this.query(new QueryEndpointInput().setName(name));
    }

    public QueryEndpointResponse query(QueryEndpointInput request) {
        return this.impl.query(request);
    }

    public ServingEndpointPermissions setPermissions(String servingEndpointId) {
        return this.setPermissions(new ServingEndpointPermissionsRequest().setServingEndpointId(servingEndpointId));
    }

    public ServingEndpointPermissions setPermissions(ServingEndpointPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public Wait<ServingEndpointDetailed, ServingEndpointDetailed> updateConfig(String name) {
        return this.updateConfig(new EndpointCoreConfigInput().setName(name));
    }

    public Wait<ServingEndpointDetailed, ServingEndpointDetailed> updateConfig(EndpointCoreConfigInput request) {
        ServingEndpointDetailed response = this.impl.updateConfig(request);
        return new Wait<ServingEndpointDetailed, ServingEndpointDetailed>((timeout, callback) -> this.waitGetServingEndpointNotUpdating(response.getName(), timeout, callback), response);
    }

    public ServingEndpointPermissions updatePermissions(String servingEndpointId) {
        return this.updatePermissions(new ServingEndpointPermissionsRequest().setServingEndpointId(servingEndpointId));
    }

    public ServingEndpointPermissions updatePermissions(ServingEndpointPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public ServingEndpointsService impl() {
        return this.impl;
    }
}

