/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.vectorsearch;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.vectorsearch.CreateVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.CreateVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.DeleteDataVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.DeleteDataVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.DeleteIndexRequest;
import com.databricks.sdk.service.vectorsearch.GetIndexRequest;
import com.databricks.sdk.service.vectorsearch.ListIndexesRequest;
import com.databricks.sdk.service.vectorsearch.ListVectorIndexesResponse;
import com.databricks.sdk.service.vectorsearch.MiniVectorIndex;
import com.databricks.sdk.service.vectorsearch.QueryVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.QueryVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.SyncIndexRequest;
import com.databricks.sdk.service.vectorsearch.UpsertDataVectorIndexRequest;
import com.databricks.sdk.service.vectorsearch.UpsertDataVectorIndexResponse;
import com.databricks.sdk.service.vectorsearch.VectorIndex;
import com.databricks.sdk.service.vectorsearch.VectorIndexType;
import com.databricks.sdk.service.vectorsearch.VectorSearchIndexesImpl;
import com.databricks.sdk.service.vectorsearch.VectorSearchIndexesService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class VectorSearchIndexesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(VectorSearchIndexesAPI.class);
    private final VectorSearchIndexesService impl;

    public VectorSearchIndexesAPI(ApiClient apiClient) {
        this.impl = new VectorSearchIndexesImpl(apiClient);
    }

    public VectorSearchIndexesAPI(VectorSearchIndexesService mock) {
        this.impl = mock;
    }

    public CreateVectorIndexResponse createIndex(String name, String endpointName, String primaryKey, VectorIndexType indexType) {
        return this.createIndex(new CreateVectorIndexRequest().setName(name).setEndpointName(endpointName).setPrimaryKey(primaryKey).setIndexType(indexType));
    }

    public CreateVectorIndexResponse createIndex(CreateVectorIndexRequest request) {
        return this.impl.createIndex(request);
    }

    public DeleteDataVectorIndexResponse deleteDataVectorIndex(String indexName, Collection<String> primaryKeys) {
        return this.deleteDataVectorIndex(new DeleteDataVectorIndexRequest().setIndexName(indexName).setPrimaryKeys(primaryKeys));
    }

    public DeleteDataVectorIndexResponse deleteDataVectorIndex(DeleteDataVectorIndexRequest request) {
        return this.impl.deleteDataVectorIndex(request);
    }

    public void deleteIndex(String indexName) {
        this.deleteIndex(new DeleteIndexRequest().setIndexName(indexName));
    }

    public void deleteIndex(DeleteIndexRequest request) {
        this.impl.deleteIndex(request);
    }

    public VectorIndex getIndex(String indexName) {
        return this.getIndex(new GetIndexRequest().setIndexName(indexName));
    }

    public VectorIndex getIndex(GetIndexRequest request) {
        return this.impl.getIndex(request);
    }

    public Iterable<MiniVectorIndex> listIndexes(String endpointName) {
        return this.listIndexes(new ListIndexesRequest().setEndpointName(endpointName));
    }

    public Iterable<MiniVectorIndex> listIndexes(ListIndexesRequest request) {
        return new Paginator(request, this.impl::listIndexes, ListVectorIndexesResponse::getVectorIndexes, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public QueryVectorIndexResponse queryIndex(String indexName, Collection<String> columns) {
        return this.queryIndex(new QueryVectorIndexRequest().setIndexName(indexName).setColumns(columns));
    }

    public QueryVectorIndexResponse queryIndex(QueryVectorIndexRequest request) {
        return this.impl.queryIndex(request);
    }

    public void syncIndex(String indexName) {
        this.syncIndex(new SyncIndexRequest().setIndexName(indexName));
    }

    public void syncIndex(SyncIndexRequest request) {
        this.impl.syncIndex(request);
    }

    public UpsertDataVectorIndexResponse upsertDataVectorIndex(String indexName, String inputsJson) {
        return this.upsertDataVectorIndex(new UpsertDataVectorIndexRequest().setIndexName(indexName).setInputsJson(inputsJson));
    }

    public UpsertDataVectorIndexResponse upsertDataVectorIndex(UpsertDataVectorIndexRequest request) {
        return this.impl.upsertDataVectorIndex(request);
    }

    public VectorSearchIndexesService impl() {
        return this.impl;
    }
}

