/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.DeleteResponse;
import com.databricks.sdk.service.catalog.DeleteTableRequest;
import com.databricks.sdk.service.catalog.ExistsRequest;
import com.databricks.sdk.service.catalog.GetTableRequest;
import com.databricks.sdk.service.catalog.ListSummariesRequest;
import com.databricks.sdk.service.catalog.ListTableSummariesResponse;
import com.databricks.sdk.service.catalog.ListTablesRequest;
import com.databricks.sdk.service.catalog.ListTablesResponse;
import com.databricks.sdk.service.catalog.TableExistsResponse;
import com.databricks.sdk.service.catalog.TableInfo;
import com.databricks.sdk.service.catalog.TablesService;
import com.databricks.sdk.service.catalog.UpdateResponse;
import com.databricks.sdk.service.catalog.UpdateTableRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class TablesImpl
implements TablesService {
    private final ApiClient apiClient;

    public TablesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(DeleteTableRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public TableExistsResponse exists(ExistsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s/exists", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, TableExistsResponse.class, headers);
    }

    @Override
    public TableInfo get(GetTableRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, TableInfo.class, headers);
    }

    @Override
    public ListTablesResponse list(ListTablesRequest request) {
        String path = "/api/2.1/unity-catalog/tables";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListTablesResponse.class, headers);
    }

    @Override
    public ListTableSummariesResponse listSummaries(ListSummariesRequest request) {
        String path = "/api/2.1/unity-catalog/table-summaries";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListTableSummariesResponse.class, headers);
    }

    @Override
    public void update(UpdateTableRequest request) {
        String path = String.format("/api/2.1/unity-catalog/tables/%s", request.getFullName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, UpdateResponse.class, headers);
    }
}

