/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.PermissionsList;
import com.databricks.sdk.service.sharing.CreateShare;
import com.databricks.sdk.service.sharing.DeleteShareRequest;
import com.databricks.sdk.service.sharing.GetShareRequest;
import com.databricks.sdk.service.sharing.ListSharesRequest;
import com.databricks.sdk.service.sharing.ListSharesResponse;
import com.databricks.sdk.service.sharing.ShareInfo;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.SharesImpl;
import com.databricks.sdk.service.sharing.SharesService;
import com.databricks.sdk.service.sharing.UpdateShare;
import com.databricks.sdk.service.sharing.UpdateSharePermissions;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class SharesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SharesAPI.class);
    private final SharesService impl;

    public SharesAPI(ApiClient apiClient) {
        this.impl = new SharesImpl(apiClient);
    }

    public SharesAPI(SharesService mock) {
        this.impl = mock;
    }

    public ShareInfo create(String name) {
        return this.create(new CreateShare().setName(name));
    }

    public ShareInfo create(CreateShare request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteShareRequest().setName(name));
    }

    public void delete(DeleteShareRequest request) {
        this.impl.delete(request);
    }

    public ShareInfo get(String name) {
        return this.get(new GetShareRequest().setName(name));
    }

    public ShareInfo get(GetShareRequest request) {
        return this.impl.get(request);
    }

    public Iterable<ShareInfo> list(ListSharesRequest request) {
        return new Paginator(request, this.impl::list, ListSharesResponse::getShares, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PermissionsList sharePermissions(String name) {
        return this.sharePermissions(new SharePermissionsRequest().setName(name));
    }

    public PermissionsList sharePermissions(SharePermissionsRequest request) {
        return this.impl.sharePermissions(request);
    }

    public ShareInfo update(String name) {
        return this.update(new UpdateShare().setName(name));
    }

    public ShareInfo update(UpdateShare request) {
        return this.impl.update(request);
    }

    public void updatePermissions(String name) {
        this.updatePermissions(new UpdateSharePermissions().setName(name));
    }

    public void updatePermissions(UpdateSharePermissions request) {
        this.impl.updatePermissions(request);
    }

    public SharesService impl() {
        return this.impl;
    }
}

