/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.PermissionsList;
import com.databricks.sdk.service.sharing.CreateShare;
import com.databricks.sdk.service.sharing.DeleteResponse;
import com.databricks.sdk.service.sharing.DeleteShareRequest;
import com.databricks.sdk.service.sharing.GetShareRequest;
import com.databricks.sdk.service.sharing.ListSharesRequest;
import com.databricks.sdk.service.sharing.ListSharesResponse;
import com.databricks.sdk.service.sharing.ShareInfo;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.SharesService;
import com.databricks.sdk.service.sharing.UpdatePermissionsResponse;
import com.databricks.sdk.service.sharing.UpdateShare;
import com.databricks.sdk.service.sharing.UpdateSharePermissions;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class SharesImpl
implements SharesService {
    private final ApiClient apiClient;

    public SharesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ShareInfo create(CreateShare request) {
        String path = "/api/2.1/unity-catalog/shares";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, ShareInfo.class, headers);
    }

    @Override
    public void delete(DeleteShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public ShareInfo get(GetShareRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ShareInfo.class, headers);
    }

    @Override
    public ListSharesResponse list(ListSharesRequest request) {
        String path = "/api/2.1/unity-catalog/shares";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListSharesResponse.class, headers);
    }

    @Override
    public PermissionsList sharePermissions(SharePermissionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, PermissionsList.class, headers);
    }

    @Override
    public ShareInfo update(UpdateShare request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, ShareInfo.class, headers);
    }

    @Override
    public void updatePermissions(UpdateSharePermissions request) {
        String path = String.format("/api/2.1/unity-catalog/shares/%s/permissions", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, UpdatePermissionsResponse.class, headers);
    }
}

