/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sql;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sql.CreateQueryRequest;
import com.databricks.sdk.service.sql.Empty;
import com.databricks.sdk.service.sql.GetQueryRequest;
import com.databricks.sdk.service.sql.ListQueriesRequest;
import com.databricks.sdk.service.sql.ListQueryObjectsResponse;
import com.databricks.sdk.service.sql.ListVisualizationsForQueryRequest;
import com.databricks.sdk.service.sql.ListVisualizationsForQueryResponse;
import com.databricks.sdk.service.sql.QueriesService;
import com.databricks.sdk.service.sql.Query;
import com.databricks.sdk.service.sql.TrashQueryRequest;
import com.databricks.sdk.service.sql.UpdateQueryRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class QueriesImpl
implements QueriesService {
    private final ApiClient apiClient;

    public QueriesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Query create(CreateQueryRequest request) {
        String path = "/api/2.0/sql/queries";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, Query.class, headers);
    }

    @Override
    public void delete(TrashQueryRequest request) {
        String path = String.format("/api/2.0/sql/queries/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Empty.class, headers);
    }

    @Override
    public Query get(GetQueryRequest request) {
        String path = String.format("/api/2.0/sql/queries/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, Query.class, headers);
    }

    @Override
    public ListQueryObjectsResponse list(ListQueriesRequest request) {
        String path = "/api/2.0/sql/queries";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListQueryObjectsResponse.class, headers);
    }

    @Override
    public ListVisualizationsForQueryResponse listVisualizations(ListVisualizationsForQueryRequest request) {
        String path = String.format("/api/2.0/sql/queries/%s/visualizations", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListVisualizationsForQueryResponse.class, headers);
    }

    @Override
    public Query update(UpdateQueryRequest request) {
        String path = String.format("/api/2.0/sql/queries/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, Query.class, headers);
    }
}

