/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.BodyLogger;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksError;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.GrpcTranscodingQueryParamsSerializer;
import com.databricks.sdk.core.UserAgent;
import com.databricks.sdk.core.error.ApiErrors;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.utils.RealTimer;
import com.databricks.sdk.core.utils.Timer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiClient {
    private static final Logger LOG = LoggerFactory.getLogger(ApiClient.class);
    private final int maxAttempts;
    private final ObjectMapper mapper;
    private final DatabricksConfig config;
    private final Random random;
    private final HttpClient httpClient;
    private final BodyLogger bodyLogger;
    private final Timer timer;

    public ApiClient() {
        this(ConfigLoader.getDefault());
    }

    public String configuredAccountID() {
        return this.config.getAccountId();
    }

    public ApiClient(DatabricksConfig config) {
        this(config, new RealTimer());
    }

    public ApiClient(DatabricksConfig config, Timer timer) {
        Integer debugTruncateBytes;
        this.config = config;
        config.resolve();
        Integer rateLimit = config.getRateLimit();
        if (rateLimit == null) {
            rateLimit = 15;
        }
        if ((debugTruncateBytes = config.getDebugTruncateBytes()) == null) {
            debugTruncateBytes = 96;
        }
        this.maxAttempts = 3;
        this.mapper = this.makeObjectMapper();
        this.random = new Random();
        this.httpClient = config.getHttpClient();
        this.bodyLogger = new BodyLogger(this.mapper, 1024, debugTruncateBytes);
        this.timer = timer;
    }

    private ObjectMapper makeObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private <I> Request withQuery(Request in, I entity) {
        if (entity == null) {
            return in;
        }
        for (GrpcTranscodingQueryParamsSerializer.HeaderEntry e : GrpcTranscodingQueryParamsSerializer.serialize(entity)) {
            in.withQueryParam(e.getKey(), e.getValue());
        }
        return in;
    }

    public <I, O> Collection<O> getCollection(String path, I in, Class<O> element) {
        return (Collection)this.withJavaType(path, in, (JavaType)this.mapper.getTypeFactory().constructCollectionType(Collection.class, element));
    }

    public <I> Map<String, String> getStringMap(String path, I in) {
        return (Map)this.withJavaType(path, in, (JavaType)this.mapper.getTypeFactory().constructMapType(Map.class, String.class, String.class));
    }

    protected <I, O> O withJavaType(String path, I in, JavaType javaType) {
        try {
            Request request = this.withQuery(new Request("GET", path), in);
            Response response = this.getResponse(request);
            return (O)this.deserialize(response.getBody(), javaType);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public <O> O GET(String path, Class<O> target) {
        return this.GET(path, null, target);
    }

    public <I, O> O GET(String path, I in, Class<O> target) {
        try {
            return this.execute(this.withQuery(new Request("GET", path), in), target);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public <I, O> O POST(String path, I in, Class<O> target) {
        try {
            return this.execute(new Request("POST", path, this.serialize(in)), target);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public <I, O> O PUT(String path, I in, Class<O> target) {
        try {
            return this.execute(new Request("PUT", path, this.serialize(in)), target);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public <I, O> O PATCH(String path, I in, Class<O> target) {
        try {
            return this.execute(new Request("PATCH", path, this.serialize(in)), target);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public <I, O> O DELETE(String path, I in, Class<O> target) {
        try {
            return this.execute(this.withQuery(new Request("DELETE", path), in), target);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    private <T> T execute(Request in, Class<T> target) throws IOException {
        Response out = this.getResponse(in);
        if (target == Void.class) {
            return null;
        }
        return this.deserialize(out.getBody(), target);
    }

    private Response getResponse(Request in) {
        in.withUrl(this.config.getHost() + in.getUrl());
        in.withHeader("Accept", "application/json");
        return this.executeInner(in);
    }

    private Response executeInner(Request in) {
        int attemptNumber = 0;
        while (true) {
            ++attemptNumber;
            IOException err = null;
            Response out = null;
            in.withHeaders(this.config.authenticate());
            String userAgent = String.format("%s auth/%s", UserAgent.asString(), this.config.getAuthType());
            in.withHeader("User-Agent", userAgent);
            try {
                out = this.httpClient.execute(in);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.makeLogRecord(in, out));
                }
                if (out.getStatusCode() < 400) {
                    return out;
                }
            }
            catch (IOException e) {
                err = e;
                LOG.debug("Request {} failed", (Object)in, (Object)e);
            }
            DatabricksError res = ApiErrors.checkForRetry(out, err);
            if (!res.isRetriable()) {
                if (res.getErrorCode() == null) {
                    return out;
                }
                throw res;
            }
            if (attemptNumber == this.maxAttempts) {
                throw new DatabricksException(String.format("Request %s failed after %d retries", in, this.maxAttempts), err);
            }
            int sleepMillis = this.getBackoffMillis(attemptNumber);
            LOG.debug(String.format("Retry %s in %dms", in.getRequestLine(), sleepMillis));
            try {
                this.timer.wait(sleepMillis);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private int getBackoffMillis(int attemptNumber) {
        int maxWait = 10000;
        int minJitter = 50;
        int maxJitter = 750;
        int wait = Math.min(maxWait, attemptNumber * 1000);
        return wait += this.random.nextInt(maxJitter - minJitter + 1) + minJitter;
    }

    private String makeLogRecord(Request in, Response out) {
        String requestBody;
        StringBuilder sb = new StringBuilder();
        sb.append("> ");
        sb.append(in.getRequestLine());
        if (this.config.isDebugHeaders()) {
            sb.append("\n * Host: ");
            sb.append(this.config.getHost());
            in.getHeaders().forEach((header, value) -> sb.append(String.format("\n * %s: %s", header, value)));
        }
        if ((requestBody = in.getBody()) != null && !requestBody.isEmpty()) {
            for (String line : this.bodyLogger.redactedDump(requestBody).split("\n")) {
                sb.append("\n> ");
                sb.append(line);
            }
        }
        sb.append("\n< ");
        sb.append(out.toString());
        for (String line : this.bodyLogger.redactedDump(out.getBody()).split("\n")) {
            sb.append("\n< ");
            sb.append(line);
        }
        return sb.toString();
    }

    public <T> T deserialize(String body, Class<T> target) throws IOException {
        return (T)this.mapper.readValue(body, target);
    }

    public <T> T deserialize(String body, JavaType target) throws IOException {
        return (T)this.mapper.readValue(body, target);
    }

    private String serialize(Object body) throws JsonProcessingException {
        return this.mapper.writeValueAsString(body);
    }
}

