/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.ml;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.ml.ApproveTransitionRequest;
import com.databricks.sdk.service.ml.ApproveTransitionRequestResponse;
import com.databricks.sdk.service.ml.CreateComment;
import com.databricks.sdk.service.ml.CreateCommentResponse;
import com.databricks.sdk.service.ml.CreateModelRequest;
import com.databricks.sdk.service.ml.CreateModelResponse;
import com.databricks.sdk.service.ml.CreateModelVersionRequest;
import com.databricks.sdk.service.ml.CreateModelVersionResponse;
import com.databricks.sdk.service.ml.CreateRegistryWebhook;
import com.databricks.sdk.service.ml.CreateTransitionRequest;
import com.databricks.sdk.service.ml.CreateTransitionRequestResponse;
import com.databricks.sdk.service.ml.CreateWebhookResponse;
import com.databricks.sdk.service.ml.DeleteCommentRequest;
import com.databricks.sdk.service.ml.DeleteModelRequest;
import com.databricks.sdk.service.ml.DeleteModelTagRequest;
import com.databricks.sdk.service.ml.DeleteModelVersionRequest;
import com.databricks.sdk.service.ml.DeleteModelVersionTagRequest;
import com.databricks.sdk.service.ml.DeleteTransitionRequestRequest;
import com.databricks.sdk.service.ml.DeleteWebhookRequest;
import com.databricks.sdk.service.ml.GetLatestVersionsRequest;
import com.databricks.sdk.service.ml.GetLatestVersionsResponse;
import com.databricks.sdk.service.ml.GetModelRequest;
import com.databricks.sdk.service.ml.GetModelResponse;
import com.databricks.sdk.service.ml.GetModelVersionDownloadUriRequest;
import com.databricks.sdk.service.ml.GetModelVersionDownloadUriResponse;
import com.databricks.sdk.service.ml.GetModelVersionRequest;
import com.databricks.sdk.service.ml.GetModelVersionResponse;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionLevelsRequest;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionLevelsResponse;
import com.databricks.sdk.service.ml.GetRegisteredModelPermissionsRequest;
import com.databricks.sdk.service.ml.ListModelsRequest;
import com.databricks.sdk.service.ml.ListModelsResponse;
import com.databricks.sdk.service.ml.ListRegistryWebhooks;
import com.databricks.sdk.service.ml.ListTransitionRequestsRequest;
import com.databricks.sdk.service.ml.ListTransitionRequestsResponse;
import com.databricks.sdk.service.ml.ListWebhooksRequest;
import com.databricks.sdk.service.ml.ModelRegistryService;
import com.databricks.sdk.service.ml.RegisteredModelPermissions;
import com.databricks.sdk.service.ml.RegisteredModelPermissionsRequest;
import com.databricks.sdk.service.ml.RejectTransitionRequest;
import com.databricks.sdk.service.ml.RejectTransitionRequestResponse;
import com.databricks.sdk.service.ml.RenameModelRequest;
import com.databricks.sdk.service.ml.RenameModelResponse;
import com.databricks.sdk.service.ml.SearchModelVersionsRequest;
import com.databricks.sdk.service.ml.SearchModelVersionsResponse;
import com.databricks.sdk.service.ml.SearchModelsRequest;
import com.databricks.sdk.service.ml.SearchModelsResponse;
import com.databricks.sdk.service.ml.SetModelTagRequest;
import com.databricks.sdk.service.ml.SetModelVersionTagRequest;
import com.databricks.sdk.service.ml.TestRegistryWebhookRequest;
import com.databricks.sdk.service.ml.TestRegistryWebhookResponse;
import com.databricks.sdk.service.ml.TransitionModelVersionStageDatabricks;
import com.databricks.sdk.service.ml.TransitionStageResponse;
import com.databricks.sdk.service.ml.UpdateComment;
import com.databricks.sdk.service.ml.UpdateCommentResponse;
import com.databricks.sdk.service.ml.UpdateModelRequest;
import com.databricks.sdk.service.ml.UpdateModelVersionRequest;
import com.databricks.sdk.service.ml.UpdateRegistryWebhook;
import com.databricks.sdk.support.Generated;

@Generated
class ModelRegistryImpl
implements ModelRegistryService {
    private final ApiClient apiClient;

    public ModelRegistryImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ApproveTransitionRequestResponse approveTransitionRequest(ApproveTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/approve";
        return this.apiClient.POST(path, request, ApproveTransitionRequestResponse.class);
    }

    @Override
    public CreateCommentResponse createComment(CreateComment request) {
        String path = "/api/2.0/mlflow/comments/create";
        return this.apiClient.POST(path, request, CreateCommentResponse.class);
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/create";
        return this.apiClient.POST(path, request, CreateModelResponse.class);
    }

    @Override
    public CreateModelVersionResponse createModelVersion(CreateModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/create";
        return this.apiClient.POST(path, request, CreateModelVersionResponse.class);
    }

    @Override
    public CreateTransitionRequestResponse createTransitionRequest(CreateTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/create";
        return this.apiClient.POST(path, request, CreateTransitionRequestResponse.class);
    }

    @Override
    public CreateWebhookResponse createWebhook(CreateRegistryWebhook request) {
        String path = "/api/2.0/mlflow/registry-webhooks/create";
        return this.apiClient.POST(path, request, CreateWebhookResponse.class);
    }

    @Override
    public void deleteComment(DeleteCommentRequest request) {
        String path = "/api/2.0/mlflow/comments/delete";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteModel(DeleteModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/delete";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteModelTag(DeleteModelTagRequest request) {
        String path = "/api/2.0/mlflow/registered-models/delete-tag";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteModelVersion(DeleteModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/delete";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteModelVersionTag(DeleteModelVersionTagRequest request) {
        String path = "/api/2.0/mlflow/model-versions/delete-tag";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteTransitionRequest(DeleteTransitionRequestRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/delete";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public void deleteWebhook(DeleteWebhookRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/delete";
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public GetLatestVersionsResponse getLatestVersions(GetLatestVersionsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/get-latest-versions";
        return this.apiClient.POST(path, request, GetLatestVersionsResponse.class);
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        String path = "/api/2.0/mlflow/databricks/registered-models/get";
        return this.apiClient.GET(path, request, GetModelResponse.class);
    }

    @Override
    public GetModelVersionResponse getModelVersion(GetModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/get";
        return this.apiClient.GET(path, request, GetModelVersionResponse.class);
    }

    @Override
    public GetModelVersionDownloadUriResponse getModelVersionDownloadUri(GetModelVersionDownloadUriRequest request) {
        String path = "/api/2.0/mlflow/model-versions/get-download-uri";
        return this.apiClient.GET(path, request, GetModelVersionDownloadUriResponse.class);
    }

    @Override
    public GetRegisteredModelPermissionLevelsResponse getRegisteredModelPermissionLevels(GetRegisteredModelPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s/permissionLevels", request.getRegisteredModelId());
        return this.apiClient.GET(path, request, GetRegisteredModelPermissionLevelsResponse.class);
    }

    @Override
    public RegisteredModelPermissions getRegisteredModelPermissions(GetRegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        return this.apiClient.GET(path, request, RegisteredModelPermissions.class);
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/list";
        return this.apiClient.GET(path, request, ListModelsResponse.class);
    }

    @Override
    public ListTransitionRequestsResponse listTransitionRequests(ListTransitionRequestsRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/list";
        return this.apiClient.GET(path, request, ListTransitionRequestsResponse.class);
    }

    @Override
    public ListRegistryWebhooks listWebhooks(ListWebhooksRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/list";
        return this.apiClient.GET(path, request, ListRegistryWebhooks.class);
    }

    @Override
    public RejectTransitionRequestResponse rejectTransitionRequest(RejectTransitionRequest request) {
        String path = "/api/2.0/mlflow/transition-requests/reject";
        return this.apiClient.POST(path, request, RejectTransitionRequestResponse.class);
    }

    @Override
    public RenameModelResponse renameModel(RenameModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/rename";
        return this.apiClient.POST(path, request, RenameModelResponse.class);
    }

    @Override
    public SearchModelVersionsResponse searchModelVersions(SearchModelVersionsRequest request) {
        String path = "/api/2.0/mlflow/model-versions/search";
        return this.apiClient.GET(path, request, SearchModelVersionsResponse.class);
    }

    @Override
    public SearchModelsResponse searchModels(SearchModelsRequest request) {
        String path = "/api/2.0/mlflow/registered-models/search";
        return this.apiClient.GET(path, request, SearchModelsResponse.class);
    }

    @Override
    public void setModelTag(SetModelTagRequest request) {
        String path = "/api/2.0/mlflow/registered-models/set-tag";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void setModelVersionTag(SetModelVersionTagRequest request) {
        String path = "/api/2.0/mlflow/model-versions/set-tag";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public RegisteredModelPermissions setRegisteredModelPermissions(RegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        return this.apiClient.PUT(path, request, RegisteredModelPermissions.class);
    }

    @Override
    public TestRegistryWebhookResponse testRegistryWebhook(TestRegistryWebhookRequest request) {
        String path = "/api/2.0/mlflow/registry-webhooks/test";
        return this.apiClient.POST(path, request, TestRegistryWebhookResponse.class);
    }

    @Override
    public TransitionStageResponse transitionStage(TransitionModelVersionStageDatabricks request) {
        String path = "/api/2.0/mlflow/databricks/model-versions/transition-stage";
        return this.apiClient.POST(path, request, TransitionStageResponse.class);
    }

    @Override
    public UpdateCommentResponse updateComment(UpdateComment request) {
        String path = "/api/2.0/mlflow/comments/update";
        return this.apiClient.PATCH(path, request, UpdateCommentResponse.class);
    }

    @Override
    public void updateModel(UpdateModelRequest request) {
        String path = "/api/2.0/mlflow/registered-models/update";
        this.apiClient.PATCH(path, request, Void.class);
    }

    @Override
    public void updateModelVersion(UpdateModelVersionRequest request) {
        String path = "/api/2.0/mlflow/model-versions/update";
        this.apiClient.PATCH(path, request, Void.class);
    }

    @Override
    public RegisteredModelPermissions updateRegisteredModelPermissions(RegisteredModelPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/registered-models/%s", request.getRegisteredModelId());
        return this.apiClient.PATCH(path, request, RegisteredModelPermissions.class);
    }

    @Override
    public void updateWebhook(UpdateRegistryWebhook request) {
        String path = "/api/2.0/mlflow/registry-webhooks/update";
        this.apiClient.PATCH(path, request, Void.class);
    }
}

