/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.CreateRepo;
import com.databricks.sdk.service.workspace.DeleteRepoRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetRepoPermissionsRequest;
import com.databricks.sdk.service.workspace.GetRepoRequest;
import com.databricks.sdk.service.workspace.ListReposRequest;
import com.databricks.sdk.service.workspace.ListReposResponse;
import com.databricks.sdk.service.workspace.RepoInfo;
import com.databricks.sdk.service.workspace.RepoPermissions;
import com.databricks.sdk.service.workspace.RepoPermissionsRequest;
import com.databricks.sdk.service.workspace.ReposService;
import com.databricks.sdk.service.workspace.UpdateRepo;
import com.databricks.sdk.support.Generated;

@Generated
class ReposImpl
implements ReposService {
    private final ApiClient apiClient;

    public ReposImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RepoInfo create(CreateRepo request) {
        String path = "/api/2.0/repos";
        return this.apiClient.POST(path, request, RepoInfo.class);
    }

    @Override
    public void delete(DeleteRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public RepoInfo get(GetRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        return this.apiClient.GET(path, request, RepoInfo.class);
    }

    @Override
    public GetRepoPermissionLevelsResponse getRepoPermissionLevels(GetRepoPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s/permissionLevels", request.getRepoId());
        return this.apiClient.GET(path, request, GetRepoPermissionLevelsResponse.class);
    }

    @Override
    public RepoPermissions getRepoPermissions(GetRepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        return this.apiClient.GET(path, request, RepoPermissions.class);
    }

    @Override
    public ListReposResponse list(ListReposRequest request) {
        String path = "/api/2.0/repos";
        return this.apiClient.GET(path, request, ListReposResponse.class);
    }

    @Override
    public RepoPermissions setRepoPermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        return this.apiClient.PUT(path, request, RepoPermissions.class);
    }

    @Override
    public void update(UpdateRepo request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        this.apiClient.PATCH(path, request, Void.class);
    }

    @Override
    public RepoPermissions updateRepoPermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        return this.apiClient.PATCH(path, request, RepoPermissions.class);
    }
}

