/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.Delete;
import com.databricks.sdk.service.workspace.ExportRequest;
import com.databricks.sdk.service.workspace.ExportResponse;
import com.databricks.sdk.service.workspace.GetStatusRequest;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetWorkspaceObjectPermissionsRequest;
import com.databricks.sdk.service.workspace.Import;
import com.databricks.sdk.service.workspace.ListResponse;
import com.databricks.sdk.service.workspace.ListWorkspaceRequest;
import com.databricks.sdk.service.workspace.Mkdirs;
import com.databricks.sdk.service.workspace.ObjectInfo;
import com.databricks.sdk.service.workspace.WorkspaceObjectPermissions;
import com.databricks.sdk.service.workspace.WorkspaceObjectPermissionsRequest;
import com.databricks.sdk.service.workspace.WorkspaceService;
import com.databricks.sdk.support.Generated;

@Generated
class WorkspaceImpl
implements WorkspaceService {
    private final ApiClient apiClient;

    public WorkspaceImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(Delete request) {
        String path = "/api/2.0/workspace/delete";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public ExportResponse export(ExportRequest request) {
        String path = "/api/2.0/workspace/export";
        return this.apiClient.GET(path, request, ExportResponse.class);
    }

    @Override
    public ObjectInfo getStatus(GetStatusRequest request) {
        String path = "/api/2.0/workspace/get-status";
        return this.apiClient.GET(path, request, ObjectInfo.class);
    }

    @Override
    public GetWorkspaceObjectPermissionLevelsResponse getWorkspaceObjectPermissionLevels(GetWorkspaceObjectPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s/permissionLevels", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        return this.apiClient.GET(path, request, GetWorkspaceObjectPermissionLevelsResponse.class);
    }

    @Override
    public WorkspaceObjectPermissions getWorkspaceObjectPermissions(GetWorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        return this.apiClient.GET(path, request, WorkspaceObjectPermissions.class);
    }

    @Override
    public void importContent(Import request) {
        String path = "/api/2.0/workspace/import";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public ListResponse list(ListWorkspaceRequest request) {
        String path = "/api/2.0/workspace/list";
        return this.apiClient.GET(path, request, ListResponse.class);
    }

    @Override
    public void mkdirs(Mkdirs request) {
        String path = "/api/2.0/workspace/mkdirs";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public WorkspaceObjectPermissions setWorkspaceObjectPermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        return this.apiClient.PUT(path, request, WorkspaceObjectPermissions.class);
    }

    @Override
    public WorkspaceObjectPermissions updateWorkspaceObjectPermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        return this.apiClient.PATCH(path, request, WorkspaceObjectPermissions.class);
    }
}

