// Code generated from OpenAPI specs by Databricks SDK Generator. DO NOT EDIT.

package com.databricks.sdk.service.billing;

import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.ToStringer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Objects;

/** Contains the BudgetPolicy details. */
@Generated
public class BudgetPolicy {
  /** A list of tags defined by the customer. At most 20 entries are allowed per policy. */
  @JsonProperty("custom_tags")
  private Collection<com.databricks.sdk.service.compute.CustomPolicyTag> customTags;

  /** The Id of the policy. This field is generated by Databricks and globally unique. */
  @JsonProperty("policy_id")
  private String policyId;

  /**
   * The name of the policy. - Must be unique among active policies. - Can contain only characters
   * from the ISO 8859-1 (latin1) set.
   */
  @JsonProperty("policy_name")
  private String policyName;

  public BudgetPolicy setCustomTags(
      Collection<com.databricks.sdk.service.compute.CustomPolicyTag> customTags) {
    this.customTags = customTags;
    return this;
  }

  public Collection<com.databricks.sdk.service.compute.CustomPolicyTag> getCustomTags() {
    return customTags;
  }

  public BudgetPolicy setPolicyId(String policyId) {
    this.policyId = policyId;
    return this;
  }

  public String getPolicyId() {
    return policyId;
  }

  public BudgetPolicy setPolicyName(String policyName) {
    this.policyName = policyName;
    return this;
  }

  public String getPolicyName() {
    return policyName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BudgetPolicy that = (BudgetPolicy) o;
    return Objects.equals(customTags, that.customTags)
        && Objects.equals(policyId, that.policyId)
        && Objects.equals(policyName, that.policyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customTags, policyId, policyName);
  }

  @Override
  public String toString() {
    return new ToStringer(BudgetPolicy.class)
        .add("customTags", customTags)
        .add("policyId", policyId)
        .add("policyName", policyName)
        .toString();
  }
}
