/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.billing.BudgetPolicy;
import com.databricks.sdk.service.billing.BudgetPolicyImpl;
import com.databricks.sdk.service.billing.BudgetPolicyService;
import com.databricks.sdk.service.billing.CreateBudgetPolicyRequest;
import com.databricks.sdk.service.billing.DeleteBudgetPolicyRequest;
import com.databricks.sdk.service.billing.GetBudgetPolicyRequest;
import com.databricks.sdk.service.billing.ListBudgetPoliciesRequest;
import com.databricks.sdk.service.billing.ListBudgetPoliciesResponse;
import com.databricks.sdk.service.billing.UpdateBudgetPolicyRequest;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class BudgetPolicyAPI {
    private static final Logger LOG = LoggerFactory.getLogger(BudgetPolicyAPI.class);
    private final BudgetPolicyService impl;

    public BudgetPolicyAPI(ApiClient apiClient) {
        this.impl = new BudgetPolicyImpl(apiClient);
    }

    public BudgetPolicyAPI(BudgetPolicyService mock) {
        this.impl = mock;
    }

    public BudgetPolicy create(CreateBudgetPolicyRequest request) {
        return this.impl.create(request);
    }

    public void delete(String policyId) {
        this.delete(new DeleteBudgetPolicyRequest().setPolicyId(policyId));
    }

    public void delete(DeleteBudgetPolicyRequest request) {
        this.impl.delete(request);
    }

    public BudgetPolicy get(String policyId) {
        return this.get(new GetBudgetPolicyRequest().setPolicyId(policyId));
    }

    public BudgetPolicy get(GetBudgetPolicyRequest request) {
        return this.impl.get(request);
    }

    public Iterable<BudgetPolicy> list(ListBudgetPoliciesRequest request) {
        return new Paginator(request, this.impl::list, ListBudgetPoliciesResponse::getPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public BudgetPolicy update(String policyId) {
        return this.update(new UpdateBudgetPolicyRequest().setPolicyId(policyId));
    }

    public BudgetPolicy update(UpdateBudgetPolicyRequest request) {
        return this.impl.update(request);
    }

    public BudgetPolicyService impl() {
        return this.impl;
    }
}

