/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.oauth2.CreateServicePrincipalSecretRequest;
import com.databricks.sdk.service.oauth2.CreateServicePrincipalSecretResponse;
import com.databricks.sdk.service.oauth2.DeleteResponse;
import com.databricks.sdk.service.oauth2.DeleteServicePrincipalSecretRequest;
import com.databricks.sdk.service.oauth2.ListServicePrincipalSecretsRequest;
import com.databricks.sdk.service.oauth2.ListServicePrincipalSecretsResponse;
import com.databricks.sdk.service.oauth2.ServicePrincipalSecretsService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ServicePrincipalSecretsImpl
implements ServicePrincipalSecretsService {
    private final ApiClient apiClient;

    public ServicePrincipalSecretsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateServicePrincipalSecretResponse create(CreateServicePrincipalSecretRequest request) {
        String path = String.format("/api/2.0/accounts/%s/servicePrincipals/%s/credentials/secrets", this.apiClient.configuredAccountID(), request.getServicePrincipalId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateServicePrincipalSecretResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteServicePrincipalSecretRequest request) {
        String path = String.format("/api/2.0/accounts/%s/servicePrincipals/%s/credentials/secrets/%s", this.apiClient.configuredAccountID(), request.getServicePrincipalId(), request.getSecretId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListServicePrincipalSecretsResponse list(ListServicePrincipalSecretsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/servicePrincipals/%s/credentials/secrets", this.apiClient.configuredAccountID(), request.getServicePrincipalId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListServicePrincipalSecretsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

