/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.CreateNetworkConnectivityConfigRequest;
import com.databricks.sdk.service.settings.CreatePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.DeleteNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.DeleteNetworkConnectivityConfigurationResponse;
import com.databricks.sdk.service.settings.DeletePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.GetNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.GetPrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.ListNccAzurePrivateEndpointRulesResponse;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsRequest;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsResponse;
import com.databricks.sdk.service.settings.ListPrivateEndpointRulesRequest;
import com.databricks.sdk.service.settings.NccAzurePrivateEndpointRule;
import com.databricks.sdk.service.settings.NetworkConnectivityConfiguration;
import com.databricks.sdk.service.settings.NetworkConnectivityService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class NetworkConnectivityImpl
implements NetworkConnectivityService {
    private final ApiClient apiClient;

    public NetworkConnectivityImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfigRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, NetworkConnectivityConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule createPrivateEndpointRule(CreatePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteNetworkConnectivityConfiguration(DeleteNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteNetworkConnectivityConfigurationResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule deletePrivateEndpointRule(DeletePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(GetNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NetworkConnectivityConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public NccAzurePrivateEndpointRule getPrivateEndpointRule(GetPrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, NccAzurePrivateEndpointRule.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListNetworkConnectivityConfigurationsResponse listNetworkConnectivityConfigurations(ListNetworkConnectivityConfigurationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListNetworkConnectivityConfigurationsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListNccAzurePrivateEndpointRulesResponse listPrivateEndpointRules(ListPrivateEndpointRulesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListNccAzurePrivateEndpointRulesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

