/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.provisioning.CreateStorageConfigurationRequest;
import com.databricks.sdk.service.provisioning.DeleteResponse;
import com.databricks.sdk.service.provisioning.DeleteStorageRequest;
import com.databricks.sdk.service.provisioning.GetStorageRequest;
import com.databricks.sdk.service.provisioning.StorageConfiguration;
import com.databricks.sdk.service.provisioning.StorageService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;
import java.util.Collection;

@Generated
class StorageImpl
implements StorageService {
    private final ApiClient apiClient;

    public StorageImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public StorageConfiguration create(CreateStorageConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/storage-configurations", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, StorageConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteStorageRequest request) {
        String path = String.format("/api/2.0/accounts/%s/storage-configurations/%s", this.apiClient.configuredAccountID(), request.getStorageConfigurationId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, DeleteResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public StorageConfiguration get(GetStorageRequest request) {
        String path = String.format("/api/2.0/accounts/%s/storage-configurations/%s", this.apiClient.configuredAccountID(), request.getStorageConfigurationId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, StorageConfiguration.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<StorageConfiguration> list() {
        String path = String.format("/api/2.0/accounts/%s/storage-configurations", this.apiClient.configuredAccountID());
        Request req = new Request("GET", path);
        req.withHeader("Accept", "application/json");
        return this.apiClient.getCollection(req, StorageConfiguration.class);
    }
}

