/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.ClusterPoliciesService;
import com.databricks.sdk.service.compute.ClusterPolicyPermissions;
import com.databricks.sdk.service.compute.ClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.CreatePolicy;
import com.databricks.sdk.service.compute.CreatePolicyResponse;
import com.databricks.sdk.service.compute.DeletePolicy;
import com.databricks.sdk.service.compute.EditPolicy;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyRequest;
import com.databricks.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.sdk.service.compute.ListPoliciesResponse;
import com.databricks.sdk.service.compute.Policy;
import com.databricks.sdk.support.Generated;

@Generated
class ClusterPoliciesImpl
implements ClusterPoliciesService {
    private final ApiClient apiClient;

    public ClusterPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePolicyResponse create(CreatePolicy request) {
        String path = "/api/2.0/policies/clusters/create";
        return this.apiClient.POST(path, request, CreatePolicyResponse.class);
    }

    @Override
    public void delete(DeletePolicy request) {
        String path = "/api/2.0/policies/clusters/delete";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void edit(EditPolicy request) {
        String path = "/api/2.0/policies/clusters/edit";
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public Policy get(GetClusterPolicyRequest request) {
        String path = "/api/2.0/policies/clusters/get";
        return this.apiClient.GET(path, request, Policy.class);
    }

    @Override
    public GetClusterPolicyPermissionLevelsResponse getClusterPolicyPermissionLevels(GetClusterPolicyPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s/permissionLevels", request.getClusterPolicyId());
        return this.apiClient.GET(path, request, GetClusterPolicyPermissionLevelsResponse.class);
    }

    @Override
    public ClusterPolicyPermissions getClusterPolicyPermissions(GetClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        return this.apiClient.GET(path, request, ClusterPolicyPermissions.class);
    }

    @Override
    public ListPoliciesResponse list(ListClusterPoliciesRequest request) {
        String path = "/api/2.0/policies/clusters/list";
        return this.apiClient.GET(path, request, ListPoliciesResponse.class);
    }

    @Override
    public ClusterPolicyPermissions setClusterPolicyPermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        return this.apiClient.PUT(path, request, ClusterPolicyPermissions.class);
    }

    @Override
    public ClusterPolicyPermissions updateClusterPolicyPermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        return this.apiClient.PATCH(path, request, ClusterPolicyPermissions.class);
    }
}

