/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.pipelines;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.pipelines.CreatePipeline;
import com.databricks.sdk.service.pipelines.CreatePipelineResponse;
import com.databricks.sdk.service.pipelines.DeletePipelineRequest;
import com.databricks.sdk.service.pipelines.EditPipeline;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionLevelsRequest;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionLevelsResponse;
import com.databricks.sdk.service.pipelines.GetPipelinePermissionsRequest;
import com.databricks.sdk.service.pipelines.GetPipelineRequest;
import com.databricks.sdk.service.pipelines.GetPipelineResponse;
import com.databricks.sdk.service.pipelines.GetUpdateRequest;
import com.databricks.sdk.service.pipelines.GetUpdateResponse;
import com.databricks.sdk.service.pipelines.ListPipelineEventsRequest;
import com.databricks.sdk.service.pipelines.ListPipelineEventsResponse;
import com.databricks.sdk.service.pipelines.ListPipelinesRequest;
import com.databricks.sdk.service.pipelines.ListPipelinesResponse;
import com.databricks.sdk.service.pipelines.ListUpdatesRequest;
import com.databricks.sdk.service.pipelines.ListUpdatesResponse;
import com.databricks.sdk.service.pipelines.PipelinePermissions;
import com.databricks.sdk.service.pipelines.PipelinePermissionsRequest;
import com.databricks.sdk.service.pipelines.PipelinesService;
import com.databricks.sdk.service.pipelines.ResetRequest;
import com.databricks.sdk.service.pipelines.StartUpdate;
import com.databricks.sdk.service.pipelines.StartUpdateResponse;
import com.databricks.sdk.service.pipelines.StopRequest;
import com.databricks.sdk.support.Generated;

@Generated
class PipelinesImpl
implements PipelinesService {
    private final ApiClient apiClient;

    public PipelinesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePipelineResponse create(CreatePipeline request) {
        String path = "/api/2.0/pipelines";
        return this.apiClient.POST(path, request, CreatePipelineResponse.class);
    }

    @Override
    public void delete(DeletePipelineRequest request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public GetPipelineResponse get(GetPipelineRequest request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        return this.apiClient.GET(path, request, GetPipelineResponse.class);
    }

    @Override
    public GetPipelinePermissionLevelsResponse getPipelinePermissionLevels(GetPipelinePermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s/permissionLevels", request.getPipelineId());
        return this.apiClient.GET(path, request, GetPipelinePermissionLevelsResponse.class);
    }

    @Override
    public PipelinePermissions getPipelinePermissions(GetPipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        return this.apiClient.GET(path, request, PipelinePermissions.class);
    }

    @Override
    public GetUpdateResponse getUpdate(GetUpdateRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/updates/%s", request.getPipelineId(), request.getUpdateId());
        return this.apiClient.GET(path, request, GetUpdateResponse.class);
    }

    @Override
    public ListPipelineEventsResponse listPipelineEvents(ListPipelineEventsRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/events", request.getPipelineId());
        return this.apiClient.GET(path, request, ListPipelineEventsResponse.class);
    }

    @Override
    public ListPipelinesResponse listPipelines(ListPipelinesRequest request) {
        String path = "/api/2.0/pipelines";
        return this.apiClient.GET(path, request, ListPipelinesResponse.class);
    }

    @Override
    public ListUpdatesResponse listUpdates(ListUpdatesRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/updates", request.getPipelineId());
        return this.apiClient.GET(path, request, ListUpdatesResponse.class);
    }

    @Override
    public void reset(ResetRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/reset", request.getPipelineId());
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public PipelinePermissions setPipelinePermissions(PipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        return this.apiClient.PUT(path, request, PipelinePermissions.class);
    }

    @Override
    public StartUpdateResponse startUpdate(StartUpdate request) {
        String path = String.format("/api/2.0/pipelines/%s/updates", request.getPipelineId());
        return this.apiClient.POST(path, request, StartUpdateResponse.class);
    }

    @Override
    public void stop(StopRequest request) {
        String path = String.format("/api/2.0/pipelines/%s/stop", request.getPipelineId());
        this.apiClient.POST(path, request, Void.class);
    }

    @Override
    public void update(EditPipeline request) {
        String path = String.format("/api/2.0/pipelines/%s", request.getPipelineId());
        this.apiClient.PUT(path, request, Void.class);
    }

    @Override
    public PipelinePermissions updatePipelinePermissions(PipelinePermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/pipelines/%s", request.getPipelineId());
        return this.apiClient.PATCH(path, request, PipelinePermissions.class);
    }
}

