/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.provisioning;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.provisioning.DeletePrivateAccesRequest;
import com.databricks.sdk.service.provisioning.GetPrivateAccesRequest;
import com.databricks.sdk.service.provisioning.PrivateAccessService;
import com.databricks.sdk.service.provisioning.PrivateAccessSettings;
import com.databricks.sdk.service.provisioning.UpsertPrivateAccessSettingsRequest;
import com.databricks.sdk.support.Generated;
import java.util.Collection;

@Generated
class PrivateAccessImpl
implements PrivateAccessService {
    private final ApiClient apiClient;

    public PrivateAccessImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public PrivateAccessSettings create(UpsertPrivateAccessSettingsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, PrivateAccessSettings.class);
    }

    @Override
    public void delete(DeletePrivateAccesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public PrivateAccessSettings get(GetPrivateAccesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        return this.apiClient.GET(path, request, PrivateAccessSettings.class);
    }

    @Override
    public Collection<PrivateAccessSettings> list() {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings", this.apiClient.configuredAccountID());
        return this.apiClient.getCollection(path, null, PrivateAccessSettings.class);
    }

    @Override
    public void replace(UpsertPrivateAccessSettingsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/private-access-settings/%s", this.apiClient.configuredAccountID(), request.getPrivateAccessSettingsId());
        this.apiClient.PUT(path, request, Void.class);
    }
}

