/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.EndpointTokenSource;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenSource;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DataPlaneTokenSource {
    private final HttpClient httpClient;
    private final TokenSource cpTokenSource;
    private final String host;
    private final ConcurrentHashMap<TokenSourceKey, EndpointTokenSource> sourcesCache;

    public DataPlaneTokenSource(HttpClient httpClient, TokenSource cpTokenSource, String host) {
        this.httpClient = Objects.requireNonNull(httpClient, "HTTP client cannot be null");
        this.cpTokenSource = Objects.requireNonNull(cpTokenSource, "Control plane token source cannot be null");
        this.host = Objects.requireNonNull(host, "Host cannot be null");
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be empty");
        }
        this.sourcesCache = new ConcurrentHashMap();
    }

    public Token getToken(String endpoint, String authDetails) {
        Objects.requireNonNull(endpoint, "Data plane endpoint URL cannot be null");
        Objects.requireNonNull(authDetails, "Authorization details cannot be null");
        if (endpoint.isEmpty()) {
            throw new IllegalArgumentException("Data plane endpoint URL cannot be empty");
        }
        if (authDetails.isEmpty()) {
            throw new IllegalArgumentException("Authorization details cannot be empty");
        }
        TokenSourceKey key = new TokenSourceKey(endpoint, authDetails);
        EndpointTokenSource specificSource = this.sourcesCache.computeIfAbsent(key, k -> new EndpointTokenSource(this.cpTokenSource, ((TokenSourceKey)k).authDetails, this.httpClient, this.host));
        return specificSource.getToken();
    }

    private static final class TokenSourceKey {
        private final String endpoint;
        private final String authDetails;

        public TokenSourceKey(String endpoint, String authDetails) {
            this.endpoint = endpoint;
            this.authDetails = authDetails;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TokenSourceKey that = (TokenSourceKey)o;
            return Objects.equals(this.endpoint, that.endpoint) && Objects.equals(this.authDetails, that.authDetails);
        }

        public int hashCode() {
            return Objects.hash(this.endpoint, this.authDetails);
        }
    }
}

