/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.oauth.Consent;
import com.databricks.sdk.core.oauth.FileTokenCache;
import com.databricks.sdk.core.oauth.OAuthClient;
import com.databricks.sdk.core.oauth.OAuthClientUtils;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.SessionCredentials;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenCache;
import com.databricks.sdk.core.oauth.TokenCacheUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalBrowserCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalBrowserCredentialsProvider.class);
    private TokenCache tokenCache;

    public ExternalBrowserCredentialsProvider(TokenCache tokenCache) {
        this.tokenCache = tokenCache;
    }

    public ExternalBrowserCredentialsProvider() {
        this(null);
    }

    @Override
    public String authType() {
        return "external-browser";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (config.getHost() == null || !Objects.equals(config.getAuthType(), "external-browser")) {
            return null;
        }
        String clientId = OAuthClientUtils.resolveClientId(config);
        String clientSecret = OAuthClientUtils.resolveClientSecret(config);
        try {
            Token cachedToken;
            if (this.tokenCache == null) {
                Path cachePath = TokenCacheUtils.getCacheFilePath(config.getHost(), clientId, config.getScopes());
                this.tokenCache = new FileTokenCache(cachePath);
            }
            if ((cachedToken = this.tokenCache.load()) != null && cachedToken.getRefreshToken() != null) {
                LOGGER.debug("Found cached token for {}:{}", (Object)config.getHost(), (Object)clientId);
                try {
                    SessionCredentials cachedCreds = new SessionCredentials.Builder().withToken(cachedToken).withHttpClient(config.getHttpClient()).withClientId(clientId).withClientSecret(clientSecret).withTokenUrl(config.getOidcEndpoints().getTokenEndpoint()).withRedirectUrl(config.getEffectiveOAuthRedirectUrl()).withTokenCache(this.tokenCache).build();
                    LOGGER.debug("Using cached token, will immediately refresh");
                    cachedCreds.token = cachedCreds.refresh();
                    return cachedCreds.configure(config);
                }
                catch (Exception e) {
                    LOGGER.info("Token refresh failed: {}, falling back to browser auth", (Object)e.getMessage());
                }
            }
            SessionCredentials credentials = this.performBrowserAuth(config, clientId, clientSecret, this.tokenCache);
            this.tokenCache.save(credentials.getToken());
            return credentials.configure(config);
        }
        catch (DatabricksException | IOException e) {
            LOGGER.error("Failed to authenticate: {}", (Object)e.getMessage());
            return null;
        }
    }

    SessionCredentials performBrowserAuth(DatabricksConfig config, String clientId, String clientSecret, TokenCache tokenCache) throws IOException {
        LOGGER.debug("Performing browser authentication");
        OAuthClient client = new OAuthClient.Builder().withHttpClient(config.getHttpClient()).withClientId(clientId).withClientSecret(clientSecret).withHost(config.getHost()).withRedirectUrl(config.getEffectiveOAuthRedirectUrl()).withScopes(config.getScopes()).build();
        Consent consent = client.initiateConsent();
        SessionCredentials credentials = consent.launchExternalBrowser();
        return new SessionCredentials.Builder().withToken(credentials.getToken()).withHttpClient(config.getHttpClient()).withClientId(config.getClientId()).withClientSecret(config.getClientSecret()).withTokenUrl(config.getOidcEndpoints().getTokenEndpoint()).withRedirectUrl(config.getEffectiveOAuthRedirectUrl()).withTokenCache(tokenCache).build();
    }
}

