/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenCache;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionCredentials
extends RefreshableTokenSource
implements CredentialsProvider,
Serializable {
    private static final long serialVersionUID = 3083941540130596650L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCredentials.class);
    private final HttpClient hc;
    private final String tokenUrl;
    private final String redirectUrl;
    private final String clientId;
    private final String clientSecret;
    private final TokenCache tokenCache;

    @Override
    public String authType() {
        return "oauth-u2m";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        return OAuthHeaderFactory.fromTokenSource(this);
    }

    private SessionCredentials(Builder b) {
        super(b.token);
        this.hc = b.hc;
        this.tokenUrl = b.tokenUrl;
        this.redirectUrl = b.redirectUrl;
        this.clientId = b.clientId;
        this.clientSecret = b.clientSecret;
        this.tokenCache = b.tokenCache;
    }

    @Override
    protected Token refresh() {
        if (this.token == null) {
            throw new DatabricksException("oauth2: token is not set");
        }
        String refreshToken = this.token.getRefreshToken();
        if (refreshToken == null) {
            throw new DatabricksException("oauth2: token expired and refresh token is not set");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.tokenUrl.contains("microsoft")) {
            headers.put("Origin", this.redirectUrl);
        }
        Token newToken = SessionCredentials.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenUrl, params, headers, AuthParameterPosition.BODY);
        if (this.tokenCache != null) {
            this.tokenCache.save(newToken);
            LOGGER.debug("Saved refreshed token to cache");
        }
        return newToken;
    }

    static class Builder {
        private HttpClient hc;
        private Token token;
        private String tokenUrl;
        private String redirectUrl;
        private String clientId;
        private String clientSecret;
        private TokenCache tokenCache;

        Builder() {
        }

        public Builder withHttpClient(HttpClient hc) {
            this.hc = hc;
            return this;
        }

        public Builder withToken(Token token) {
            this.token = token;
            return this;
        }

        public Builder withTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public Builder withRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withTokenCache(TokenCache tokenCache) {
            this.tokenCache = tokenCache;
            return this;
        }

        public SessionCredentials build() {
            return new SessionCredentials(this);
        }
    }
}

