/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.TokenSource;

public class TokenSourceCredentialsProvider
implements CredentialsProvider {
    private final TokenSource tokenSource;
    private final String authType;

    public TokenSourceCredentialsProvider(TokenSource tokenSource, String authType) {
        this.tokenSource = tokenSource;
        this.authType = authType;
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        try {
            this.tokenSource.getToken().getAccessToken();
            return OAuthHeaderFactory.fromTokenSource(this.tokenSource);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String authType() {
        return this.authType;
    }
}

